/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.luoperation;

import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultTreeModel;
import sanproject.client.com.RJCom;
import sanproject.client.com.RJcMenuAction;
import sanproject.client.com.RJcPopupMenu;
import sanproject.client.com.abs.RJaContainMenu;
import sanproject.client.com.abs.RJaTreeNode;
import sanproject.client.data.RJDataControl;
import sanproject.client.exdevice.com.AbstractElement;
import sanproject.client.exdevice.com.MultiDetailElement;
import sanproject.client.exdevice.com.Operation;
import sanproject.client.exdevice.data.ExternalVolumeMaintenanceData;
import sanproject.client.exdevice.data.PathGroupInfo;
import sanproject.client.exdevice.data.PresetManager;
import sanproject.client.exdevice.data.ProductInfo;
import sanproject.client.exdevice.event.ElementEvent;
import sanproject.client.exdevice.luoperation.ElementUtilities;
import sanproject.client.exdevice.luoperation.LocalGuidance;
import sanproject.client.exdevice.luoperation.LocalOperation;
import sanproject.client.exdevice.luoperation.PathGroupElement;
import sanproject.client.exdevice.utility.Debug;

public class ExternalProductElement
extends MultiDetailElement
implements RJaContainMenu {
    static final long serialVersionUID = -3792942401153107917L;
    private transient ProductInfo productInfo;
    private RJcMenuAction disconnectSubsystemAction;
    private RJcMenuAction checkPathsAction;

    public ExternalProductElement(ProductInfo productInfo) {
        String string = productInfo.toString();
        this.setName(string);
        this.productInfo = productInfo;
        String string2 = LocalGuidance.MENU_DISCONNECTSUBSYSTEM.getItemID();
        this.disconnectSubsystemAction = new RJcMenuAction(string2){

            public void actionPerformed(ActionEvent actionEvent) {
                RJCom.putLog(RJDataControl.getDataControl(), "[ExDevice_LU]", "ExternalProductElement", "[ExternalProductElement] onSelect Disconnect SubSystem.", 0);
                ExternalProductElement.this.onSelectDisconnectSubsystem(actionEvent);
            }

            public String toString() {
                String string = (String)this.getValue("Name");
                return string;
            }
        };
        string2 = LocalGuidance.MENU_CHECKPATH.getItemID();
        this.checkPathsAction = new RJcMenuAction(string2){

            public void actionPerformed(ActionEvent actionEvent) {
                RJCom.putLog(RJDataControl.getDataControl(), "[ExDevice_LU]", "ExternalProductElement", "[ExternalProductElement] onSelect Check Path.", 0);
                ExternalProductElement.this.onSelectCheckPath(actionEvent);
            }

            public String toString() {
                String string = (String)this.getValue("Name");
                return string;
            }
        };
    }

    public boolean hasDisplayLimitation() {
        boolean bl = true;
        return bl;
    }

    public void createChildElements(AbstractElement.DetailType detailType) {
        this.fireStateChanged(ElementEvent.CREATE_CHILDELEMENT_STARTED);
        PathGroupInfo[] pathGroupInfoArray = this.getPathGroups();
        int n = pathGroupInfoArray.length;
        for (int i = 0; i < n; ++i) {
            PathGroupInfo pathGroupInfo = pathGroupInfoArray[i];
            PathGroupElement pathGroupElement = new PathGroupElement(pathGroupInfo);
            this.addChildElement(null, pathGroupElement);
        }
        this.fireStateChanged(ElementEvent.CREATE_CHILDELEMENT_ENDED);
    }

    public void createDetailView(JPanel jPanel) {
        if (this.treeNode != null) {
            RJaTreeNode rJaTreeNode = (RJaTreeNode)this.treeNode.getParent();
            if (rJaTreeNode != null) {
                MultiDetailElement multiDetailElement = (MultiDetailElement)rJaTreeNode.getUserObject();
                multiDetailElement.createDetailView(jPanel);
            }
        } else {
            Debug.println("not found 'Subsystem' tree node.");
        }
    }

    public void showMenu(JComponent jComponent, int n, int n2, DefaultTreeModel defaultTreeModel, RJaTreeNode rJaTreeNode) {
        this.updateActionsStatus();
        RJcMenuAction[] rJcMenuActionArray = new RJcMenuAction[]{this.disconnectSubsystemAction, this.checkPathsAction};
        RJcPopupMenu rJcPopupMenu = new RJcPopupMenu(rJcMenuActionArray);
        ((JPopupMenu)rJcPopupMenu).show(jComponent, n, n2);
    }

    public Icon getIcon(boolean bl) {
        Icon icon = this.toProductIcon();
        return icon;
    }

    public Icon toProductIcon() {
        ProductInfo productInfo = this.getProductInfo();
        Icon icon = ElementUtilities.toProductIcon(productInfo);
        return icon;
    }

    public String toStringDeviceStatus() {
        ProductInfo productInfo = this.getProductInfo();
        String string = ElementUtilities.toStringDeviceStatus(productInfo);
        return string;
    }

    public ProductInfo getProductInfo() {
        ProductInfo productInfo = this.productInfo;
        return productInfo;
    }

    public String getVenderName() {
        ProductInfo productInfo = this.getProductInfo();
        String string = productInfo.getVendorName();
        return string;
    }

    public String getProductName() {
        ProductInfo productInfo = this.getProductInfo();
        String string = productInfo.getProductName();
        return string;
    }

    public String getSerialNumber() {
        ProductInfo productInfo = this.getProductInfo();
        String string = productInfo.getSerial();
        return string;
    }

    protected boolean isModify() {
        ProductInfo productInfo = this.getProductInfo();
        boolean bl = productInfo.isModify();
        return bl;
    }

    private PathGroupInfo[] getPathGroups() {
        PathGroupInfo[] pathGroupInfoArray = new PathGroupInfo[]{};
        ProductInfo productInfo = this.getProductInfo();
        Collection collection = productInfo.getPathGroupInfo();
        if (collection != null) {
            pathGroupInfoArray = collection.toArray(pathGroupInfoArray);
        }
        return pathGroupInfoArray;
    }

    private void updateActionsStatus() {
        PresetManager presetManager;
        boolean bl;
        ProductInfo productInfo = this.getProductInfo();
        boolean bl2 = bl = ExternalProductElement.isEditable(13, 1);
        boolean bl3 = bl;
        if (bl) {
            presetManager = PresetManager.getInstance();
            bl2 = Operation.isPossibleTo(presetManager, LocalOperation.DISCONNECT_VOLUME) ? ExternalVolumeMaintenanceData.canDisconnectSubsystem(productInfo) : false;
        }
        if (bl) {
            presetManager = PresetManager.getInstance();
            bl3 = Operation.isPossibleTo(presetManager, LocalOperation.CHECK_PATHS) ? ExternalVolumeMaintenanceData.canCheckPathAndRestoreVol(productInfo) : false;
        }
        this.disconnectSubsystemAction.setEnabled(bl2);
        this.checkPathsAction.setEnabled(bl3);
    }

    private void onSelectDisconnectSubsystem(ActionEvent actionEvent) {
        ProductInfo productInfo = this.getProductInfo();
        boolean bl = ExternalVolumeMaintenanceData.canDisconnectSubsystem(productInfo);
        if (bl) {
            ProductInfo[] productInfoArray = new ProductInfo[]{productInfo};
            ExternalVolumeMaintenanceData.doDisconnectSubsystem(productInfoArray);
            this.treePanel.refreshTree();
        }
    }

    private void onSelectCheckPath(ActionEvent actionEvent) {
        ProductInfo productInfo = this.getProductInfo();
        boolean bl = ExternalVolumeMaintenanceData.canCheckPathAndRestoreVol(productInfo);
        if (bl) {
            ProductInfo[] productInfoArray = new ProductInfo[]{productInfo};
            ExternalVolumeMaintenanceData.doCheckPathAndRestoreVol(productInfoArray);
            this.treePanel.refreshTree();
        }
    }
}

