/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.luoperation;

import java.util.ArrayList;
import sanproject.client.exdevice.com.AbstractElement;
import sanproject.client.exdevice.data.EXDException;
import sanproject.client.exdevice.data.PathDirector;
import sanproject.client.exdevice.data.PathGroupInfo;
import sanproject.client.exdevice.data.PhysicalPathInfo;
import sanproject.client.exdevice.data.ProductInfo;
import sanproject.client.exdevice.event.ElementEvent;
import sanproject.client.exdevice.luoperation.ExternalPortElement;
import sanproject.client.exdevice.luoperation.ExternalProductElement;
import sanproject.client.exdevice.luoperation.PathExternalProductElement;
import sanproject.client.exdevice.luoperation.PathGroupElement;
import sanproject.client.exdevice.luoperation.PathTargetElement;
import sanproject.client.exdevice.luoperation.PhysicalPathElement;
import sanproject.common.Robj_interface_RJiPortIndex;
import sanproject.common.Robj_interface_RJiPortInfoDetail;

public class PhysicalPathDirectorElement
extends AbstractElement {
    public static final AbstractElement.DetailType PRODUCTS_DETAILTYPE = new AbstractElement.DetailType("Products detail type."){

        public void createChildElements(AbstractElement abstractElement) {
        }
    };
    public static final AbstractElement.DetailType EXTERNALPORT_DETAILTYPE = new AbstractElement.DetailType("External Port detail type."){

        public void createChildElements(AbstractElement abstractElement) {
        }
    };
    public static final AbstractElement.DetailType PATHTARGET_DETAILTYPE = new AbstractElement.DetailType("PathTarget detail type."){

        public void createChildElements(AbstractElement abstractElement) {
        }
    };
    private transient PathDirector director;
    private ExternalProductElement currentProduct;
    private ExternalPortElement currentPort;

    public PhysicalPathDirectorElement(PathDirector pathDirector) {
        this.director = pathDirector;
    }

    public boolean hasDisplayLimitation() {
        boolean bl = true;
        return bl;
    }

    public void createChildElements(AbstractElement.DetailType detailType) {
        this.fireStateChanged(ElementEvent.CREATE_CHILDELEMENT_STARTED);
        if (PRODUCTS_DETAILTYPE.equals(detailType)) {
            ProductInfo[] productInfoArray = this.getExternalProducts();
            int n = productInfoArray.length;
            for (int i = 0; i < n; ++i) {
                ProductInfo productInfo = productInfoArray[i];
                PathExternalProductElement pathExternalProductElement = new PathExternalProductElement(productInfo);
                this.addChildElement(PRODUCTS_DETAILTYPE, pathExternalProductElement);
            }
        } else if (EXTERNALPORT_DETAILTYPE.equals(detailType)) {
            Robj_interface_RJiPortInfoDetail[] robj_interface_RJiPortInfoDetailArray = this.getExternalPorts();
            int n = robj_interface_RJiPortInfoDetailArray.length;
            for (int i = 0; i < n; ++i) {
                Robj_interface_RJiPortInfoDetail robj_interface_RJiPortInfoDetail = robj_interface_RJiPortInfoDetailArray[i];
                ExternalPortElement externalPortElement = new ExternalPortElement(robj_interface_RJiPortInfoDetail);
                this.addChildElement(EXTERNALPORT_DETAILTYPE, externalPortElement);
            }
        } else if (PATHTARGET_DETAILTYPE.equals(detailType)) {
            PhysicalPathInfo[] physicalPathInfoArray = this.getPathTargets();
            int n = physicalPathInfoArray.length;
            for (int i = 0; i < n; ++i) {
                PhysicalPathInfo physicalPathInfo = physicalPathInfoArray[i];
                PathTargetElement pathTargetElement = new PathTargetElement(physicalPathInfo);
                this.addChildElement(PATHTARGET_DETAILTYPE, pathTargetElement);
            }
        } else {
            PhysicalPathInfo[] physicalPathInfoArray = this.getSelectedPaths();
            int n = physicalPathInfoArray.length;
            for (int i = 0; i < n; ++i) {
                PhysicalPathInfo physicalPathInfo = physicalPathInfoArray[i];
                PhysicalPathElement physicalPathElement = new PhysicalPathElement(physicalPathInfo, i + 1);
                this.addChildElement(null, physicalPathElement);
            }
        }
        this.fireStateChanged(ElementEvent.CREATE_CHILDELEMENT_ENDED);
    }

    public void addSelectedPaths(PathTargetElement[] pathTargetElementArray) {
        if (pathTargetElementArray != null) {
            int n = pathTargetElementArray.length;
            for (int i = 0; i < n; ++i) {
                PathTargetElement pathTargetElement = pathTargetElementArray[i];
                PhysicalPathInfo physicalPathInfo = pathTargetElement.getPhysicalPathInfo();
                this.director.addSelectedPath(physicalPathInfo);
            }
            this.removeChildElements();
        }
    }

    public void removeSelectedPaths(PhysicalPathElement[] physicalPathElementArray) {
        if (physicalPathElementArray != null) {
            int n = physicalPathElementArray.length;
            for (int i = 0; i < n; ++i) {
                PhysicalPathElement physicalPathElement = physicalPathElementArray[i];
                PhysicalPathInfo physicalPathInfo = physicalPathElement.getPhysicalPathInfo();
                this.director.removeSelectedPath(physicalPathInfo);
            }
            this.removeChildElements();
        }
    }

    public void priorityUp(PhysicalPathElement[] physicalPathElementArray) {
        if (physicalPathElementArray != null) {
            int n = physicalPathElementArray.length;
            boolean bl = true;
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                PhysicalPathElement physicalPathElement = physicalPathElementArray[i];
                int n3 = physicalPathElement.getPriority();
                if (!bl && n3 - n2 > 1) {
                    bl = true;
                }
                n2 = n3;
                if (!bl) continue;
                PhysicalPathInfo physicalPathInfo = physicalPathElement.getPhysicalPathInfo();
                bl = this.director.priorityUp(physicalPathInfo);
            }
            this.removeChildElements();
        }
    }

    public void priorityDown(PhysicalPathElement[] physicalPathElementArray) {
        if (physicalPathElementArray != null) {
            int n = physicalPathElementArray.length;
            boolean bl = true;
            int n2 = 0;
            for (int i = n - 1; i >= 0; --i) {
                PhysicalPathElement physicalPathElement = physicalPathElementArray[i];
                int n3 = physicalPathElement.getPriority();
                if (!bl && n2 - n3 > 1) {
                    bl = true;
                }
                n2 = n3;
                if (!bl) continue;
                PhysicalPathInfo physicalPathInfo = physicalPathElement.getPhysicalPathInfo();
                bl = this.director.priorityDown(physicalPathInfo);
            }
            this.removeChildElements();
        }
    }

    public boolean canAddSelectedPaths(PathTargetElement[] pathTargetElementArray) {
        boolean bl = false;
        if (pathTargetElementArray != null) {
            int n = pathTargetElementArray.length;
            for (int i = 0; i < n; ++i) {
                PathTargetElement pathTargetElement = pathTargetElementArray[i];
                PhysicalPathInfo physicalPathInfo = pathTargetElement.getPhysicalPathInfo();
                boolean bl2 = this.director.canAddSelectedPath(physicalPathInfo);
                if (!bl2) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public boolean canRemoveSelectedPaths(PhysicalPathElement[] physicalPathElementArray) {
        boolean bl = false;
        if (physicalPathElementArray != null) {
            int n = physicalPathElementArray.length;
            for (int i = 0; i < n; ++i) {
                PhysicalPathElement physicalPathElement = physicalPathElementArray[i];
                PhysicalPathInfo physicalPathInfo = physicalPathElement.getPhysicalPathInfo();
                boolean bl2 = this.director.canRemoveSelectedPath(physicalPathInfo);
                if (!bl2) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public boolean canPriorityUpPaths(PhysicalPathElement[] physicalPathElementArray) {
        boolean bl = false;
        if (physicalPathElementArray != null) {
            int n = physicalPathElementArray.length;
            for (int i = 0; i < n; ++i) {
                PhysicalPathElement physicalPathElement = physicalPathElementArray[i];
                PhysicalPathInfo physicalPathInfo = physicalPathElement.getPhysicalPathInfo();
                boolean bl2 = this.director.canPriorityUp(physicalPathInfo);
                if (!bl2) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public boolean canPriorityDownPaths(PhysicalPathElement[] physicalPathElementArray) {
        boolean bl = false;
        if (physicalPathElementArray != null) {
            int n = physicalPathElementArray.length;
            for (int i = 0; i < n; ++i) {
                PhysicalPathElement physicalPathElement = physicalPathElementArray[i];
                PhysicalPathInfo physicalPathInfo = physicalPathElement.getPhysicalPathInfo();
                boolean bl2 = this.director.canPriorityDown(physicalPathInfo);
                if (!bl2) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public boolean getAllowsChildren() {
        boolean bl = false;
        return bl;
    }

    public PathGroupElement createPathGroup() {
        PathGroupInfo pathGroupInfo = this.director.createPathGroup();
        PathGroupElement pathGroupElement = new PathGroupElement(pathGroupInfo);
        return pathGroupElement;
    }

    public void executeDiscoveryPort(ExternalPortElement[] externalPortElementArray) throws EXDException {
        ArrayList<Robj_interface_RJiPortInfoDetail> arrayList = new ArrayList<Robj_interface_RJiPortInfoDetail>();
        if (externalPortElementArray != null) {
            int n = externalPortElementArray.length;
            for (int i = 0; i < n; ++i) {
                ExternalPortElement externalPortElement = externalPortElementArray[i];
                Robj_interface_RJiPortInfoDetail robj_interface_RJiPortInfoDetail = externalPortElement.getPortInfo();
                arrayList.add(robj_interface_RJiPortInfoDetail);
            }
        }
        if (!arrayList.isEmpty()) {
            Robj_interface_RJiPortInfoDetail[] robj_interface_RJiPortInfoDetailArray = new Robj_interface_RJiPortInfoDetail[]{};
            robj_interface_RJiPortInfoDetailArray = arrayList.toArray(robj_interface_RJiPortInfoDetailArray);
            this.director.doDiscoveryPort((Robj_interface_RJiPortIndex[])robj_interface_RJiPortInfoDetailArray);
            this.removeChildElements();
        }
    }

    public void setCurrentProduct(ExternalProductElement externalProductElement) {
        this.currentProduct = externalProductElement;
        this.removeChildElements(EXTERNALPORT_DETAILTYPE);
        this.removeChildElements(PATHTARGET_DETAILTYPE);
    }

    public void setCurrentPort(ExternalPortElement externalPortElement) {
        this.currentPort = externalPortElement;
        this.removeChildElements(PATHTARGET_DETAILTYPE);
    }

    public void commit() throws EXDException {
        this.director.commit();
    }

    private ProductInfo[] getExternalProducts() {
        ProductInfo[] productInfoArray = new ProductInfo[]{};
        ProductInfo[] productInfoArray2 = this.director.getDiscoveryProduct();
        if (productInfoArray2 != null) {
            productInfoArray = productInfoArray2;
        }
        return productInfoArray;
    }

    private Robj_interface_RJiPortInfoDetail[] getExternalPorts() {
        ProductInfo productInfo;
        Robj_interface_RJiPortInfoDetail[] robj_interface_RJiPortInfoDetailArray;
        Robj_interface_RJiPortInfoDetail[] robj_interface_RJiPortInfoDetailArray2 = new Robj_interface_RJiPortInfoDetail[]{};
        if (this.currentProduct != null && (robj_interface_RJiPortInfoDetailArray = this.director.getDiscoveryPort(productInfo = this.currentProduct.getProductInfo())) != null) {
            robj_interface_RJiPortInfoDetailArray2 = robj_interface_RJiPortInfoDetailArray;
        }
        return robj_interface_RJiPortInfoDetailArray2;
    }

    private PhysicalPathInfo[] getPathTargets() {
        Robj_interface_RJiPortInfoDetail robj_interface_RJiPortInfoDetail;
        ProductInfo productInfo;
        PhysicalPathInfo[] physicalPathInfoArray;
        PhysicalPathInfo[] physicalPathInfoArray2 = new PhysicalPathInfo[]{};
        if (this.currentProduct != null && this.currentPort != null && (physicalPathInfoArray = this.director.getPhysicalPath(productInfo = this.currentProduct.getProductInfo(), (Robj_interface_RJiPortIndex)(robj_interface_RJiPortInfoDetail = this.currentPort.getPortInfo()))) != null) {
            physicalPathInfoArray2 = physicalPathInfoArray;
        }
        return physicalPathInfoArray2;
    }

    private PhysicalPathInfo[] getSelectedPaths() {
        PhysicalPathInfo[] physicalPathInfoArray = new PhysicalPathInfo[]{};
        PhysicalPathInfo[] physicalPathInfoArray2 = this.director.getSelectedPath();
        if (physicalPathInfoArray2 != null) {
            physicalPathInfoArray = physicalPathInfoArray2;
        }
        return physicalPathInfoArray;
    }
}

