/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.identity;

import java.awt.Color;
import java.awt.Font;
import java.awt.Toolkit;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;
import sanproject.client.identity.RestrictDocument;

class RJComTextFieldIdentity
extends JTextField {
    public static final boolean ON = true;
    public static final boolean OFF = false;
    public static final short ALPHABETIC = 1;
    public static final short NUMERIC = 2;
    public static final short HEXADECIMAL = 4;
    public static final short SPACE_UBAR = 8;
    public static final short SPACE = 16;
    public static final short UNDERBAR = 32;
    public static final short HYPHEN = 64;
    public static final short PERIOD = 128;
    static final int MAX_LEN = 65536;
    private boolean updFlg = false;
    private Toolkit toolkit;
    private int min = 0;
    private int max = 65536;
    private short chkStr = 0;
    private RJComTextFieldIdentity textField;
    private String originalData = "";
    private static final String NOT_EFFECTIVE_CHARACTERS = "\\,/;:*?\"<>|&%^";
    private static String effectiveCharacters;

    public RJComTextFieldIdentity() {
        this.setDocument(new CharKindDocument(this.max));
        this.textField = this;
    }

    public RJComTextFieldIdentity(short s) {
        this.setChkStr(s);
        this.setDocument(new CharKindDocument(this.max));
        this.textField = this;
    }

    public void putText(String string) {
        this.setText(string);
        this.setCaretPosition(0);
        this.setUpdFlg(false);
        this.textField.setForeground(Color.black);
        this.originalData = string;
    }

    public void setUpdFlg(boolean bl) {
        if (bl) {
            this.setFont(new Font(this.getFont().getName(), 3, this.getFont().getSize()));
        } else {
            this.setFont(new Font(this.getFont().getName(), 0, this.getFont().getSize()));
        }
        this.updFlg = bl;
    }

    public boolean getUpdFlg() {
        return this.updFlg;
    }

    public void setMaxLen(int n) {
        this.max = n > 65536 ? 65536 : (n < this.min ? this.min : n);
        this.setDocument(new CharKindDocument(this.max));
    }

    public void setMinLen(int n) {
        this.min = n < 0 ? 0 : (n > this.max ? this.max : n);
    }

    public void setChkStr(short s) {
        this.chkStr = s;
    }

    static {
        StringBuffer stringBuffer = new StringBuffer();
        for (char c = ' '; c < '\u007f'; c = (char)(c + '\u0001')) {
            if (NOT_EFFECTIVE_CHARACTERS.indexOf(c) != -1) continue;
            stringBuffer.append(c);
        }
        effectiveCharacters = stringBuffer.toString();
    }

    class CharKindDocument
    extends RestrictDocument {
        public CharKindDocument() {
            this(-1);
        }

        public CharKindDocument(int n) {
            super(n);
        }

        public String getEffectiveCharacters() {
            return effectiveCharacters;
        }

        public void insertString(int n, String string, AttributeSet attributeSet) {
            try {
                super.insertString(n, string, attributeSet);
                if (attributeSet != null && attributeSet.isDefined(StyleConstants.ComposedTextAttribute)) {
                    return;
                }
                int n2 = this.getLength();
                String string2 = this.getText(0, n2);
                if (!string2.equals(RJComTextFieldIdentity.this.originalData)) {
                    RJComTextFieldIdentity.this.setUpdFlg(true);
                    RJComTextFieldIdentity.this.textField.setForeground(Color.blue);
                } else {
                    RJComTextFieldIdentity.this.setUpdFlg(false);
                    RJComTextFieldIdentity.this.textField.setForeground(Color.black);
                }
            }
            catch (Exception exception) {
                throw new IllegalStateException("Not Found Data");
            }
        }

        public void remove(int n, int n2) {
            try {
                super.remove(n, n2);
                int n3 = this.getLength();
                String string = this.getText(0, n3);
                if (!string.equals(RJComTextFieldIdentity.this.originalData)) {
                    RJComTextFieldIdentity.this.setUpdFlg(true);
                    RJComTextFieldIdentity.this.textField.setForeground(Color.blue);
                } else {
                    RJComTextFieldIdentity.this.setUpdFlg(false);
                    RJComTextFieldIdentity.this.textField.setForeground(Color.black);
                }
            }
            catch (Exception exception) {
                throw new IllegalStateException("Not Found Data");
            }
        }
    }
}

