/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.monitor.hihsm.manualplan;

import javax.swing.Icon;
import javax.swing.tree.DefaultTreeModel;
import sanproject.client.com.RJcTreePanel;
import sanproject.client.com.abs.RJaTreeNode;
import sanproject.client.monitor.com.RJHihDataSupplier;
import sanproject.client.monitor.com.RJHihIconTable;
import sanproject.client.monitor.com.RJHihPGrpElement;
import sanproject.client.monitor.hihsm.manualplan.RJHihMpSLdevTablePanel;
import sanproject.common.Robj_interface_RJiPGIndex;
import sanproject.serverux.data.HIHsmDetailClass;
import sanproject.serverux.data.HIHsmPGUseRate;
import sanproject.serverux.data.MonitorInfoCollection;

public class RJHihMpPGrpElement
extends RJHihPGrpElement {
    private Integer useRateAverage = null;
    private Integer useRateMaximum = null;
    private Boolean moveHistory = null;
    protected boolean fixed = false;
    private boolean usage = false;
    protected RJaTreeNode thisNode = null;
    private Integer classNo;
    private int classCount = 4;
    private DefaultTreeModel treeModel = null;

    public RJHihMpPGrpElement(Robj_interface_RJiPGIndex robj_interface_RJiPGIndex, RJHihDataSupplier rJHihDataSupplier, RJcTreePanel rJcTreePanel) {
        super(robj_interface_RJiPGIndex, rJHihDataSupplier, rJcTreePanel);
    }

    public RJHihMpPGrpElement(int n, int n2, RJHihDataSupplier rJHihDataSupplier, RJcTreePanel rJcTreePanel) {
        super(n, n2, rJHihDataSupplier, rJcTreePanel);
    }

    public void collectUseRate(MonitorInfoCollection monitorInfoCollection, int n) {
        this.useRateAverage = null;
        this.useRateMaximum = null;
        this.moveHistory = null;
        if (monitorInfoCollection != null) {
            HIHsmPGUseRate hIHsmPGUseRate = (HIHsmPGUseRate)monitorInfoCollection.get(n);
            this.useRateAverage = RJHihMpPGrpElement.newInteger(hIHsmPGUseRate.getTotalAverage());
            this.useRateMaximum = RJHihMpPGrpElement.newInteger(hIHsmPGUseRate.getTotalMax());
            this.moveHistory = new Boolean(hIHsmPGUseRate.getTotalMoveHistory() == 1);
        }
    }

    public void setFixedPg(HIHsmDetailClass[] hIHsmDetailClassArray, Integer[] integerArray) {
        boolean bl = false;
        this.classNo = null;
        this.classCount = integerArray.length;
        for (int i = 0; i < hIHsmDetailClassArray.length; ++i) {
            int[] nArray = hIHsmDetailClassArray[i].getFB4();
            int[] nArray2 = hIHsmDetailClassArray[i].getPG();
            boolean[] blArray = hIHsmDetailClassArray[i].getFixed();
            for (int j = 0; j < nArray.length; ++j) {
                if (nArray[j] != this.fb4 || nArray2[j] != this.pg) continue;
                this.classNo = integerArray[i];
                this.fixed = blArray[j];
                bl = true;
                break;
            }
            if (bl) break;
        }
    }

    public String toString() {
        String string = "";
        if (this.moveHistory != null && this.moveHistory.booleanValue()) {
            string = "!";
        }
        String string2 = RJHihMpPGrpElement.toClprString(this.getClprNo(), this.getClprName());
        String string3 = this.toPGString() + "(" + string + this.getRateAverageString() + "/" + this.getRateMaximumString() + " %, " + string2 + ")";
        return string3;
    }

    public Icon getIcon(boolean bl) {
        int n = 10;
        int[][] nArrayArray = new int[][]{{23, 27, 31, 35}, {24, 28, 32, 36}, {60, 62, 64, 66}};
        if (this.fixed) {
            n = 21;
        } else if (this.classNo != null) {
            if (this.getRaidLevel().startsWith("1")) {
                n = nArrayArray[0][this.supplier.toIconType(this.classNo, this.classCount)];
            } else if (this.getRaidLevel().startsWith("5")) {
                n = nArrayArray[1][this.supplier.toIconType(this.classNo, this.classCount)];
            } else if (this.getRaidLevel().startsWith("6")) {
                n = nArrayArray[2][this.supplier.toIconType(this.classNo, this.classCount)];
            }
        }
        Icon icon = RJHihIconTable.getIcon(n);
        return icon;
    }

    public Integer getRateAverage() {
        return this.useRateAverage;
    }

    public String getRateAverageString() {
        return this.toAverageString(this.useRateAverage, this.useRateMaximum);
    }

    public Integer getRateMaximum() {
        return this.useRateMaximum;
    }

    public String getRateMaximumString() {
        return this.toMaximumString(this.useRateMaximum);
    }

    public Boolean getMoveHistory() {
        return this.moveHistory;
    }

    public String toAverageString(Integer n, Integer n2) {
        String string = "-";
        if (n != null) {
            string = n.toString();
            if (n == 0 && n2 != null && n2 > 0) {
                string = "+" + string;
            }
        }
        return string;
    }

    public String toMaximumString(Integer n) {
        String string = "-";
        if (n != null) {
            string = n.toString();
        }
        return string;
    }

    public void selectNode(RJaTreeNode rJaTreeNode) {
        RJHihMpSLdevTablePanel rJHihMpSLdevTablePanel = (RJHihMpSLdevTablePanel)this.treePanel.getTablePanel();
        rJHihMpSLdevTablePanel.setElement(this);
    }

    public void usageAction(boolean bl) {
        this.usage = bl;
        this.collectUseRate(null, 0);
    }
}

