/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.monitor.performance.port;

import java.util.Arrays;
import javax.swing.JCheckBox;
import sanproject.client.com.RJComDef;
import sanproject.client.monitor.com.RJHihBoolIcon;
import sanproject.client.monitor.com.RJHihContainSel;
import sanproject.client.monitor.com.RJHihDataSupplier;
import sanproject.client.monitor.com.RJHihElement;
import sanproject.client.monitor.com.RJHihPortInfo;
import sanproject.client.monitor.com.RJHihTimePair;
import sanproject.client.monitor.performance.port.RJHihPortChartAxisComboBox;
import sanproject.client.monitor.performance.port.RJHihPortDetailComboBox;
import sanproject.client.monitor.performance.port.RJHihPortTreePanel;
import sanproject.client.monitor.performance.port.RJHihPtLunDetailChartData;
import sanproject.common.Robj_interface_RJiHostGroup;
import sanproject.common.Robj_interface_RJiLDEVIndex;
import sanproject.common.Robj_interface_RJiLUPathIndex;
import sanproject.serversx.data.RJiLDEVIndex;
import sanproject.serverux.arg.monitor.ArgLUAbility;
import sanproject.serverux.arg.monitor.MonArg;
import sanproject.serverux.data.LDEVMonitorLUAbility;
import sanproject.serverux.data.MonitorElementInfo;
import sanproject.serverux.data.MonitorInfoCollection;
import sanproject.serverux.dataimpl.RJiLDEVInfoDetail3;

public class RJHihPtLunElement
extends RJHihElement
implements RJHihContainSel {
    private RJHihBoolIcon selection = new RJHihBoolIcon(false);
    public final int MONITOR_RATE_IO = 1;
    public final int MONITOR_RATE_MB = 2;
    private RJHihTimePair term = null;
    private String szCULDEV = null;
    private String szEType = null;
    private Integer nPathCount = null;
    private Long nResponseTime = null;
    private Long nCurrentIO = null;
    private Long nUseRateAverageIO = null;
    private Long nUseRateMaximumIO = null;
    private Long nCurrentMB = null;
    private Long nUseRateAverageMB = null;
    private Long nUseRateMaximumMB = null;
    private long[] nChartAvrIO = null;
    private long[] nChartAvrMB = null;
    private long[] nChartMaxIO = null;
    private long[] nChartMaxMB = null;
    private long[] nChartMinIO = null;
    private long[] nChartMinMB = null;
    private long[] nIOSeq = null;
    private long[] nIORnd = null;
    private long[] nReadSeq = null;
    private long[] nReadRnd = null;
    private long[] nWriteSeq = null;
    private long[] nWriteRnd = null;
    private long[] nReadHitSeq = null;
    private long[] nReadHitRnd = null;
    private long[] nWriteHitSeq = null;
    private long[] nWriteHitRnd = null;
    private long[] nBackTransCtoD = null;
    private long[] nBackTransDtoCSeq = null;
    private long[] nBackTransDtoCRnd = null;
    private RJHihPortDetailComboBox DetailCombo = null;
    private JCheckBox DetailCheck = null;
    private RJHihPortChartAxisComboBox AxisCombo = null;
    public Robj_interface_RJiLUPathIndex PathInfo = null;
    private RJHihPortTreePanel TreePanel = null;
    public int nPortID = -1;
    public int nHostID = -1;
    public int nLUN = -1;
    public int nPathNumber = -1;
    public int nEmulationType = 0;

    public RJHihPtLunElement(String string, RJHihDataSupplier rJHihDataSupplier, RJHihPortTreePanel rJHihPortTreePanel, RJHihPortInfo rJHihPortInfo, Robj_interface_RJiHostGroup robj_interface_RJiHostGroup, Robj_interface_RJiLUPathIndex robj_interface_RJiLUPathIndex, RJiLDEVInfoDetail3[] rJiLDEVInfoDetail3Array) {
        super(string, rJHihDataSupplier, rJHihPortTreePanel);
        this.TreePanel = rJHihPortTreePanel;
        this.DetailCombo = this.TreePanel.getDetailCombo();
        this.DetailCheck = this.TreePanel.getDetailCheckBox();
        this.AxisCombo = this.TreePanel.getAxisCombo();
        this.PathInfo = robj_interface_RJiLUPathIndex;
        this.nPortID = rJHihPortInfo.getSPort();
        this.nHostID = robj_interface_RJiHostGroup.getSHostgroupID();
        this.nLUN = robj_interface_RJiLUPathIndex.getSLUN();
        this.initLDEVInfo(rJiLDEVInfoDetail3Array);
    }

    public void initLDEVInfo(RJiLDEVInfoDetail3[] rJiLDEVInfoDetail3Array) {
        String string = "";
        RJiLDEVInfoDetail3 rJiLDEVInfoDetail3 = null;
        RJiLDEVIndex rJiLDEVIndex = new RJiLDEVIndex();
        rJiLDEVIndex.setSLDKC(this.PathInfo.getSLDKC());
        rJiLDEVIndex.setSCU(this.PathInfo.getSCU());
        rJiLDEVIndex.setSLDEV(this.PathInfo.getSLDEV());
        int n = Arrays.binarySearch((Robj_interface_RJiLDEVIndex[])rJiLDEVInfoDetail3Array, rJiLDEVIndex);
        if (n >= 0) {
            rJiLDEVInfoDetail3 = rJiLDEVInfoDetail3Array[n];
        }
        if (rJiLDEVInfoDetail3 != null) {
            if (rJiLDEVInfoDetail3.isExternalVolume()) {
                string = string + RJComDef.LDEV_MARK_E;
            }
            if (rJiLDEVInfoDetail3.isQSVvol()) {
                string = string + RJComDef.LDEV_MARK_V;
            }
            if (rJiLDEVInfoDetail3.isAOUVvol()) {
                string = string + RJComDef.LDEV_MARK_U;
            }
            this.setPathCount(rJiLDEVInfoDetail3.getILUPathNumber());
            String string2 = "";
            this.szEType = this.supplier.changeEmulation(rJiLDEVInfoDetail3.getIEmulationType()) + string2;
        }
        this.szCULDEV = RJHihPtLunElement.toHexString(this.PathInfo.getSLDKC(), 2) + ":" + RJHihPtLunElement.toHexString(this.PathInfo.getSCU(), 2) + ":" + RJHihPtLunElement.toHexString(this.PathInfo.getSLDEV(), 2) + string;
    }

    public void collectUseRate(LDEVMonitorLUAbility lDEVMonitorLUAbility) {
        if (lDEVMonitorLUAbility != null) {
            this.nUseRateAverageIO = RJHihPtLunElement.newLong(lDEVMonitorLUAbility.getTotalIOPerS());
            this.nUseRateAverageMB = RJHihPtLunElement.newLong(lDEVMonitorLUAbility.getTotalTransRate());
            this.nUseRateMaximumIO = RJHihPtLunElement.newLong(lDEVMonitorLUAbility.getTotalMaxIOPerSec());
            this.nUseRateMaximumMB = RJHihPtLunElement.newLong(lDEVMonitorLUAbility.getTotalMaxTransRate());
            this.nResponseTime = RJHihPtLunElement.newLong(lDEVMonitorLUAbility.getTotalResponseTime());
            this.setMonTarget(lDEVMonitorLUAbility);
        }
    }

    private void setMonTarget(LDEVMonitorLUAbility lDEVMonitorLUAbility) {
        this.monTarget = lDEVMonitorLUAbility.getTotalIOPerS() != -5L;
    }

    public void collectCurrentUseRate(LDEVMonitorLUAbility lDEVMonitorLUAbility) {
        this.nCurrentIO = null;
        this.nCurrentMB = null;
        if (lDEVMonitorLUAbility != null) {
            this.nCurrentIO = RJHihPtLunElement.newLong(lDEVMonitorLUAbility.getTotalIOPerS());
            this.nCurrentMB = RJHihPtLunElement.newLong(lDEVMonitorLUAbility.getTotalTransRate());
            this.setMonTarget(lDEVMonitorLUAbility);
        }
    }

    public long[] getChart(int n) {
        long[] lArray = null;
        this.getChartData();
        lArray = n == 1 ? this.nChartAvrIO : this.nChartAvrMB;
        return lArray;
    }

    public RJHihPtLunDetailChartData getDetailChart() {
        RJHihPtLunDetailChartData rJHihPtLunDetailChartData = null;
        this.getChartData();
        rJHihPtLunDetailChartData.nIOSeq = this.nIOSeq;
        rJHihPtLunDetailChartData.nIORnd = this.nIORnd;
        rJHihPtLunDetailChartData.nReadSeq = this.nReadSeq;
        rJHihPtLunDetailChartData.nReadRnd = this.nReadRnd;
        rJHihPtLunDetailChartData.nWriteSeq = this.nWriteSeq;
        rJHihPtLunDetailChartData.nWriteRnd = this.nWriteRnd;
        rJHihPtLunDetailChartData.nReadHitSeq = this.nReadHitSeq;
        rJHihPtLunDetailChartData.nReadHitRnd = this.nReadHitRnd;
        rJHihPtLunDetailChartData.nWriteHitSeq = this.nWriteHitSeq;
        rJHihPtLunDetailChartData.nWriteHitRnd = this.nWriteHitRnd;
        rJHihPtLunDetailChartData.nBackTransCtoD = this.nBackTransCtoD;
        rJHihPtLunDetailChartData.nBackTransDtoCSeq = this.nBackTransDtoCSeq;
        rJHihPtLunDetailChartData.nBackTransDtoCRnd = this.nBackTransDtoCRnd;
        return rJHihPtLunDetailChartData;
    }

    private void getChartData() {
        LDEVMonitorLUAbility lDEVMonitorLUAbility;
        MonitorInfoCollection monitorInfoCollection = null;
        LDEVMonitorLUAbility lDEVMonitorLUAbility2 = null;
        this.term = this.supplier.getMonitoringInfo().getMonitoringTime();
        if (this.term != null) {
            lDEVMonitorLUAbility = new ArgLUAbility(1, this.term.getFromTime(), this.term.getToTime());
            lDEVMonitorLUAbility.addLU(this.nPortID, this.nHostID, this.nLUN);
            monitorInfoCollection = (MonitorInfoCollection)this.supplier.getMonitorInfo((MonArg)lDEVMonitorLUAbility);
        }
        if (monitorInfoCollection != null) {
            lDEVMonitorLUAbility = new LDEVMonitorLUAbility();
            lDEVMonitorLUAbility.setLU(this.nPortID, this.nHostID, this.nLUN);
            int n = monitorInfoCollection.indexOf((MonitorElementInfo)lDEVMonitorLUAbility);
            if (n != -1) {
                lDEVMonitorLUAbility2 = (LDEVMonitorLUAbility)monitorInfoCollection.get(n);
                if (lDEVMonitorLUAbility2 != null) {
                    this.nChartAvrIO = lDEVMonitorLUAbility2.getIOPerSec();
                    this.nChartAvrMB = lDEVMonitorLUAbility2.getTransRate();
                    this.nChartMaxIO = null;
                    this.nChartMaxMB = null;
                    this.nChartMinIO = null;
                    this.nChartMinMB = null;
                    this.nIOSeq = lDEVMonitorLUAbility2.getIORateSeq();
                    this.nIORnd = lDEVMonitorLUAbility2.getIORateRnd();
                    this.nReadSeq = lDEVMonitorLUAbility2.getReadSeq();
                    this.nReadRnd = lDEVMonitorLUAbility2.getReadRnd();
                    this.nWriteSeq = lDEVMonitorLUAbility2.getWriteSeq();
                    this.nWriteRnd = lDEVMonitorLUAbility2.getWriteRnd();
                    this.nReadHitSeq = lDEVMonitorLUAbility2.getReadHitSeq();
                    this.nReadHitRnd = lDEVMonitorLUAbility2.getReadHitRnd();
                    this.nWriteHitSeq = lDEVMonitorLUAbility2.getWriteHitSeq();
                    this.nWriteHitRnd = lDEVMonitorLUAbility2.getWriteHitRnd();
                    this.nBackTransCtoD = lDEVMonitorLUAbility2.getBackTransCtoD();
                    this.nBackTransDtoCSeq = lDEVMonitorLUAbility2.getBackTransDtoCSeq();
                    this.nBackTransDtoCRnd = lDEVMonitorLUAbility2.getBackTransDtoCRnd();
                }
            } else {
                this.supplier.putLog("[Monitor]", "[Port]", "RJHihPtLunElement.getChartData:Matched Error Port ID = " + lDEVMonitorLUAbility.getPortID());
            }
        }
    }

    public String getCULDEV() {
        return this.szCULDEV;
    }

    public String getEType() {
        return this.szEType;
    }

    public Integer getPathCount() {
        return this.nPathCount;
    }

    public void setPathCount(int n) {
        this.nPathCount = new Integer(n);
    }

    public Long getCurrentIO() {
        return this.nCurrentIO;
    }

    public Long getCurrentMB() {
        return this.nCurrentMB;
    }

    public Long getAverageIO() {
        return this.nUseRateAverageIO;
    }

    public Long getAverageMB() {
        return this.nUseRateAverageMB;
    }

    public Long getMaximumIO() {
        return this.nUseRateMaximumIO;
    }

    public Long getMaximumMB() {
        return this.nUseRateMaximumMB;
    }

    public Long getResponseTime() {
        return this.nResponseTime;
    }

    public long[] getChartMaxIO() {
        return this.nChartMaxIO;
    }

    public long[] getChartMinIO() {
        return this.nChartMinIO;
    }

    public long[] getChartAvrIO() {
        return this.nChartAvrIO;
    }

    public long[] getChartMaxMB() {
        return this.nChartMaxMB;
    }

    public long[] getChartMinMB() {
        return this.nChartMinMB;
    }

    public long[] getChartAvrMB() {
        return this.nChartAvrMB;
    }

    public long[] getIOSeq() {
        return this.nIOSeq;
    }

    public long[] getIORnd() {
        return this.nIORnd;
    }

    public long[] getReadSeq() {
        return this.nReadSeq;
    }

    public long[] getReadRnd() {
        return this.nReadRnd;
    }

    public long[] getWriteSeq() {
        return this.nWriteSeq;
    }

    public long[] getWriteRnd() {
        return this.nWriteRnd;
    }

    public long[] getReadHitSeq() {
        return this.nReadHitSeq;
    }

    public long[] getReadHitRnd() {
        return this.nReadHitRnd;
    }

    public long[] getWriteHitSeq() {
        return this.nWriteHitSeq;
    }

    public long[] getWriteHitRnd() {
        return this.nWriteHitRnd;
    }

    public long[] getBackTransCtoD() {
        return this.nBackTransCtoD;
    }

    public long[] getBackTransDtoCSeq() {
        return this.nBackTransDtoCSeq;
    }

    public long[] getBackTransDtoCRnd() {
        return this.nBackTransDtoCRnd;
    }

    public RJHihBoolIcon getSelection() {
        return this.selection;
    }

    public void setSelection(boolean bl) {
        this.selection.setValue(bl);
    }
}

