/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.mrcf;

import java.awt.Color;
import java.util.ArrayList;
import sanproject.client.com.RJCom;
import sanproject.client.com.RJComPanel;
import sanproject.client.com.RJComUty;
import sanproject.client.data.RJDataControl;
import sanproject.client.data.RJDataWndInf;
import sanproject.client.mrcf.RJMrcfApplyRslt;
import sanproject.client.mrcf.RJMrcfEquipVol;
import sanproject.client.mrcf.RJMrcfGetData;
import sanproject.client.mrcf.RJMrcfMacro;
import sanproject.client.mrcf.RJOMrcfGetData;
import sanproject.client.mrcf.RJRCCellDatExt;
import sanproject.serverux.dataimpl.RMCPCUOption;
import sanproject.serverux.dataimpl.RMCPCUofCUOption;

public class RJMrcfFcDataCtrl
implements RJMrcfMacro {
    RJOMrcfGetData siDataCtrl = null;
    private RMCPCUofCUOption[] presetCuOpt = null;
    public static final int CTG_TIMER_MAX = 600;
    public static final int CTG_TIMER_MIN = 0;
    public static final int CTG_TIMER_DEF = 120;
    public static final int CTG_TIMER_COL = 3;
    final String TRC_FUNC = "FcDtcl";
    final int FCV2_CTG_COLNUM = 2;
    final int FCV2_CTG_COL_CU = 0;
    final int FCV2_CTG_COL_TM = 1;
    final int FUNCSW_SIMF = 1024;
    RJDataWndInf FCT_COL_HD_CU = null;
    RJDataWndInf FCT_COL_HD_TM = null;

    public RJMrcfFcDataCtrl(RJOMrcfGetData rJOMrcfGetData) {
        this.siDataCtrl = rJOMrcfGetData;
        this.FCT_COL_HD_CU = RJCom.getWinInf(rJOMrcfGetData.data, "HMRCF", "MR_COM_CU", "CU", Color.BLACK);
        this.FCT_COL_HD_TM = RJCom.getWinInf(rJOMrcfGetData.data, "HMRCF", "FCT_TTL_SCPTM", "SCP Delay Time(sec.)", Color.BLACK);
    }

    RJDataControl getDataCtrl() {
        return this.siDataCtrl.data;
    }

    public void putLog(String string, String string2) {
        if (string != null && string2 != null) {
            RJCom.putLog(this.siDataCtrl.getDataControl(), "[FC]", string, string2, 0);
        } else {
            RJCom.putLog(this.siDataCtrl.getDataControl(), "[FC]", "error", "error", 0);
        }
    }

    void initPresetArea(RMCPCUofCUOption[] rMCPCUofCUOptionArray) {
        if (rMCPCUofCUOptionArray != null && this.presetCuOpt == null) {
            this.presetCuOpt = new RMCPCUofCUOption[rMCPCUofCUOptionArray.length];
        }
    }

    void initPresetData() {
        this.siDataCtrl.deleteAllPresetData();
        this.siDataCtrl.resetErrorDetail();
        if (this.presetCuOpt != null) {
            for (int i = 0; i < this.presetCuOpt.length; ++i) {
                this.presetCuOpt[i] = null;
            }
        }
    }

    RMCPCUofCUOption[] getAllCuOption() {
        RMCPCUofCUOption[] rMCPCUofCUOptionArray = null;
        RMCPCUOption rMCPCUOption = this.siDataCtrl.data.getRmcpCUOptionData();
        if (rMCPCUOption != null) {
            rMCPCUofCUOptionArray = rMCPCUOption.CUSetting;
        }
        return rMCPCUofCUOptionArray;
    }

    RMCPCUofCUOption getCuOption(int n) {
        RMCPCUofCUOption[] rMCPCUofCUOptionArray;
        RMCPCUofCUOption rMCPCUofCUOption = null;
        if (this.presetCuOpt != null) {
            if (this.isValidCu(n, this.presetCuOpt.length)) {
                rMCPCUofCUOption = this.presetCuOpt[n];
            } else {
                this.putLog("FcDtcl", "getCuOption(): invalid param.CU=" + RJComUty.itoh(n, 2));
            }
        } else {
            this.initPresetArea(this.getAllCuOption());
        }
        if (rMCPCUofCUOption == null && (rMCPCUofCUOptionArray = this.getAllCuOption()) != null) {
            if (this.isValidCu(n, rMCPCUofCUOptionArray.length)) {
                rMCPCUofCUOption = rMCPCUofCUOptionArray[n];
            } else {
                this.putLog("FcDtcl", "getCuOption(): invalid param.CU=" + RJComUty.itoh(n, 2));
            }
        }
        return rMCPCUofCUOption;
    }

    RJRCCellDatExt[][] getCuOptTable(short s) {
        RJRCCellDatExt[][] rJRCCellDatExtArray = null;
        RJMrcfGetData rJMrcfGetData = (RJMrcfGetData)this.siDataCtrl;
        ArrayList arrayList = rJMrcfGetData.getMFEquipVol();
        if (null != arrayList) {
            for (int i = 0; i < arrayList.size(); ++i) {
                RJMrcfEquipVol rJMrcfEquipVol = (RJMrcfEquipVol)arrayList.get(i);
                if (rJMrcfEquipVol.getLdkcId() != s) continue;
                short[] sArray = rJMrcfEquipVol.getEquipCu();
                if (null != sArray && 0 != sArray.length) {
                    rJRCCellDatExtArray = new RJRCCellDatExt[sArray.length][2];
                    for (int j = 0; j < sArray.length; ++j) {
                        String string = null;
                        int n = -1;
                        rJRCCellDatExtArray[j][0] = new RJRCCellDatExt(RJComUty.itoh(sArray[j], 2), 0, 16);
                        rJRCCellDatExtArray[j][0].setData(sArray[j]);
                        RMCPCUofCUOption rMCPCUofCUOption = this.getCuOption(sArray[j]);
                        if (rMCPCUofCUOption != null) {
                            n = rMCPCUofCUOption.SusScpTime;
                            string = Integer.toString(rMCPCUofCUOption.SusScpTime);
                        } else {
                            this.putLog("FcDtcl", "getCuOptTable(): Invalid data.CU=" + RJComUty.itoh(sArray[j], 2));
                            string = this.siDataCtrl.ERR_STRING;
                        }
                        rJRCCellDatExtArray[j][1] = new RJRCCellDatExt(string, 0, 16);
                        rJRCCellDatExtArray[j][1].setData(n);
                        rJRCCellDatExtArray[j][1].setSortAttr(2);
                        rJRCCellDatExtArray[j][1].setSortValue(n);
                        int n2 = rJRCCellDatExtArray[j][0].getAttr();
                        int n3 = rJRCCellDatExtArray[j][1].getAttr();
                        if (this.isPresetCu(sArray[j])) {
                            n2 |= 1;
                            n3 |= 1;
                        }
                        rJRCCellDatExtArray[j][0].setAttr(n2);
                        rJRCCellDatExtArray[j][1].setAttr(n3);
                    }
                    break;
                }
                this.putLog("FcDtcl", "getCuOptTable(): No Data.LDKC=" + s);
                break;
            }
        }
        if (null == rJRCCellDatExtArray) {
            this.putLog("FcDtcl", "getCuOptTable(): Equip data failed.LDKC=" + s);
            rJRCCellDatExtArray = new RJRCCellDatExt[0][0];
        }
        return rJRCCellDatExtArray;
    }

    String[] getCuOptTableColumn() {
        String[] stringArray = new String[]{this.FCT_COL_HD_CU.getGuidance(), this.FCT_COL_HD_TM.getGuidance()};
        return stringArray;
    }

    String[] getCuOptTblRestoreColumn() {
        String[] stringArray = new String[]{this.FCT_COL_HD_CU.getGuidance()};
        return stringArray;
    }

    int setCuOption(int n, int n2) {
        int n3 = 0;
        if (this.isValidTimerData(n2)) {
            if (this.presetCuOpt == null) {
                this.initPresetArea(this.getAllCuOption());
            }
            if (this.isValidCu(n, this.presetCuOpt.length)) {
                RMCPCUofCUOption[] rMCPCUofCUOptionArray = this.getAllCuOption();
                if (rMCPCUofCUOptionArray != null) {
                    if (rMCPCUofCUOptionArray[n] != null) {
                        if (this.presetCuOpt[n] != null) {
                            if (n2 != rMCPCUofCUOptionArray[n].SusScpTime) {
                                this.presetCuOpt[n].SusScpTime = n2;
                            } else {
                                this.presetCuOpt[n] = null;
                            }
                        } else if (n2 != rMCPCUofCUOptionArray[n].SusScpTime) {
                            this.presetCuOpt[n] = (RMCPCUofCUOption)rMCPCUofCUOptionArray[n].clone();
                            this.presetCuOpt[n].SusScpTime = n2;
                        }
                    } else {
                        this.putLog("FcDtcl", "setCuOption(): No Data.CU=" + n);
                        n3 = 7440;
                    }
                } else {
                    this.putLog("FcDtcl", "setCuOption(): No Data.");
                    n3 = 7440;
                }
            } else {
                this.putLog("FcDtcl", "setCuOption(): Invalid CU. CU=" + n);
                n3 = 7440;
            }
        } else {
            this.putLog("FcDtcl", "setCuOption(): Invalid timer. CU=" + n + " Timer=" + n2);
            n3 = 55597;
        }
        return n3;
    }

    boolean isValidTimerData(int n) {
        boolean bl = true;
        if (n >= 0) {
            if (n > 600) {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    boolean isValidCu(int n, int n2) {
        boolean bl = true;
        if (0 > n || n2 <= n) {
            bl = false;
            this.putLog("FcDtcl", "isValidCu(): Invalid CU. CU=" + n + " Prm=" + n2);
        }
        return bl;
    }

    boolean isPresetDataExist() {
        boolean bl = false;
        if (this.presetCuOpt != null && this.getPresetCuOptCnt() != 0) {
            bl = true;
        }
        return bl;
    }

    boolean isPresetCu(int n) {
        boolean bl = false;
        if (this.presetCuOpt != null && this.presetCuOpt[n] != null) {
            bl = true;
        }
        return bl;
    }

    RJMrcfApplyRslt setApplyData(RJComPanel rJComPanel) {
        RJMrcfApplyRslt rJMrcfApplyRslt = null;
        this.siDataCtrl.iPresetNum = 0;
        int n = 0;
        if (rJComPanel != null) {
            n = this.setPresetData();
            if (n == 0) {
                this.siDataCtrl.omrcfApplyStart(rJComPanel);
                if (this.siDataCtrl.statList != null) {
                    Integer n2 = (Integer)this.siDataCtrl.statList.get(0);
                    Integer n3 = (Integer)this.siDataCtrl.statList.get(1);
                    rJMrcfApplyRslt = this.makeApplyRsltMsg(n2, n3);
                    rJMrcfApplyRslt.errDtl = this.siDataCtrl.errInf;
                } else {
                    this.putLog("FcDtcl", "setApplyData(): Result data failed.");
                    rJMrcfApplyRslt = this.makeApplyRsltMsg(RJOMrcfGetData.MSG_FUNC, 7440);
                }
            } else {
                this.putLog("FcDtcl", "setApplyData(): Set operation failed.");
                rJMrcfApplyRslt = this.makeApplyRsltMsg(RJOMrcfGetData.MSG_FUNC, n);
            }
        } else {
            this.putLog("FcDtcl", "setApplyData(): Invalid parameter.");
            rJMrcfApplyRslt = this.makeApplyRsltMsg(RJOMrcfGetData.MSG_FUNC, 7440);
        }
        return rJMrcfApplyRslt;
    }

    private int setPresetData() {
        int n = 0;
        RMCPCUOption rMCPCUOption = this.siDataCtrl.data.getRmcpCUOptionData();
        RMCPCUOption rMCPCUOption2 = null;
        if (rMCPCUOption != null) {
            rMCPCUOption2 = (RMCPCUOption)rMCPCUOption.clone();
            if (rMCPCUOption2 != null) {
                if (this.presetCuOpt != null) {
                    rMCPCUOption2.FuncSWOption |= 0x400;
                    for (int i = 0; i < this.presetCuOpt.length; ++i) {
                        if (this.presetCuOpt[i] == null) continue;
                        if (rMCPCUOption2.CUSetting[i] != null) {
                            rMCPCUOption2.CUSetting[i].SusScpTime = this.presetCuOpt[i].SusScpTime;
                            continue;
                        }
                        this.putLog("FcDtcl", "setPresetData(): Invalid default data. CU=" + i);
                        n = 7440;
                        break;
                    }
                    if (n == 0) {
                        this.siDataCtrl.getDataControl().setObject(rMCPCUOption2);
                    }
                } else {
                    this.putLog("FcDtcl", "setPresetData(): Preset data failed.");
                    n = 7440;
                }
            } else {
                this.putLog("FcDtcl", "setPresetData(): Clone data failed.");
                n = 7440;
            }
        } else {
            this.putLog("FcDtcl", "setPresetData(): Default data failed.");
            n = 7440;
        }
        return n;
    }

    private RJMrcfApplyRslt makeApplyRsltMsg(int n, int n2) {
        RJMrcfApplyRslt rJMrcfApplyRslt = new RJMrcfApplyRslt();
        rJMrcfApplyRslt.alMsg = new ArrayList();
        rJMrcfApplyRslt.alMsg.add(new Integer(n));
        rJMrcfApplyRslt.alMsg.add(new Integer(n2));
        return rJMrcfApplyRslt;
    }

    int getPresetCuOptCnt() {
        int n = 0;
        if (this.presetCuOpt != null) {
            for (int i = 0; i < this.presetCuOpt.length; ++i) {
                if (this.presetCuOpt[i] == null) continue;
                ++n;
            }
        } else {
            this.putLog("FcDtcl", "getPresetCuOptCnt(): No data.");
        }
        return n;
    }

    void resetPresetCuOpt(int n) {
        if (this.presetCuOpt != null && this.isValidCu(n, this.presetCuOpt.length)) {
            this.presetCuOpt[n] = null;
        }
    }

    boolean isValidCuOpt() {
        boolean bl = true;
        RMCPCUOption rMCPCUOption = this.siDataCtrl.data.getRmcpCUOptionData();
        if (rMCPCUOption != null) {
            if (!this.isValidCuOpt_Obj(rMCPCUOption.CLPRSetting)) {
                this.putLog("FcDtcl", "isValidCuOpt(): Invalid CLPR Inf.");
                bl = false;
            }
            if (!this.isValidCuOpt_Obj(rMCPCUOption.SLPRSetting)) {
                this.putLog("FcDtcl", "isValidCuOpt(): Invalid SLPR Inf.");
                bl = false;
            }
            if (null == rMCPCUOption.SystemSetting) {
                this.putLog("FcDtcl", "isValidCuOpt(): Invalid System Inf.");
                bl = false;
            }
            if (!this.isValidCuOpt_Obj(rMCPCUOption.CUSetting)) {
                this.putLog("FcDtcl", "isValidCuOpt(): Invalid CU Inf.");
                bl = false;
            }
        } else {
            this.putLog("FcDtcl", "isValidCuOpt(): No data.");
            bl = false;
        }
        return bl;
    }

    private boolean isValidCuOpt_Obj(Object[] objectArray) {
        boolean bl = true;
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] != null) continue;
                this.putLog("FcDtcl", "isValidCuOpt_Obj(): Invalid individual data.");
                bl = false;
                break;
            }
        } else {
            this.putLog("FcDtcl", "isValidCuOpt_Obj(): No data.");
            bl = false;
        }
        return bl;
    }
}

