/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.mrcf;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import sanproject.client.com.RJCom;
import sanproject.client.com.RJComEETableModel;
import sanproject.client.com.RJComTblCRenderer;
import sanproject.client.com.RJComUty;
import sanproject.client.data.RJDataControl;
import sanproject.client.data.RJDataStartParam;
import sanproject.client.mrcf.RJMrcfCtgDetail;
import sanproject.client.mrcf.RJMrcfFilterInf;
import sanproject.client.mrcf.RJOMrcfDataControl;
import sanproject.client.mrcf.RJOMrcfPairData;
import sanproject.client.mrcf.RJOMrcfPairInf;
import sanproject.client.mrcf.RJRCCellDatExt;
import sanproject.client.mrcf.RJSiException;
import sanproject.client.mrcf.RJSiGetDataSrv;
import sanproject.client.mrcf.RJSiPortGrp;
import sanproject.client.mrcf.RJSiSystemInf;
import sanproject.common.Robj_interface_RJiHostGroup;
import sanproject.common.Robj_interface_RJiLDEVIndex;
import sanproject.common.Robj_interface_RJiLUPathIndex;
import sanproject.common.Robj_interface_RJiPortInfoDetail;
import sanproject.common.Robj_interface_RJiiSCSITarget;
import sanproject.serverux.dataimpl.MRCFgetHistInf;
import sanproject.serverux.dataimpl.MRCFgetOptInf;
import sanproject.serverux.dataimpl.MRCFgetPairStatus;
import sanproject.serverux.dataimpl.MrcGetPairInf_Output;
import sanproject.serverux.dataimpl.PRMCLPRName;
import sanproject.serverux.dataimpl.PRMName;
import sanproject.serverux.dataimpl.RJiLDEVInfoDetail3;

public class RJOMrcfGetData
extends RJOMrcfDataControl {
    public RJSiGetDataSrv dataSrv = null;

    public RJOMrcfGetData() {
    }

    public RJOMrcfGetData(RJDataControl rJDataControl) {
        super(rJDataControl);
        try {
            this.makeFilterClass();
            super.setStartKind(1);
            this.initGetClass();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void initGetClass() {
        this.dataSrv = new RJSiGetDataSrv(this);
        this.iCltKind = this.getOpenKind();
    }

    public String[] getColumnTitle_SetTbl() {
        String[] stringArray = new String[]{RJCom.getWinInf(this.data, "HOMRCF", "OMR_COM_PVOL", "P-VOL", this.stdFgClr).getGuidance(), RJCom.getWinInf(this.data, "HOMRCF", "OMR_COM_MU", "MU", this.stdFgClr).getGuidance(), RJCom.getWinInf(this.data, "HOMRCF", "OMR_COM_PAIRSTAT", "Status", this.stdFgClr).getGuidance(), RJCom.getWinInf(this.data, "HOMRCF", "OMR_COM_SVOL", "S-VOL", this.stdFgClr).getGuidance(), RJCom.getWinInf(this.data, "HOMRCF", "OMR_COM_EML", "Emulation", this.stdFgClr).getGuidance(), RJCom.getWinInf(this.data, "HOMRCF", "OMR_COM_CAPACITY", "Capacity(MB)", this.stdFgClr).getGuidance(), RJCom.getWinInf(this.data, "HOMRCF", "OMR_COM_PCLPR", "CLPR(P)", this.stdFgClr).getGuidance(), RJCom.getWinInf(this.data, "HOMRCF", "OMR_COM_SCLPR", "CLPR(S)", this.stdFgClr).getGuidance()};
        return stringArray;
    }

    public String getPairStatusName(int n) {
        int n2 = this.getStartKind();
        String string = null;
        switch (n) {
            case 0: {
                if (n2 == 0) {
                    string = this.MR_COM_STNAME_SMPL.getGuidance();
                    break;
                }
                string = this.OMR_COM_STNAME_SMPL.getGuidance();
                break;
            }
            case 16: {
                if (n2 == 0) {
                    string = this.MR_COM_STNAME_PEND.getGuidance();
                    break;
                }
                string = this.OMR_COM_STNAME_COPY_PD.getGuidance();
                break;
            }
            case 32: 
            case 544: {
                if (n2 == 0) {
                    string = this.MR_COM_STNAME_DPLX.getGuidance();
                    break;
                }
                string = this.OMR_COM_STNAME_PAIR.getGuidance();
                break;
            }
            case 48: 
            case 560: {
                if (n2 == 0) {
                    string = this.MR_COM_STNAME_SPLT.getGuidance();
                    break;
                }
                string = this.OMR_COM_STNAME_PSUS.getGuidance();
                break;
            }
            case 64: 
            case 576: {
                if (n2 == 0) {
                    string = this.MR_COM_STNAME_RSYC.getGuidance();
                    break;
                }
                string = this.OMR_COM_STNAME_COPY_RS.getGuidance();
                break;
            }
            case 96: {
                if (n2 == 0) {
                    string = this.MR_COM_STNAME_SPPD.getGuidance();
                    break;
                }
                string = this.OMR_COM_STNAME_COPY_SP.getGuidance();
                break;
            }
            case 72: 
            case 584: {
                if (n2 == 0) {
                    string = this.MR_COM_STNAME_RV_RSYC.getGuidance();
                    break;
                }
                string = this.OMR_COM_STNAME_COPY_RSR.getGuidance();
                break;
            }
            case 104: {
                if (n2 == 0) {
                    string = this.MR_COM_STNAME_VSPLT.getGuidance();
                    break;
                }
                string = this.OMR_COM_STNAME_PSUS_SP.getGuidance();
                break;
            }
            case 80: 
            case 592: {
                if (n2 == 0) {
                    string = this.MR_COM_STNAME_SSPD.getGuidance();
                    break;
                }
                string = this.OMR_COM_STNAME_PSUE.getGuidance();
                break;
            }
            case 112: {
                if (n2 == 0) {
                    string = this.MR_COM_STNAME_FLSH.getGuidance();
                    break;
                }
                string = this.OMR_COM_STNAME_FLSH.getGuidance();
                break;
            }
            case -1: {
                string = this.OMR_COM_STNAME_WAIT.getGuidance();
                break;
            }
            case 1: 
            case 513: {
                if (n2 == 0) {
                    string = this.MR_COM_STNAME_DLPD.getGuidance();
                    break;
                }
                string = this.OMR_COM_STNAME_DLPD.getGuidance();
                break;
            }
            case 640: {
                string = this.OMR_COM_QSST_RSRP.getGuidance();
                break;
            }
            case 528: {
                string = this.OMR_COM_QSST_COPY.getGuidance();
                break;
            }
            case 641: {
                string = this.OMR_COM_QSST_PFUS.getGuidance();
                break;
            }
            default: {
                string = this.ERR_STRING;
            }
        }
        return string;
    }

    public String getPairStatusName(RJOMrcfPairData rJOMrcfPairData) {
        String string = rJOMrcfPairData.iPairStat == 0 ? this.chgSimplexName(rJOMrcfPairData) : this.getPairStatusName(rJOMrcfPairData.iPairStat);
        if (this.getStartKind() == 0 && this.chkStatSpdMig(rJOMrcfPairData)) {
            string = this.MR_COM_STNAME_SPDMIG.getGuidance();
        }
        return string;
    }

    public String[] getCopyPaceName() {
        return this.szCopyPace;
    }

    public String getCopyPaceName(int n) {
        switch (n) {
            case 0: {
                return this.szCopyPace[0];
            }
            case 1: {
                return this.szCopyPace[1];
            }
            case 2: {
                return this.szCopyPace[2];
            }
        }
        return this.NO_DATA;
    }

    public boolean isCopyPaceValid(int n) {
        boolean bl = false;
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public int getCopyPaceCmbIdx(int n) {
        int n2 = -1;
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            default: {
                n2 = -1;
                RJCom.putLog(this.data, "[HOMRCF]", "[getData]", "getCopyPaceCmbIdx:invalid index:" + n, 0);
            }
        }
        return n2;
    }

    public String[] getSplitTypeName() {
        return this.szSpltType;
    }

    public int getSplitType(int n) {
        int n2;
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 240;
                break;
            }
            case 2: {
                n2 = 65535;
                break;
            }
            default: {
                RJCom.putLog(this.data, "[HOMRCF]", "[getData]", "getSplitType:invalid index:" + n, 0);
                n2 = -1;
            }
        }
        return n2;
    }

    public int getSplitTypeCmbIdx(int n) {
        int n2 = -1;
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 240: {
                n2 = 1;
                break;
            }
            case 65535: {
                n2 = 2;
                break;
            }
            default: {
                RJCom.putLog(this.data, "[HOMRCF]", "[getData]", "getSplitTypeCmbIdx:invalid type:" + n, 0);
                n2 = -1;
            }
        }
        return n2;
    }

    public int[] getTcCuOption(short s) {
        int[] nArray = new int[2];
        ArrayList arrayList = null;
        if (this.getStartKind() == 0) {
            super.waitCtl();
            this.data.getRmcpCUOption(s);
            this.data.waitDC();
            arrayList = this.data.getEndStatus();
            if ((Integer)arrayList.get(0) != 0) {
                RJCom.putLog(this.data, "[HOMRCF]", "[getData]", "getTcCuOption:FuncCode=" + (Integer)arrayList.get(0), 0);
                RJCom.putLog(this.data, "[HOMRCF]", "[getData]", "getTcCuOption:ErrCode=" + (Integer)arrayList.get(1), 0);
                RJCom.putLog(this.data, "[HOMRCF]", "[getData]", "getTcCuOption:CU Opt No Data", 0);
                nArray[0] = (Integer)arrayList.get(0);
                nArray[1] = (Integer)arrayList.get(1);
            }
        }
        return nArray;
    }

    public ArrayList getPortPairInf(short s) throws RJSiException {
        ArrayList arrayList = null;
        int[] nArray = this.dataSrv.getPairData_Open(s, (short)-1);
        if (0 != nArray[0]) {
            RJSiException rJSiException = new RJSiException("Connect error.");
            rJSiException.setErrParam(nArray[0], nArray[1]);
            throw rJSiException;
        }
        arrayList = this.dataSrv.getAlDspData();
        return arrayList;
    }

    public ArrayList getPairInf_NoPairFlt(short s, int n) throws RJSiException {
        ArrayList arrayList = null;
        ArrayList<Short> arrayList2 = new ArrayList<Short>();
        Robj_interface_RJiLDEVIndex[] robj_interface_RJiLDEVIndexArray = null;
        arrayList2.add(new Short(s));
        try {
            Robj_interface_RJiLUPathIndex[] robj_interface_RJiLUPathIndexArray = this.dataSrv.getPortPathIndexData(arrayList2);
            if (robj_interface_RJiLUPathIndexArray != null && 0 != robj_interface_RJiLUPathIndexArray.length) {
                robj_interface_RJiLDEVIndexArray = new Robj_interface_RJiLDEVIndex[robj_interface_RJiLUPathIndexArray.length];
                for (int i = 0; i < robj_interface_RJiLUPathIndexArray.length; ++i) {
                    robj_interface_RJiLDEVIndexArray[i] = robj_interface_RJiLUPathIndexArray[i];
                }
                arrayList = this.dataSrv.getPairInf_NoPairFlt(robj_interface_RJiLDEVIndexArray, n, false);
            } else {
                RJCom.putLog(this.data, "[HOMRCF]", "[getData]", "getPairInf_NoPairFlt:No path index", 0);
                arrayList = new ArrayList();
            }
        }
        catch (RJSiException rJSiException) {
            throw rJSiException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            RJSiException rJSiException = new RJSiException("Connect error.");
            rJSiException.setErrParam(MSG_FUNC, 7440);
            throw rJSiException;
        }
        return arrayList;
    }

    public ArrayList getPairInf_NoPairFlt(short s, short[] sArray, int n) throws RJSiException {
        ArrayList arrayList = null;
        Robj_interface_RJiLDEVIndex[] robj_interface_RJiLDEVIndexArray = null;
        int[] nArray = new int[2];
        try {
            robj_interface_RJiLDEVIndexArray = this.dataSrv.getLdevIndex_Srv(s, sArray);
            if (null != robj_interface_RJiLDEVIndexArray && 0 != robj_interface_RJiLDEVIndexArray.length) {
                arrayList = this.dataSrv.getPairInf_NoPairFlt(robj_interface_RJiLDEVIndexArray, n, false);
            } else {
                RJCom.putLog(this.data, "[HOMRCF]", "[getData]", "getPairInf_NoPairFlt:No LDEV index", 0);
                arrayList = new ArrayList();
            }
        }
        catch (RJSiException rJSiException) {
            nArray[0] = rJSiException.getIPart();
            nArray[1] = rJSiException.getIErrCode();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            nArray[0] = MSG_FUNC;
            nArray[1] = 7440;
        }
        if (0 != nArray[0]) {
            RJSiException rJSiException = new RJSiException("Connect error.");
            rJSiException.setErrParam(nArray[0], nArray[1]);
            throw rJSiException;
        }
        return arrayList;
    }

    public ArrayList getGrpPairInf(short s, short s2) throws RJSiException {
        ArrayList arrayList = null;
        int[] nArray = this.dataSrv.getPairData_Open(s, s2);
        if (0 != nArray[0]) {
            RJSiException rJSiException = new RJSiException("Connect error.");
            rJSiException.setErrParam(nArray[0], nArray[1]);
            throw rJSiException;
        }
        arrayList = this.dataSrv.getAlDspData();
        return arrayList;
    }

    ArrayList getCascadeData(RJOMrcfPairData rJOMrcfPairData) throws RJSiException {
        ArrayList arrayList = null;
        if (null == rJOMrcfPairData) {
            RJSiException rJSiException = new RJSiException();
            rJSiException.setErrParam(MSG_FUNC, 7440);
            throw rJSiException;
        }
        arrayList = this.dataSrv.getPairData_Cscd(rJOMrcfPairData);
        return arrayList;
    }

    public String getPortName(short s) {
        String string = null;
        if (s == -1) {
            RJCom.putLog(this.data, "[HOMRCF]", "[getData]", "getPortName:Param Error", 0);
            string = this.OMR_COM_ERR_STRING.getGuidance();
        } else {
            if (null != this.dataSrv.m_PortDtl) {
                for (int i = 0; i < this.dataSrv.m_PortDtl.length; ++i) {
                    if (s != this.dataSrv.m_PortDtl[i].getSPort()) continue;
                    string = this.dataSrv.m_PortDtl[i].getStrPortDisplayName();
                    break;
                }
            }
            if (null == string) {
                string = this.OMR_COM_ERR_STRING.getGuidance();
            }
        }
        return string;
    }

    public ArrayList getEquipPort() {
        ArrayList arrayList = this.dataSrv.getValidPortDtl();
        return arrayList;
    }

    public ArrayList getPortHostGrp(short s) {
        ArrayList<RJSiPortGrp> arrayList = new ArrayList<RJSiPortGrp>();
        Robj_interface_RJiPortInfoDetail robj_interface_RJiPortInfoDetail = this.dataSrv.getPortDtl(s);
        if (null != robj_interface_RJiPortInfoDetail) {
            Robj_interface_RJiiSCSITarget[] robj_interface_RJiiSCSITargetArray;
            if (this.dataSrv.isFibrePort(robj_interface_RJiPortInfoDetail.getByPortKindNo())) {
                Robj_interface_RJiHostGroup[] robj_interface_RJiHostGroupArray = this.dataSrv.getPortHostGrp(s);
                if (null != robj_interface_RJiHostGroupArray) {
                    for (int i = 0; i < robj_interface_RJiHostGroupArray.length; ++i) {
                        RJSiPortGrp rJSiPortGrp = new RJSiPortGrp();
                        rJSiPortGrp.setSPort(s);
                        rJSiPortGrp.setSGrp(robj_interface_RJiHostGroupArray[i].getSHostgroupID());
                        rJSiPortGrp.setStrGrpName(robj_interface_RJiHostGroupArray[i].getStrHostgroupNickName());
                        arrayList.add(rJSiPortGrp);
                    }
                }
            } else if (this.dataSrv.isIscsiPort(robj_interface_RJiPortInfoDetail.getByPortKindNo()) && null != (robj_interface_RJiiSCSITargetArray = this.dataSrv.getPortTargetGrp(s))) {
                for (int i = 0; i < robj_interface_RJiiSCSITargetArray.length; ++i) {
                    RJSiPortGrp rJSiPortGrp = new RJSiPortGrp();
                    rJSiPortGrp.setSPort(s);
                    rJSiPortGrp.setSGrp(robj_interface_RJiiSCSITargetArray[i].getSiSCSITargetID());
                    rJSiPortGrp.setStrGrpName(robj_interface_RJiiSCSITargetArray[i].getStriSCSITarget());
                    arrayList.add(rJSiPortGrp);
                }
            }
        } else {
            RJCom.putLog(this.data, "[HOMRCF]", "[getData]", "getPortHostGrp : Invalid port object.Port=" + s, 0);
        }
        return arrayList;
    }

    public MRCFgetOptInf getOptionInf() {
        if (null == this.dataSrv.m_OptSrv) {
            RJCom.putLog(this.data, "[HOMRCF]", "[getData]", "getOptionInf : getOMrcfOptionStatusData Error", 0);
        }
        return this.dataSrv.m_OptSrv;
    }

    public ArrayList getOpenSvolList(ArrayList arrayList, int n) {
        if (arrayList == null) {
            RJCom.putLog(this.data, "[HOMRCF]", "[getData]", "getOpenSvolList : Null", 0);
            return arrayList;
        }
        if (arrayList.size() == 0) {
            RJCom.putLog(this.data, "[HOMRCF]", "[getData]", "getOpenSvolList : NoData ", 0);
            return arrayList;
        }
        block8: for (int i = arrayList.size() - 1; i >= 0; --i) {
            if (i != 0) {
                RJOMrcfPairData rJOMrcfPairData = (RJOMrcfPairData)arrayList.get(i);
                RJOMrcfPairData rJOMrcfPairData2 = (RJOMrcfPairData)arrayList.get(i - 1);
                if (rJOMrcfPairData.comparePvol(rJOMrcfPairData2.spLdkc, rJOMrcfPairData2.ipCu, rJOMrcfPairData2.ipLdev)) {
                    arrayList.remove(i);
                    continue;
                }
            }
            int n2 = n;
            int n3 = this.getExVolAtrb(((RJOMrcfPairData)arrayList.get((int)i)).byVolType);
            if ((n2 & 0x10) != 16) {
                if (n3 == 0) {
                    arrayList.remove(i);
                    continue;
                }
            } else {
                n2 ^= 0x10;
            }
            if ((n2 & 8) != 8) {
                if (n3 != 0) {
                    arrayList.remove(i);
                    continue;
                }
            } else {
                n2 ^= 8;
            }
            if (((RJOMrcfPairData)arrayList.get((int)i)).iPairStat == 0) {
                int n4;
                if ((n & 4) == 4) {
                    n2 -= 4;
                }
                if ((n4 = this.getParentPairEx((RJOMrcfPairData)arrayList.get(i))) != 0) {
                    arrayList.remove(i);
                    continue;
                }
                if (n4 == -1) {
                    RJCom.putLog(this.data, "[HMRCF]", "[getData]", "getOpenSvolList:Can't get Parent", 0);
                    arrayList.remove(i);
                    continue;
                }
                switch (n2) {
                    case 1: {
                        if ((((RJOMrcfPairData)arrayList.get((int)i)).iVolAtrb & 0x80) != 128) continue block8;
                        arrayList.remove(i);
                        break;
                    }
                    case 2: {
                        if ((((RJOMrcfPairData)arrayList.get((int)i)).iVolAtrb & 0x80) == 128) continue block8;
                        arrayList.remove(i);
                        break;
                    }
                    case 3: {
                        continue block8;
                    }
                    default: {
                        arrayList.remove(i);
                        break;
                    }
                }
                continue;
            }
            if ((n & 4) != 4) {
                arrayList.remove(i);
                continue;
            }
            RJOMrcfPairData rJOMrcfPairData = (RJOMrcfPairData)arrayList.get(i);
            if (rJOMrcfPairData.iMu == 0) {
                arrayList.remove(i);
                continue;
            }
            if (0 != this.getVolumePairKindEx(rJOMrcfPairData)) {
                arrayList.remove(i);
                continue;
            }
            switch (rJOMrcfPairData.iPairStat) {
                case 1: 
                case 72: 
                case 96: 
                case 104: {
                    arrayList.remove(i);
                    continue block8;
                }
                default: {
                    if (!RJOMrcfGetData.isQsPairStat(rJOMrcfPairData.iPairStat)) continue block8;
                    arrayList.remove(i);
                    continue block8;
                }
            }
        }
        return arrayList;
    }

    boolean chkTargetPairStat(RJOMrcfPairData rJOMrcfPairData) {
        if (rJOMrcfPairData == null) {
            RJCom.putLog(this.data, "[HOMRCF]", "[getData]", "chkTargetPairStat:Param error", 0);
            return false;
        }
        int n = this.getVolumePairKindEx(rJOMrcfPairData);
        if (n != 0) {
            return false;
        }
        ArrayList arrayList = this.getVolumePairInf(rJOMrcfPairData.spLdkc, rJOMrcfPairData.ipCu, rJOMrcfPairData.ipLdev);
        if (arrayList == null) {
            RJCom.putLog(this.data, "[HOMRCF]", "[getData]", "chkTargetPairStat:P-VOL Data failed(null) " + RJComUty.itoh(rJOMrcfPairData.ipCu, 2) + "*" + RJComUty.itoh(rJOMrcfPairData.ipLdev, 2), 0);
            return false;
        }
        if (arrayList.size() == 0) {
            RJCom.putLog(this.data, "[HOMRCF]", "[getData]", "chkTargetPairStat:P-VOL Data failed " + RJComUty.itoh(rJOMrcfPairData.ipCu, 2) + "*" + RJComUty.itoh(rJOMrcfPairData.ipLdev, 2), 0);
            return false;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            RJOMrcfPairData rJOMrcfPairData2 = (RJOMrcfPairData)arrayList.get(i);
            if (rJOMrcfPairData2.iMu == 0) {
                return false;
            }
            switch (rJOMrcfPairData2.iPairStat) {
                case 1: 
                case 72: 
                case 96: 
                case 104: {
                    return false;
                }
            }
            if (!RJOMrcfGetData.isQsPairStat(rJOMrcfPairData2.iPairStat)) continue;
            return false;
        }
        return true;
    }

    public int chkSelectVolumeAtrb(RJOMrcfPairData[] rJOMrcfPairDataArray) {
        int n = -1;
        int n2 = -1;
        if (rJOMrcfPairDataArray == null) {
            RJCom.putLog(this.data, "[HOMRCF]", "[GetData]", "chkSelectVolumeAtrb:Param Error", 0);
            return -1;
        }
        for (int i = 0; i < rJOMrcfPairDataArray.length; ++i) {
            if (i == 0) {
                n = rJOMrcfPairDataArray[i].iVolAtrb;
                continue;
            }
            n2 = rJOMrcfPairDataArray[i].iVolAtrb;
            if ((n & 0x80) == (n2 & 0x80)) continue;
            return -1;
        }
        return n;
    }

    public int getParentPairEx(RJOMrcfPairData rJOMrcfPairData) {
        ArrayList arrayList = new ArrayList();
        int n = -1;
        if (null != rJOMrcfPairData) {
            n = (rJOMrcfPairData.iVolAtrb & 0x80) == 128 ? ((rJOMrcfPairData.iVolAtrb & 2) == 2 ? 1 : ((rJOMrcfPairData.iVolAtrb & 4) == 4 ? 0 : 0)) : 0;
            if (n != 1) {
                arrayList = this.getPresetData();
                if (arrayList == null) {
                    n = 0;
                } else if (arrayList.size() == 0) {
                    n = 0;
                } else {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        RJOMrcfPairInf rJOMrcfPairInf = (RJOMrcfPairInf)arrayList.get(i);
                        if (!rJOMrcfPairInf.compareSvol(rJOMrcfPairData.spLdkc, rJOMrcfPairData.ipCu, rJOMrcfPairData.ipLdev)) continue;
                        n = 1;
                        break;
                    }
                }
            }
        }
        return n;
    }

    public RJSiSystemInf getAllVolumeNumber() {
        RJSiSystemInf rJSiSystemInf = null;
        if (null != this.dataSrv.m_SysInf) {
            rJSiSystemInf = this.dataSrv.m_SysInf;
        } else {
            RJCom.putLog(this.data, "[HOMRCF]", "[getData]", "getAllVolumeNumber:Data not exist", 0);
            rJSiSystemInf = new RJSiSystemInf(new MRCFgetPairStatus());
        }
        return rJSiSystemInf;
    }

    public void getAllVolumeNumberSrv() throws RJSiException {
        MrcGetPairInf_Output mrcGetPairInf_Output = this.dataSrv.getPairInf_Srv(this.dataSrv.getPairParam_Pair(new ArrayList()));
        if (null != mrcGetPairInf_Output) {
            this.dataSrv.m_SysInf = new RJSiSystemInf((MRCFgetPairStatus)mrcGetPairInf_Output.getInf());
        }
    }

    public int getOpenKind() {
        RJDataStartParam rJDataStartParam = this.data.getStartParamClass();
        int n = rJDataStartParam.getVenderID();
        RJCom.putLog(this.data, "[HOMRCF]", "[getData]", "Start Kind = " + n, 0);
        this.iCltKind = n;
        return n;
    }

    public int getClientType() {
        return this.iCltKind;
    }

    public int[] getEnableMU(RJOMrcfPairData rJOMrcfPairData) {
        int n;
        int[] nArray = new int[3];
        int n2 = 0;
        int n3 = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList arrayList2 = this.dataSrv.getAlDspData();
        if (null != arrayList2) {
            RJOMrcfPairData rJOMrcfPairData2;
            int n4;
            n = 0;
            n = this.getVolumePairKind(rJOMrcfPairData);
            for (n4 = 0; n4 < arrayList2.size(); ++n4) {
                rJOMrcfPairData2 = (RJOMrcfPairData)arrayList2.get(n4);
                if (!rJOMrcfPairData.comparePvol(rJOMrcfPairData2.spLdkc, rJOMrcfPairData2.ipCu, rJOMrcfPairData2.ipLdev) || 3 <= rJOMrcfPairData2.iMu) continue;
                n3 |= 1 << rJOMrcfPairData2.iMu;
                ++n2;
            }
            if (null != this.presetData) {
                for (n4 = 0; n4 < this.presetData.size(); ++n4) {
                    rJOMrcfPairData2 = (RJOMrcfPairInf)this.presetData.get(n4);
                    if (!rJOMrcfPairData.comparePvol(((RJOMrcfPairInf)rJOMrcfPairData2).spLdkc, ((RJOMrcfPairInf)rJOMrcfPairData2).ipCu, ((RJOMrcfPairInf)rJOMrcfPairData2).ipLdev) || 3 <= ((RJOMrcfPairInf)rJOMrcfPairData2).iMu) continue;
                    n3 |= 1 << ((RJOMrcfPairInf)rJOMrcfPairData2).iMu;
                }
            }
            for (n4 = 0; n4 < 3; ++n4) {
                if (0 != (n3 & 1 << n4)) continue;
                if (0 == n4) {
                    if (0 != n) continue;
                    arrayList.add(new Integer(n4));
                    continue;
                }
                arrayList.add(new Integer(n4));
            }
        }
        nArray = new int[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            Integer n5 = (Integer)arrayList.get(n);
            nArray[n] = n5;
        }
        return nArray;
    }

    public int getModifyStatus() {
        int n = this.data.getViewModifyStatus();
        boolean bl = this.getMrcfPermission();
        if (n != 0 && !bl) {
            RJCom.putLog(this.data, "[HOMRCF]", "[getData]", "getModifyStatus:Permission denied", 0);
            n = 0;
        }
        return n;
    }

    public JTableHeader initTable(String[] stringArray, JTable jTable, RJComEETableModel rJComEETableModel, RJComTblCRenderer rJComTblCRenderer, RJRCCellDatExt[][] rJRCCellDatExtArray) {
        TableModel tableModel = jTable.getModel();
        tableModel = null;
        tableModel = new RJComEETableModel();
        rJComEETableModel.setDataVector(rJRCCellDatExtArray, stringArray);
        jTable.setModel(rJComEETableModel);
        jTable.setRowHeight(16);
        JTableHeader jTableHeader = jTable.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        Dimension dimension = jTableHeader.getPreferredSize();
        dimension.height = 18;
        jTableHeader.setPreferredSize(dimension);
        DefaultTableColumnModel defaultTableColumnModel = (DefaultTableColumnModel)jTable.getColumnModel();
        for (int i = 0; i < stringArray.length; ++i) {
            TableColumn tableColumn = defaultTableColumnModel.getColumn(i);
            tableColumn.setCellRenderer(rJComTblCRenderer);
            if (i != stringArray.length - 1 || jTable.getAutoResizeMode() == 0) continue;
            tableColumn.setResizable(false);
        }
        jTable.revalidate();
        jTable.repaint(1L);
        return jTableHeader;
    }

    public int compPresetVol(RJOMrcfPairData rJOMrcfPairData) {
        ArrayList arrayList = new ArrayList();
        arrayList = super.getPresetData();
        if (arrayList == null) {
            return 0;
        }
        if (arrayList.size() == 0) {
            return 0;
        }
        if (10 == this.getPresetKind() || 6 == this.getPresetKind()) {
            return 0;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            RJOMrcfPairInf rJOMrcfPairInf = (RJOMrcfPairInf)arrayList.get(i);
            if (this.getPresetKind() == 5) {
                if (!rJOMrcfPairInf.comparePvol(rJOMrcfPairData.spLdkc, rJOMrcfPairData.ipCu, rJOMrcfPairData.ipLdev)) continue;
                return 1;
            }
            if (rJOMrcfPairData.ssLdkc == -1 || rJOMrcfPairData.isLdev == -1 || rJOMrcfPairData.isCu == -1) {
                if (rJOMrcfPairInf.comparePvol(rJOMrcfPairData.spLdkc, rJOMrcfPairData.ipCu, rJOMrcfPairData.ipLdev)) {
                    return 1;
                }
                if (!rJOMrcfPairInf.compareSvol(rJOMrcfPairData.spLdkc, rJOMrcfPairData.ipCu, rJOMrcfPairData.ipLdev)) continue;
                return 1;
            }
            if (rJOMrcfPairInf.comparePair(rJOMrcfPairData)) {
                return 1;
            }
            if (this.getPresetKind() != 0 && this.getPresetKind() != 1 || -1 != rJOMrcfPairInf.iPairStat) continue;
            if (rJOMrcfPairInf.comparePvol(rJOMrcfPairData.spLdkc, rJOMrcfPairData.ipCu, rJOMrcfPairData.ipLdev)) {
                return 1;
            }
            if (!rJOMrcfPairInf.compareSvol(rJOMrcfPairData.spLdkc, rJOMrcfPairData.ipCu, rJOMrcfPairData.ipLdev)) continue;
            return 1;
        }
        return 0;
    }

    public void setColumnSize(JTable jTable, int n) {
        Object object;
        int n2 = 0;
        int n3 = 0;
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            object = System.getProperty("os.name");
            n2 = object != null ? (((String)object).indexOf("Windows") != -1 ? 65 : 80) : 65;
            if (i == 2) {
                n2 = 120;
            }
            if (i == 5) {
                n2 = 120;
            }
            if (i == 0 || i == 3) {
                n2 = 190;
            }
            if (i == 6 || i == 7) {
                n2 = 80;
            }
            if (i == 4) {
                n2 = 85;
            }
            tableColumn.setPreferredWidth(n2);
            n3 += n2;
        }
        if (n3 > 0) {
            JTableHeader jTableHeader = jTable.getTableHeader();
            object = jTableHeader.getPreferredSize();
            ((Dimension)object).width = n3;
            RJCom.putLog(this.data, "[HOMRCF]", "[DataCtrl]", "setColumnSize Width=" + ((Dimension)object).width, 0);
            jTableHeader.setPreferredSize((Dimension)object);
        }
    }

    public void makeFilterClass() {
        if (this.fltInf != null) {
            this.fltInf = null;
        }
        this.fltInf = new RJMrcfFilterInf();
    }

    public RJMrcfFilterInf getFilterInf() {
        return this.fltInf;
    }

    public void setFilterInf(RJMrcfFilterInf rJMrcfFilterInf) {
        this.fltInf = rJMrcfFilterInf;
    }

    public boolean compFilterInf(int n, int n2) {
        if (!this.bFltFlg) {
            return true;
        }
        RJMrcfFilterInf rJMrcfFilterInf = this.getFilterInf();
        if (rJMrcfFilterInf.iRsv) {
            return (n2 & 0x80) == 128;
        }
        if (rJMrcfFilterInf.iPair) {
            if (n == 0) {
                if ((n2 & 0x80) == 128) {
                    return false;
                }
            }
            switch (n) {
                case 0: {
                    return rJMrcfFilterInf.iSmpl;
                }
                case 32: {
                    return rJMrcfFilterInf.iDplx;
                }
                case 112: {
                    return rJMrcfFilterInf.iFlsh;
                }
                case 16: {
                    return rJMrcfFilterInf.iPend;
                }
                case 64: {
                    return rJMrcfFilterInf.iRsyc;
                }
                case 72: {
                    return rJMrcfFilterInf.iRvRsyc;
                }
                case 80: {
                    return rJMrcfFilterInf.iSpnd;
                }
                case 48: {
                    return rJMrcfFilterInf.iSplt;
                }
                case 96: {
                    return rJMrcfFilterInf.iSpPend;
                }
                case 104: {
                    return rJMrcfFilterInf.iVSplt;
                }
                case -1: {
                    return rJMrcfFilterInf.iWait;
                }
                case 1: {
                    return rJMrcfFilterInf.bDlpd;
                }
                case 528: {
                    return rJMrcfFilterInf.bQsSt_Copy;
                }
                case 576: {
                    return rJMrcfFilterInf.bQsSt_Cprs;
                }
                case 584: {
                    return rJMrcfFilterInf.bQsSt_Crsr;
                }
                case 513: {
                    return rJMrcfFilterInf.bQsSt_Dlpd;
                }
                case 544: {
                    return rJMrcfFilterInf.bQsSt_Pair;
                }
                case 641: {
                    return rJMrcfFilterInf.bQsSt_Pfus;
                }
                case 592: {
                    return rJMrcfFilterInf.bQsSt_Psue;
                }
                case 560: {
                    return rJMrcfFilterInf.bQsSt_Psus;
                }
                case 640: {
                    return rJMrcfFilterInf.bQsSt_Rsrp;
                }
            }
            return false;
        }
        if (rJMrcfFilterInf.iNonPair) {
            if (n != 0) {
                if (n != 1) {
                    return false;
                }
            }
            if ((n2 & 0x80) == 128) {
                return false;
            }
        }
        return rJMrcfFilterInf.iPair || rJMrcfFilterInf.iNonPair;
    }

    public boolean compFilterInfEx(int n, int n2, int n3) {
        boolean bl = false;
        bl = this.compFilterInf(n, n2);
        if (bl) {
            RJMrcfFilterInf rJMrcfFilterInf = this.getFilterInf();
            if (n3 != 0) {
                if (!rJMrcfFilterInf.bExVol) {
                    bl = rJMrcfFilterInf.bExVol;
                }
            } else if (!rJMrcfFilterInf.bIntVol) {
                bl = rJMrcfFilterInf.bIntVol;
            }
        }
        return bl;
    }

    public boolean compFilterInfEx2(RJOMrcfPairData rJOMrcfPairData, int n) {
        boolean bl = false;
        if (rJOMrcfPairData != null && (bl = this.compFilterInfEx(rJOMrcfPairData.iPairStat, rJOMrcfPairData.iVolAtrb, n))) {
            RJMrcfFilterInf rJMrcfFilterInf = this.getFilterInf();
            if (-1 != rJMrcfFilterInf.iClpr && rJOMrcfPairData.ipClpr != rJMrcfFilterInf.iClpr) {
                bl = false;
            }
            if (rJOMrcfPairData instanceof RJOMrcfPairData) {
                if (rJOMrcfPairData.bQs) {
                    if (!rJMrcfFilterInf.bQsChk) {
                        bl = false;
                    }
                } else if (!rJMrcfFilterInf.bSiChk && rJOMrcfPairData.iPairStat != 0) {
                    bl = false;
                }
            }
        }
        return bl;
    }

    public MRCFgetHistInf getHistoryInf() {
        MRCFgetHistInf mRCFgetHistInf = null;
        mRCFgetHistInf = this.dataSrv.m_HistSrv;
        if (mRCFgetHistInf == null) {
            RJCom.putLog(this.data, "[HOMRCF]", "[getData]", "getHist: No Data", 0);
        }
        return mRCFgetHistInf;
    }

    public boolean getHistoryInf(short s, short s2, short s3, short s4) throws RJSiException {
        boolean bl = true;
        if (!this.isValidHistIndex(s, s2, s3)) {
            RJCom.putLog(this.data, "[HOMRCF]", "[getData]", "getHistoryInf: Invalid parameter", 0);
            bl = false;
        } else {
            try {
                this.dataSrv.getHistInf_Srv(s, s2, s3, s4);
            }
            catch (RJSiException rJSiException) {
                RJCom.putLog(this.data, "[HOMRCF]", "[getData]", "getHistoryInf: Connect error", 0);
                throw rJSiException;
            }
            catch (Exception exception) {
                RJCom.putLog(this.data, "[HOMRCF]", "[getData]", "getHistoryInf: Exception", 0);
                exception.printStackTrace();
                RJSiException rJSiException = new RJSiException();
                rJSiException.setErrParam(MSG_FUNC, 7440);
                throw rJSiException;
            }
        }
        return bl;
    }

    boolean isValidHistIndex(short s, short s2, short s3) {
        boolean bl = true;
        if (null != this.dataSrv.m_HistSrv) {
            int n = this.getSiHistIndexNum();
            if (0 != n) {
                if (s >= n) {
                    bl = false;
                }
            } else if (0 != s) {
                bl = false;
            }
            if (0 == this.getStartKind()) {
                int n2 = this.getFcHistIndexNum();
                if (0 != n2) {
                    if (s2 >= n2) {
                        bl = false;
                    }
                } else if (0 != s2) {
                    bl = false;
                }
            } else {
                int n3;
                int n4 = this.getQsHistIndexNum();
                if (0 != n4) {
                    if (s2 >= n4) {
                        bl = false;
                    }
                } else if (0 != s2) {
                    bl = false;
                }
                if (0 != (n3 = this.getTiHistIndexNum())) {
                    if (s3 >= n3) {
                        bl = false;
                    }
                } else if (0 != s3) {
                    bl = false;
                }
            }
        } else {
            if (0 != s) {
                bl = false;
            }
            if (0 != s2) {
                bl = false;
            }
            if (this.getStartKind() == 1 && 0 != s3) {
                bl = false;
            }
        }
        return bl;
    }

    int getSiHistIndexNum() {
        int n = 0;
        if (null != this.dataSrv.m_HistSrv) {
            n = this.dataSrv.m_HistSrv.getISiHistNum() / 16384;
            if (0 != this.dataSrv.m_HistSrv.getISiHistNum() % 16384) {
                ++n;
            }
        }
        return n;
    }

    int getFcHistIndexNum() {
        int n = 0;
        if (null != this.dataSrv.m_HistSrv) {
            n = this.dataSrv.m_HistSrv.getIFcHistNum() / 16384;
            if (0 != this.dataSrv.m_HistSrv.getIFcHistNum() % 16384) {
                ++n;
            }
        }
        return n;
    }

    int getQsHistIndexNum() {
        int n = 0;
        if (null != this.dataSrv.m_HistSrv) {
            n = this.dataSrv.m_HistSrv.getIQsHistNum() / 16384;
            if (0 != this.dataSrv.m_HistSrv.getIQsHistNum() % 16384) {
                ++n;
            }
        }
        return n;
    }

    int getTiHistIndexNum() {
        int n = 0;
        if (null != this.dataSrv.m_HistSrv) {
            int n2 = this.dataSrv.m_HistSrv.getITiHistNum();
            n = n2 / 16384;
            if (0 != n2 % 16384) {
                ++n;
            }
        }
        return n;
    }

    public Icon getFilterIcon() {
        Icon icon = null;
        RJMrcfFilterInf rJMrcfFilterInf = new RJMrcfFilterInf();
        boolean bl = this.chkFilterStatus();
        if (!bl) {
            if (null == this.iconFltOff) {
                this.iconFltOff = RJCom.createImgIcon(this.data, "Flt_off.gif");
            }
            icon = this.iconFltOff;
        } else {
            if (null == this.iconFltOn) {
                this.iconFltOn = RJCom.createImgIcon(this.data, "Flt_on.gif");
            }
            icon = this.iconFltOn;
        }
        return icon;
    }

    public Icon getIcon(String string) {
        Icon icon = RJCom.createImgIcon(this.data, string);
        return icon;
    }

    private boolean chkFilterStatus() {
        RJMrcfFilterInf rJMrcfFilterInf = new RJMrcfFilterInf();
        boolean bl = false;
        if (rJMrcfFilterInf.iRsv != this.fltInf.iRsv) {
            return true;
        }
        if (rJMrcfFilterInf.iNonPair != this.fltInf.iNonPair) {
            return true;
        }
        if (rJMrcfFilterInf.iPair != this.fltInf.iPair) {
            return true;
        }
        if (rJMrcfFilterInf.iSmpl != this.fltInf.iSmpl) {
            return true;
        }
        if (rJMrcfFilterInf.iDplx != this.fltInf.iDplx) {
            return true;
        }
        if (rJMrcfFilterInf.iPend != this.fltInf.iPend) {
            return true;
        }
        if (rJMrcfFilterInf.iRsyc != this.fltInf.iRsyc) {
            return true;
        }
        if (rJMrcfFilterInf.iRvRsyc != this.fltInf.iRvRsyc) {
            return true;
        }
        if (rJMrcfFilterInf.iSplt != this.fltInf.iSplt) {
            return true;
        }
        if (rJMrcfFilterInf.iSpnd != this.fltInf.iSpnd) {
            return true;
        }
        if (rJMrcfFilterInf.iSpPend != this.fltInf.iSpPend) {
            return true;
        }
        if (rJMrcfFilterInf.iVSplt != this.fltInf.iVSplt) {
            return true;
        }
        if (rJMrcfFilterInf.iFlsh != this.fltInf.iFlsh) {
            return true;
        }
        if (rJMrcfFilterInf.iCscd != this.fltInf.iCscd) {
            return true;
        }
        if (rJMrcfFilterInf.bDlpd != this.fltInf.bDlpd) {
            return true;
        }
        if (rJMrcfFilterInf.iClpr != this.fltInf.iClpr) {
            return true;
        }
        if (rJMrcfFilterInf.bExVol != this.fltInf.bExVol) {
            return true;
        }
        if (rJMrcfFilterInf.bIntVol != this.fltInf.bIntVol) {
            return true;
        }
        return this.isQsChkChanged();
    }

    boolean isQsChkChanged() {
        RJMrcfFilterInf rJMrcfFilterInf = new RJMrcfFilterInf();
        boolean bl = false;
        if (rJMrcfFilterInf.bQsChk != this.fltInf.bQsChk) {
            bl = true;
        }
        if (rJMrcfFilterInf.bSiChk != this.fltInf.bSiChk) {
            bl = true;
        }
        if (rJMrcfFilterInf.bQsSt_Copy != this.fltInf.bQsSt_Copy) {
            bl = true;
        }
        if (rJMrcfFilterInf.bQsSt_Cprs != this.fltInf.bQsSt_Cprs) {
            bl = true;
        }
        if (rJMrcfFilterInf.bQsSt_Crsr != this.fltInf.bQsSt_Crsr) {
            bl = true;
        }
        if (rJMrcfFilterInf.bQsSt_Dlpd != this.fltInf.bQsSt_Dlpd) {
            bl = true;
        }
        if (rJMrcfFilterInf.bQsSt_Pair != this.fltInf.bQsSt_Pair) {
            bl = true;
        }
        if (rJMrcfFilterInf.bQsSt_Pfus != this.fltInf.bQsSt_Pfus) {
            bl = true;
        }
        if (rJMrcfFilterInf.bQsSt_Psue != this.fltInf.bQsSt_Psue) {
            bl = true;
        }
        if (rJMrcfFilterInf.bQsSt_Psus != this.fltInf.bQsSt_Psus) {
            bl = true;
        }
        if (rJMrcfFilterInf.bQsSt_Rsrp != this.fltInf.bQsSt_Rsrp) {
            bl = true;
        }
        return bl;
    }

    public int getVolumePairKind(RJOMrcfPairData rJOMrcfPairData) {
        return this.getVolumePairKindEx(rJOMrcfPairData);
    }

    public int getVolumePairKindEx(RJOMrcfPairData rJOMrcfPairData) {
        ArrayList arrayList = new ArrayList();
        int n = -1;
        int n2 = -1;
        if (null != rJOMrcfPairData && (n = (int)rJOMrcfPairData.sNodePos) == 0 && (arrayList = this.getPresetData()) != null && arrayList.size() != 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                RJOMrcfPairInf rJOMrcfPairInf = (RJOMrcfPairInf)arrayList.get(i);
                if (!rJOMrcfPairData.comparePvol(rJOMrcfPairInf.ssLdkc, rJOMrcfPairInf.isCu, rJOMrcfPairInf.isLdev)) continue;
                int n3 = rJOMrcfPairInf.iAtrb;
                int n4 = this.getParentPairEx(rJOMrcfPairInf);
                if (n4 == 1) {
                    n = 2;
                    break;
                }
                n = 1;
                break;
            }
        }
        return n;
    }

    public int[] getPresetOption() {
        int[] nArray = new int[]{this.defOpt.optMap, this.defOpt.optMap2};
        return nArray;
    }

    public boolean compOptionInf() {
        boolean bl = true;
        MRCFgetOptInf mRCFgetOptInf = this.getOptionInf();
        if (mRCFgetOptInf == null) {
            RJCom.putLog(this.data, "[HOMRCF]", "[GetData]", "compOptionInf:data get error", 0);
        } else if (this.defOpt.optMap != mRCFgetOptInf.optMap) {
            bl = false;
        }
        return bl;
    }

    public RJDataControl getDataControl() {
        return this.data;
    }

    public String getCopyProgressName(int n, int n2) {
        String string;
        switch (n) {
            case 0: 
            case 1: 
            case 513: {
                string = this.OMR_COM_NO_DATA.getGuidance();
                break;
            }
            default: {
                int n3 = this.getCopyProgress(n2);
                new String();
                string = String.valueOf(n3) + "%";
            }
        }
        return string;
    }

    public int getCopyProgress(int n) {
        return n & 0xFFFF;
    }

    public String getCopyPaceName(int n, int n2) {
        switch (n) {
            case 1: 
            case 32: 
            case 48: 
            case 80: 
            case 513: 
            case 528: 
            case 544: 
            case 560: 
            case 576: 
            case 584: 
            case 592: 
            case 640: 
            case 641: {
                return this.OMR_COM_NO_DATA.getGuidance();
            }
        }
        return this.getCopyPaceName(n2);
    }

    public String chgSimplexName(RJOMrcfPairData rJOMrcfPairData) {
        String string;
        int n = this.getVolumePairKindEx(rJOMrcfPairData);
        switch (n) {
            case 0: {
                string = this.getPairStatusName(0);
                break;
            }
            case 1: {
                string = this.VOL_SECOND;
                break;
            }
            case 2: {
                string = this.VOL_LEAF;
                break;
            }
            default: {
                string = this.getPairStatusName(0);
            }
        }
        return string;
    }

    public ArrayList getVolumePairInf(short s, short s2, short s3) {
        ArrayList<RJOMrcfPairData> arrayList = new ArrayList<RJOMrcfPairData>();
        if (null != this.dataSrv.m_AlDspData) {
            for (int i = 0; i < this.dataSrv.m_AlDspData.size(); ++i) {
                RJOMrcfPairData rJOMrcfPairData = (RJOMrcfPairData)this.dataSrv.m_AlDspData.get(i);
                if (!rJOMrcfPairData.comparePvol(s, s2, s3)) continue;
                arrayList.add(rJOMrcfPairData);
            }
        }
        return arrayList;
    }

    public ArrayList getVolumePairInf_Srv(short s, short s2, short s3) throws RJSiException {
        ArrayList arrayList = null;
        Robj_interface_RJiLDEVIndex[] robj_interface_RJiLDEVIndexArray = new Robj_interface_RJiLDEVIndex[]{this.dataSrv.getLDEVIndex(s, s2, s3)};
        arrayList = this.dataSrv.getPairInf_NoPairFlt(robj_interface_RJiLDEVIndexArray, 24, true);
        return arrayList;
    }

    public String getPresetKindName(int n) {
        String string = "";
        if (n == -1) {
            return "";
        }
        ArrayList arrayList = super.getPresetData();
        if (arrayList == null) {
            return "";
        }
        if (arrayList.size() == 0) {
            return "";
        }
        String string2 = this.getSetKindName(n);
        switch (n) {
            case 1: {
                String string3 = this.getSplitTypeName(((RJOMrcfPairInf)arrayList.get((int)0)).iOpt);
                if (string3 == null) {
                    string3 = "";
                }
                string = string2 + "-" + string3;
                break;
            }
            case 2: {
                String string4 = this.getResyncTypeName(((RJOMrcfPairInf)arrayList.get((int)0)).iOpt);
                if (string4 == null) {
                    string4 = "";
                }
                string = string2 + "-" + string4;
                break;
            }
            default: {
                String string5 = "";
                string = string2;
            }
        }
        return string;
    }

    public String getSetKindName(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = this.getWndInfStr("HOMRCF", "OMR_COM_TITLE_CREATE", "Paircreate");
                break;
            }
            case 1: {
                string = this.getWndInfStr("HOMRCF", "OMR_COM_TITLE_SPLIT", "Pairsplit");
                break;
            }
            case 2: {
                string = this.getWndInfStr("HOMRCF", "OMR_COM_TITLE_RESYNC", "Pairresync");
                break;
            }
            case 3: {
                string = this.getWndInfStr("HOMRCF", "OMR_COM_TITLE_SPLIT_E", "Pairsplit-E");
                break;
            }
            case 4: 
            case 16: {
                string = this.getWndInfStr("HOMRCF", "OMR_COM_TITLE_SPLIT_S", "Pairsplit-S");
                break;
            }
            case 5: {
                string = this.getWndInfStr("HOMRCF", "OMR_COM_TITLE_ATTRIBUTE", "Change Reserve");
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    public String getSplitTypeName(int n) {
        switch (n) {
            case 0: {
                return this.OMR_COM_SPLTTYPE_S_SPLIT.getGuidance();
            }
            case 240: {
                return this.OMR_COM_SPLTTYPE_Q_SPLIT.getGuidance();
            }
            case 65535: {
                return this.OMR_COM_SPLTTYPE_M_SPLIT.getGuidance();
            }
        }
        return "";
    }

    public int getVolumePairKind2(RJOMrcfPairData rJOMrcfPairData) {
        ArrayList arrayList = new ArrayList();
        int n = this.getVolumePairKind(rJOMrcfPairData);
        this.getEnableSetKind2(rJOMrcfPairData.spLdkc, rJOMrcfPairData.ipCu, rJOMrcfPairData.ipLdev);
        switch (n) {
            case 0: {
                arrayList = this.getVolumePairInf(rJOMrcfPairData.ssLdkc, rJOMrcfPairData.isCu, rJOMrcfPairData.isLdev);
                if (arrayList == null) break;
                for (int i = 0; i < arrayList.size(); ++i) {
                    RJOMrcfPairData rJOMrcfPairData2 = (RJOMrcfPairData)arrayList.get(i);
                    if (rJOMrcfPairData2 == null || rJOMrcfPairData2.isCu == -1 || rJOMrcfPairData2.isLdev == -1) continue;
                    this.getEnableSetKind(rJOMrcfPairData2.iPairStat, n);
                }
                break;
            }
            case 1: {
                break;
            }
        }
        return n;
    }

    public void getEnableSetKind(int n, int n2) {
        if (n2 == 0) {
            switch (n) {
                case 0: {
                    break;
                }
                case 32: {
                    break;
                }
                case 112: {
                    break;
                }
                case 16: {
                    break;
                }
                case 64: {
                    break;
                }
                case 72: {
                    this.setKind.bCreate = false;
                    this.setKind.bSplit = false;
                    this.setKind.bResync = false;
                    this.setKind.bRsycR = false;
                    break;
                }
                case 80: {
                    break;
                }
                case 48: {
                    break;
                }
                case 96: {
                    this.setKind.bCreate = false;
                    this.setKind.bSplit = false;
                    this.setKind.bResync = false;
                    this.setKind.bRsycR = false;
                    break;
                }
                case 104: {
                    this.setKind.bCreate = false;
                    this.setKind.bSplit = false;
                    this.setKind.bResync = false;
                    this.setKind.bRsycR = false;
                    break;
                }
                case -1: {
                    break;
                }
                case 584: {
                    this.setKind.bResync = false;
                    this.setKind.bRsycR = false;
                    this.setKind.bSuspend = false;
                    this.setKind.bQRst = false;
                    break;
                }
            }
        } else {
            switch (n) {
                case 0: {
                    break;
                }
                case 32: {
                    this.setKind.bSplit = false;
                    this.setKind.bRsycR = false;
                    break;
                }
                case 112: {
                    break;
                }
                case 16: {
                    this.setKind.bSplit = false;
                    this.setKind.bRsycR = false;
                    break;
                }
                case 64: {
                    this.setKind.bSplit = false;
                    this.setKind.bRsycR = false;
                    break;
                }
                case 72: {
                    this.setKind.bSplit = false;
                    this.setKind.bRsycR = false;
                    break;
                }
                case 80: {
                    this.setKind.bSplit = false;
                    this.setKind.bRsycR = false;
                    break;
                }
                case 48: {
                    this.setKind.bRsycR = false;
                    break;
                }
                case 96: {
                    this.setKind.bSplit = false;
                    this.setKind.bRsycR = false;
                    break;
                }
                case 104: {
                    this.setKind.bSplit = false;
                    this.setKind.bRsycR = false;
                    break;
                }
                case -1: {
                    break;
                }
            }
        }
        if (RJOMrcfGetData.isQsPairStat(n)) {
            this.setKind.bQRst = false;
        }
    }

    public void getEnableSetKind2(short s, int n, int n2) {
        ArrayList arrayList;
        if (this.setKind == null) {
            this.setKind = new RJOMrcfDataControl.RJOMrcfEnableSetKind();
        }
        if ((arrayList = this.getVolumePairInf(s, (short)n, (short)n2)) != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                RJOMrcfPairData rJOMrcfPairData = (RJOMrcfPairData)arrayList.get(i);
                if (rJOMrcfPairData == null || rJOMrcfPairData.isCu == -1 || rJOMrcfPairData.isLdev == -1) continue;
                switch (rJOMrcfPairData.iPairStat) {
                    case 16: 
                    case 32: 
                    case 64: 
                    case 96: 
                    case 104: 
                    case 112: {
                        this.setKind.bRsycR = false;
                        break;
                    }
                    case 584: {
                        this.setKind.bCreate = false;
                        this.setKind.bResync = false;
                        this.setKind.bRsycR = false;
                        this.setKind.bSplit = false;
                        break;
                    }
                    case 72: {
                        if (0 == this.getStartKind()) {
                            this.setKind.bCreate = false;
                        }
                        this.setKind.bSplit = false;
                        this.setKind.bResync = false;
                        this.setKind.bRsycR = false;
                        break;
                    }
                }
                if (!RJOMrcfGetData.isQsPairStat(rJOMrcfPairData.iPairStat)) continue;
                this.setKind.bQRst = false;
            }
        }
    }

    public boolean getMrcfPermission() {
        RJDataStartParam rJDataStartParam = this.data.getStartParamClass();
        boolean bl = this.getStartKind() == 1 ? rJDataStartParam.getPermissionTABOption(6, 1) : rJDataStartParam.getPermissionTABOption(8, 1);
        return bl;
    }

    public boolean getNowMode() {
        boolean bl;
        int n = this.data.getViewModifyStatus();
        boolean bl2 = this.getMrcfPermission();
        if (n != 0) {
            if (!bl2) {
                RJCom.putLog(this.data, "[HOMRCF]", "[DataCtrl]", "getNowMode:MRCF Permission denied", 0);
                bl = false;
            } else {
                bl = true;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean getMode() {
        boolean bl = true;
        int n = this.data.getViewModifyStatus();
        bl = n != 0;
        return bl;
    }

    public boolean mrcfEmlCheck(RJOMrcfPairData rJOMrcfPairData, RJOMrcfPairData rJOMrcfPairData2) {
        boolean bl = false;
        if (null != rJOMrcfPairData && null != rJOMrcfPairData2) {
            String string;
            String string2 = this.mrcfEmlChange(rJOMrcfPairData.iEmul);
            if (string2.equals(string = this.mrcfEmlChange(rJOMrcfPairData2.iEmul))) {
                bl = true;
            } else if (rJOMrcfPairData.sVolFlg == 2 | rJOMrcfPairData2.sVolFlg == 2) {
                bl = this.mrcfEmlCheckSub(string2, string);
            }
        }
        return bl;
    }

    public String mrcfEmlChange(String string) {
        String string2 = string;
        if (string.equals(this.OMR_COM_EMU41.getGuidance())) {
            string2 = this.OMR_COM_EMU01.getGuidance();
        }
        if (string.equals(this.OMR_COM_EMU11.getGuidance())) {
            string2 = this.OMR_COM_EMU03.getGuidance();
        }
        if (string.equals(this.OMR_COM_EMU43.getGuidance())) {
            string2 = this.OMR_COM_EMU05.getGuidance();
        }
        if (string.equals(this.OMR_COM_EMU29.getGuidance())) {
            string2 = this.OMR_COM_EMU07.getGuidance();
        }
        if (string.equals(this.OMR_COM_EMU44.getGuidance())) {
            string2 = this.OMR_COM_EMU07.getGuidance();
        }
        if (string.equals(this.OMR_COM_EMU30.getGuidance())) {
            string2 = this.OMR_COM_EMU08.getGuidance();
        }
        if (string.equals(this.OMR_COM_EMU45.getGuidance())) {
            string2 = this.OMR_COM_EMU08.getGuidance();
        }
        if (string.equals(this.OMR_COM_EMU31.getGuidance())) {
            string2 = this.OMR_COM_EMU09.getGuidance();
        }
        if (string.equals(this.OMR_COM_EMU46.getGuidance())) {
            string2 = this.OMR_COM_EMU09.getGuidance();
        }
        if (string.equals(this.OMR_COM_EMU47.getGuidance())) {
            string2 = this.OMR_COM_EMU09.getGuidance();
        }
        if (string.equals(this.OMR_COM_EMU32.getGuidance())) {
            string2 = this.OMR_COM_EMU10.getGuidance();
        }
        if (string.equals(this.OMR_COM_EMU39.getGuidance())) {
            string2 = this.OMR_COM_EMU18.getGuidance();
        }
        if (string.equals(this.OMR_COM_EMU40.getGuidance())) {
            string2 = this.OMR_COM_EMU19.getGuidance();
        }
        if (string.equals(this.OMR_COM_EMU33.getGuidance())) {
            string2 = this.OMR_COM_EMU23.getGuidance();
        }
        if (string.equals(this.OMR_COM_EMU51.getGuidance())) {
            string2 = this.OMR_COM_EMU23.getGuidance();
        }
        if (string.equals(this.OMR_COM_EMU34.getGuidance())) {
            string2 = this.OMR_COM_EMU24.getGuidance();
        }
        if (string.equals(this.OMR_COM_EMU52.getGuidance())) {
            string2 = this.OMR_COM_EMU24.getGuidance();
        }
        if (string.equals(this.OMR_COM_EMU35.getGuidance())) {
            string2 = this.OMR_COM_EMU25.getGuidance();
        }
        if (string.equals(this.OMR_COM_EMU53.getGuidance())) {
            string2 = this.OMR_COM_EMU25.getGuidance();
        }
        if (string.equals(this.OMR_COM_EMU36.getGuidance())) {
            string2 = this.OMR_COM_EMU26.getGuidance();
        }
        if (string.equals(this.OMR_COM_EMU37.getGuidance())) {
            string2 = this.OMR_COM_EMU27.getGuidance();
        }
        if (string.equals(this.OMR_COM_EMU38.getGuidance())) {
            string2 = this.OMR_COM_EMU28.getGuidance();
        }
        return string2;
    }

    public boolean mrcfEmlCheckSub(String string, String string2) {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(10);
        StringBuffer stringBuffer2 = new StringBuffer(10);
        StringBuffer stringBuffer3 = new StringBuffer(10);
        StringBuffer stringBuffer4 = new StringBuffer(10);
        StringBuffer stringBuffer5 = new StringBuffer(10);
        StringBuffer stringBuffer6 = new StringBuffer(10);
        stringBuffer.append(string + "A");
        stringBuffer2.append(string + "B");
        stringBuffer3.append(string + "C");
        stringBuffer4.append(string2 + "A");
        stringBuffer5.append(string2 + "B");
        stringBuffer6.append(string2 + "C");
        if (string.equals(stringBuffer4.toString())) {
            bl = true;
        }
        if (string.equals(stringBuffer5.toString())) {
            bl = true;
        }
        if (string.equals(stringBuffer6.toString())) {
            bl = true;
        }
        if (string2.equals(stringBuffer.toString())) {
            bl = true;
        }
        if (string2.equals(stringBuffer2.toString())) {
            bl = true;
        }
        if (string2.equals(stringBuffer3.toString())) {
            bl = true;
        }
        return bl;
    }

    public String getEmurationTypeWithLUExtension(RJOMrcfPairData rJOMrcfPairData) {
        String string = "";
        if (rJOMrcfPairData != null && rJOMrcfPairData.iEmul != null) {
            string = string + rJOMrcfPairData.iEmul;
            if (rJOMrcfPairData.iVolLuse > 1) {
                string = string + "*" + rJOMrcfPairData.iVolLuse;
            }
        }
        return string;
    }

    public String getSplitGroupString(int n) {
        String string = "";
        string = -1 == n ? this.NO_DATA : Integer.toString(n);
        return string;
    }

    public RJMrcfCtgDetail getCtgInf(int n) {
        RJMrcfCtgDetail rJMrcfCtgDetail = null;
        if (n < 0 || n >= 128) {
            RJCom.putLog(this.data, "[HOMRCF]", "[getData]", "getCtgInf : Param error.", 0);
        } else {
            ArrayList arrayList = this.dataSrv.getCtgDispData();
            if (null != arrayList) {
                block0: for (int i = 0; i < arrayList.size(); ++i) {
                    RJMrcfCtgDetail rJMrcfCtgDetail2 = (RJMrcfCtgDetail)arrayList.get(i);
                    if (n != rJMrcfCtgDetail2.iCtgId) continue;
                    rJMrcfCtgDetail = rJMrcfCtgDetail2;
                    if (10 != this.presetKind || null == this.presetData || 0 == this.presetData.size()) break;
                    for (int j = 0; j < this.presetData.size(); ++j) {
                        RJMrcfCtgDetail rJMrcfCtgDetail3 = (RJMrcfCtgDetail)this.presetData.get(j);
                        if (rJMrcfCtgDetail.iCtgId != rJMrcfCtgDetail3.iCtgId) continue;
                        rJMrcfCtgDetail.iErrCode = rJMrcfCtgDetail3.iErrCode;
                        break block0;
                    }
                    break;
                }
            }
        }
        return rJMrcfCtgDetail;
    }

    public RJMrcfCtgDetail getDispCtgInf(int n) {
        RJMrcfCtgDetail rJMrcfCtgDetail = null;
        if (n < 0 || n >= 128) {
            RJCom.putLog(this.data, "[HOMRCF]", "[getData]", "getCtgInf : Param error.", 0);
        } else {
            int[] nArray = new int[4];
            int[] nArray2 = new int[4];
            if (this.presetData != null) {
                block4: for (int i = 0; i < this.presetData.size(); ++i) {
                    RJMrcfCtgDetail rJMrcfCtgDetail2 = (RJMrcfCtgDetail)this.presetData.get(i);
                    switch (rJMrcfCtgDetail2.iCtgAtrb) {
                        case 1: {
                            nArray = this.chkBitMap(nArray, rJMrcfCtgDetail2.iCtgId);
                            continue block4;
                        }
                        case 2: {
                            nArray2 = this.chkBitMap(nArray2, rJMrcfCtgDetail2.iCtgId);
                            continue block4;
                        }
                    }
                }
            }
            if ((rJMrcfCtgDetail = this.getCtgInf(n)) == null) {
                RJCom.putLog(this.data, "[HOMRCF]", "[getData]", "getCtgInf : Detail Data error.", 0);
            } else if ((rJMrcfCtgDetail.iCtgAtrb & 0x20) == 0) {
                if (this.isChkCtgBitMap(nArray, rJMrcfCtgDetail.iCtgId)) {
                    if (rJMrcfCtgDetail != null) {
                        rJMrcfCtgDetail.iCtgAtrb = 128;
                    }
                } else if (this.isChkCtgBitMap(nArray2, rJMrcfCtgDetail.iCtgId) && rJMrcfCtgDetail != null) {
                    rJMrcfCtgDetail.iCtgAtrb = 0;
                }
            } else if (rJMrcfCtgDetail.iErrCode != 0) {
                if (this.isChkCtgBitMap(nArray, rJMrcfCtgDetail.iCtgId)) {
                    if (rJMrcfCtgDetail != null) {
                        rJMrcfCtgDetail.iCtgAtrb = 128;
                    }
                } else if (this.isChkCtgBitMap(nArray2, rJMrcfCtgDetail.iCtgId) && rJMrcfCtgDetail != null) {
                    rJMrcfCtgDetail.iCtgAtrb = 0;
                }
            } else {
                RJCom.putLog(this.data, "[HOMRCF]", "[getData]", "getCtgInf : Not for show", 0);
            }
        }
        return rJMrcfCtgDetail;
    }

    public ArrayList getCtgDetail(int n) {
        ArrayList<RJMrcfCtgDetail> arrayList = new ArrayList<RJMrcfCtgDetail>();
        ArrayList arrayList2 = this.dataSrv.getCtgDispData();
        if (arrayList2 == null) {
            RJCom.putLog(this.data, "[HOMRCF]", "[getData]", "getCtgDetail : Data error.", 0);
            arrayList = null;
        } else {
            block7: for (int i = 0; i < arrayList2.size(); ++i) {
                RJMrcfCtgDetail rJMrcfCtgDetail = (RJMrcfCtgDetail)arrayList2.get(i);
                if (rJMrcfCtgDetail == null) {
                    RJCom.putLog(this.data, "[HOMRCF]", "[getData]", "getCtgDetail : Detail Data Failed.Grp=" + i, 0);
                    continue;
                }
                int n2 = rJMrcfCtgDetail.iCtgAtrb;
                switch (n) {
                    case 1: {
                        if ((n2 & 0x20) != 0 || (n2 & 0x80) == 0 || (n2 & 0x40) != 0) continue block7;
                        arrayList.add(rJMrcfCtgDetail);
                        continue block7;
                    }
                    case 2: {
                        if ((n2 & 0x20) != 0 || (n2 & 0x80) != 0 || (n2 & 0x40) != 0) continue block7;
                        arrayList.add(rJMrcfCtgDetail);
                        continue block7;
                    }
                    case 3: {
                        if ((n2 & 0x20) != 0 || (n2 & 0x80) == 0 || (n2 & 0x40) == 0) continue block7;
                        arrayList.add(rJMrcfCtgDetail);
                        continue block7;
                    }
                    case 4: {
                        if ((n2 & 0x20) == 0 || (n2 & 0x80) == 0) continue block7;
                        arrayList.add(rJMrcfCtgDetail);
                        continue block7;
                    }
                    case 5: {
                        if ((n2 & 0x20) != 0) continue block7;
                        arrayList.add(rJMrcfCtgDetail);
                        continue block7;
                    }
                    default: {
                        RJCom.putLog(this.data, "[HOMRCF]", "[getData]", "getCtgDetail : Param error.", 0);
                        arrayList = null;
                        return arrayList;
                    }
                }
            }
        }
        return arrayList;
    }

    public ArrayList getDispCtgDetail(int n) {
        ArrayList<RJMrcfCtgDetail> arrayList = new ArrayList<RJMrcfCtgDetail>();
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        if (arrayList == null) {
            return arrayList;
        }
        if (this.presetData != null) {
            block11: for (int i = 0; i < this.presetData.size(); ++i) {
                RJMrcfCtgDetail rJMrcfCtgDetail = (RJMrcfCtgDetail)this.presetData.get(i);
                switch (rJMrcfCtgDetail.iCtgAtrb) {
                    case 1: {
                        nArray = this.chkBitMap(nArray, rJMrcfCtgDetail.iCtgId);
                        continue block11;
                    }
                    case 2: {
                        nArray2 = this.chkBitMap(nArray2, rJMrcfCtgDetail.iCtgId);
                        continue block11;
                    }
                }
            }
        }
        ArrayList arrayList2 = this.dataSrv.getCtgDispData();
        block12: for (int i = 0; i < arrayList2.size(); ++i) {
            RJMrcfCtgDetail rJMrcfCtgDetail;
            int n2;
            RJMrcfCtgDetail rJMrcfCtgDetail2 = (RJMrcfCtgDetail)arrayList2.get(i);
            if (rJMrcfCtgDetail2 == null) {
                RJCom.putLog(this.data, "[HOMRCF]", "[getData]", "getDispCtgDetail : Detail Data Failed.Grp=" + i, 0);
                continue;
            }
            if (10 == this.presetKind && null != this.presetData && 0 != this.presetData.size()) {
                for (n2 = 0; n2 < this.presetData.size(); ++n2) {
                    rJMrcfCtgDetail = (RJMrcfCtgDetail)this.presetData.get(n2);
                    if (rJMrcfCtgDetail2.iCtgId != rJMrcfCtgDetail.iCtgId) continue;
                    rJMrcfCtgDetail2.iErrCode = rJMrcfCtgDetail.iErrCode;
                    break;
                }
            }
            n2 = rJMrcfCtgDetail2.iCtgAtrb;
            switch (n) {
                case 1: {
                    if (this.isChkCtgBitMap(nArray, rJMrcfCtgDetail2.getCtgId())) {
                        rJMrcfCtgDetail2.iCtgAtrb = 128;
                        arrayList.add(rJMrcfCtgDetail2);
                        continue block12;
                    }
                    if (this.isChkCtgBitMap(nArray2, rJMrcfCtgDetail2.getCtgId()) || (n2 & 0x20) != 0 || (n2 & 0x80) == 0 || (n2 & 0x40) != 0) continue block12;
                    arrayList.add(rJMrcfCtgDetail2);
                    continue block12;
                }
                case 2: {
                    if (this.isChkCtgBitMap(nArray, rJMrcfCtgDetail2.iCtgId)) continue block12;
                    if (this.isChkCtgBitMap(nArray2, rJMrcfCtgDetail2.getCtgId())) {
                        rJMrcfCtgDetail2.iCtgAtrb = 0;
                        arrayList.add(rJMrcfCtgDetail2);
                        continue block12;
                    }
                    if ((n2 & 0x20) != 0 || (n2 & 0x80) != 0 || (n2 & 0x40) != 0) continue block12;
                    arrayList.add(rJMrcfCtgDetail2);
                    continue block12;
                }
                case 3: {
                    if ((n2 & 0x20) != 0 || (n2 & 0x80) == 0 || (n2 & 0x40) == 0) continue block12;
                    arrayList.add(rJMrcfCtgDetail2);
                    continue block12;
                }
                case 4: {
                    if ((n2 & 0x20) == 0 || (n2 & 0x80) == 0) continue block12;
                    arrayList.add(rJMrcfCtgDetail2);
                    continue block12;
                }
                case 5: {
                    rJMrcfCtgDetail = rJMrcfCtgDetail2;
                    if ((n2 & 0x20) == 0) {
                        if (this.isChkCtgBitMap(nArray, rJMrcfCtgDetail2.getCtgId())) {
                            rJMrcfCtgDetail2.iCtgAtrb = 128;
                        } else if (this.isChkCtgBitMap(nArray2, rJMrcfCtgDetail2.getCtgId())) {
                            rJMrcfCtgDetail2.iCtgAtrb = 0;
                        }
                        arrayList.add(rJMrcfCtgDetail2);
                        continue block12;
                    }
                    if (rJMrcfCtgDetail != null && rJMrcfCtgDetail.iErrCode != 0) {
                        RJCom.putLog(this.data, "[HOMRCF]", "[getData]", "getDispCtgDetail : GrpID:Code=" + rJMrcfCtgDetail.iCtgId + ":" + rJMrcfCtgDetail.iErrCode, 0);
                        if (this.isChkCtgBitMap(nArray, rJMrcfCtgDetail2.getCtgId())) {
                            rJMrcfCtgDetail2.iCtgAtrb = 128;
                        } else if (this.isChkCtgBitMap(nArray2, rJMrcfCtgDetail2.getCtgId())) {
                            rJMrcfCtgDetail2.iCtgAtrb = 0;
                        }
                        arrayList.add(rJMrcfCtgDetail2);
                        continue block12;
                    }
                    RJCom.putLog(this.data, "[HOMRCF]", "[getData]", "getDispCtgDetail : used from open host. " + rJMrcfCtgDetail.iCtgId, 0);
                    continue block12;
                }
                default: {
                    RJCom.putLog(this.data, "[HOMRCF]", "[getData]", "getDispCtgDetail : Param error.", 0);
                    arrayList = null;
                    return arrayList;
                }
            }
        }
        return arrayList;
    }

    public boolean isChkCtgBitMap(int[] nArray, int n) {
        boolean bl = false;
        int n2 = n / 32;
        if (n2 > nArray.length) {
            return bl;
        }
        int n3 = n % 32;
        int n4 = Integer.MIN_VALUE >>> n3;
        if ((nArray[n2] & n4) != 0) {
            bl = true;
        }
        return bl;
    }

    public int[] chkBitMap(int[] nArray, int n) {
        boolean bl = false;
        int n2 = n / 32;
        if (n2 > nArray.length) {
            return nArray;
        }
        int n3 = n % 32;
        nArray[n2] = nArray[n2] | Integer.MIN_VALUE >>> n3;
        return nArray;
    }

    public boolean prechkCtgSetData(RJMrcfCtgDetail rJMrcfCtgDetail) {
        boolean bl = false;
        RJMrcfCtgDetail rJMrcfCtgDetail2 = this.getCtgInf(rJMrcfCtgDetail.iCtgId);
        if (rJMrcfCtgDetail2 != null) {
            switch (rJMrcfCtgDetail.iCtgAtrb) {
                case 2: {
                    if ((rJMrcfCtgDetail2.iCtgAtrb & 0x20) == 0 && (rJMrcfCtgDetail2.iCtgAtrb & 0x80) != 0 && (rJMrcfCtgDetail2.iCtgAtrb & 0x40) == 0) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 1: {
                    if ((rJMrcfCtgDetail2.iCtgAtrb & 0x20) == 0 && (rJMrcfCtgDetail2.iCtgAtrb & 0x80) == 0 && (rJMrcfCtgDetail2.iCtgAtrb & 0x40) == 0) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    bl = false;
                }
            }
        }
        return bl;
    }

    public int getCtgGroupStatus(int n) {
        int n2 = -1;
        n2 = n == -1 ? -1 : ((n & 0x20) != 0 ? 65535 : ((n & 0x20) == 0 && (n & 0x80) == 0 && (n & 0x40) == 0 ? 0 : ((n & 0x20) == 0 && (n & 0x80) != 0 && (n & 0x40) == 0 ? 128 : 64)));
        return n2;
    }

    public void changeCtgPresetData() {
        if (this.presetKind != 10) {
            this.deleteAllPresetData();
            return;
        }
        for (int i = this.presetData.size() - 1; i > -1; --i) {
            RJMrcfCtgDetail rJMrcfCtgDetail = (RJMrcfCtgDetail)this.presetData.get(i);
            RJMrcfCtgDetail rJMrcfCtgDetail2 = this.getCtgInf(rJMrcfCtgDetail.iCtgId);
            if (rJMrcfCtgDetail2 != null) {
                int n = this.getCtgGroupStatus(rJMrcfCtgDetail2.iCtgAtrb);
                if (n != 65535 || rJMrcfCtgDetail.iErrCode != 0) continue;
                this.presetData.remove(i);
                continue;
            }
            this.presetData.remove(i);
        }
    }

    public String getClprName(int n) {
        PRMName pRMName;
        String string;
        String string2 = null;
        string2 = n != -1 ? ((string = (pRMName = this.data.getPRMNameData()).getCLPRName(n)) != null && string.length() != 0 ? RJComUty.itoa(n, 2) + ":" + string : RJComUty.itoa(n, 2)) : this.OMR_COM_NO_DATA.getGuidance();
        return string2;
    }

    public int getExVolAtrb(byte by) {
        int n = 0;
        n = by != 0 ? 1 : 0;
        return n;
    }

    public boolean isSameExp(RJOMrcfPairData rJOMrcfPairData, RJOMrcfPairData rJOMrcfPairData2) {
        boolean bl = false;
        if (null != rJOMrcfPairData && null != rJOMrcfPairData2) {
            if (rJOMrcfPairData.lLba == rJOMrcfPairData2.lLba) {
                if (null != rJOMrcfPairData.alLbaLuse && null != rJOMrcfPairData2.alLbaLuse) {
                    ArrayList arrayList = rJOMrcfPairData.alLbaLuse;
                    ArrayList arrayList2 = rJOMrcfPairData2.alLbaLuse;
                    if (arrayList.size() == arrayList2.size()) {
                        boolean bl2 = false;
                        for (int i = 0; i < arrayList.size(); ++i) {
                            Long l = (Long)arrayList.get(i);
                            Long l2 = (Long)arrayList2.get(i);
                            if (l.longValue() == l2.longValue()) continue;
                            RJCom.putLog(this.data, "[HOMRCF]", "[getData]", "isSameExp : different Exp. data.", 0);
                            bl2 = true;
                            break;
                        }
                        if (!bl2) {
                            bl = true;
                        }
                    } else {
                        RJCom.putLog(this.data, "[HOMRCF]", "[getData]", "isSameExp : different Exp. size.", 0);
                    }
                } else {
                    RJCom.putLog(this.data, "[HOMRCF]", "[getData]", "isSameExp : Exp. data failed.", 0);
                }
            } else {
                RJCom.putLog(this.data, "[HOMRCF]", "[getData]", "isSameExp : different LBA.", 0);
            }
        } else {
            RJCom.putLog(this.data, "[HOMRCF]", "[getData]", "isSameExp : Parameter error.", 0);
        }
        return bl;
    }

    public Component getVisibleComponent(Component component) {
        Component component2;
        for (component2 = component; component2 != null && !component2.isVisible(); component2 = component2.getParent()) {
        }
        return component2;
    }

    public String makeVolString(RJOMrcfPairData rJOMrcfPairData, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        if (null != rJOMrcfPairData) {
            if ((n & 0x80) == 128) {
                if (null != rJOMrcfPairData.pvolDtl) {
                    stringBuffer2.append(RJComUty.getLDEVDisplayName(rJOMrcfPairData.pvolDtl));
                } else {
                    stringBuffer2.append(this.ERR_STRING);
                }
                if ((n & 8) != 8) {
                    stringBuffer.append(this.getPortName((short)rJOMrcfPairData.ipPort));
                    stringBuffer.append("-");
                    if (-1 != rJOMrcfPairData.ipGrp) {
                        stringBuffer.append(RJComUty.itoh(rJOMrcfPairData.ipGrp, 2));
                    } else {
                        stringBuffer.append(this.ERR_STRING);
                    }
                    stringBuffer.append("-");
                    if (-1 != rJOMrcfPairData.ipLun) {
                        stringBuffer.append(this.getLUNDisplayString(rJOMrcfPairData.ipLun));
                    } else {
                        stringBuffer.append(this.ERR_STRING);
                    }
                    stringBuffer.append("(");
                    stringBuffer.append(stringBuffer2.toString());
                    stringBuffer.append(")");
                } else {
                    stringBuffer.append(stringBuffer2.toString());
                }
            } else if ((n & 0x40) == 64) {
                if (null != rJOMrcfPairData.svolDtl) {
                    stringBuffer2.append(RJComUty.getLDEVDisplayName(rJOMrcfPairData.svolDtl));
                } else {
                    stringBuffer2.append(this.ERR_STRING);
                }
                if ((n & 8) != 8) {
                    stringBuffer.append(this.getPortName((short)rJOMrcfPairData.isPort));
                    stringBuffer.append("-");
                    if (-1 != rJOMrcfPairData.isGrp) {
                        stringBuffer.append(RJComUty.itoh(rJOMrcfPairData.isGrp, 2));
                    } else {
                        stringBuffer.append(this.ERR_STRING);
                    }
                    stringBuffer.append("-");
                    if (-1 != rJOMrcfPairData.isLun) {
                        stringBuffer.append(super.getLUNDisplayString(rJOMrcfPairData.isLun));
                    } else {
                        stringBuffer.append(this.ERR_STRING);
                    }
                    stringBuffer.append("(");
                    stringBuffer.append(stringBuffer2.toString());
                    stringBuffer.append(")");
                } else {
                    stringBuffer.append(stringBuffer2.toString());
                }
            } else {
                stringBuffer.append(this.ERR_STRING);
            }
        } else {
            stringBuffer.append(this.ERR_STRING);
        }
        return stringBuffer.toString();
    }

    public String makeVolString(short s, short s2, short s3) {
        return RJComUty.getLDEVDisplayName(s, s2, s3);
    }

    public void makePresetVolBitMap(int[] nArray) {
        if (nArray == null || nArray.length < 4096) {
            RJCom.putLog(this.data, "[HOMRCF]", "[getData]", "makePresetVolBitMap:invalid param.", 0);
        } else {
            ArrayList arrayList = super.getPresetData();
            if (arrayList != null) {
                block4: for (int i = 0; i < arrayList.size(); ++i) {
                    RJOMrcfPairInf rJOMrcfPairInf = (RJOMrcfPairInf)arrayList.get(i);
                    int n = this.getPresetKind();
                    switch (n) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            this.setLdevBitMapOn(nArray, rJOMrcfPairInf.spLdkc << 8 | rJOMrcfPairInf.ipCu, rJOMrcfPairInf.ipLdev);
                            this.setLdevBitMapOn(nArray, rJOMrcfPairInf.ssLdkc << 8 | rJOMrcfPairInf.isCu, rJOMrcfPairInf.isLdev);
                            continue block4;
                        }
                        case 5: {
                            this.setLdevBitMapOn(nArray, rJOMrcfPairInf.spLdkc << 8 | rJOMrcfPairInf.ipCu, rJOMrcfPairInf.ipLdev);
                            continue block4;
                        }
                    }
                }
            }
        }
    }

    public void disposeFilterDialog(boolean bl) {
        this.bFltClose = bl;
        this.nowDlg.dispose();
    }

    public void showFilterDialog() {
        this.bFltClose = false;
        this.nowDlg.show();
    }

    int chkLpr(RJOMrcfPairData rJOMrcfPairData) {
        int n = 0;
        boolean bl = true;
        boolean bl2 = true;
        if (rJOMrcfPairData.spSlpr == rJOMrcfPairData.ssSlpr) {
            if (rJOMrcfPairData.ipClpr != rJOMrcfPairData.isClpr) {
                bl = false;
            }
        } else {
            bl2 = false;
        }
        if (!bl2) {
            n = 59069;
        } else if (!bl) {
            n = 59000;
        }
        return n;
    }

    ArrayList getAllClprNum() {
        int n;
        PRMCLPRName[] pRMCLPRNameArray;
        int n2;
        ArrayList<PRMCLPRName[]> arrayList = new ArrayList<PRMCLPRName[]>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        PRMName pRMName = this.data.getPRMNameData();
        if (null != pRMName && null != pRMName.prmSLPRName) {
            for (n2 = 0; n2 < pRMName.prmSLPRName.length; ++n2) {
                pRMCLPRNameArray = pRMName.prmSLPRName[n2].prmCLPRName;
                if (null == pRMCLPRNameArray) continue;
                for (n = 0; n < pRMCLPRNameArray.length; ++n) {
                    arrayList2.add(new Integer(pRMCLPRNameArray[n].nID));
                }
            }
        }
        for (n2 = 0; n2 < arrayList2.size(); ++n2) {
            pRMCLPRNameArray = (PRMCLPRName[])arrayList2.get(n2);
            if (n2 == 0) {
                arrayList.add(pRMCLPRNameArray);
                continue;
            }
            n = 0;
            for (int i = 0; i < arrayList.size(); ++i) {
                Integer n3 = (Integer)arrayList.get(i);
                if (n3 <= pRMCLPRNameArray.intValue()) continue;
                arrayList.add(i, pRMCLPRNameArray);
                n = 1;
                break;
            }
            if (n != 0) continue;
            arrayList.add(pRMCLPRNameArray);
        }
        return arrayList;
    }

    public ArrayList getSnapshotInf(short s, short s2, short s3) {
        ArrayList arrayList = this.getVolumePairInf(s, s2, s3);
        if (arrayList != null) {
            for (int i = arrayList.size() - 1; i > -1; --i) {
                RJOMrcfPairData rJOMrcfPairData = (RJOMrcfPairData)arrayList.get(i);
                if (RJOMrcfGetData.isQsPairStat(rJOMrcfPairData.iPairStat)) continue;
                arrayList.remove(i);
            }
        }
        return arrayList;
    }

    public static boolean isQsPairStat(int n) {
        boolean bl = false;
        switch (n) {
            case 513: 
            case 528: 
            case 544: 
            case 560: 
            case 576: 
            case 584: 
            case 592: 
            case 640: 
            case 641: {
                bl = true;
                break;
            }
        }
        return bl;
    }

    public Object getPoolInf() {
        return this.dataSrv.m_PoolSrv;
    }

    public int getVolId(RJOMrcfPairData rJOMrcfPairData) {
        int n = -1;
        if (null != rJOMrcfPairData) {
            n = this.getVolId(rJOMrcfPairData.spLdkc, rJOMrcfPairData.ipCu, rJOMrcfPairData.ipLdev);
        }
        return n;
    }

    public int getVolId(int n, int n2, int n3) {
        int n4 = -1;
        n4 = n << 16 | n2 << 8 | n3;
        return n4;
    }

    public int getPairIconId(RJOMrcfPairData rJOMrcfPairData) {
        int n = 42;
        if (null != rJOMrcfPairData) {
            if (rJOMrcfPairData instanceof RJOMrcfPairInf) {
                n = 126;
            } else if (RJOMrcfGetData.isQsPairStat(rJOMrcfPairData.iPairStat)) {
                n = 202;
            } else {
                int n2 = this.getVolumePairKindEx(rJOMrcfPairData);
                if (n2 == 0) {
                    n = 122;
                    int n3 = rJOMrcfPairData.iVolAtrb;
                    if ((n3 & 0x80) == 128) {
                        n = 126;
                    } else if (0 == rJOMrcfPairData.iPairStat) {
                        n = 42;
                    }
                } else if (n2 == 1) {
                    n = 124;
                    if (0 == rJOMrcfPairData.iPairStat) {
                        n = 121;
                    }
                } else {
                    n = 121;
                }
            }
        }
        return n;
    }

    public String getResyncTypeDirection(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = this.getWndInfStr("HOMRCF", "OMR_COM_P_S", "(P->S)");
                break;
            }
            case 64: {
                string = this.getWndInfStr("HOMRCF", "OMR_COM_P_S", "(P->S)");
                break;
            }
            case 1: {
                string = this.getWndInfStr("HOMRCF", "OMR_COM_S_P", "(S->P)");
                break;
            }
            case 129: {
                string = this.getWndInfStr("HOMRCF", "OMR_COM_S_P", "(S->P)");
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    public int getSiPairNum(RJOMrcfPairData rJOMrcfPairData) {
        int n = 0;
        if (null != rJOMrcfPairData) {
            ArrayList arrayList = this.getVolumePairInf(rJOMrcfPairData.spLdkc, rJOMrcfPairData.ipCu, rJOMrcfPairData.ipLdev);
            if (0 != arrayList.size()) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    RJOMrcfPairData rJOMrcfPairData2 = (RJOMrcfPairData)arrayList.get(i);
                    if (null != rJOMrcfPairData2) {
                        if (0 == rJOMrcfPairData2.iPairStat || RJOMrcfGetData.isQsPairStat(rJOMrcfPairData2.iPairStat)) continue;
                        ++n;
                        continue;
                    }
                    RJCom.putLog(this.data, "[HOMRCF]", "[getData]", "getSiPairNum:Pair data not exist.", 0);
                }
            } else {
                RJCom.putLog(this.data, "[HOMRCF]", "[getData]", "getSiPairNum:Pair data not exist.", 0);
            }
        } else {
            RJCom.putLog(this.data, "[HOMRCF]", "[getData]", "getSiPairNum:invalid param.", 0);
        }
        return n;
    }

    boolean chkStatSpdMig(RJOMrcfPairData rJOMrcfPairData) {
        boolean bl = false;
        if (rJOMrcfPairData.iPairStat == 80 && 0 != (rJOMrcfPairData.sStatOpt & 1)) {
            bl = true;
        }
        return bl;
    }

    public boolean isExtMFVol(RJiLDEVInfoDetail3 rJiLDEVInfoDetail3) {
        RJiLDEVInfoDetail3 rJiLDEVInfoDetail32;
        boolean bl = false;
        if (rJiLDEVInfoDetail3 instanceof RJiLDEVInfoDetail3 && (rJiLDEVInfoDetail32 = rJiLDEVInfoDetail3).isExternalMFVolume()) {
            bl = true;
        }
        return bl;
    }

    public int getCtgGroupStatusDisplay(int n) {
        int n2 = -1;
        n2 = n == -1 ? -1 : ((n & 0x20) != 0 ? 65535 : ((n & 0x20) == 0 && (n & 0x80) == 0 && (n & 0x40) == 0 ? 0 : ((n & 0x20) == 0 && (n & 0x80) != 0 && (n & 0x40) == 0 ? 128 : ((n & 8) == 0 ? 64 : 8))));
        return n2;
    }
}

