/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.openldevguard.dctl;

import java.util.Iterator;
import sanproject.client.openldevguard.dctl.DruLdevInterface;
import sanproject.client.openldevguard.dctl.ManageDeleteAllExtents;
import sanproject.client.openldevguard.dctl.ManageGuardRetention;
import sanproject.client.openldevguard.dctl.ManageLdevInfo;
import sanproject.client.openldevguard.dctl.ManageVmaInfo;
import sanproject.client.openldevguard.dctl.RJODGDDataControl;
import sanproject.client.openldevguard.dctl.RJODGDException;
import sanproject.client.openldevguard.dctl.com.ManageReadWriteDataInterface;
import sanproject.client.openldevguard.dctl.extent.RJODGDExtentManager;
import sanproject.common.Robj_interface_RJiLDEVIndex;

public class RJODGDLdev
implements DruLdevInterface {
    private final int ldkcNumber;
    private final int cuNumber;
    private final int ldevNumber;
    private final RJODGDDataControl dataControl;
    private final ManageGuardRetention guardRetentionManager;
    private final ManageVmaInfo vmaInfoManager;
    private final ManageDeleteAllExtents deleleAllExtentsManager;
    private final ManageLdevInfo ldevInfoManager;

    public RJODGDLdev(RJODGDDataControl rJODGDDataControl, int n, int n2, int n3) {
        this.dataControl = rJODGDDataControl;
        this.ldkcNumber = n;
        this.cuNumber = n2;
        this.ldevNumber = n3;
        this.guardRetentionManager = this.dataControl.getGuardRetentionManager();
        this.vmaInfoManager = this.dataControl.getSetVmaDataManager();
        this.deleleAllExtentsManager = this.dataControl.getDeleteAllExtentsManager();
        this.ldevInfoManager = this.dataControl.getLdevInfoManager();
    }

    public boolean canChgAttribute() {
        boolean bl = false;
        if (this.dataControl.getOperationState().canChgAttribute() && this.guardRetentionManager.canChangeAttribute(this.ldkcNumber, this.cuNumber, this.ldevNumber)) {
            bl = true;
        }
        return bl;
    }

    public boolean canChgSvol() {
        boolean bl = false;
        if (this.dataControl.getOperationState().canChgSvol() && this.guardRetentionManager.canChangeSVolState(this.ldkcNumber, this.cuNumber, this.ldevNumber)) {
            bl = true;
        }
        return bl;
    }

    public boolean canChgRmReserved() {
        boolean bl = false;
        if (this.dataControl.getOperationState().canChgRmReserved() && this.guardRetentionManager.canChangeReserved(this.ldkcNumber, this.cuNumber, this.ldevNumber)) {
            bl = true;
        }
        return bl;
    }

    public boolean canClearSpMode() {
        boolean bl = false;
        if (this.dataControl.getOperationState().canClearSpMode() && this.guardRetentionManager.canClearMode(this.ldkcNumber, this.cuNumber, this.ldevNumber)) {
            bl = true;
        }
        return bl;
    }

    public boolean canChgRetentionTerm() {
        boolean bl = false;
        if (this.dataControl.getOperationState().canChgRetentionTerm() && this.guardRetentionManager.canChgRetentionTerm(this.ldkcNumber, this.cuNumber, this.ldevNumber)) {
            bl = true;
        }
        return bl;
    }

    public boolean canSetVma() {
        boolean bl = false;
        if (this.dataControl.getOperationState().canSetVma() && this.guardRetentionManager.canSetVma(this.ldkcNumber, this.cuNumber, this.ldevNumber) && this.vmaInfoManager.canSetVma(this.ldkcNumber, this.cuNumber, this.ldevNumber)) {
            bl = true;
        }
        return bl;
    }

    public boolean canDeleteVma() {
        boolean bl = false;
        if (this.dataControl.getOperationState().canDeleteVma() && this.vmaInfoManager.canDeleteVma(this.ldkcNumber, this.cuNumber, this.ldevNumber)) {
            bl = true;
        }
        return bl;
    }

    public boolean canReleaseVma() {
        boolean bl = false;
        if (this.dataControl.getOperationState().canReleaseVma() && this.vmaInfoManager.canReleaseVma(this.ldkcNumber, this.cuNumber, this.ldevNumber)) {
            bl = true;
        }
        return bl;
    }

    public boolean canAllReleaseExtent() {
        boolean bl = false;
        if (this.dataControl.getOperationState().canAllReleaseExtent() && this.deleleAllExtentsManager.canDeleteAllExtents(this.ldkcNumber, this.cuNumber, this.ldevNumber)) {
            bl = true;
        }
        return bl;
    }

    public String toString() {
        return this.ldevInfoManager.getLdevString(this.ldkcNumber, this.cuNumber, this.ldevNumber);
    }

    public boolean canCopyExtent() {
        return false;
    }

    public boolean canAllChgDefault() {
        return false;
    }

    public boolean isCopyExtent(int n, int n2) {
        return false;
    }

    public int getLdkc() {
        return this.ldkcNumber;
    }

    public int getCu() {
        return this.cuNumber;
    }

    public int getLdev() {
        return this.ldevNumber;
    }

    public byte getGuard() {
        return this.guardRetentionManager.getChangeAttribute(this.ldkcNumber, this.cuNumber, this.ldevNumber);
    }

    public byte getOldGuard() {
        return this.guardRetentionManager.getOriginalAttribute(this.ldkcNumber, this.cuNumber, this.ldevNumber);
    }

    public void setGuard(byte by) {
        Robj_interface_RJiLDEVIndex[] robj_interface_RJiLDEVIndexArray = this.ldevInfoManager.getLuseLdevs(this.ldkcNumber, this.cuNumber, this.ldevNumber);
        for (int i = 0; i < robj_interface_RJiLDEVIndexArray.length; ++i) {
            short s = robj_interface_RJiLDEVIndexArray[i].getSLDKC();
            short s2 = robj_interface_RJiLDEVIndexArray[i].getSCU();
            short s3 = robj_interface_RJiLDEVIndexArray[i].getSLDEV();
            this.guardRetentionManager.setAttribute(s, s2, s3, by);
        }
    }

    public boolean isSVolAdapt() {
        return this.guardRetentionManager.isChangeSVolEnable(this.ldkcNumber, this.cuNumber, this.ldevNumber);
    }

    public boolean isOriginalSVolAdapt() {
        return this.guardRetentionManager.isOriginalSVolEnable(this.ldkcNumber, this.cuNumber, this.ldevNumber);
    }

    public void setSVolAdapt(boolean bl) {
        Robj_interface_RJiLDEVIndex[] robj_interface_RJiLDEVIndexArray = this.ldevInfoManager.getLuseLdevs(this.ldkcNumber, this.cuNumber, this.ldevNumber);
        for (int i = 0; i < robj_interface_RJiLDEVIndexArray.length; ++i) {
            short s = robj_interface_RJiLDEVIndexArray[i].getSLDKC();
            short s2 = robj_interface_RJiLDEVIndexArray[i].getSCU();
            short s3 = robj_interface_RJiLDEVIndexArray[i].getSLDEV();
            this.guardRetentionManager.setSVolEnable(s, s2, s3, bl);
        }
    }

    public boolean isRMReserved() {
        return this.guardRetentionManager.isChangeReserved(this.ldkcNumber, this.cuNumber, this.ldevNumber);
    }

    public void setRmReserved(boolean bl) {
        Robj_interface_RJiLDEVIndex[] robj_interface_RJiLDEVIndexArray = this.ldevInfoManager.getLuseLdevs(this.ldkcNumber, this.cuNumber, this.ldevNumber);
        for (int i = 0; i < robj_interface_RJiLDEVIndexArray.length; ++i) {
            short s = robj_interface_RJiLDEVIndexArray[i].getSLDKC();
            short s2 = robj_interface_RJiLDEVIndexArray[i].getSCU();
            short s3 = robj_interface_RJiLDEVIndexArray[i].getSLDEV();
            this.guardRetentionManager.setRmReserved(s, s2, s3, bl);
        }
    }

    public boolean isZeroReadCap() {
        return this.guardRetentionManager.isChangeZeroReadCap(this.ldkcNumber, this.cuNumber, this.ldevNumber);
    }

    public boolean isInvisible() {
        return this.guardRetentionManager.isChangeInvisible(this.ldkcNumber, this.cuNumber, this.ldevNumber);
    }

    public void clearMode() {
        Robj_interface_RJiLDEVIndex[] robj_interface_RJiLDEVIndexArray = this.ldevInfoManager.getLuseLdevs(this.ldkcNumber, this.cuNumber, this.ldevNumber);
        for (int i = 0; i < robj_interface_RJiLDEVIndexArray.length; ++i) {
            short s = robj_interface_RJiLDEVIndexArray[i].getSLDKC();
            short s2 = robj_interface_RJiLDEVIndexArray[i].getSCU();
            short s3 = robj_interface_RJiLDEVIndexArray[i].getSLDEV();
            this.guardRetentionManager.setSpecialMode(s, s2, s3, (byte)0);
        }
    }

    public int getRetentionTerm() {
        return this.guardRetentionManager.getChangeRetentionTerm(this.ldkcNumber, this.cuNumber, this.ldevNumber);
    }

    public int getOldRetentionTerm() {
        return this.guardRetentionManager.getOriginalRetentionTerm(this.ldkcNumber, this.cuNumber, this.ldevNumber);
    }

    public void setRetentionTerm(int n) {
        Robj_interface_RJiLDEVIndex[] robj_interface_RJiLDEVIndexArray = this.ldevInfoManager.getLuseLdevs(this.ldkcNumber, this.cuNumber, this.ldevNumber);
        for (int i = 0; i < robj_interface_RJiLDEVIndexArray.length; ++i) {
            short s = robj_interface_RJiLDEVIndexArray[i].getSLDKC();
            short s2 = robj_interface_RJiLDEVIndexArray[i].getSCU();
            short s3 = robj_interface_RJiLDEVIndexArray[i].getSLDEV();
            this.guardRetentionManager.setRetentionTerm(s, s2, s3, n);
        }
    }

    public int getVmaSize() {
        return this.vmaInfoManager.getVmaSize(this.ldkcNumber, this.cuNumber, this.ldevNumber);
    }

    public boolean isVma() {
        return this.vmaInfoManager.isVma(this.ldkcNumber, this.cuNumber, this.ldevNumber);
    }

    public void setVma() {
        this.vmaInfoManager.setVma(this.ldkcNumber, this.cuNumber, this.ldevNumber);
    }

    public void deleteVma() {
        this.vmaInfoManager.deleteVma(this.ldkcNumber, this.cuNumber, this.ldevNumber);
    }

    public void releaseVma() {
        this.vmaInfoManager.releaseVma(this.ldkcNumber, this.cuNumber, this.ldevNumber);
    }

    public boolean isExtent() {
        return this.deleleAllExtentsManager.isExtent(this.ldkcNumber, this.cuNumber, this.ldevNumber);
    }

    public boolean isOriginalExtent() {
        return this.deleleAllExtentsManager.isOriginalExtent(this.ldkcNumber, this.cuNumber, this.ldevNumber);
    }

    public boolean canPartialRefresh() {
        boolean bl = false;
        if (!this.getExtentManager().isChangeDisplayedArea(this.ldkcNumber, this.cuNumber, this.ldevNumber) && !this.deleleAllExtentsManager.isModify(this.ldkcNumber, this.cuNumber, this.ldevNumber)) {
            bl = true;
        }
        return bl;
    }

    public void clearExtent() {
        this.getExtentManager().clearExtent();
    }

    public void initExtent() throws RJODGDException {
        this.getExtentManager().initExtent(this.ldkcNumber, this.cuNumber, this.ldevNumber, this.getLbaSize(), this.getVmaSize());
    }

    public RJODGDExtentManager getExtentManager() {
        return this.dataControl.getExtentManager();
    }

    public String getEmulationType() {
        return this.ldevInfoManager.getEmulationType(this.ldkcNumber, this.cuNumber, this.ldevNumber);
    }

    public long getCapacity() {
        Robj_interface_RJiLDEVIndex[] robj_interface_RJiLDEVIndexArray = this.ldevInfoManager.getLuseLdevs(this.ldkcNumber, this.cuNumber, this.ldevNumber);
        long l = 0L;
        for (int i = 0; i < robj_interface_RJiLDEVIndexArray.length; ++i) {
            short s = robj_interface_RJiLDEVIndexArray[i].getSLDKC();
            short s2 = robj_interface_RJiLDEVIndexArray[i].getSCU();
            short s3 = robj_interface_RJiLDEVIndexArray[i].getSLDEV();
            l += this.ldevInfoManager.getCapacity(s, s2, s3);
        }
        return l;
    }

    public long getLbaSize() {
        return this.ldevInfoManager.getLbaSize(this.ldkcNumber, this.cuNumber, this.ldevNumber);
    }

    public int getLuPathCnt() {
        return this.ldevInfoManager.getPathCount(this.ldkcNumber, this.cuNumber, this.ldevNumber);
    }

    public boolean isExternal() {
        return this.ldevInfoManager.isExternal(this.ldkcNumber, this.cuNumber, this.ldevNumber);
    }

    public boolean isVVol() {
        return this.ldevInfoManager.isVVol(this.ldkcNumber, this.cuNumber, this.ldevNumber);
    }

    public RJODGDLdev[] getLuseLdevs() {
        Robj_interface_RJiLDEVIndex[] robj_interface_RJiLDEVIndexArray = this.ldevInfoManager.getLuseLdevs(this.ldkcNumber, this.cuNumber, this.ldevNumber);
        RJODGDLdev[] rJODGDLdevArray = new RJODGDLdev[robj_interface_RJiLDEVIndexArray.length];
        for (int i = 0; i < rJODGDLdevArray.length; ++i) {
            short s = robj_interface_RJiLDEVIndexArray[i].getSLDKC();
            short s2 = robj_interface_RJiLDEVIndexArray[i].getSCU();
            short s3 = robj_interface_RJiLDEVIndexArray[i].getSLDEV();
            rJODGDLdevArray[i] = new RJODGDLdev(this.dataControl, s, s2, s3);
        }
        return rJODGDLdevArray;
    }

    public boolean isModify() {
        boolean bl = false;
        Iterator iterator = this.dataControl.getDataManagerRW(4).iterator();
        while (iterator.hasNext()) {
            ManageReadWriteDataInterface manageReadWriteDataInterface = (ManageReadWriteDataInterface)iterator.next();
            if (!manageReadWriteDataInterface.isModify(this.ldkcNumber, this.cuNumber, this.ldevNumber)) continue;
            bl = true;
            break;
        }
        return bl;
    }
}

