/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.openldevguard.gui.main;

import sanproject.client.data.RJDataMsg;
import sanproject.client.openldevguard.dctl.RJODGDCuLdev;
import sanproject.client.openldevguard.dctl.RJODGDException;
import sanproject.client.openldevguard.dctl.RJODGDLdev;
import sanproject.client.openldevguard.dctl.extent.RJODGDExtentManager;
import sanproject.client.openldevguard.dctl.extent.RJODGDLba;
import sanproject.client.openldevguard.dctl.extent.RJODGDLbaManager;
import sanproject.client.openldevguard.gui.OpenLDEVGuardException;
import sanproject.client.openldevguard.gui.main.DefaultExtentAreaWrapper;
import sanproject.client.openldevguard.gui.main.ExtentAreaWrapper;
import sanproject.client.openldevguard.gui.main.LDEVWrapper;
import sanproject.client.openldevguard.gui.main.OpenLDEVGuardDataControlWrapper;

class DefaultLDEVWrapper
implements LDEVWrapper {
    private OpenLDEVGuardDataControlWrapper mdcwWrapper;
    private RJODGDLdev moldInformation;

    DefaultLDEVWrapper(OpenLDEVGuardDataControlWrapper openLDEVGuardDataControlWrapper, RJODGDLdev rJODGDLdev) {
        this.mdcwWrapper = openLDEVGuardDataControlWrapper;
        this.moldInformation = rJODGDLdev;
    }

    public String toString() {
        String string = this.moldInformation.toString();
        return string;
    }

    public final int getLDKCNumber() {
        int n = this.moldInformation.getLdkc();
        return n;
    }

    public final int getCUNumber() {
        int n = this.moldInformation.getCu();
        return n;
    }

    public final int getLDEVNumber() {
        int n = this.moldInformation.getLdev();
        return n;
    }

    public final RJODGDCuLdev getCULDEVStructure() {
        int n = this.getCUNumber();
        int n2 = this.getLDEVNumber();
        RJODGDCuLdev rJODGDCuLdev = new RJODGDCuLdev(n, n2);
        return rJODGDCuLdev;
    }

    public final byte getAttribute() {
        byte by = this.moldInformation.getGuard();
        return by;
    }

    public final String getEmulationType() {
        String string = this.moldInformation.getEmulationType();
        return string;
    }

    public final long getCapacity() {
        long l = this.moldInformation.getCapacity();
        return l;
    }

    public final int getVMASize() {
        int n = this.moldInformation.getVmaSize();
        return n;
    }

    public final int getRetentionTerm() {
        int n = this.moldInformation.getRetentionTerm();
        return n;
    }

    public final int getPathCount() {
        int n = this.moldInformation.getLuPathCnt();
        return n;
    }

    public final long getFirstFreeLBA() {
        RJODGDExtentManager rJODGDExtentManager = this.getExtentManager();
        RJODGDLbaManager rJODGDLbaManager = rJODGDExtentManager.getLbaManager();
        long l = rJODGDLbaManager.getFirstFreeArea();
        return l;
    }

    public final long getMinimumLBARange() {
        RJODGDExtentManager rJODGDExtentManager = this.getExtentManager();
        RJODGDLbaManager rJODGDLbaManager = rJODGDExtentManager.getLbaManager();
        long l = rJODGDLbaManager.getRangeMin();
        return l;
    }

    public final long getMaximumLBARange() {
        RJODGDExtentManager rJODGDExtentManager = this.getExtentManager();
        RJODGDLbaManager rJODGDLbaManager = rJODGDExtentManager.getLbaManager();
        long l = rJODGDLbaManager.getRangeMax();
        return l;
    }

    public final LDEVWrapper[] getLUSEVolumes() {
        LDEVWrapper[] lDEVWrapperArray;
        RJODGDLdev[] rJODGDLdevArray = this.moldInformation.getLuseLdevs();
        if (rJODGDLdevArray != null) {
            lDEVWrapperArray = new LDEVWrapper[rJODGDLdevArray.length];
            for (int i = 0; i < rJODGDLdevArray.length; ++i) {
                RJODGDLdev rJODGDLdev = rJODGDLdevArray[i];
                lDEVWrapperArray[i] = new DefaultLDEVWrapper(this.mdcwWrapper, rJODGDLdev);
            }
        } else {
            lDEVWrapperArray = new LDEVWrapper[]{};
        }
        return lDEVWrapperArray;
    }

    public final int getExtentCount() {
        RJODGDExtentManager rJODGDExtentManager = this.getExtentManager();
        int n = rJODGDExtentManager.getTotalExtent();
        return n;
    }

    public final ExtentAreaWrapper[] getExtentAreas() throws OpenLDEVGuardException {
        ExtentAreaWrapper[] extentAreaWrapperArray = new ExtentAreaWrapper[]{};
        try {
            if (this.hasExtentArea()) {
                this.moldInformation.initExtent();
                RJODGDExtentManager rJODGDExtentManager = this.moldInformation.getExtentManager();
                int n = rJODGDExtentManager.getTotalExtent();
                extentAreaWrapperArray = new ExtentAreaWrapper[n];
                int n2 = 0;
                for (int i = 0; n2 < extentAreaWrapperArray.length && i < 65536; ++i) {
                    if (!rJODGDExtentManager.isSetExtent(i)) continue;
                    extentAreaWrapperArray[n2] = new DefaultExtentAreaWrapper(this, i);
                    ++n2;
                }
            }
        }
        catch (RJODGDException rJODGDException) {
            int n = rJODGDException.getPosition();
            int n3 = rJODGDException.getCode();
            RJDataMsg rJDataMsg = this.mdcwWrapper.createMessageObject(n, n3);
            throw new OpenLDEVGuardException(rJDataMsg, (Throwable)rJODGDException);
        }
        return extentAreaWrapperArray;
    }

    public final byte getOriginalAttribute() {
        byte by = this.moldInformation.getOldGuard();
        return by;
    }

    public final boolean getOriginalSVolAdapt() {
        boolean bl = this.moldInformation.isOriginalSVolAdapt();
        return bl;
    }

    public final int getOriginalRetentionTerm() {
        int n = this.moldInformation.getOldRetentionTerm();
        return n;
    }

    public final boolean isModified() {
        boolean bl = this.moldInformation.isModify();
        return bl;
    }

    public final boolean isExternal() {
        boolean bl = this.moldInformation.isExternal();
        return bl;
    }

    public final boolean isVVol() {
        boolean bl = this.moldInformation.isVVol();
        return bl;
    }

    public final boolean isSVolAdapt() {
        boolean bl = this.moldInformation.isSVolAdapt();
        return bl;
    }

    public final boolean isReserved() {
        boolean bl = this.moldInformation.isRMReserved();
        return bl;
    }

    public final boolean isZeroReadCap() {
        boolean bl = this.moldInformation.isZeroReadCap();
        return bl;
    }

    public final boolean isInvisible() {
        boolean bl = this.moldInformation.isInvisible();
        return bl;
    }

    public final boolean hasVMAArea() {
        boolean bl = this.moldInformation.isVma();
        return bl;
    }

    public final boolean hasExtentArea() {
        boolean bl = this.moldInformation.isExtent();
        return bl;
    }

    public final boolean canCopyExtent() {
        boolean bl = this.moldInformation.canCopyExtent();
        return bl;
    }

    public final boolean canCopyExtentAt(LDEVWrapper lDEVWrapper) {
        int n = lDEVWrapper.getCUNumber();
        int n2 = lDEVWrapper.getLDEVNumber();
        boolean bl = this.moldInformation.isCopyExtent(n, n2);
        return bl;
    }

    public final boolean canDefaultExtent() {
        boolean bl = this.moldInformation.canAllChgDefault();
        return bl;
    }

    public final boolean canAllDeleteExtent() {
        boolean bl = this.moldInformation.canAllReleaseExtent();
        return bl;
    }

    public final boolean canChangeAttribute() {
        boolean bl = this.moldInformation.canChgAttribute();
        return bl;
    }

    public final boolean canChangeSVolState() {
        boolean bl = this.moldInformation.canChgSvol();
        return bl;
    }

    public final boolean canChangeReserved() {
        boolean bl = this.moldInformation.canChgRmReserved();
        return bl;
    }

    public final boolean canChangeRetentionTerm() {
        boolean bl = this.moldInformation.canChgRetentionTerm();
        return bl;
    }

    public final boolean canCreateVMA() {
        boolean bl = this.moldInformation.canSetVma();
        return bl;
    }

    public final boolean canReleaseVMA() {
        boolean bl = this.moldInformation.canReleaseVma();
        return bl;
    }

    public final boolean canClearMode() {
        boolean bl = this.moldInformation.canClearSpMode();
        return bl;
    }

    public final boolean canCreateExtentArea(long l, long l2) {
        RJODGDExtentManager rJODGDExtentManager = this.getExtentManager();
        RJODGDLbaManager rJODGDLbaManager = rJODGDExtentManager.getLbaManager();
        RJODGDLba rJODGDLba = new RJODGDLba(l, l2);
        boolean bl = rJODGDLbaManager.isSet(rJODGDLba);
        return bl;
    }

    public final void changeAttribute(byte by) {
        this.moldInformation.setGuard(by);
    }

    public final void setSVolEnabled(boolean bl) {
        this.moldInformation.setSVolAdapt(bl);
    }

    public final void setReserved(boolean bl) {
        this.moldInformation.setRmReserved(bl);
    }

    public final void setRetentionTerm(int n) {
        this.moldInformation.setRetentionTerm(n);
    }

    public final void createVMAArea() {
        this.moldInformation.setVma();
    }

    public final void releaseVMAArea() {
        this.moldInformation.releaseVma();
    }

    public boolean canDeleteVMA() {
        boolean bl = this.moldInformation.canDeleteVma();
        return bl;
    }

    public void deleteVMAArea() {
        this.moldInformation.deleteVma();
    }

    public boolean canRefreshExtent() {
        boolean bl = this.moldInformation.canPartialRefresh();
        return bl;
    }

    public void clearExtent() {
        this.moldInformation.clearExtent();
    }

    public final void clearMode() {
        this.moldInformation.clearMode();
    }

    final RJODGDExtentManager getExtentManager() {
        RJODGDExtentManager rJODGDExtentManager = this.moldInformation.getExtentManager();
        return rJODGDExtentManager;
    }

    public boolean isSupportExtent() {
        RJODGDExtentManager rJODGDExtentManager = this.getExtentManager();
        boolean bl = rJODGDExtentManager.isSupprtExtent();
        return bl;
    }

    public boolean hasOriginalExtentArea() {
        boolean bl = this.moldInformation.isOriginalExtent();
        return bl;
    }
}

