/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.openldevguard.gui.main;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.util.logging.Level;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import sanproject.client.com.RJComDialog;
import sanproject.client.data.RJDataMsg;
import sanproject.client.openldevguard.color.ColorManager;
import sanproject.client.openldevguard.com.KeyEventReceiver;
import sanproject.client.openldevguard.com.KeyEventTransferable;
import sanproject.client.openldevguard.gui.ComponentFactory;
import sanproject.client.openldevguard.gui.ComponentUtilities;
import sanproject.client.openldevguard.gui.TitleValueListPanel;
import sanproject.client.openldevguard.gui.logging.Logger;
import sanproject.client.openldevguard.gui.main.ExtentSettingInformation;
import sanproject.client.openldevguard.gui.main.LDEVWrapper;
import sanproject.client.openldevguard.gui.main.OpenLDEVGuardDataControlWrapper;
import sanproject.client.openldevguard.gui.main.StandardComponentFactory;
import sanproject.client.openldevguard.text.NumberStringDocument;

class ExtentSettingDialogPanel
extends JPanel
implements KeyEventReceiver {
    private static final String MODULE_NAME = "ExtSetting";
    private OpenLDEVGuardDataControlWrapper mdcwWrapper;
    private LDEVWrapper mldwTargetLDEV;
    private JTextField mtxfStartLBA;
    private JTextField mtxfBlockSize;
    private JRadioButton mrbnReadWrite;
    private JRadioButton mrbnReadOnly;
    private JButton mbtnOK;
    private JButton mbtnCancel;
    private transient boolean mbUserOK;
    static /* synthetic */ Class class$java$awt$Dialog;

    ExtentSettingDialogPanel(OpenLDEVGuardDataControlWrapper openLDEVGuardDataControlWrapper, LDEVWrapper lDEVWrapper) {
        this.mdcwWrapper = openLDEVGuardDataControlWrapper;
        this.mldwTargetLDEV = lDEVWrapper;
        this.mbUserOK = false;
        ContainerListener containerListener = new ContainerListener(){

            public void componentAdded(ContainerEvent containerEvent) {
                ExtentSettingDialogPanel.this.addComponent(containerEvent);
            }

            public void componentRemoved(ContainerEvent containerEvent) {
                ExtentSettingDialogPanel.this.removeComponent(containerEvent);
            }
        };
        this.addContainerListener(containerListener);
        ComponentFactory componentFactory = StandardComponentFactory.getComponentFactory();
        ColorManager colorManager = ColorManager.getInstance();
        Object object = new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                JTextField jTextField = (JTextField)focusEvent.getSource();
                jTextField.selectAll();
            }
        };
        long l = this.mldwTargetLDEV.getFirstFreeLBA();
        Object object2 = String.valueOf(l);
        Color color = colorManager.getSelectedLineBackground();
        Color color2 = colorManager.getSelectedLineForeground();
        NumberStringDocument numberStringDocument = new NumberStringDocument(10);
        this.mtxfStartLBA = componentFactory.createTextField();
        this.mtxfStartLBA.addFocusListener((FocusListener)object);
        this.mtxfStartLBA.setDocument(numberStringDocument);
        this.mtxfStartLBA.setColumns(10);
        this.mtxfStartLBA.setHorizontalAlignment(4);
        this.mtxfStartLBA.setSelectionColor(color);
        this.mtxfStartLBA.setSelectedTextColor(color2);
        this.mtxfStartLBA.setText((String)object2);
        object = new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                JTextField jTextField = (JTextField)focusEvent.getSource();
                jTextField.selectAll();
            }
        };
        Object object3 = colorManager.getSelectedLineBackground();
        Object object4 = colorManager.getSelectedLineForeground();
        object2 = new NumberStringDocument(10);
        this.mtxfBlockSize = componentFactory.createTextField();
        this.mtxfBlockSize.addFocusListener((FocusListener)object);
        this.mtxfBlockSize.setDocument((Document)object2);
        this.mtxfBlockSize.setColumns(10);
        this.mtxfBlockSize.setHorizontalAlignment(4);
        this.mtxfBlockSize.setSelectionColor((Color)object3);
        this.mtxfBlockSize.setSelectedTextColor((Color)object4);
        this.mtxfBlockSize.setText("1");
        object = "LDEV Guard/STRING_STE_READWRITE";
        object3 = this.mdcwWrapper.getGuidanceString((String)object);
        object4 = this.mdcwWrapper.getGuidanceColor((String)object);
        this.mrbnReadWrite = componentFactory.createRadioButton((String)object3);
        this.mrbnReadWrite.setForeground((Color)object4);
        this.mrbnReadWrite.setOpaque(false);
        object = "LDEV Guard/STRING_STE_READONLY";
        object3 = this.mdcwWrapper.getGuidanceString((String)object);
        object4 = this.mdcwWrapper.getGuidanceColor((String)object);
        this.mrbnReadOnly = componentFactory.createRadioButton((String)object3);
        this.mrbnReadOnly.setForeground((Color)object4);
        this.mrbnReadOnly.setOpaque(false);
        object = new ButtonGroup();
        ((ButtonGroup)object).add(this.mrbnReadWrite);
        ((ButtonGroup)object).add(this.mrbnReadOnly);
        this.mrbnReadWrite.setSelected(true);
        object = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExtentSettingDialogPanel.this.doButtonAction(actionEvent);
            }
        };
        object3 = "COMMON/OK";
        object4 = this.mdcwWrapper.getGuidanceString((String)object3);
        object2 = this.mdcwWrapper.getGuidanceColor((String)object3);
        this.mbtnOK = componentFactory.createButton((String)object4);
        this.mbtnOK.addActionListener((ActionListener)object);
        this.mbtnOK.setForeground((Color)object2);
        object3 = "COMMON/Cancel";
        object4 = this.mdcwWrapper.getGuidanceString((String)object3);
        object2 = this.mdcwWrapper.getGuidanceColor((String)object3);
        this.mbtnCancel = componentFactory.createButton((String)object4);
        this.mbtnCancel.addActionListener((ActionListener)object);
        this.mbtnCancel.setForeground((Color)object2);
        this.buildPanelLayout();
    }

    public final void keyEventReceived(KeyEventTransferable keyEventTransferable, KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        int n2 = keyEvent.getModifiers();
        String string = KeyEvent.getKeyText(n);
        String string2 = KeyEvent.getKeyModifiersText(n2);
        Logger.put(Level.FINEST, MODULE_NAME, "    keyEventReceived()    [" + string2 + " + " + string + "]");
    }

    private void addComponent(ContainerEvent containerEvent) {
        Component component = containerEvent.getChild();
        if (component instanceof KeyEventTransferable) {
            KeyEventTransferable keyEventTransferable = (KeyEventTransferable)((Object)component);
            keyEventTransferable.addKeyEventReceiver(this);
        }
    }

    private void removeComponent(ContainerEvent containerEvent) {
        Object object;
        Component component = containerEvent.getChild();
        if (component instanceof KeyEventTransferable) {
            object = (KeyEventTransferable)((Object)component);
            object.removeKeyEventReceiver(this);
        }
        if (component instanceof Container) {
            object = (Container)component;
            ((Container)object).removeAll();
        }
    }

    private void buildPanelLayout() {
        ComponentFactory componentFactory = StandardComponentFactory.getComponentFactory();
        Object object = this.mdcwWrapper.getGuidanceString("LDEV Guard/STRING_DPT_EXTSETTING");
        JPanel jPanel = ComponentUtilities.buildTitlePanel(componentFactory, (String)object);
        object = new BorderLayout(4, 4);
        JPanel jPanel2 = componentFactory.createPanel();
        jPanel2.setLayout((LayoutManager)object);
        jPanel2.setOpaque(false);
        jPanel2.add((Component)jPanel, "West");
        Object object2 = "LDEV Guard/STRING_DAT_STARTLBA";
        Object object3 = this.mdcwWrapper.getGuidanceString((String)object2);
        Object object4 = "LDEV Guard/STRING_DAT_LBA";
        Object object5 = this.mdcwWrapper.getGuidanceString((String)object4);
        Object object6 = this.mdcwWrapper.getGuidanceColor((String)object4);
        Object object7 = componentFactory.createLabel((String)object5);
        ((JComponent)object7).setForeground((Color)object6);
        object4 = new BorderLayout(4, 4);
        object2 = componentFactory.createPanel();
        ((Container)object2).setLayout((LayoutManager)object4);
        ((JComponent)object2).setOpaque(false);
        ((Container)object2).add((Component)this.mtxfStartLBA, "West");
        ((Container)object2).add((Component)object7, "Center");
        Object object8 = new TitleValueListPanel.TitleValuePair(componentFactory, (String)object3, (JComponent)object2);
        object7 = "LDEV Guard/STRING_DAT_BLOCKSIZE";
        object2 = this.mdcwWrapper.getGuidanceString((String)object7);
        object5 = "COMMON/blocks";
        object6 = this.mdcwWrapper.getGuidanceString((String)object5);
        Color color = this.mdcwWrapper.getGuidanceColor((String)object5);
        object4 = componentFactory.createLabel((String)object6);
        ((JComponent)object4).setForeground(color);
        object5 = new BorderLayout(4, 4);
        object7 = componentFactory.createPanel();
        ((Container)object7).setLayout((LayoutManager)object5);
        ((JComponent)object7).setOpaque(false);
        ((Container)object7).add((Component)this.mtxfBlockSize, "West");
        ((Container)object7).add((Component)object4, "Center");
        object3 = new TitleValueListPanel.TitleValuePair(componentFactory, (String)object2, (JComponent)object7);
        object4 = "COMMON/Attribute";
        object7 = this.mdcwWrapper.getGuidanceString((String)object4);
        object6 = new GridLayout(1, 0, 4, 4);
        object5 = componentFactory.createPanel();
        ((Container)object5).setLayout((LayoutManager)object6);
        ((JComponent)object5).setOpaque(false);
        ((Container)object5).add(this.mrbnReadWrite);
        ((Container)object5).add(this.mrbnReadOnly);
        object6 = new BorderLayout(4, 4);
        object4 = componentFactory.createPanel();
        ((Container)object4).setLayout((LayoutManager)object6);
        ((JComponent)object4).setOpaque(false);
        ((Container)object4).add((Component)object5, "West");
        object2 = new TitleValueListPanel.TitleValuePair(componentFactory, (String)object7, (JComponent)object4);
        object = new TitleValueListPanel();
        ((TitleValueListPanel)object).addPair((TitleValueListPanel.TitleValuePair)object8);
        ((TitleValueListPanel)object).addPair((TitleValueListPanel.TitleValuePair)object3);
        ((TitleValueListPanel)object).addPair((TitleValueListPanel.TitleValuePair)object2);
        object8 = new BorderLayout(4, 4);
        jPanel = componentFactory.createPanel();
        jPanel.setLayout((LayoutManager)object8);
        jPanel.setOpaque(false);
        jPanel.add((Component)object, "North");
        object3 = new GridLayout(1, 0, 4, 4);
        object8 = componentFactory.createPanel();
        ((Container)object8).setLayout((LayoutManager)object3);
        ((JComponent)object8).setOpaque(false);
        ((Container)object8).add(this.mbtnOK);
        ((Container)object8).add(this.mbtnCancel);
        ComponentUtilities.decorateInputAreaMarginBorder((JComponent)object8);
        object3 = new BorderLayout(4, 4);
        object = componentFactory.createPanel();
        ((Container)object).setLayout((LayoutManager)object3);
        ((JComponent)object).setOpaque(false);
        ((Container)object).add((Component)object8, "East");
        object8 = ColorManager.getInstance();
        object3 = new BorderLayout(4, 4);
        object2 = ((ColorManager)object8).getPanelBackground();
        this.setLayout((LayoutManager)object3);
        this.setOpaque(true);
        this.setBackground((Color)object2);
        this.add((Component)jPanel2, "North");
        this.add((Component)jPanel, "Center");
        this.add((Component)object, "South");
        ComponentUtilities.decorateInputAreaMarginBorder(this);
    }

    private void doButtonAction(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.mbtnOK)) {
            int n = this.getUserInputError();
            if (n == 0) {
                this.mbUserOK = true;
                this.doDialogClose();
            } else {
                RJDataMsg rJDataMsg = this.mdcwWrapper.createMessageObject(9610, n);
                String string = rJDataMsg.getMessage();
                Logger.put(Level.FINE, MODULE_NAME, string);
                Object[] objectArray = new Object[]{this.mdcwWrapper.getGuidanceString("COMMON/OK")};
                RJComDialog.show(this, rJDataMsg, 0, objectArray, objectArray[0]);
            }
        } else if (object.equals(this.mbtnCancel)) {
            this.doDialogClose();
        }
    }

    private int getUserInputError() {
        int n;
        String string = this.mtxfStartLBA.getText();
        long l = string == null || string.equals("") ? this.mldwTargetLDEV.getFirstFreeLBA() : Long.parseLong(string, 10);
        String string2 = this.mtxfBlockSize.getText();
        long l2 = string2 == null || string2.equals("") ? 0L : Long.parseLong(string2, 10);
        if (l < this.mldwTargetLDEV.getFirstFreeLBA() || l > this.mldwTargetLDEV.getMaximumLBARange()) {
            this.mtxfStartLBA.requestFocus();
            this.mtxfStartLBA.selectAll();
            n = 9997;
        } else if (l2 < 1L || l2 > 0x100000000L) {
            this.mtxfBlockSize.requestFocus();
            this.mtxfBlockSize.selectAll();
            n = 9996;
        } else if (!this.mldwTargetLDEV.canCreateExtentArea(l, l2)) {
            this.mtxfBlockSize.requestFocus();
            this.mtxfBlockSize.selectAll();
            n = 9995;
        } else {
            n = 0;
        }
        return n;
    }

    private void doDialogClose() {
        Dialog dialog = (Dialog)SwingUtilities.getAncestorOfClass(class$java$awt$Dialog == null ? (class$java$awt$Dialog = ExtentSettingDialogPanel.class$("java.awt.Dialog")) : class$java$awt$Dialog, this);
        if (dialog != null) {
            dialog.dispose();
            dialog.removeAll();
        } else {
            Logger.put(Level.WARNING, MODULE_NAME, "Can not found dialog. A dialog cannot be closed.");
        }
    }

    public final boolean isInputComplete() {
        return this.mbUserOK;
    }

    public final ExtentSettingInformation getSettingInformation() {
        ExtentSettingInformation extentSettingInformation = new ExtentSettingInformation(){

            public boolean isInputComplete() {
                return ExtentSettingDialogPanel.this.isInputComplete();
            }

            public long getStartLBA() {
                String string = ExtentSettingDialogPanel.this.mtxfStartLBA.getText();
                long l = string == null || string.equals("") ? ExtentSettingDialogPanel.this.mldwTargetLDEV.getFirstFreeLBA() : Long.parseLong(string, 10);
                return l;
            }

            public long getBlockSize() {
                String string = ExtentSettingDialogPanel.this.mtxfBlockSize.getText();
                if (string == null || string.equals("")) {
                    string = "0";
                }
                long l = Long.parseLong(string, 10);
                return l;
            }

            public byte getAttribute() {
                int n = ExtentSettingDialogPanel.this.mrbnReadWrite.isSelected() ? -128 : (ExtentSettingDialogPanel.this.mrbnReadOnly.isSelected() ? -126 : 0);
                return (byte)n;
            }

            public boolean isNeedTermSetting() {
                byte by = this.getAttribute();
                boolean bl = false;
                if (by == -126 || by == -127) {
                    bl = true;
                }
                return bl;
            }
        };
        return extentSettingInformation;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

