/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.openldevguard.gui.main;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import sanproject.client.openldevguard.gui.DataWrapper;
import sanproject.client.openldevguard.gui.OpenLDEVGuardException;
import sanproject.client.openldevguard.gui.logging.Logger;
import sanproject.client.openldevguard.gui.main.CUWrapper;
import sanproject.client.openldevguard.gui.main.LDEVWrapper;
import sanproject.client.openldevguard.gui.main.OpenLDEVGuardDataControlWrapper;
import sanproject.client.openldevguard.gui.main.SubsystemTreeNode;
import sanproject.client.openldevguard.utility.StringUtilities;
import sanproject.client.openldevguard.utility.sort.DataSorter;
import sanproject.client.openldevguard.utility.sort.DataSorterFactory;

class SubsystemTreeModel
implements TreeModel {
    private static final String MODULE_NAME = "Tree";
    private static final Set SUPPORT_EMULATIONS = new HashSet();
    private OpenLDEVGuardDataControlWrapper mdcwWrapper;
    private Set msetModelListeners;
    private SubsystemTreeNode mstnRootNode;
    private boolean initializedLdevFlg = false;

    SubsystemTreeModel(OpenLDEVGuardDataControlWrapper openLDEVGuardDataControlWrapper) {
        this.mdcwWrapper = openLDEVGuardDataControlWrapper;
        this.msetModelListeners = new HashSet();
    }

    public final Object getRoot() {
        return this.mstnRootNode;
    }

    public final Object getChild(Object object, int n) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        TreeNode treeNode = defaultMutableTreeNode.getChildAt(n);
        return treeNode;
    }

    public final int getChildCount(Object object) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        int n = defaultMutableTreeNode.getChildCount();
        return n;
    }

    public final boolean isLeaf(Object object) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        boolean bl = defaultMutableTreeNode.isLeaf();
        return bl;
    }

    public final void valueForPathChanged(TreePath treePath, Object object) {
    }

    public final int getIndexOfChild(Object object, Object object2) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)object2;
        int n = defaultMutableTreeNode.getIndex(defaultMutableTreeNode2);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addTreeModelListener(TreeModelListener treeModelListener) {
        Set set = this.msetModelListeners;
        synchronized (set) {
            this.msetModelListeners.add(treeModelListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeTreeModelListener(TreeModelListener treeModelListener) {
        Set set = this.msetModelListeners;
        synchronized (set) {
            this.msetModelListeners.remove(treeModelListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireTreeNodesChanged(TreeModelEvent treeModelEvent) {
        Set set;
        Object object = this.msetModelListeners;
        synchronized (object) {
            set = Collections.synchronizedSet(this.msetModelListeners);
        }
        object = set.iterator();
        while (object.hasNext()) {
            TreeModelListener treeModelListener = (TreeModelListener)object.next();
            treeModelListener.treeNodesChanged(treeModelEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireTreeNodesInserted(TreeModelEvent treeModelEvent) {
        Set set;
        Object object = this.msetModelListeners;
        synchronized (object) {
            set = Collections.synchronizedSet(this.msetModelListeners);
        }
        object = set.iterator();
        while (object.hasNext()) {
            TreeModelListener treeModelListener = (TreeModelListener)object.next();
            treeModelListener.treeNodesInserted(treeModelEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireTreeNodesRemoved(TreeModelEvent treeModelEvent) {
        Set set;
        Object object = this.msetModelListeners;
        synchronized (object) {
            set = Collections.synchronizedSet(this.msetModelListeners);
        }
        object = set.iterator();
        while (object.hasNext()) {
            TreeModelListener treeModelListener = (TreeModelListener)object.next();
            treeModelListener.treeNodesRemoved(treeModelEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireTreeStructureChanged(TreeModelEvent treeModelEvent) {
        Set set;
        Object object = this.msetModelListeners;
        synchronized (object) {
            set = Collections.synchronizedSet(this.msetModelListeners);
        }
        object = set.iterator();
        while (object.hasNext()) {
            TreeModelListener treeModelListener = (TreeModelListener)object.next();
            treeModelListener.treeStructureChanged(treeModelEvent);
        }
    }

    public final void initializeData(int n, int n2) throws OpenLDEVGuardException {
        Object object;
        Object object2;
        if (this.mstnRootNode != null) {
            this.mstnRootNode.removeAllChildren();
        }
        final String string = this.mdcwWrapper.getGuidanceString("COMMON/Subsystem");
        this.mstnRootNode = new SubsystemTreeNode(){

            public Icon getOpenedIcon() {
                return DEFAULT_OPEN_ICON;
            }

            public Icon getCollapsedIcon() {
                return DEFAULT_CLOSE_ICON;
            }

            public Object getReferencedObject() {
                String string2 = this.toString();
                return string2;
            }

            public boolean isModified() {
                return false;
            }

            public String createSortKey() {
                String string2 = this.toString();
                return string2;
            }

            public String toString() {
                String string2 = string;
                return string2;
            }
        };
        Object object3 = this.mdcwWrapper.getMountedCUs(n, n2);
        Object object4 = DataSorterFactory.createStringDataSorter();
        for (int i = 0; i < ((CUWrapper[])object3).length; ++i) {
            object2 = SubsystemTreeNode.createControlUnitNode(this.mdcwWrapper, object3[i]);
            object = object2.createSortKey();
            object4.put(object, object2);
        }
        List list = object4.getSortedDataList();
        object2 = list.iterator();
        while (object2.hasNext()) {
            object = (SubsystemTreeNode)object2.next();
            this.mstnRootNode.add((MutableTreeNode)object);
        }
        object3 = this.mdcwWrapper.getAllLDEVs(n, n2);
        object4 = DataSorterFactory.createStringDataSorter();
        for (int i = 0; i < ((DataWrapper[])object3).length; ++i) {
            object2 = SubsystemTreeNode.createLogicalUnitNode(this.mdcwWrapper, (LDEVWrapper)object3[i]);
            object = object2.createSortKey();
            object4.put(object, object2);
        }
        List list2 = object4.getSortedDataList();
        object2 = list2.iterator();
        while (object2.hasNext()) {
            object = (SubsystemTreeNode)object2.next();
            LDEVWrapper lDEVWrapper = (LDEVWrapper)object.getReferencedObject();
            if (!this.isSupportLDEV(lDEVWrapper)) continue;
            int n3 = lDEVWrapper.getCUNumber();
            SubsystemTreeNode subsystemTreeNode = this.searchCUNode(n3);
            subsystemTreeNode.add((MutableTreeNode)object);
        }
        object3 = new TreePath(this.mstnRootNode);
        object4 = new TreeModelEvent((Object)this, (TreePath)object3);
        this.fireTreeStructureChanged((TreeModelEvent)object4);
    }

    public final void initializeDataCU(int n, int n2) throws OpenLDEVGuardException {
        Object object;
        Object object2;
        if (this.mstnRootNode != null) {
            this.mstnRootNode.removeAllChildren();
            this.initializedLdevFlg = false;
        }
        final String string = this.mdcwWrapper.getGuidanceString("COMMON/Subsystem");
        this.mstnRootNode = new SubsystemTreeNode(){

            public Icon getOpenedIcon() {
                return DEFAULT_OPEN_ICON;
            }

            public Icon getCollapsedIcon() {
                return DEFAULT_CLOSE_ICON;
            }

            public Object getReferencedObject() {
                String string2 = this.toString();
                return string2;
            }

            public boolean isModified() {
                return false;
            }

            public String createSortKey() {
                String string2 = this.toString();
                return string2;
            }

            public String toString() {
                String string2 = string;
                return string2;
            }
        };
        Object object3 = this.mdcwWrapper.getMountedCUs(n, n2);
        Object object4 = DataSorterFactory.createStringDataSorter();
        for (int i = 0; i < ((CUWrapper[])object3).length; ++i) {
            object2 = SubsystemTreeNode.createControlUnitNode(this.mdcwWrapper, object3[i]);
            object = object2.createSortKey();
            object4.put(object, object2);
        }
        List list = object4.getSortedDataList();
        object2 = list.iterator();
        while (object2.hasNext()) {
            object = (SubsystemTreeNode)object2.next();
            this.mstnRootNode.add((MutableTreeNode)object);
        }
        object3 = new TreePath(this.mstnRootNode);
        object4 = new TreeModelEvent((Object)this, (TreePath)object3);
        this.fireTreeStructureChanged((TreeModelEvent)object4);
    }

    public final void initializeDataLDEV(int n, int n2) throws OpenLDEVGuardException {
        if (!this.initializedLdevFlg) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            if (this.mstnRootNode != null) {
                object4 = this.mstnRootNode.children();
                while (object4.hasMoreElements()) {
                    object3 = (SubsystemTreeNode)object4.nextElement();
                    ((DefaultMutableTreeNode)object3).removeAllChildren();
                }
            }
            object4 = this.mdcwWrapper.getAllLDEVs(n, n2);
            object3 = DataSorterFactory.createStringDataSorter();
            for (int i = 0; i < ((LDEVWrapper[])object4).length; ++i) {
                object2 = SubsystemTreeNode.createLogicalUnitNode(this.mdcwWrapper, object4[i]);
                object = object2.createSortKey();
                object3.put(object, object2);
            }
            List list = object3.getSortedDataList();
            object2 = list.iterator();
            while (object2.hasNext()) {
                object = (SubsystemTreeNode)object2.next();
                LDEVWrapper lDEVWrapper = (LDEVWrapper)object.getReferencedObject();
                if (!this.isSupportLDEV(lDEVWrapper)) continue;
                int n3 = lDEVWrapper.getCUNumber();
                SubsystemTreeNode subsystemTreeNode = this.searchCUNode(n3);
                subsystemTreeNode.add((MutableTreeNode)object);
            }
            object4 = new TreePath(this.mstnRootNode);
            object3 = new TreeModelEvent((Object)this, (TreePath)object4);
            this.fireTreeStructureChanged((TreeModelEvent)object3);
            this.initializedLdevFlg = true;
        }
    }

    public final boolean notifyUpdateLDEVNode() {
        boolean bl = this.initializedLdevFlg;
        this.initializedLdevFlg = false;
        return bl;
    }

    public final void updateNodeStates(LDEVWrapper[] lDEVWrapperArray) {
        Object object;
        int n;
        Object[] objectArray;
        Object object2;
        DataSorter dataSorter = DataSorterFactory.createMixtureDataSorter();
        for (int i = 0; i < lDEVWrapperArray.length; ++i) {
            object2 = lDEVWrapperArray[i];
            if (!this.isSupportLDEV((LDEVWrapper)object2)) continue;
            int n2 = object2.getCUNumber();
            int n3 = object2.getLDEVNumber();
            objectArray = String.valueOf(n2) + "/" + String.valueOf(n3);
            dataSorter.put(objectArray, object2);
        }
        List list = dataSorter.getSortedDataList();
        object2 = list.iterator();
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        ArrayList<SubsystemTreeNode> arrayList = new ArrayList<SubsystemTreeNode>();
        while (object2.hasNext()) {
            objectArray = (TreeNode[])object2.next();
            n = objectArray.getCUNumber();
            int n4 = objectArray.getLDEVNumber();
            SubsystemTreeNode subsystemTreeNode = this.searchCUNode(n);
            if (subsystemTreeNode != null) {
                object = this.searchLDEVNode(subsystemTreeNode, n4);
                if (object != null) {
                    if (defaultMutableTreeNode == null) {
                        defaultMutableTreeNode = subsystemTreeNode;
                    } else if (!subsystemTreeNode.equals(defaultMutableTreeNode)) {
                        Object[] objectArray2 = defaultMutableTreeNode.getPath();
                        int n5 = arrayList.size();
                        int[] nArray = new int[n5];
                        for (int i = 0; i < n5; ++i) {
                            SubsystemTreeNode subsystemTreeNode2 = (SubsystemTreeNode)arrayList.get(i);
                            nArray[i] = defaultMutableTreeNode.getIndex(subsystemTreeNode2);
                        }
                        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, objectArray2, nArray, null);
                        this.fireTreeNodesChanged(treeModelEvent);
                        defaultMutableTreeNode = subsystemTreeNode;
                        arrayList.clear();
                    }
                    int n6 = subsystemTreeNode.getIndex((TreeNode)object);
                    SubsystemTreeNode subsystemTreeNode3 = SubsystemTreeNode.createLogicalUnitNode(this.mdcwWrapper, (LDEVWrapper)objectArray);
                    subsystemTreeNode.remove(n6);
                    subsystemTreeNode.insert(subsystemTreeNode3, n6);
                    arrayList.add(subsystemTreeNode3);
                    continue;
                }
                String string = StringUtilities.toHexString(n4, 2, true);
                Logger.put(Level.WARNING, MODULE_NAME, "not found ldev node. [" + string + "]");
                continue;
            }
            object = StringUtilities.toHexString(n, 2, true);
            Logger.put(Level.WARNING, MODULE_NAME, "not found cu node. [" + (String)object + "]");
        }
        if (defaultMutableTreeNode != null && !arrayList.isEmpty()) {
            objectArray = defaultMutableTreeNode.getPath();
            n = arrayList.size();
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                object = (SubsystemTreeNode)arrayList.get(i);
                nArray[i] = defaultMutableTreeNode.getIndex((TreeNode)object);
            }
            TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, objectArray, nArray, null);
            this.fireTreeNodesChanged(treeModelEvent);
        }
    }

    private boolean isSupportLDEV(LDEVWrapper lDEVWrapper) {
        boolean bl;
        Object object;
        boolean bl2 = false;
        if (this.mdcwWrapper.isSupportFunctionExtent() && ((LDEVWrapper[])(object = lDEVWrapper.getLUSEVolumes())).length <= 1 && SUPPORT_EMULATIONS.contains(object = lDEVWrapper.getEmulationType()) && (bl = lDEVWrapper.isSupportExtent()) && (bl = lDEVWrapper.hasOriginalExtentArea())) {
            bl2 = true;
        }
        return bl2;
    }

    private SubsystemTreeNode searchCUNode(int n) {
        SubsystemTreeNode subsystemTreeNode = (SubsystemTreeNode)this.getRoot();
        SubsystemTreeNode subsystemTreeNode2 = null;
        Enumeration<TreeNode> enumeration = subsystemTreeNode.children();
        while (enumeration.hasMoreElements()) {
            SubsystemTreeNode subsystemTreeNode3 = (SubsystemTreeNode)enumeration.nextElement();
            CUWrapper cUWrapper = (CUWrapper)subsystemTreeNode3.getReferencedObject();
            if (cUWrapper.getCUNumber() != n) continue;
            subsystemTreeNode2 = subsystemTreeNode3;
            break;
        }
        return subsystemTreeNode2;
    }

    private SubsystemTreeNode searchLDEVNode(SubsystemTreeNode subsystemTreeNode, int n) {
        SubsystemTreeNode subsystemTreeNode2 = null;
        Enumeration<TreeNode> enumeration = subsystemTreeNode.children();
        while (enumeration.hasMoreElements()) {
            SubsystemTreeNode subsystemTreeNode3 = (SubsystemTreeNode)enumeration.nextElement();
            LDEVWrapper lDEVWrapper = (LDEVWrapper)subsystemTreeNode3.getReferencedObject();
            if (lDEVWrapper.getLDEVNumber() != n) continue;
            subsystemTreeNode2 = subsystemTreeNode3;
            break;
        }
        return subsystemTreeNode2;
    }

    static {
        SUPPORT_EMULATIONS.add("OPEN-V");
    }
}

