/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.openldevguard.gui.main;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import java.util.EventListener;
import java.util.logging.Level;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import sanproject.client.com.RJComDialog;
import sanproject.client.data.RJDataMsg;
import sanproject.client.openldevguard.color.ColorManager;
import sanproject.client.openldevguard.com.KeyEventReceiver;
import sanproject.client.openldevguard.com.KeyEventTransferable;
import sanproject.client.openldevguard.gui.ComponentFactory;
import sanproject.client.openldevguard.gui.ComponentUtilities;
import sanproject.client.openldevguard.gui.logging.Logger;
import sanproject.client.openldevguard.gui.main.OpenLDEVGuardDataControlWrapper;
import sanproject.client.openldevguard.gui.main.StandardComponentFactory;
import sanproject.client.openldevguard.text.NumberStringDocument;

class TermSettingDialogPanel
extends JPanel
implements KeyEventReceiver {
    private static final String MODULE_NAME = "TermSetting";
    private static final int YEARS_LENGTH = 2;
    private static final int DAYS_LENGTH = 5;
    private OpenLDEVGuardDataControlWrapper mdcwWrapper;
    private JRadioButton mrbnSpecifies;
    private JRadioButton mrbnUnlimited;
    private JTextField mtxfTermYears;
    private JTextField mtxfTermDays;
    private JButton mbtnOK;
    private JButton mbtnCancel;
    private transient boolean mbUserOK;
    static /* synthetic */ Class class$java$awt$Dialog;

    TermSettingDialogPanel(OpenLDEVGuardDataControlWrapper openLDEVGuardDataControlWrapper) {
        this(openLDEVGuardDataControlWrapper, 2190);
    }

    TermSettingDialogPanel(OpenLDEVGuardDataControlWrapper openLDEVGuardDataControlWrapper, int n) {
        this.mdcwWrapper = openLDEVGuardDataControlWrapper;
        this.mbUserOK = false;
        ContainerListener containerListener = new ContainerListener(){

            public void componentAdded(ContainerEvent containerEvent) {
                TermSettingDialogPanel.this.addComponent(containerEvent);
            }

            public void componentRemoved(ContainerEvent containerEvent) {
                TermSettingDialogPanel.this.removeComponent(containerEvent);
            }
        };
        this.addContainerListener(containerListener);
        ComponentFactory componentFactory = StandardComponentFactory.getComponentFactory();
        ColorManager colorManager = ColorManager.getInstance();
        EventListener eventListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                TermSettingDialogPanel.this.doSelectionChanged(itemEvent);
            }
        };
        Object object = "LDEV Guard/STRING_BTN_SPECIFIES";
        Object object2 = this.mdcwWrapper.getGuidanceString((String)object);
        Serializable serializable = this.mdcwWrapper.getGuidanceColor((String)object);
        this.mrbnSpecifies = componentFactory.createRadioButton((String)object2);
        this.mrbnSpecifies.addItemListener((ItemListener)eventListener);
        this.mrbnSpecifies.setForeground((Color)serializable);
        this.mrbnSpecifies.setOpaque(false);
        object = "LDEV Guard/STRING_BTN_UNLIMITED";
        object2 = this.mdcwWrapper.getGuidanceString((String)object);
        serializable = this.mdcwWrapper.getGuidanceColor((String)object);
        this.mrbnUnlimited = componentFactory.createRadioButton((String)object2);
        this.mrbnUnlimited.addItemListener((ItemListener)eventListener);
        this.mrbnUnlimited.setForeground((Color)serializable);
        this.mrbnUnlimited.setOpaque(false);
        object = new ButtonGroup();
        ((ButtonGroup)object).add(this.mrbnSpecifies);
        ((ButtonGroup)object).add(this.mrbnUnlimited);
        eventListener = new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                JTextField jTextField = (JTextField)focusEvent.getSource();
                jTextField.selectAll();
            }
        };
        object = colorManager.getSelectedLineBackground();
        object2 = colorManager.getSelectedLineForeground();
        serializable = new NumberStringDocument(2);
        this.mtxfTermYears = componentFactory.createTextField();
        this.mtxfTermYears.addFocusListener((FocusListener)eventListener);
        this.mtxfTermYears.setDocument((Document)((Object)serializable));
        this.mtxfTermYears.setColumns(3);
        this.mtxfTermYears.setHorizontalAlignment(4);
        this.mtxfTermYears.setSelectionColor((Color)object);
        this.mtxfTermYears.setSelectedTextColor((Color)object2);
        this.mtxfTermYears.setText("0");
        eventListener = new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                JTextField jTextField = (JTextField)focusEvent.getSource();
                jTextField.selectAll();
            }
        };
        object = colorManager.getSelectedLineBackground();
        object2 = colorManager.getSelectedLineForeground();
        serializable = new NumberStringDocument(5);
        this.mtxfTermDays = componentFactory.createTextField();
        this.mtxfTermDays.addFocusListener((FocusListener)eventListener);
        this.mtxfTermDays.setDocument((Document)((Object)serializable));
        this.mtxfTermDays.setColumns(6);
        this.mtxfTermDays.setHorizontalAlignment(4);
        this.mtxfTermDays.setSelectionColor((Color)object);
        this.mtxfTermDays.setSelectedTextColor((Color)object2);
        this.mtxfTermDays.setText("0");
        eventListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TermSettingDialogPanel.this.doButtonAction(actionEvent);
            }
        };
        object = "COMMON/OK";
        object2 = this.mdcwWrapper.getGuidanceString((String)object);
        serializable = this.mdcwWrapper.getGuidanceColor((String)object);
        this.mbtnOK = componentFactory.createButton((String)object2);
        this.mbtnOK.addActionListener((ActionListener)eventListener);
        this.mbtnOK.setForeground((Color)serializable);
        object = "COMMON/Cancel";
        object2 = this.mdcwWrapper.getGuidanceString((String)object);
        serializable = this.mdcwWrapper.getGuidanceColor((String)object);
        this.mbtnCancel = componentFactory.createButton((String)object2);
        this.mbtnCancel.addActionListener((ActionListener)eventListener);
        this.mbtnCancel.setForeground((Color)serializable);
        this.setDefaultTermDays(n);
        this.buildPanelLayout();
    }

    public final void keyEventReceived(KeyEventTransferable keyEventTransferable, KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        int n2 = keyEvent.getModifiers();
        String string = KeyEvent.getKeyText(n);
        String string2 = KeyEvent.getKeyModifiersText(n2);
        Logger.put(Level.FINEST, MODULE_NAME, "    keyEventReceived()    [" + string2 + " + " + string + "]");
    }

    private void addComponent(ContainerEvent containerEvent) {
        Component component = containerEvent.getChild();
        if (component instanceof KeyEventTransferable) {
            KeyEventTransferable keyEventTransferable = (KeyEventTransferable)((Object)component);
            keyEventTransferable.addKeyEventReceiver(this);
        }
    }

    private void removeComponent(ContainerEvent containerEvent) {
        Object object;
        Component component = containerEvent.getChild();
        if (component instanceof KeyEventTransferable) {
            object = (KeyEventTransferable)((Object)component);
            object.removeKeyEventReceiver(this);
        }
        if (component instanceof Container) {
            object = (Container)component;
            ((Container)object).removeAll();
        }
    }

    private void buildPanelLayout() {
        ComponentFactory componentFactory = StandardComponentFactory.getComponentFactory();
        Object object = this.mdcwWrapper.getGuidanceString("LDEV Guard/STRING_DPT_TERMSETTING");
        JPanel jPanel = ComponentUtilities.buildTitlePanel(componentFactory, (String)object);
        object = new BorderLayout(4, 4);
        JPanel jPanel2 = componentFactory.createPanel();
        jPanel2.setLayout((LayoutManager)object);
        jPanel2.setOpaque(false);
        jPanel2.add((Component)jPanel, "West");
        Object object2 = "LDEV Guard/STRING_DAT_YEARS";
        Object object3 = this.mdcwWrapper.getGuidanceString((String)object2);
        Object object4 = this.mdcwWrapper.getGuidanceColor((String)object2);
        Serializable serializable = componentFactory.createLabel((String)object3);
        serializable.setForeground((Color)object4);
        object2 = new BorderLayout(4, 4);
        Serializable serializable2 = componentFactory.createPanel();
        ((Container)serializable2).setLayout((LayoutManager)object2);
        ((JComponent)serializable2).setOpaque(false);
        ((Container)serializable2).add(this.mtxfTermYears, "West");
        ((Container)serializable2).add((Component)serializable, "Center");
        object3 = "LDEV Guard/STRING_DAT_DAYS";
        object4 = this.mdcwWrapper.getGuidanceString((String)object3);
        Color color = this.mdcwWrapper.getGuidanceColor((String)object3);
        object2 = componentFactory.createLabel((String)object4);
        ((JComponent)object2).setForeground(color);
        object3 = new BorderLayout(4, 4);
        serializable = componentFactory.createPanel();
        serializable.setLayout((LayoutManager)object3);
        serializable.setOpaque(false);
        serializable.add(this.mtxfTermDays, "West");
        serializable.add((Component)object2, "Center");
        object2 = new BorderLayout(8, 0);
        Object object5 = componentFactory.createPanel();
        ((Container)object5).setLayout((LayoutManager)object2);
        ((JComponent)object5).setOpaque(false);
        ((Container)object5).add((Component)serializable2, "West");
        ((Container)object5).add((Component)serializable, "Center");
        serializable2 = new BorderLayout(4, 4);
        object = componentFactory.createPanel();
        ((Container)object).setLayout((LayoutManager)((Object)serializable2));
        ((JComponent)object).setOpaque(false);
        ((Container)object).add((Component)this.mrbnSpecifies, "West");
        ((Container)object).add((Component)object5, "Center");
        serializable2 = new BorderLayout(4, 4);
        object5 = componentFactory.createPanel();
        ((Container)object5).setLayout((LayoutManager)((Object)serializable2));
        ((JComponent)object5).setOpaque(false);
        ((Container)object5).add((Component)this.mrbnUnlimited, "West");
        serializable = ComponentUtilities.buildListValueComponent(componentFactory, (JComponent)object);
        object2 = ComponentUtilities.buildListValueComponent(componentFactory, (JComponent)object5);
        object3 = new GridLayout(0, 1, 4, 4);
        serializable2 = componentFactory.createPanel();
        ((Container)serializable2).setLayout((LayoutManager)object3);
        ((JComponent)serializable2).setOpaque(false);
        ((Container)serializable2).add((Component)serializable);
        ((Container)serializable2).add((Component)object2);
        serializable = new BorderLayout();
        jPanel = componentFactory.createPanel();
        jPanel.setLayout((LayoutManager)((Object)serializable));
        jPanel.setOpaque(false);
        jPanel.add((Component)serializable2, "North");
        serializable2 = new GridLayout(1, 0, 4, 4);
        object5 = componentFactory.createPanel();
        ((Container)object5).setLayout((LayoutManager)((Object)serializable2));
        ((JComponent)object5).setOpaque(false);
        ((Container)object5).add(this.mbtnOK);
        ((Container)object5).add(this.mbtnCancel);
        ComponentUtilities.decorateInputAreaMarginBorder((JComponent)object5);
        serializable2 = new BorderLayout(4, 4);
        object = componentFactory.createPanel();
        ((Container)object).setLayout((LayoutManager)((Object)serializable2));
        ((JComponent)object).setOpaque(false);
        ((Container)object).add((Component)object5, "East");
        object5 = ColorManager.getInstance();
        serializable2 = new BorderLayout(4, 4);
        serializable = ((ColorManager)object5).getPanelBackground();
        this.setLayout((LayoutManager)((Object)serializable2));
        this.setOpaque(true);
        this.setBackground((Color)serializable);
        this.add((Component)jPanel2, "North");
        this.add((Component)jPanel, "Center");
        this.add((Component)object, "South");
        ComponentUtilities.decorateInputAreaMarginBorder(this);
    }

    private void doSelectionChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            Object object = itemEvent.getSource();
            boolean bl = object.equals(this.mrbnSpecifies);
            this.mtxfTermYears.setEnabled(bl);
            this.mtxfTermDays.setEnabled(bl);
            if (bl) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        TermSettingDialogPanel.this.mtxfTermYears.requestFocus();
                        TermSettingDialogPanel.this.mtxfTermYears.selectAll();
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    private void doButtonAction(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.mbtnOK)) {
            int n = this.getUserInputError();
            if (n == 0) {
                this.mbUserOK = true;
                this.doDialogClose();
            } else {
                RJDataMsg rJDataMsg = this.mdcwWrapper.createMessageObject(9610, n);
                String string = rJDataMsg.getMessage();
                Logger.put(Level.FINE, MODULE_NAME, string);
                Object[] objectArray = new Object[]{this.mdcwWrapper.getGuidanceString("COMMON/OK")};
                RJComDialog.show(this, rJDataMsg, 0, objectArray, objectArray[0]);
            }
        } else if (object.equals(this.mbtnCancel)) {
            this.doDialogClose();
        }
    }

    private int getUserInputError() {
        int n;
        block2: {
            block4: {
                int n2;
                String string;
                block3: {
                    n = 0;
                    if (!this.mrbnSpecifies.isSelected()) break block2;
                    string = this.mtxfTermYears.getText();
                    if (string == null || string.equals("")) {
                        string = "0";
                    }
                    if ((n2 = Integer.parseInt(string, 10)) <= 60) break block3;
                    this.mtxfTermYears.requestFocus();
                    this.mtxfTermYears.selectAll();
                    n = 9363;
                    break block2;
                }
                string = this.mtxfTermDays.getText();
                if (string == null || string.equals("")) {
                    string = "0";
                }
                if ((n2 = Integer.parseInt(string, 10)) <= 21900) break block4;
                this.mtxfTermDays.requestFocus();
                this.mtxfTermDays.selectAll();
                n = 9363;
                break block2;
            }
            int n3 = this.getInputTermDays();
            if (n3 <= 21900) break block2;
            this.mtxfTermYears.requestFocus();
            this.mtxfTermYears.selectAll();
            n = 9363;
        }
        return n;
    }

    private void doDialogClose() {
        Dialog dialog = (Dialog)SwingUtilities.getAncestorOfClass(class$java$awt$Dialog == null ? (class$java$awt$Dialog = TermSettingDialogPanel.class$("java.awt.Dialog")) : class$java$awt$Dialog, this);
        if (dialog != null) {
            dialog.dispose();
            dialog.removeAll();
        } else {
            Logger.put(Level.WARNING, MODULE_NAME, "Can not found dialog. A dialog cannot be closed.");
        }
    }

    public final void setDefaultTermDays(int n) {
        if (n == -1) {
            this.mrbnUnlimited.setSelected(true);
            this.mrbnUnlimited.requestFocus();
        } else {
            this.mrbnSpecifies.setSelected(true);
            this.mrbnSpecifies.requestFocus();
            int n2 = n / 365;
            int n3 = n - n2 * 365;
            String string = String.valueOf(n2);
            String string2 = String.valueOf(n3);
            this.mtxfTermYears.setText(string);
            this.mtxfTermDays.setText(string2);
        }
    }

    public final boolean isInputComplete() {
        return this.mbUserOK;
    }

    public final int getInputTermDays() {
        int n = 0;
        if (this.mrbnUnlimited.isSelected()) {
            n = -1;
        } else {
            String string = this.mtxfTermYears.getText();
            if (string == null || string.equals("")) {
                string = "0";
            }
            int n2 = Integer.parseInt(string, 10);
            String string2 = this.mtxfTermDays.getText();
            if (string2 == null || string2.equals("")) {
                string2 = "0";
            }
            int n3 = Integer.parseInt(string2, 10);
            n = n2 * 365 + n3;
        }
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

