/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.syslog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import sanproject.client.syslog.RJColleague;
import sanproject.client.syslog.RJMediator;
import sanproject.client.syslog.RJslDef;
import sanproject.client.syslog.RJslGuide;
import sanproject.client.syslog.RJslNumberField;

public class RJslIPField
extends JPanel
implements RJslGuide,
RJColleague,
RJMediator {
    protected RJslNumberField[] fields;
    private JLabel[] label;
    boolean chg_state = false;
    RJMediator mediator;
    int[] ipNum = RJslDef.def_IPv4;
    protected int col_num = 4;
    int num_size = 3;
    int max = 255;
    int min = 0;
    String ip_dot = ".";
    int italic = 3;
    int not_italic = 0;
    Color blue = Color.blue;
    Color black = Color.black;

    public RJslIPField() {
        this.init();
    }

    public void init() {
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.white);
        this.setBorder(UIManager.getBorder("TextField.border"));
        this.fields = new RJslNumberField[this.col_num];
        this.label = new JLabel[this.col_num - 1];
        for (int i = 0; i < this.col_num; ++i) {
            if (i != 0) {
                this.label[i - 1] = new JLabel();
                this.label[i - 1].setText(this.ip_dot);
                this.add((Component)this.label[i - 1], new GridBagConstraints(i * 2 - 1, 0, 1, 1, 0.1, 0.1, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            }
            this.fields[i] = new RJslNumberField(this.num_size, this.min, this.max);
            this.fields[i].setBorder(BorderFactory.createEmptyBorder());
            this.fields[i].setOpaque(false);
            this.fields[i].setHorizontalAlignment(0);
            this.fields[i].setMediator(this);
            this.add((Component)this.fields[i], new GridBagConstraints(i * 2, 0, 1, 1, 0.1, 0.1, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    public void setValue(int[] nArray) {
        for (int i = 0; i < this.col_num; ++i) {
            this.fields[i].setText(Integer.toString(nArray[i]));
        }
    }

    public String getAddress_string() {
        String string = "";
        for (int i = 0; i < this.fields.length; ++i) {
            if (i != 0) {
                string = string + this.ip_dot;
            }
            string = string + this.fields[i].getText();
        }
        return string;
    }

    public int[] getAddress_int() {
        int[] nArray = new int[this.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            nArray[i] = this.fields[i].getText() == null || this.fields[i].getText().equals("") ? 0 : Integer.parseInt(this.fields[i].getText());
        }
        return nArray;
    }

    public boolean check(int[] nArray) {
        boolean bl = false;
        int[] nArray2 = this.getAddress_int();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            bl = true;
        }
        return bl;
    }

    public void setEnabled(boolean bl) {
        int n;
        for (n = 0; n < this.fields.length; ++n) {
            this.fields[n].setEnabled(bl);
        }
        for (n = 0; n < this.label.length; ++n) {
            this.label[n].setEnabled(bl);
        }
    }

    public void setEditable(boolean bl) {
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i].setEditable(bl);
        }
    }

    public void setItalic(boolean bl) {
        int n;
        this.chg_state = bl;
        for (n = 0; n < this.fields.length; ++n) {
            if (bl) {
                this.fields[n].setFont(new Font(null, this.italic, 12));
                continue;
            }
            this.fields[n].setFont(new Font(null, this.not_italic, 12));
        }
        for (n = 0; n < this.label.length; ++n) {
            if (bl) {
                this.label[n].setFont(new Font(null, this.italic, 12));
                continue;
            }
            this.label[n].setFont(new Font(null, this.not_italic, 12));
        }
    }

    public void setBlue(boolean bl) {
        int n;
        for (n = 0; n < this.fields.length; ++n) {
            if (bl) {
                this.fields[n].setForeground(this.blue);
                continue;
            }
            this.fields[n].setForeground(this.black);
        }
        for (n = 0; n < this.label.length; ++n) {
            if (bl) {
                this.label[n].setForeground(this.blue);
                continue;
            }
            this.label[n].setForeground(this.black);
        }
    }

    public void setBlack() {
        int n;
        for (n = 0; n < this.fields.length; ++n) {
            this.fields[n].setDisabledTextColor(this.black);
        }
        for (n = 0; n < this.label.length; ++n) {
            this.label[n].setForeground(this.black);
        }
    }

    public void requestFocus() {
        this.fields[0].requestFocus();
        this.fields[0].selectAll();
    }

    public boolean getstate() {
        return this.chg_state;
    }

    public void setMediator(RJMediator rJMediator) {
        this.mediator = rJMediator;
    }

    public void colleagueChanged() {
        if (this.mediator != null) {
            this.mediator.colleagueChanged();
        }
    }
}

