/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.profiles.common;

import com.ws.wbem.CloseableAddableIterator;
import com.ws.wbem.jserver.DaemonThreadFactory;
import com.ws.wbem.profiles.common.BaseProviderImpl;
import com.ws.wbem.profiles.common.IndicationHandler;
import com.ws.wbem.profiles.common.IndicationManager;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.cim.CIMArgument;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.provider.IndicationProvider;
import javax.wbem.provider.ProviderHandle;
import javax.wbem.provider.PullInstanceProvider;

public abstract class BaseProvider
implements PullInstanceProvider,
IndicationProvider,
IndicationHandler {
    private BaseProviderImpl<?, ?> mImplementation;
    private static int DEFAULT_NUM_THREADS = 10;
    private static int NUM_THREADS;
    private static String QUERY;
    protected static ProviderHandle mHandle;
    protected static Logger mLogger;
    private static volatile ExecutorService exec;
    protected IndicationManager mIndicationManager;

    private static void setProviderHandle(ProviderHandle providerHandle) {
        mHandle = providerHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public BaseProvider() {
        if (exec == null) {
            Class<BaseProvider> clazz = BaseProvider.class;
            // MONITORENTER : com.ws.wbem.profiles.common.BaseProvider.class
            if (exec == null) {
                NUM_THREADS = DEFAULT_NUM_THREADS;
                exec = new ThreadPoolExecutor(1, NUM_THREADS, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new DaemonThreadFactory());
                ((ThreadPoolExecutor)exec).allowCoreThreadTimeOut(true);
            }
            // MONITOREXIT : clazz
        }
        this.mIndicationManager = new IndicationManager(this);
    }

    public void activateFilter(CIMInstance cIMInstance, CIMInstance cIMInstance2, CIMInstance cIMInstance3) throws WBEMException {
        mLogger.info("activatefilter: " + cIMInstance.getObjectPath());
        String string = (String)cIMInstance.getPropertyValue(QUERY);
        int n = this.mIndicationManager.activate(string);
        if (1 == n) {
            this.getImplementation().processIndicationFilter(string, true);
        }
    }

    public void authorizeFilter(CIMInstance cIMInstance, CIMInstance cIMInstance2, CIMInstance cIMInstance3) throws WBEMException {
        mLogger.info("authorizeFilter: " + cIMInstance.getObjectPath());
        this.mIndicationManager.authorize((String)cIMInstance.getPropertyValue(QUERY));
    }

    protected void authorizeSet() throws WBEMException {
        mLogger.info("authorize set called");
        mLogger.info("authorize set completed");
    }

    public void close() throws WBEMException {
        if (this.mImplementation != null) {
            mLogger.info("close() " + this.mImplementation.getClass().getName());
        }
        if (null != exec && !exec.isShutdown()) {
            exec.shutdownNow();
            exec = null;
        }
    }

    public CIMObjectPath createInstance(CIMInstance cIMInstance) throws WBEMException {
        this.authorizeSet();
        mLogger.info("createInstance: " + cIMInstance.getObjectPath());
        throw new WBEMException(7);
    }

    public void deActivateFilter(CIMInstance cIMInstance, CIMInstance cIMInstance2, CIMInstance cIMInstance3) throws WBEMException {
        mLogger.info("deactivateFilter: " + cIMInstance.getObjectPath());
        String string = (String)cIMInstance.getPropertyValue(QUERY);
        int n = this.mIndicationManager.deactivate(string);
        if (0 == n) {
            this.getImplementation().processIndicationFilter(string, false);
        }
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws WBEMException {
        this.authorizeSet();
        mLogger.info("deleteInstance: " + cIMObjectPath);
        this.getImplementation().deleteInstance(cIMObjectPath);
    }

    protected void enumerate(CloseableAddableIterator<CIMInstance> closeableAddableIterator, CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, String[] stringArray, String string, String string2, boolean bl3, boolean bl4) throws WBEMException {
        this.getImplementation().enumerate(closeableAddableIterator, cIMObjectPath, stringArray, string, string2, bl3, bl4, null, null);
    }

    public CloseableIterator<CIMInstance> enumerateInstances(CIMObjectPath cIMObjectPath, String[] stringArray, String string, String string2, boolean bl) throws WBEMException {
        mLogger.info("enumerateInstances (pull): " + cIMObjectPath);
        CloseableIterator<?> closeableIterator = this.threadedEnumerate(cIMObjectPath, false, false, stringArray, string, string2, bl, false);
        mLogger.info("enumerateInstances (pull) completed: " + cIMObjectPath);
        return closeableIterator;
    }

    public CloseableIterator<CIMInstance> execQuery(CIMObjectPath cIMObjectPath, String string, String string2) throws WBEMException {
        mLogger.info("execQuery() not supported");
        throw new WBEMException(7);
    }

    protected ExecutorService getExecutorService() {
        return exec;
    }

    protected BaseProviderImpl<?, ?> getImplementation() throws WBEMException {
        return this.mImplementation;
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, String[] stringArray) throws WBEMException {
        return this.getImplementation().getInstance(cIMObjectPath, stringArray);
    }

    @Override
    public String[] getSupportedIndications() {
        return null;
    }

    public void initialize(ProviderHandle providerHandle) throws WBEMException {
        BaseProvider.setProviderHandle(providerHandle);
        if (null != this.mImplementation) {
            this.getImplementation().initialize(providerHandle);
        }
    }

    public Object invokeMethod(CIMObjectPath cIMObjectPath, String string, CIMArgument<?>[] cIMArgumentArray, CIMArgument<?>[] cIMArgumentArray2) throws WBEMException {
        return this.getImplementation().invokeMethod(cIMObjectPath, string, cIMArgumentArray, cIMArgumentArray2);
    }

    public void modifyInstance(CIMInstance cIMInstance, String[] stringArray) throws WBEMException {
        this.authorizeSet();
        mLogger.info("modifyInstance: " + cIMInstance.getObjectPath());
        this.getImplementation().modifyInstance(cIMInstance, stringArray);
    }

    protected void setImplementation(BaseProviderImpl<?, ?> baseProviderImpl) {
        this.mImplementation = baseProviderImpl;
    }

    protected CloseableIterator<?> threadedEnumerate(final CIMObjectPath cIMObjectPath, final boolean bl, final boolean bl2, final String[] stringArray, final String string, final String string2, final boolean bl3, final boolean bl4) throws WBEMException {
        final CloseableAddableIterator closeableAddableIterator = new CloseableAddableIterator();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Thread thread = Thread.currentThread();
                String string3 = BaseProvider.this.getClass().getName();
                thread.setName("enumerateThread - " + string3);
                try {
                    BaseProvider.this.enumerate((CloseableAddableIterator<CIMInstance>)closeableAddableIterator, cIMObjectPath, bl, bl2, stringArray, string, string2, bl3, bl4);
                }
                catch (WBEMException wBEMException) {
                    if (closeableAddableIterator.getWBEMException() == null) {
                        closeableAddableIterator.setException(wBEMException);
                        closeableAddableIterator.close();
                    }
                }
                finally {
                    thread.setName("enumerateThread - idle");
                }
            }
        };
        if (null != runnable) {
            exec.execute(runnable);
        }
        return closeableAddableIterator;
    }

    static {
        QUERY = "Query";
        mLogger = Logger.getLogger("com.ws.wbem.jserver");
        exec = null;
    }
}

