/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.profiles.dmtf.indications;

import com.ws.utilities.WSIStandardMessages;
import com.ws.wbem.CloseableAddableIterator;
import com.ws.wbem.jserver.JServerProperties;
import com.ws.wbem.jserver.JServerServiceAdapterFactory;
import com.ws.wbem.jserver.JServerSettings;
import com.ws.wbem.jserver.profiles.common.BaseInstanceProvider;
import com.ws.wbem.profiles.dmtf.indications.IndicationsBackupStore;
import com.ws.wbem.server.services.indication.EventService;
import com.ws.wbem.server.services.indication.FilterActivation;
import com.ws.wbem.server.services.indication.RepeatNotificationPolicy;
import java.io.Serializable;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.UUID;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMDateTimeAbsolute;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger64;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.WBEMOperation;
import javax.wbem.WBEMOperationErrors;
import javax.wbem.provider.ProviderHandle;
import javax.wbem.provider.PullAssociatorProvider;

public class IndicationSubscriptionProvider
extends BaseInstanceProvider
implements PullAssociatorProvider {
    protected static final String LISTENERCLASS = "CIM_ListenerDestination";
    protected static final String HTTPS = "https";
    private static final int SUBSCRIPTION_STATE_ENABLED = 2;
    protected static final int SUBSCRIPTION_STATE_DISABLED = 4;
    private final int PROTOCOL_CIMXML = 2;
    private final int PROTOCOL_WSMAN = 4;
    protected EventService mEventService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activateFilter(CIMInstance cIMInstance, CIMInstance cIMInstance2, CIMInstance cIMInstance3, String[] stringArray) throws WBEMException {
        String string = (String)cIMInstance2.getPropertyValue("Name");
        FilterActivation filterActivation = null;
        CloseableIterator closeableIterator = mHandle.associatorInstances(cIMInstance2.getObjectPath(), cIMInstance.getClassName(), LISTENERCLASS, null, null, null);
        if (!closeableIterator.hasNext()) {
            filterActivation = new FilterActivation(cIMInstance2.getObjectPath(), cIMInstance2, this.mEventService, stringArray);
            filterActivation.run();
            filterActivation.authorize("", cIMInstance3, cIMInstance);
            filterActivation.activate(cIMInstance3, cIMInstance);
            HashMap<String, FilterActivation> hashMap = this.mEventService.filterActivations;
            synchronized (hashMap) {
                this.mEventService.filterActivations.put(string, filterActivation);
            }
        }
        HashMap<String, FilterActivation> hashMap = this.mEventService.filterActivations;
        synchronized (hashMap) {
            filterActivation = this.mEventService.filterActivations.get(string);
        }
        if (filterActivation != null) {
            filterActivation.activateSubscription(cIMInstance3, cIMInstance);
        }
    }

    public CloseableIterator<CIMInstance> associators(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string, String string2, String string3, String[] stringArray, String string4, String string5, boolean bl) throws WBEMException {
        this.checkArguments(cIMObjectPath2, WBEMOperation.OPENASSOCIATORS, string4, string5, bl);
        CloseableIterator closeableIterator = mInternalProvider.associators(cIMObjectPath, this.setInteropNamespace(this.cleanSystemName(cIMObjectPath2)), string, string2, string3, stringArray, string4, string5, bl);
        ArrayList<CIMInstance> arrayList = new ArrayList<CIMInstance>();
        while (closeableIterator.hasNext()) {
            CIMInstance cIMInstance = this.fixSystemName((CIMInstance)closeableIterator.next());
            arrayList.add(this.cleanInstance(cIMObjectPath2, cIMInstance));
        }
        return new CloseableAddableIterator(arrayList);
    }

    public CIMObjectPath createInstance(CIMInstance cIMInstance) throws WBEMException {
        CIMProperty cIMProperty;
        String string = cIMInstance.getObjectPath().getNamespace();
        CIMObjectPath cIMObjectPath = null;
        CIMObjectPath cIMObjectPath2 = null;
        CIMProperty cIMProperty2 = null;
        CIMProperty cIMProperty3 = null;
        CIMInstance cIMInstance2 = null;
        CIMInstance cIMInstance3 = null;
        try {
            UnsignedInteger16 unsignedInteger16;
            CIMObjectPath cIMObjectPath3;
            String[] stringArray;
            StringBuffer stringBuffer;
            String string2;
            CIMProperty cIMProperty4;
            String string3;
            UnsignedInteger16 unsignedInteger162;
            String string4;
            Serializable serializable;
            block45: {
                try {
                    cIMProperty2 = cIMInstance.getProperty("Filter");
                    cIMObjectPath = this.setInteropNamespace(this.cleanSystemName((CIMObjectPath)cIMProperty2.getValue()));
                }
                catch (Exception exception) {
                    Object[] objectArray = new Object[]{"Filter"};
                    throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMInstance.getObjectPath(), (String)WSIStandardMessages.getMessage((String)"ERROR_PROVIDER_GENERIC_VALUE", (Object[])objectArray), (WBEMOperation)WBEMOperation.CREATEINSTANCE, (String)cIMInstance.getClassName());
                }
                try {
                    cIMProperty3 = cIMInstance.getProperty("Handler");
                    cIMObjectPath2 = this.setInteropNamespace(this.cleanSystemName((CIMObjectPath)cIMProperty3.getValue()));
                }
                catch (Exception exception) {
                    Object[] objectArray = new Object[]{"Handler"};
                    throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMInstance.getObjectPath(), (String)WSIStandardMessages.getMessage((String)"ERROR_PROVIDER_GENERIC_VALUE", (Object[])objectArray), (WBEMOperation)WBEMOperation.CREATEINSTANCE, (String)cIMInstance.getClassName());
                }
                try {
                    cIMObjectPath = this.setDefaultNamespace(cIMObjectPath, cIMInstance.getObjectPath());
                    cIMInstance2 = this.cleanSystemName(mHandle.getInstance(cIMObjectPath, null));
                }
                catch (Exception exception) {
                    Object[] objectArray = new Object[]{cIMObjectPath};
                    throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMInstance.getObjectPath(), (String)WSIStandardMessages.getMessage((String)"ERROR_PROVIDER_GENERIC_VALUE_REF", (Object[])objectArray), (WBEMOperation)WBEMOperation.CREATEINSTANCE, (String)cIMInstance.getClassName());
                }
                try {
                    cIMObjectPath2 = this.setDefaultNamespace(cIMObjectPath2, cIMInstance.getObjectPath());
                    cIMInstance3 = this.cleanSystemName(mHandle.getInstance(cIMObjectPath2, null));
                }
                catch (Exception exception) {
                    Object[] objectArray = new Object[]{cIMObjectPath2};
                    throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMInstance.getObjectPath(), (String)WSIStandardMessages.getMessage((String)"ERROR_PROVIDER_GENERIC_VALUE_REF", (Object[])objectArray), (WBEMOperation)WBEMOperation.CREATEINSTANCE, (String)cIMInstance.getClassName());
                }
                cIMProperty = cIMInstance3.getProperty("Destination");
                if (cIMProperty == null || cIMProperty.getValue() == null) {
                    throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMInstance.getObjectPath(), (String)WSIStandardMessages.getMessage((String)"ERROR_SERVICE_EVENT_DESTINATION_INVALID"), (WBEMOperation)WBEMOperation.CREATEINSTANCE, (String)cIMInstance.getClassName());
                }
                try {
                    serializable = new URL((String)cIMProperty.getValue());
                    string4 = ((URL)serializable).getProtocol();
                    unsignedInteger162 = (UnsignedInteger16)cIMInstance3.getPropertyValue("Protocol");
                    if (null != unsignedInteger162 && this.mutualAuthReq(unsignedInteger162.intValue())) {
                        mLogger.info("Server is configured for secure indications only");
                        if (string4 == null || !string4.equalsIgnoreCase(HTTPS)) {
                            mLogger.warning("Creation of indication subscription failed because destination was http but server requires https.  Subscription is: " + cIMInstance.getObjectPath());
                            Object[] objectArray = new Object[]{string4};
                            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMInstance.getObjectPath(), (String)WSIStandardMessages.getMessage((String)"ERROR_SERVICE_EVENT_SCHEME_NOT_SUPPORTED", (Object[])objectArray), (WBEMOperation)WBEMOperation.CREATEINSTANCE, (String)cIMInstance.getClassName());
                        }
                    }
                    string3 = ((URL)serializable).getHost();
                    cIMProperty4 = null;
                    try {
                        cIMProperty4 = InetAddress.getByName(string3);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (cIMProperty4 == null || !(cIMProperty4 instanceof Inet6Address)) break block45;
                    string2 = System.getProperty("com.ws.jserver.indications.ipv6scopeid");
                    int n = -1;
                    try {
                        n = Integer.parseInt(string2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (n != -1 && n != ((Inet6Address)cIMProperty4).getScopeId()) {
                        stringBuffer = new StringBuffer((String)cIMProperty.getValue());
                        int n2 = stringBuffer.indexOf("%");
                        int n3 = stringBuffer.indexOf("]");
                        if (n2 != -1) {
                            stringBuffer.delete(n2, n3);
                            n3 = n2;
                        }
                        stringBuffer.insert(n3, "%" + string2);
                        stringArray = new String[]{"Destination"};
                        cIMObjectPath3 = new CIMObjectPath[]{new CIMProperty("Destination", CIMDataType.STRING_T, (Object)stringBuffer.toString(), false)};
                        try {
                            cIMInstance3 = cIMInstance3.deriveInstance((CIMProperty[])cIMObjectPath3);
                            mInternalProvider.modifyInstance(cIMInstance3, stringArray);
                        }
                        catch (WBEMException wBEMException) {
                            mLogger.warning("Error modifying listener destination property to use specified IPv6 scope ID: " + string2);
                        }
                    }
                }
                catch (WBEMException wBEMException) {
                    throw wBEMException;
                }
                catch (Throwable throwable) {
                    throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMInstance.getObjectPath(), (String)throwable.getMessage(), (WBEMOperation)WBEMOperation.CREATEINSTANCE, (String)cIMInstance.getClassName());
                }
            }
            serializable = new ArrayList();
            string4 = new CIMProperty("Filter", cIMProperty2.getDataType(), (Object)cIMInstance2.getObjectPath(), true);
            unsignedInteger162 = new CIMProperty("Handler", cIMProperty3.getDataType(), (Object)cIMInstance3.getObjectPath(), true);
            ((ArrayList)serializable).add(string4);
            ((ArrayList)serializable).add(unsignedInteger162);
            string3 = cIMInstance.getProperty("SubscriptionDuration");
            if (string3 != null && string3.getValue() != null) {
                cIMProperty4 = new Object[]{"SubscriptionDuration", this.mClassName};
                throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMInstance.getObjectPath(), (String)WSIStandardMessages.getMessage((String)"ERROR_SERVICE_PROPERTY_NOT_SUPPORTED", (Object[])cIMProperty4), (WBEMOperation)WBEMOperation.CREATEINSTANCE, (String)cIMInstance.getClassName());
            }
            cIMProperty4 = cIMInstance.getProperty("SubscriptionState");
            UnsignedInteger16 unsignedInteger163 = unsignedInteger16 = null == cIMProperty4 ? null : (UnsignedInteger16)cIMProperty4.getValue();
            if (null == unsignedInteger16) {
                unsignedInteger16 = new UnsignedInteger16(2);
                cIMProperty4 = new CIMProperty("SubscriptionState", CIMDataType.UINT16_T, (Object)unsignedInteger16, false);
            } else if (2 != unsignedInteger16.intValue() && 4 != unsignedInteger16.intValue()) {
                string2 = String.format("Cannot create instance of %s because the only valid values for the SubscriptionState property are 2 (Enabled) or 4 (Disabled) but the value of this property for the specified instance was %d", cIMInstance.getClassName(), unsignedInteger16.intValue());
                throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMInstance.getObjectPath(), (String)string2, (WBEMOperation)WBEMOperation.CREATEINSTANCE, (String)cIMInstance.getClassName());
            }
            ((ArrayList)serializable).add(cIMProperty4);
            string2 = cIMInstance.getProperty("RepeatNotificationPolicy");
            CIMProperty cIMProperty5 = cIMInstance.getProperty("RepeatNotificationCount");
            stringBuffer = cIMInstance.getProperty("RepeatNotificationInterval");
            CIMProperty cIMProperty6 = cIMInstance.getProperty("RepeatNotificationGap");
            if (null != string2) {
                ((ArrayList)serializable).add(string2);
                RepeatNotificationPolicy repeatNotificationPolicy = RepeatNotificationPolicy.getRepeatNotificationPolicy((UnsignedInteger16)string2.getValue());
                if (repeatNotificationPolicy != RepeatNotificationPolicy.None) {
                    if (null == cIMProperty5 || null == cIMProperty5.getValue()) {
                        throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMInstance.getObjectPath(), (String)"If RepeatNotificationPolicy is not 2 (None) there must be a RepeatNotificationCount value", (WBEMOperation)WBEMOperation.CREATEINSTANCE, (String)cIMInstance.getClassName());
                    }
                    if (((UnsignedInteger16)cIMProperty5.getValue()).intValue() < 1) {
                        throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMInstance.getObjectPath(), (String)("RepeatNotificationCount property must have a a value that is greater then 0 but it has a value of: " + cIMProperty5.getValue()), (WBEMOperation)WBEMOperation.CREATEINSTANCE, (String)cIMInstance.getClassName());
                    }
                    if (null == stringBuffer || null == stringBuffer.getValue()) {
                        throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMInstance.getObjectPath(), (String)"If RepeatNotificationPolicy is not 2 (None) there must be a RepeatNotificationInterval value", (WBEMOperation)WBEMOperation.CREATEINSTANCE, (String)cIMInstance.getClassName());
                    }
                    if (((UnsignedInteger64)stringBuffer.getValue()).intValue() < 1) {
                        throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMInstance.getObjectPath(), (String)("RepeatNotificationInterval property must have a value that is greater then 0 but it has a value of: " + stringBuffer.getValue()), (WBEMOperation)WBEMOperation.CREATEINSTANCE, (String)cIMInstance.getClassName());
                    }
                    if (repeatNotificationPolicy == RepeatNotificationPolicy.Delay) {
                        if (null == cIMProperty6 || null == cIMProperty6.getValue()) {
                            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMInstance.getObjectPath(), (String)"If RepeatNotificationPolicy is 4 (Delay), there must be a RepeatNotificationGap value", (WBEMOperation)WBEMOperation.CREATEINSTANCE, (String)cIMInstance.getClassName());
                        }
                        if (((UnsignedInteger64)cIMProperty6.getValue()).intValue() < 0) {
                            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMInstance.getObjectPath(), (String)("RepeatNotificationGap property must have a value that is greater then or equal to 0 but it has a value of: " + cIMProperty6.getValue()), (WBEMOperation)WBEMOperation.CREATEINSTANCE, (String)cIMInstance.getClassName());
                        }
                        ((ArrayList)serializable).add(cIMProperty6);
                    }
                    ((ArrayList)serializable).add(stringBuffer);
                    ((ArrayList)serializable).add(cIMProperty5);
                }
            } else {
                ((ArrayList)serializable).add(new CIMProperty("RepeatNotificationPolicy", CIMDataType.UINT16_T, (Object)RepeatNotificationPolicy.None.getRepeatNotificationPolicyValue(), false));
            }
            ((ArrayList)serializable).add(new CIMProperty("SubscriptionStartTime", CIMDataType.DATETIME_T, (Object)new CIMDateTimeAbsolute(), false));
            ((ArrayList)serializable).add(new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)UUID.randomUUID().toString(), false));
            CIMProperty[] cIMPropertyArray = new CIMProperty[]{string4, unsignedInteger162};
            stringArray = ((ArrayList)serializable).toArray(new CIMProperty[((ArrayList)serializable).size()]);
            cIMObjectPath3 = cIMInstance.getObjectPath();
            CIMObjectPath cIMObjectPath4 = new CIMObjectPath(cIMObjectPath3.getScheme(), cIMObjectPath3.getHost(), cIMObjectPath3.getPort(), JServerProperties.getInteropNamespace(), this.mClassName, cIMPropertyArray);
            cIMInstance = cIMInstance.deriveInstance(cIMObjectPath4);
            cIMInstance = this.deriveInstance(cIMInstance, (CIMProperty[])stringArray);
            if (unsignedInteger16.intValue() == 2) {
                this.enableSubscription(cIMInstance, cIMInstance2, cIMInstance3, true);
            }
        }
        catch (WBEMException wBEMException) {
            throw wBEMException;
        }
        catch (Exception exception) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMInstance.getObjectPath(), (Throwable)exception, (WBEMOperation)WBEMOperation.CREATEINSTANCE, (String)cIMInstance.getClassName());
        }
        cIMProperty = null;
        try {
            cIMProperty = mInternalProvider.createInstance(cIMInstance);
            IndicationsBackupStore.storeData(mHandle);
        }
        catch (WBEMException wBEMException) {
            try {
                mLogger.log(Level.SEVERE, "Caught exception trying to create instance ofIndicationSubscription: " + cIMProperty, wBEMException);
                this.disableSubscription(cIMInstance.getObjectPath(), WBEMOperation.CREATEINSTANCE);
            }
            catch (WBEMException wBEMException2) {
                mLogger.log(Level.SEVERE, "Caught exception trying to disable Indication Subscription that was just enabled but had to be disabled because the instance could not be created:" + cIMProperty, wBEMException);
            }
            throw wBEMException;
        }
        cIMProperty = this.fixAssociationSystemName((CIMObjectPath)cIMProperty);
        if (!JServerProperties.getInteropNamespace().equalsIgnoreCase(string)) {
            cIMProperty = this.setAssociationNamespace((CIMObjectPath)cIMProperty, string);
        }
        return cIMProperty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deactivateFilter(CIMInstance cIMInstance, CIMInstance cIMInstance2, CIMInstance cIMInstance3, boolean bl) throws WBEMException {
        String string = (String)cIMInstance2.getPropertyValue("Name");
        FilterActivation filterActivation = null;
        if (!bl) {
            HashMap<String, FilterActivation> hashMap = this.mEventService.filterActivations;
            synchronized (hashMap) {
                filterActivation = this.mEventService.filterActivations.get(string);
            }
            if (filterActivation != null) {
                filterActivation.deactivateSubscription(cIMInstance3, cIMInstance);
            }
        } else {
            HashMap<String, FilterActivation> hashMap = this.mEventService.filterActivations;
            synchronized (hashMap) {
                filterActivation = this.mEventService.filterActivations.remove(string);
            }
            if (filterActivation != null) {
                filterActivation.deactivate(cIMInstance3, cIMInstance);
            }
        }
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws WBEMException {
        CIMObjectPath cIMObjectPath2 = null;
        try {
            cIMObjectPath2 = this.findInstanceName(this.cleanAssociationSystemName(this.setAssociationNamespace(cIMObjectPath, JServerProperties.getInteropNamespace())));
        }
        catch (WBEMException wBEMException) {
            // empty catch block
        }
        if (null == cIMObjectPath2) {
            cIMObjectPath2 = cIMObjectPath;
        }
        try {
            this.disableSubscription(cIMObjectPath2, WBEMOperation.DELETEINSTANCE);
        }
        catch (WBEMException wBEMException) {
            mLogger.log(Level.SEVERE, "Caught exception trying to disable Indication Subscription: " + cIMObjectPath2, wBEMException);
        }
        mInternalProvider.deleteInstance(cIMObjectPath2);
        IndicationsBackupStore.storeData(mHandle);
    }

    private void disableSubscription(CIMObjectPath cIMObjectPath, WBEMOperation wBEMOperation) throws WBEMException {
        CIMObjectPath cIMObjectPath2;
        CIMProperty cIMProperty = cIMObjectPath.getKey("Filter");
        CIMProperty cIMProperty2 = cIMObjectPath.getKey("Handler");
        CIMObjectPath cIMObjectPath3 = cIMProperty == null ? null : this.setInteropNamespace((CIMObjectPath)cIMProperty.getValue());
        CIMObjectPath cIMObjectPath4 = cIMObjectPath2 = cIMProperty2 == null ? null : this.setInteropNamespace((CIMObjectPath)cIMProperty2.getValue());
        if (cIMObjectPath2 == null || cIMObjectPath3 == null) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (String)"The filter or Listener shall not be null", (WBEMOperation)wBEMOperation, null);
        }
        CIMInstance cIMInstance = this.cleanSystemName(mHandle.getInstance(cIMObjectPath3, null));
        CIMInstance cIMInstance2 = this.cleanSystemName(mHandle.getInstance(cIMObjectPath2, null));
        CIMInstance cIMInstance3 = this.cleanAssociationSystemName(mHandle.getInstance(cIMObjectPath, null));
        CIMProperty cIMProperty3 = cIMInstance3.getProperty("SubscriptionState");
        if (null == cIMProperty3 || null == cIMProperty3.getValue() || ((UnsignedInteger16)cIMProperty3.getValue()).intValue() != 4) {
            boolean bl = true;
            CloseableIterator closeableIterator = mHandle.associatorInstances(cIMObjectPath3, cIMObjectPath.getObjectName(), LISTENERCLASS, null, null, null);
            int n = 0;
            while (closeableIterator.hasNext()) {
                if (++n > 1) {
                    bl = false;
                    break;
                }
                closeableIterator.next();
            }
            this.deactivateFilter(cIMInstance3, cIMInstance, cIMInstance2, bl);
        }
    }

    private void enableSubscription(CIMInstance cIMInstance, CIMInstance cIMInstance2, CIMInstance cIMInstance3, boolean bl) throws WBEMException {
        String[] stringArray = (String[])cIMInstance2.getPropertyValue("SourceNamespaces");
        String string = (String)cIMInstance2.getPropertyValue("SourceNamespace");
        if (null == stringArray || stringArray.length == 0) {
            if (null == string) {
                string = cIMInstance2.getObjectPath().getNamespace();
            }
            stringArray = new String[]{string};
        } else if (null != string && !Arrays.asList(stringArray).contains(string)) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMInstance.getObjectPath(), (String)"SourceNamespace property has value that is not present in String array of the SourceNamespaces property value", (WBEMOperation)(bl ? WBEMOperation.CREATEINSTANCE : WBEMOperation.MODIFYINSTANCE), null);
        }
        if (bl && (stringArray.length > 1 || !stringArray[0].equalsIgnoreCase(cIMInstance2.getObjectPath().getNamespace()))) {
            HashSet<String> hashSet = new HashSet<String>();
            CIMObjectPath cIMObjectPath = new CIMObjectPath(null, null, null, cIMInstance2.getObjectPath().getNamespace(), "CIM_WBEMServerNamespace", null);
            CloseableIterator closeableIterator = mHandle.enumerateInstances(cIMObjectPath, null);
            while (closeableIterator.hasNext()) {
                hashSet.add((String)((CIMInstance)closeableIterator.next()).getPropertyValue("CIM_WBEMServerNamespace"));
            }
            for (String string2 : stringArray) {
                if (hashSet.contains(string2)) continue;
            }
        }
        this.activateFilter(cIMInstance, cIMInstance2, cIMInstance3, stringArray);
    }

    public CloseableIterator<CIMInstance> enumerateInstances(CIMObjectPath cIMObjectPath, String[] stringArray, String string, String string2, boolean bl) throws WBEMException {
        this.checkArguments(cIMObjectPath, WBEMOperation.OPENENUMERATEINSTANCES, string, string2, bl);
        CloseableIterator closeableIterator = mInternalProvider.enumerateInstances(this.setInteropNamespace(cIMObjectPath), stringArray, string, string2, bl);
        ArrayList<CIMInstance> arrayList = new ArrayList<CIMInstance>();
        while (closeableIterator.hasNext()) {
            CIMInstance cIMInstance = this.fixAssociationSystemName((CIMInstance)closeableIterator.next());
            arrayList.add(this.cleanInstance(cIMObjectPath, cIMInstance));
        }
        return new CloseableAddableIterator(arrayList);
    }

    public CloseableIterator<CIMInstance> execQuery(CIMObjectPath cIMObjectPath, String string, String string2) throws WBEMException {
        CloseableIterator<CIMInstance> closeableIterator = this.enumerateInstances(this.setInteropNamespace(cIMObjectPath), null, null, null, false);
        return this.execQuery(this.setInteropNamespace(cIMObjectPath), string, string2, (Iterator)closeableIterator);
    }

    protected CIMObjectPath findInstanceName(CIMObjectPath cIMObjectPath) throws WBEMException {
        CIMObjectPath cIMObjectPath2 = null;
        if (null != cIMObjectPath) {
            CloseableIterator closeableIterator = mInternalProvider.enumerateInstances(cIMObjectPath, null, null, null, false);
            while (closeableIterator.hasNext()) {
                CIMInstance cIMInstance = (CIMInstance)closeableIterator.next();
                CIMObjectPath cIMObjectPath3 = cIMInstance.getObjectPath();
                if (null == cIMObjectPath3 || !cIMObjectPath3.equalsModelPath(cIMObjectPath)) continue;
                cIMObjectPath2 = cIMObjectPath3;
                break;
            }
        }
        return cIMObjectPath2;
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, String[] stringArray) throws WBEMException {
        CIMObjectPath cIMObjectPath2 = null;
        try {
            cIMObjectPath2 = this.findInstanceName(this.cleanAssociationSystemName(this.setAssociationNamespace(cIMObjectPath, JServerProperties.getInteropNamespace())));
        }
        catch (WBEMException wBEMException) {
            // empty catch block
        }
        if (null == cIMObjectPath2) {
            cIMObjectPath2 = cIMObjectPath;
        }
        CIMInstance cIMInstance = this.fixAssociationSystemName(mInternalProvider.getInstance(cIMObjectPath2, stringArray));
        return this.cleanInstance(cIMObjectPath, cIMInstance);
    }

    public void initialize(ProviderHandle providerHandle) throws WBEMException {
        super.initialize(providerHandle);
        this.mClassName = JServerSettings.replaceSchemaClassName((String)"CIM_IndicationSubscription");
        this.mEventService = (EventService)JServerServiceAdapterFactory.getService((String)"Indication");
    }

    public void modifyInstance(CIMInstance cIMInstance, String[] cIMObjectPath) throws WBEMException {
        long l;
        if (null != cIMObjectPath) {
            for (String string : cIMObjectPath) {
                if ("SubscriptionState".equalsIgnoreCase(string)) continue;
                throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMInstance.getObjectPath(), (String)"CIM_IndicationSubscription only supports modifyInstance with the \"SubscriptionState\" property", (WBEMOperation)WBEMOperation.CREATEINSTANCE, (String)cIMInstance.getClassName());
            }
        }
        CIMObjectPath cIMObjectPath2 = null;
        try {
            cIMObjectPath2 = this.findInstanceName(this.cleanAssociationSystemName(this.setAssociationNamespace(cIMInstance.getObjectPath(), JServerProperties.getInteropNamespace())));
        }
        catch (WBEMException wBEMException) {
            // empty catch block
        }
        CIMInstance cIMInstance2 = mInternalProvider.getInstance(cIMObjectPath2, null);
        UnsignedInteger16 unsignedInteger16 = (UnsignedInteger16)cIMInstance.getPropertyValue("SubscriptionState");
        long l2 = l = null != cIMInstance2.getPropertyValue("SubscriptionState") ? ((UnsignedInteger16)cIMInstance2.getPropertyValue("SubscriptionState")).longValue() : 2L;
        if (null != unsignedInteger16 && unsignedInteger16.longValue() != l) {
            long l3 = unsignedInteger16.longValue();
            if (l3 != 4L && l3 != 2L) {
                throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMInstance.getObjectPath(), (String)"CIM_IndicationSubscription only supports modifyInstance with the \"SubscriptionState\" property value of \"2 (enabled)\" or \"4 (disabled)\"", (WBEMOperation)WBEMOperation.CREATEINSTANCE, (String)cIMInstance.getClassName());
            }
            CIMInstance cIMInstance3 = new CIMInstance(cIMInstance2.getObjectPath(), cIMInstance.getProperties());
            if (l3 == 4L) {
                this.disableSubscription(cIMObjectPath2, WBEMOperation.MODIFYINSTANCE);
            } else {
                CIMObjectPath cIMObjectPath3 = cIMObjectPath2 != null ? (CIMObjectPath)cIMObjectPath2.getKeyValue("Filter") : null;
                CIMInstance cIMInstance4 = mInternalProvider.getInstance(cIMObjectPath3, null);
                CIMObjectPath cIMObjectPath4 = cIMObjectPath2 != null ? (CIMObjectPath)cIMObjectPath2.getKeyValue("Handler") : null;
                CIMInstance cIMInstance5 = mInternalProvider.getInstance(cIMObjectPath4, null);
                this.enableSubscription(cIMInstance2, cIMInstance4, cIMInstance5, false);
            }
            mInternalProvider.modifyInstance(cIMInstance3, new String[]{"SubscriptionState"});
            IndicationsBackupStore.storeData(mHandle);
        }
    }

    private boolean mutualAuthReq(int n) {
        boolean bl = false;
        CIMObjectPath cIMObjectPath = null;
        String string = null;
        switch (n) {
            case 4: {
                string = "WS_WSManagementIndicationHandlerTLSSettingData";
                break;
            }
            case 2: {
                string = "WS_CIMXMLSIndicationHandlerTLSSettingData";
            }
        }
        if (null != string) {
            try {
                cIMObjectPath = new CIMObjectPath(null, null, null, JServerProperties.getInteropNamespace(), JServerSettings.replaceSchemaClassName((String)string), null);
                CloseableIterator closeableIterator = mInternalProvider.enumerateInstances(cIMObjectPath, null, null, null, false);
                if (closeableIterator.hasNext()) {
                    CIMInstance cIMInstance = (CIMInstance)closeableIterator.next();
                    bl = (Boolean)cIMInstance.getPropertyValue("MutualAuthenticationRequired");
                } else {
                    mLogger.warning("Could not find SettingDataClass for  indication handler service: " + cIMObjectPath);
                }
            }
            catch (WBEMException wBEMException) {
                mLogger.log(Level.SEVERE, "Caught excception enumerting instances of " + cIMObjectPath, wBEMException);
            }
        }
        return bl;
    }

    public CloseableIterator<CIMInstance> references(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string, String[] stringArray, String string2, String string3, boolean bl) throws WBEMException {
        this.checkArguments(cIMObjectPath2, WBEMOperation.OPENREFERENCES, string2, string3, bl);
        CloseableIterator closeableIterator = mInternalProvider.references(cIMObjectPath, this.setInteropNamespace(this.cleanSystemName(cIMObjectPath2)), string, stringArray, string2, string3, bl);
        ArrayList<CIMInstance> arrayList = new ArrayList<CIMInstance>();
        while (closeableIterator.hasNext()) {
            CIMInstance cIMInstance = this.fixAssociationSystemName((CIMInstance)closeableIterator.next());
            arrayList.add(this.cleanInstance(cIMObjectPath2, cIMInstance));
        }
        return new CloseableAddableIterator(arrayList);
    }
}

