/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.server.services.discovery.slp;

import ch.ethz.iks.slp.ServiceLocationManager;
import com.ws.wbem.jserver.JServerProperties;
import com.ws.wbem.jserver.JServerService;
import com.ws.wbem.jserver.WBEMServer;
import com.ws.wbem.server.services.discovery.slp.SLPDiscoveryTemplate;
import com.ws.wbem.server.services.discovery.slp.SLPRegistration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.client.WBEMClient;
import javax.wbem.provider.ProviderHandle;

public class SLPDiscoveryService
implements JServerService {
    private static final String CCN_TCPProtocolEndpoint = "CIM_TCPProtocolEndpoint";
    private static final String CCN_WBEMSERVER = "CIM_WBEMServer";
    private static final String CCN_IPPROTOCOLENDPOINT = "CIM_IPProtocolEndpoint";
    private static final String CCN_PROTOCOLSERVICE = "CIM_ProtocolService";
    private static final String CCN_PROTOCOLSERVICECAPABILITIES = "CIM_WBEMProtocolServiceCapabilities";
    private static final String CV_OTHER = "Other";
    private static final String CV_UNKNOWN = "Unknown";
    private static final String CV_NONE = "None";
    private static final String CV_BASIC = "Basic";
    private static final String CV_DIGEST = "Digest";
    private static final String CV_CIMXML = "CIM-XML";
    private static final String CV_WSMAN = "WS-Management";
    private static final String CCN_NAMESPACE = "CIM_WBEMServerNamespace";
    private static final String CCN_REGISTEREDPROFILE = "CIM_RegisteredProfile";
    private static final int SLP_LIFETIME_DEFAULT = 10800;
    private static final int SLP_LIFETIME_MAXIMUM = 65535;
    private static final int ENABLEDSTATE_ENABLED = 2;
    private int mSLPTimeout = 10800;
    private WBEMClient handle;
    private Logger mLogger;
    private final String mInteropNamespace;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    ScheduledFuture<?> regHandle = null;

    public SLPDiscoveryService() {
        this.mInteropNamespace = JServerProperties.getInteropNamespace();
    }

    public void close() {
        this.deRegister();
        ServiceLocationManager.stop();
        this.scheduler.shutdownNow();
    }

    public void deRegister() {
        try {
            SLPDiscoveryTemplate[] sLPDiscoveryTemplateArray;
            for (SLPDiscoveryTemplate sLPDiscoveryTemplate : sLPDiscoveryTemplateArray = this.getSLPTemplates()) {
                this.deRegister(sLPDiscoveryTemplate.getTemplateURL());
            }
            return;
        }
        catch (WBEMException wBEMException) {
            Throwable throwable = wBEMException.getCause();
            if (null == throwable) {
                throwable = wBEMException;
            }
            this.mLogger.log(Level.WARNING, "Received an excepiton trying to deregister SLP template,", throwable);
            return;
        }
    }

    public void deRegister(String string) {
        try {
            if (this.regHandle != null) {
                this.regHandle.cancel(false);
                this.regHandle = null;
            }
            SLPRegistration sLPRegistration = new SLPRegistration(this.mLogger);
            sLPRegistration.deRegisterService("service:wbem:" + string);
        }
        catch (Exception exception) {
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return;
        }
    }

    private void getNameSpaceInformation(List<String> list, List<String> list2) throws WBEMException {
        String[] stringArray = new String[]{"Name"};
        CloseableIterator closeableIterator = this.handle.enumerateInstances(new CIMObjectPath(null, null, null, this.mInteropNamespace, CCN_NAMESPACE, null), stringArray);
        while (closeableIterator.hasNext()) {
            CIMInstance cIMInstance = (CIMInstance)closeableIterator.next();
            list.add((String)this.getPropertyValue(cIMInstance.getProperty("Name")));
        }
    }

    private String getProfileString(CIMInstance cIMInstance, String string) {
        boolean bl = false;
        UnsignedInteger16 unsignedInteger16 = (UnsignedInteger16)this.getPropertyValue(cIMInstance.getProperty("AdvertiseTypes"));
        if (unsignedInteger16 == null) {
            return null;
        }
        for (UnsignedInteger16 unsignedInteger162 : unsignedInteger16) {
            if (unsignedInteger162.intValue() != 3) continue;
            bl = true;
        }
        if (bl) {
            String string2;
            UnsignedInteger16 unsignedInteger163 = (UnsignedInteger16)this.getPropertyValue(cIMInstance.getProperty("RegisteredOrganization"));
            String string3 = this.getRegisteredOrganization(unsignedInteger163.intValue());
            if (string3 == null) {
                return null;
            }
            if (string3.equalsIgnoreCase(CV_OTHER)) {
                string3 = (String)this.getPropertyValue(cIMInstance.getProperty("OtherRegisteredOrganization"));
            }
            if ((string2 = (String)this.getPropertyValue(cIMInstance.getProperty("RegisteredName"))) == null) {
                return null;
            }
            if (string == null) {
                return new String(string3 + ":" + string2);
            }
            return new String(string3 + ":" + string + ":" + string2);
        }
        return null;
    }

    private Object getPropertyValue(CIMProperty<?> cIMProperty) {
        if (cIMProperty != null) {
            return cIMProperty.getValue();
        }
        return null;
    }

    private String getRegisteredOrganization(int n) {
        String[] stringArray = new String[]{"", CV_OTHER, "DMTF", "CompTIA", "Consortium for Service Innovation", "FAST", "GGF", "INTAP", "itSMF", "NAC", "Northwest Energy Efficiency Alliance", "SNIA", "TM Forum", "The Open Group", "ANSI", "IEEE", "IETF", "INCITS", "ISO", "W3C"};
        if (n < 1 || n > 19) {
            return null;
        }
        return stringArray[n];
    }

    private String[] getRegisteredProfiles(WBEMClient wBEMClient) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            CloseableIterator closeableIterator = wBEMClient.enumerateInstances(new CIMObjectPath(null, null, null, this.mInteropNamespace, CCN_REGISTEREDPROFILE, null), (String[])null);
            while (closeableIterator.hasNext()) {
                CIMInstance cIMInstance = (CIMInstance)closeableIterator.next();
                String string = this.getProfileString(cIMInstance, null);
                if (string == null || arrayList.contains(string)) continue;
                arrayList.add(string);
            }
        }
        catch (WBEMException wBEMException) {
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private synchronized List<SLPDiscoveryTemplate> getSLPTemplate(String string) throws WBEMException {
        class ProtocolInfo {
            String mCommMech;
            String mOtherCommMech;
            String[] mCommMechVersion;
            String[] mAuthMechSupported;
            String[] mOtherAuthMechanism;
        }
        String string2;
        String[] stringArray;
        Short[] shortArray;
        String string3;
        CloseableIterator closeableIterator;
        SLPDiscoveryTemplate sLPDiscoveryTemplate;
        String string4;
        Object object;
        Object object2;
        CIMInstance cIMInstance;
        CloseableIterator closeableIterator2;
        ArrayList<SLPDiscoveryTemplate> arrayList = new ArrayList<SLPDiscoveryTemplate>();
        String[] stringArray2 = new String[]{"Name", "ElementName", "Description"};
        Object object3 = this.handle.enumerateInstances(new CIMObjectPath(null, null, null, this.mInteropNamespace, CCN_WBEMSERVER, null), stringArray2);
        CIMInstance cIMInstance2 = (CIMInstance)object3.next();
        object3 = null;
        String string5 = (String)cIMInstance2.getPropertyValue("ElementName");
        String string6 = (String)cIMInstance2.getPropertyValue("Description");
        String string7 = (String)cIMInstance2.getPropertyValue("Name");
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        this.getNameSpaceInformation(arrayList2, arrayList3);
        ArrayList<String> arrayList4 = new ArrayList<String>();
        if (string != null && !string.isEmpty()) {
            arrayList4.add(string);
        } else {
            try {
                closeableIterator2 = this.handle.enumerateInstances(new CIMObjectPath(null, null, null, this.mInteropNamespace, CCN_IPPROTOCOLENDPOINT, null), null);
                while (closeableIterator2.hasNext()) {
                    cIMInstance = (CIMInstance)closeableIterator2.next();
                    object2 = (String)cIMInstance.getPropertyValue("IPv4Address");
                    if (null == object2) {
                        object2 = (String)cIMInstance.getPropertyValue("IPv6Address");
                    }
                    arrayList4.add((String)object2);
                }
            }
            catch (WBEMException wBEMException) {
                throw new WBEMException(1, "Unable to get IP addresses", null, (Throwable)wBEMException);
            }
        }
        closeableIterator2 = this.getRegisteredProfiles(this.handle);
        cIMInstance = new CIMObjectPath(null, null, null, this.mInteropNamespace, CCN_TCPProtocolEndpoint, null);
        object3 = this.handle.enumerateInstances((CIMObjectPath)cIMInstance, null);
        object2 = new HashMap();
        ArrayList<Object> arrayList5 = new ArrayList<Object>();
        while (object3.hasNext()) {
            object = (CIMInstance)object3.next();
            UnsignedInteger16 unsignedInteger16 = (UnsignedInteger16)object.getPropertyValue("EnabledState");
            if (null != unsignedInteger16 && unsignedInteger16.intValue() != 2) continue;
            arrayList5.add(object);
            String string8 = this.handle.associatorInstances(object.getObjectPath(), null, CCN_PROTOCOLSERVICE, "Dependent", "Antecedent", null);
            ProtocolInfo object4 = new ProtocolInfo();
            if (string8.hasNext()) {
                string4 = (CIMInstance)string8.next();
                sLPDiscoveryTemplate = (UnsignedInteger16)string4.getPropertyValue("Protocol");
                switch (sLPDiscoveryTemplate.intValue()) {
                    case 1: {
                        object4.mCommMech = CV_OTHER;
                        object4.mOtherCommMech = (String)this.getPropertyValue(string4.getProperty("OtherProtocol"));
                        break;
                    }
                    case 5: {
                        object4.mCommMech = CV_CIMXML;
                        break;
                    }
                    case 6: {
                        object4.mCommMech = CV_WSMAN;
                        break;
                    }
                    default: {
                        object4.mCommMech = CV_UNKNOWN;
                    }
                }
                closeableIterator = this.handle.associatorInstances(string4.getObjectPath(), null, CCN_PROTOCOLSERVICECAPABILITIES, "ManagedElement", "Capabilities", null);
                if (closeableIterator.hasNext()) {
                    string3 = (CIMInstance)closeableIterator.next();
                    object4.mCommMechVersion = (String[])string3.getPropertyValue("WBEMProtocolVersionsSupported");
                    shortArray = (Short[])string3.getPropertyValue("AuthenticationMechanismsSupported");
                    stringArray = (String[])string3.getPropertyValue("AuthenticationMechanismsDescriptions");
                    if (null != shortArray) {
                        object4.mAuthMechSupported = new String[shortArray.length];
                        object4.mOtherAuthMechanism = null != stringArray && stringArray.length == shortArray.length ? new String[stringArray.length] : null;
                        for (int stringArray3 = 0; stringArray3 < shortArray.length; ++stringArray3) {
                            string2 = "";
                            switch (shortArray[stringArray3]) {
                                case 1: {
                                    object4.mAuthMechSupported[stringArray3] = CV_OTHER;
                                    if (null == object4.mOtherAuthMechanism || null == stringArray) break;
                                    string2 = stringArray[stringArray3];
                                    break;
                                }
                                case 2: {
                                    object4.mAuthMechSupported[stringArray3] = CV_NONE;
                                    break;
                                }
                                case 3: {
                                    object4.mAuthMechSupported[stringArray3] = CV_BASIC;
                                    break;
                                }
                                case 4: {
                                    object4.mAuthMechSupported[stringArray3] = CV_DIGEST;
                                    break;
                                }
                                default: {
                                    object4.mAuthMechSupported[stringArray3] = CV_UNKNOWN;
                                }
                            }
                            if (null == object4.mOtherAuthMechanism) continue;
                            object4.mOtherAuthMechanism[stringArray3] = string2;
                        }
                    }
                }
            }
            ((HashMap)object2).put((String)object.getPropertyValue("Name"), object4);
        }
        object = new HashSet();
        object3 = null;
        for (String string8 : arrayList4) {
            for (CIMInstance cIMInstance3 : arrayList5) {
                String string9;
                String string10;
                String string11;
                string4 = (String)cIMInstance3.getPropertyValue("BindToAddress");
                if (null != string4 && !string8.equalsIgnoreCase(string4)) continue;
                sLPDiscoveryTemplate = new SLPDiscoveryTemplate();
                sLPDiscoveryTemplate.setServiceName(string5);
                sLPDiscoveryTemplate.setServiceDescription(string6);
                sLPDiscoveryTemplate.setServiceID(string7);
                closeableIterator = new String[arrayList2.size()];
                sLPDiscoveryTemplate.setNamespaces(arrayList2.toArray((T[])closeableIterator));
                string3 = (String)cIMInstance3.getPropertyValue("Name");
                shortArray = (Short[])((HashMap)object2).get(string3);
                if (null != shortArray) {
                    sLPDiscoveryTemplate.setCommunicationMechanism(shortArray.mCommMech);
                    if (null != shortArray.mOtherCommMech) {
                        sLPDiscoveryTemplate.setOtherCommunicationMechanism(shortArray.mOtherCommMech);
                    }
                    if (null != shortArray.mAuthMechSupported) {
                        sLPDiscoveryTemplate.setAuthenticationMechanismsSupported(shortArray.mAuthMechSupported);
                    }
                    if (null != shortArray.mOtherAuthMechanism) {
                        sLPDiscoveryTemplate.setAuthenticationMechanismDescriptions(shortArray.mOtherAuthMechanism);
                    }
                    if (null != shortArray.mCommMechVersion && shortArray.mCommMechVersion.length > 0) {
                        sLPDiscoveryTemplate.setProtocolVersion(shortArray.mCommMechVersion[0]);
                    }
                }
                stringArray = new String[]{"Basic Read", "Basic Write", "Schema Manipulation", "Instance Manipulation", "Association Traversal", "Query Execution", "Qualifier Declaration", "Indications"};
                String[] stringArray3 = new String[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray3[i] = stringArray[i];
                }
                sLPDiscoveryTemplate.setFunctionalProfilesSupported(stringArray3);
                string2 = (UnsignedInteger16)this.getPropertyValue(cIMInstance3.getProperty("ProtocolIFType"));
                String string12 = CV_OTHER;
                if (null != string2) {
                    switch (string2.intValue()) {
                        case 4204: {
                            string12 = "http";
                            break;
                        }
                        case 4406: {
                            string12 = "https";
                            break;
                        }
                        default: {
                            string12 = CV_OTHER;
                        }
                    }
                }
                if (null == shortArray) continue;
                String string13 = JServerProperties.getAdvertisedPort((String)shortArray.mCommMech, (String)string12, null);
                if (null == string13) {
                    string11 = (UnsignedInteger32)this.getPropertyValue(cIMInstance3.getProperty("PortNumber"));
                    if (null != string11) {
                        string13 = string11.toString();
                    } else {
                        this.mLogger.log(Level.SEVERE, "SLP Information is incomplete. TCPProtocolEndpoint instance does not have a value for property PortNumber:\n", new Object[]{cIMInstance3});
                    }
                }
                if (null == (string11 = JServerProperties.getAdvertisedIPAddress((String)shortArray.mCommMech, (String)string12, null))) {
                    string11 = string8;
                }
                if (null == (string10 = JServerProperties.getAdvertisedScheme((String)shortArray.mCommMech, (String)string12, (String)string12))) {
                    string10 = string12;
                }
                if (!object.add(string9 = string10 + "://" + string11 + ":" + string13)) continue;
                sLPDiscoveryTemplate.setTemplateURL(string9);
                sLPDiscoveryTemplate.setRegisteredProfiles((String[])closeableIterator2);
                arrayList.add(sLPDiscoveryTemplate);
            }
        }
        return arrayList;
    }

    private synchronized SLPDiscoveryTemplate[] getSLPTemplates() throws WBEMException {
        String string = JServerProperties.getBindIP();
        List<SLPDiscoveryTemplate> list = this.getSLPTemplate(string);
        return list.toArray(new SLPDiscoveryTemplate[list.size()]);
    }

    public void initialize(WBEMServer wBEMServer, ProviderHandle providerHandle, Logger logger) {
        block3: {
            this.mLogger = logger;
            logger.info("Initializing SLP Discovery Service");
            this.handle = providerHandle;
            String string = JServerProperties.getSLPRefreshRate();
            try {
                int n = Integer.parseInt(string);
                this.setSLPTimeout(n);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable.getCause();
                if (null == throwable2) {
                    throwable2 = throwable;
                }
                if (!this.mLogger.isLoggable(Level.FINE)) break block3;
                this.mLogger.log(Level.FINE, "Exception getting SLP timeout,", throwable2);
            }
        }
        this.registerSLP();
    }

    private void registerSLP() {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Thread thread = Thread.currentThread();
                String string = thread.getThreadGroup().getName();
                thread.setName(string + ":" + "registerSLP");
                try {
                    SLPDiscoveryService.this.mLogger.fine("Getting SLP Information");
                    SLPDiscoveryTemplate[] sLPDiscoveryTemplateArray = null;
                    for (int i = 0; i < 6 && (sLPDiscoveryTemplateArray = SLPDiscoveryService.this.getSLPTemplates()).length == 0; ++i) {
                        SLPDiscoveryService.this.mLogger.warning("No SLP template information, trying again in 10 seconds");
                        try {
                            Thread.sleep(10000L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            if (!SLPDiscoveryService.this.mLogger.isLoggable(Level.FINE)) continue;
                            SLPDiscoveryService.this.mLogger.log(Level.FINE, "Exception waiting for SLP template", interruptedException);
                        }
                    }
                    if (null != sLPDiscoveryTemplateArray) {
                        for (SLPDiscoveryTemplate sLPDiscoveryTemplate : sLPDiscoveryTemplateArray) {
                            SLPDiscoveryService.this.mLogger.info("Registering SLP Information");
                            SLPRegistration sLPRegistration = new SLPRegistration(SLPDiscoveryService.this.mLogger);
                            int n = sLPRegistration.registerService("service:wbem:" + sLPDiscoveryTemplate.getTemplateURL(), sLPDiscoveryTemplate.allAttrString(), SLPDiscoveryService.this.mSLPTimeout);
                            SLPDiscoveryService.this.mLogger.log(Level.INFO, "SLP registion returned: {0}", n);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable.getCause();
                    if (null == throwable2) {
                        throwable2 = throwable;
                    }
                    SLPDiscoveryService.this.mLogger.log(Level.SEVERE, "Received exception trying to register with SLP,", throwable2);
                }
                finally {
                    SLPDiscoveryService.this.mLogger.fine("RegisterSLP thread exiting.");
                }
            }
        };
        int n = this.mSLPTimeout - 5;
        if (n <= 0) {
            n = 5;
        }
        if (this.regHandle != null) {
            this.regHandle.cancel(false);
            this.regHandle = null;
        }
        this.regHandle = this.scheduler.scheduleWithFixedDelay(runnable, 1L, n, TimeUnit.SECONDS);
    }

    public void reset() throws WBEMException {
        this.registerSLP();
    }

    private void setSLPTimeout(int n) {
        if (n > 0 && n < 65535) {
            this.mSLPTimeout = n;
        }
    }
}

