/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.server.services.indication;

import com.ws.wbem.server.services.indication.EventProviderRequest;
import com.ws.wbem.server.services.indication.SubActivation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;

class IndicationRequestCollator {
    private final List<SubActivation> mSubActList;
    Callback callback;
    private final Logger mLogger = Logger.getLogger("com.ws.wbem.jserver");

    IndicationRequestCollator(List<SubActivation> list, Callback callback) {
        this.mSubActList = list;
        this.callback = callback;
    }

    EventRequestResult processEventRequest() {
        List<ActivationInfo> list;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        WBEMException wBEMException = null;
        Iterator<SubActivation> iterator = this.mSubActList.iterator();
        ArrayList<SubActivation> arrayList = new ArrayList<SubActivation>();
        boolean bl = false;
        HashMap<Object, ArrayList<ActivationInfo>> hashMap = new HashMap<Object, ArrayList<ActivationInfo>>();
        while (iterator.hasNext()) {
            object4 = iterator.next();
            object3 = null;
            try {
                object3 = this.callback.doSubActivationOperation((SubActivation)object4);
                bl = true;
            }
            catch (Throwable throwable) {
                this.mLogger.log(Level.WARNING, "Received an exception getting poll info", throwable);
                if (!(throwable instanceof WBEMException)) {
                    wBEMException = new WBEMException(1, throwable.toString());
                    continue;
                }
                wBEMException = (WBEMException)throwable;
                continue;
            }
            if (object3 == null) {
                arrayList.add((SubActivation)object4);
                continue;
            }
            object2 = ((EventProviderRequest)object3).getClassPath();
            object = object2.getObjectName() == null || object2.getObjectName().length() == 0 ? object2 + ":" + ((EventProviderRequest)object3).getEventType() : object2.toString();
            list = (List)hashMap.get(object);
            if (list == null) {
                list = new ArrayList<ActivationInfo>();
                hashMap.put(object, (ArrayList<ActivationInfo>)list);
            }
            list.add(new ActivationInfo((SubActivation)object4, (EventProviderRequest)object3));
        }
        if (bl) {
            wBEMException = null;
        }
        object4 = hashMap.values().iterator();
        while (wBEMException == null && object4.hasNext()) {
            Object object5;
            String[] stringArray3;
            Object object6;
            object3 = (List)object4.next();
            object = new ArrayList();
            object2 = new ArrayList();
            list = new ArrayList();
            ArrayList<String[]> arrayList2 = new ArrayList<String[]>();
            String[] stringArray2 = object3.iterator();
            while (stringArray2.hasNext()) {
                object6 = (CIMObjectPath[])stringArray2.next();
                stringArray3 = ((ActivationInfo)object6).getSubactivation();
                arrayList2.add(stringArray3);
                object5 = ((ActivationInfo)object6).getRequest();
                object.add(((EventProviderRequest)object5).getFilter().toString());
                object2.add(((EventProviderRequest)object5).getClassPath());
                list.add((ActivationInfo)((Object)((EventProviderRequest)object5).getEventType()));
            }
            try {
                stringArray2 = object.toArray(new String[object.size()]);
                object6 = object2.toArray(new CIMObjectPath[object2.size()]);
                stringArray3 = list.toArray(new String[list.size()]);
                object5 = this.callback.doProviderOperation(stringArray2, (CIMObjectPath[])object6, stringArray3);
                Iterator iterator2 = arrayList2.iterator();
                while (iterator2.hasNext()) {
                    try {
                        SubActivation subActivation = (SubActivation)iterator2.next();
                        this.callback.processSingleResult(subActivation, object5);
                        arrayList.add(subActivation);
                    }
                    catch (Throwable throwable) {
                        this.mLogger.log(Level.WARNING, "Received an exception getting poll info", throwable);
                        wBEMException = !(throwable instanceof WBEMException) ? new WBEMException(1, throwable.toString()) : (WBEMException)throwable;
                        while (iterator2.hasNext()) {
                            SubActivation subActivation = (SubActivation)iterator2.next();
                            try {
                                this.callback.processSingleException(subActivation, wBEMException);
                            }
                            catch (Throwable throwable2) {
                                this.mLogger.log(Level.WARNING, "Got an exception", throwable2);
                            }
                        }
                        break;
                    }
                    if (wBEMException == null) continue;
                }
                if (wBEMException == null) continue;
                break;
            }
            catch (Throwable throwable) {
                this.mLogger.log(Level.WARNING, "Got an exception getting poll info", throwable);
                wBEMException = !(throwable instanceof WBEMException) ? new WBEMException(1, throwable.toString()) : (WBEMException)throwable;
                for (String[] stringArray3 : arrayList2) {
                    try {
                        this.callback.processSingleException((SubActivation)stringArray3, wBEMException);
                    }
                    catch (Throwable throwable3) {
                        this.mLogger.log(Level.WARNING, "Got an exception", throwable);
                    }
                }
            }
        }
        while (object4.hasNext()) {
            object3 = (List)object4.next();
            object = object3.iterator();
            while (object.hasNext()) {
                object2 = (ActivationInfo)object.next();
                list = ((ActivationInfo)object2).getSubactivation();
                try {
                    this.callback.processSingleNoResult((SubActivation)((Object)list));
                }
                catch (Throwable throwable) {
                    this.mLogger.log(Level.WARNING, "Got an exception", throwable);
                }
            }
        }
        return new EventRequestResult(wBEMException, arrayList);
    }

    private class ActivationInfo {
        private final SubActivation mSubactivation;
        private final EventProviderRequest mRequest;

        public ActivationInfo(SubActivation subActivation, EventProviderRequest eventProviderRequest) {
            this.mRequest = eventProviderRequest;
            this.mSubactivation = subActivation;
        }

        public SubActivation getSubactivation() {
            return this.mSubactivation;
        }

        public EventProviderRequest getRequest() {
            return this.mRequest;
        }
    }

    static interface Callback {
        public EventProviderRequest doSubActivationOperation(SubActivation var1) throws WBEMException;

        public Object doProviderOperation(String[] var1, CIMObjectPath[] var2, String[] var3) throws WBEMException;

        public void processSingleResult(SubActivation var1, Object var2) throws WBEMException;

        public void processSingleException(SubActivation var1, WBEMException var2) throws WBEMException;

        public void processSingleNoResult(SubActivation var1) throws WBEMException;
    }

    public class EventRequestResult {
        public final WBEMException mException;
        public final List<SubActivation> mListSubActivation;

        public EventRequestResult(WBEMException wBEMException, List<SubActivation> list) {
            this.mException = wBEMException;
            this.mListSubActivation = list;
        }
    }
}

