/*
 * Decompiled with CFR 0.152.
 */
package sanproject.serverux.dataimpl;

import java.io.Serializable;
import sanproject.serverux.dataimpl.EXDExternalDevice;
import sanproject.serverux.dataimpl.EXDLogicalPath;
import sanproject.serverux.dataimpl.EXDPGInfo;
import sanproject.serverux.dataimpl.EXDVolumeStatus;

public class EXDExternalVolume
extends EXDPGInfo
implements Serializable {
    private static final long serialVersionUID = -8000000419972764397L;
    protected static final int OPTION_VLD = Integer.MIN_VALUE;
    protected static final int OPTION_POF = 0x40000000;
    protected static final int OPTION_VVL = 0x10000000;
    protected static final int OPTION_IOS = 0x4000000;
    protected static final int OPTION_CAC = 0x2000000;
    protected static final int OPTION_RCMD = 0x1000000;
    protected static final int OPTION_CMWR = 0x800000;
    protected static final int OPTION_ODM = 0x400000;
    protected static final int OPTION_TSE = 16384;
    protected static final int MAX_PATH = 8;
    protected EXDExternalDevice mDevice;
    protected int mPathGroupId;
    protected int mOption;
    protected byte mPathMode;
    protected short mOwnership;
    protected EXDLogicalPath[] mLogicalPathList;
    protected EXDVolumeStatus mVolumeStatus;

    public EXDExternalVolume(EXDExternalDevice eXDExternalDevice, int n, int n2, int n3, short s, short s2, int n4, byte by, int n5) {
        this.mDevice = eXDExternalDevice;
        this.mPathGroupId = n;
        super.setIFB4(n2);
        super.setIPG(n3);
        super.setSSLPR(s);
        super.setSCLPR(s2);
        this.mOption = n4;
        this.mPathMode = by;
        super.setIBaseEmulationType(n5);
        this.mLogicalPathList = new EXDLogicalPath[8];
        this.mVolumeStatus = new EXDVolumeStatus();
        this.mOwnership = (short)255;
    }

    public EXDExternalVolume() {
        this(new EXDExternalDevice(), 0, 0, 0, 0, 0, 0, 0, 0);
    }

    public EXDExternalVolume(EXDExternalDevice eXDExternalDevice) {
        this(eXDExternalDevice, 0, 0, 0, 0, 0, 0, 0, 0);
        if (eXDExternalDevice.isCommandDevice()) {
            this.setRemoteCommand(true);
        }
    }

    public int getExternalVolumeID() {
        return this.mDevice.getExternalVolumeID();
    }

    public EXDExternalDevice getExternalDeviceInfo() {
        return this.mDevice;
    }

    public int referPathGroupID() {
        return this.mPathGroupId;
    }

    protected int getOption() {
        return this.mOption;
    }

    public boolean getSupportMode() {
        int n = this.mOption & Integer.MIN_VALUE;
        return n != 0;
    }

    public boolean getPsOff() {
        int n = this.mOption & 0x40000000;
        return n != 0;
    }

    public boolean getVvol() {
        int n = this.mOption & 0x10000000;
        return n != 0;
    }

    public boolean getIoSuppression() {
        int n = this.mOption & 0x4000000;
        return n != 0;
    }

    public boolean getCacheMode() {
        int n = this.mOption & 0x2000000;
        return n == 0;
    }

    public boolean getRemoteCommand() {
        int n = this.mOption & 0x1000000;
        return n != 0;
    }

    public boolean getInflowControl() {
        int n = this.mOption & 0x800000;
        return n != 0;
    }

    public boolean getOneToOneMode() {
        return this.mDevice.isInheritDrive();
    }

    public byte getPathMode() {
        return this.mPathMode;
    }

    public EXDLogicalPath[] getLogicalPathList() {
        return this.mLogicalPathList;
    }

    public EXDVolumeStatus getVolumeStatus() {
        return this.mVolumeStatus;
    }

    public short getOwnership() {
        return this.mOwnership;
    }

    public boolean isTSEAttribute() {
        int n = this.mOption & 0x4000;
        return n != 0;
    }

    public boolean isODMAttribute() {
        int n = this.mOption & 0x400000;
        return n != 0;
    }

    public void setPathGroupID(int n) {
        this.mPathGroupId = n;
    }

    protected void setOption(int n) {
        this.mOption = n;
    }

    public void setSupportMode(boolean bl) {
        if (this.getSupportMode() != bl) {
            this.mOption ^= Integer.MIN_VALUE;
        }
    }

    public void setPsOff(boolean bl) {
        if (this.getPsOff() != bl) {
            this.mOption ^= 0x40000000;
        }
    }

    public void setVvol(boolean bl) {
        if (this.getVvol() != bl) {
            this.mOption ^= 0x10000000;
        }
    }

    public void setIoSuppression(boolean bl) {
        if (this.getIoSuppression() != bl) {
            this.mOption ^= 0x4000000;
        }
    }

    public void setCacheMode(boolean bl) {
        if (this.getCacheMode() != bl) {
            this.mOption ^= 0x2000000;
        }
    }

    public void setRemoteCommand(boolean bl) {
        if (this.getRemoteCommand() != bl) {
            this.mOption ^= 0x1000000;
        }
    }

    public void setInflowControl(boolean bl) {
        if (this.getInflowControl() != bl) {
            this.mOption ^= 0x800000;
        }
    }

    public void setOneToOneMode(boolean bl) {
    }

    public void setPathMode(byte by) {
        this.mPathMode = by;
    }

    public boolean isConfigured() {
        return this.mDevice.isConfigured();
    }

    public int setId(int n) {
        return this.mDevice.setVolumeId(n);
    }

    public void setVolumeStatus(EXDVolumeStatus eXDVolumeStatus) {
        this.mVolumeStatus = eXDVolumeStatus;
    }

    public void setOwnership(short s) {
        this.mOwnership = s;
    }

    public void setTSEAttribute(boolean bl) {
        if (this.isTSEAttribute() != bl) {
            this.mOption ^= 0x4000;
        }
    }

    public void setODMAttribute(boolean bl) {
        if (this.isODMAttribute() != bl) {
            this.mOption ^= 0x400000;
        }
    }
}

