/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.sanproject.rmi.server.functions;

import com.hitachi.sanproject.data.SanData;
import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanDataUtility;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import com.hitachi.sanproject.rmi.SanRmiException;
import com.hitachi.sanproject.rmi.server.SanRmiServer;
import com.hitachi.sanproject.rmi.server.managers.SanAuthenticationManager;
import com.hitachi.sanproject.rmi.server.managers.SanResourcelockManager;
import com.hitachi.sanproject.rmi.server.managers.SanResourcelockStatus;
import com.hitachi.sanproject.rmi.server.managers.SanUserAccount;
import com.hitachi.sanproject.util.SanLogger;
import java.io.File;
import java.util.logging.Logger;

public class SANFunctions {
    private SANFunctions() {
    }

    public static short debuginvoke(SanData sanData, SanRequest sanRequest, SanResponse sanResponse) throws SanDataException {
        String string = String.format("%s%s%s.json", "debug", File.separator, sanRequest.key());
        SanDataUtility.writeValueToJSON((File)new File(string), (SanData)sanRequest);
        String string2 = String.format("%s%s%s.json", "debug", File.separator, sanResponse.key());
        SanDataUtility.readValueFromJSON((File)new File(string2), (SanData)sanResponse);
        return 0;
    }

    public static short stopServer(SanData sanData, SanRequest sanRequest, SanResponse sanResponse) {
        Logger logger = SanRmiServer.getLogger();
        SanRmiServer.stopServer();
        try {
            sanResponse.newObj("ErrorInfo").putInt("ErrorCode", 0);
            sanResponse.getObj("ErrorInfo").putIntArray("MessageId", new int[]{0, 0});
        }
        catch (SanDataException sanDataException) {
            logger.warning(SanLogger.getStackTrace((Throwable)sanDataException));
            return -1;
        }
        return 0;
    }

    public static short authenticateStorageUser(SanData sanData, SanRequest sanRequest, SanResponse sanResponse) throws SanRmiException, SanDataException {
        Logger logger = SanRmiServer.getLogger();
        SanAuthenticationManager sanAuthenticationManager = SanRmiServer.getAuthenticationManager();
        SanUserAccount sanUserAccount = sanAuthenticationManager.authenticateStorageUser(sanData, sanRequest.getString("UserName"), sanRequest.getString("Password"), sanRequest.getInt("SsoOption"), sanResponse);
        return 0;
    }

    public static short lockSystem(SanData sanData, SanRequest sanRequest, SanResponse sanResponse) throws SanRmiException, SanDataException {
        Logger logger = SanRmiServer.getLogger();
        SanResourcelockManager sanResourcelockManager = SanRmiServer.getResourcelockManager();
        SanResourcelockStatus sanResourcelockStatus = sanResourcelockManager.lockSystem(sanData, sanRequest, sanResponse);
        return 0;
    }

    public static short unlockSystem(SanData sanData, SanRequest sanRequest, SanResponse sanResponse) throws SanRmiException, SanDataException {
        Logger logger = SanRmiServer.getLogger();
        SanResourcelockManager sanResourcelockManager = SanRmiServer.getResourcelockManager();
        SanResourcelockStatus sanResourcelockStatus = sanResourcelockManager.unlockSystem(sanData, sanRequest, sanResponse);
        return 0;
    }

    public static short unlockSystemForcibly(SanData sanData, SanRequest sanRequest, SanResponse sanResponse) throws SanRmiException, SanDataException {
        Logger logger = SanRmiServer.getLogger();
        SanResourcelockManager sanResourcelockManager = SanRmiServer.getResourcelockManager();
        SanResourcelockStatus sanResourcelockStatus = sanResourcelockManager.unlockSystemForcibly(sanData, sanRequest, sanResponse);
        return 0;
    }

    public static short lockResource(SanData sanData, SanRequest sanRequest, SanResponse sanResponse) throws SanRmiException, SanDataException {
        Logger logger = SanRmiServer.getLogger();
        SanResourcelockManager sanResourcelockManager = SanRmiServer.getResourcelockManager();
        SanResourcelockStatus sanResourcelockStatus = sanResourcelockManager.lockResource(sanData, sanRequest, sanResponse);
        return 0;
    }

    public static short unlockResource(SanData sanData, SanRequest sanRequest, SanResponse sanResponse) throws SanRmiException, SanDataException {
        Logger logger = SanRmiServer.getLogger();
        SanResourcelockManager sanResourcelockManager = SanRmiServer.getResourcelockManager();
        SanResourcelockStatus sanResourcelockStatus = sanResourcelockManager.unlockResource(sanData, sanRequest, sanResponse);
        return 0;
    }

    public static short unlockResourceForcibly(SanData sanData, SanRequest sanRequest, SanResponse sanResponse) throws SanRmiException, SanDataException {
        Logger logger = SanRmiServer.getLogger();
        SanResourcelockManager sanResourcelockManager = SanRmiServer.getResourcelockManager();
        SanResourcelockStatus sanResourcelockStatus = sanResourcelockManager.unlockResourceForcibly(sanData, sanRequest, sanResponse);
        return 0;
    }

    public static short unlockSystemAndResourceForcibly(SanData sanData, SanRequest sanRequest, SanResponse sanResponse) throws SanRmiException, SanDataException {
        SanResourcelockManager sanResourcelockManager = SanRmiServer.getResourcelockManager();
        sanResourcelockManager.unlockSystemAndResourceForcibly(sanData, sanRequest, sanResponse);
        return 0;
    }
}

