/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.sanproject.rmi.server.managers;

import com.hitachi.sanproject.data.SanData;
import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.server.managers.SanUserAccount;
import java.util.BitSet;

public class SanResourcelockStatus {
    private Long resourcelockId;
    private SanUserAccount userAccount;
    private boolean IsSystemlock;
    private BitSet lockedResourcegroups;

    SanResourcelockStatus(Long l, SanUserAccount sanUserAccount, boolean bl, BitSet bitSet) {
        this.resourcelockId = l;
        this.userAccount = sanUserAccount;
        this.IsSystemlock = bl;
        if (!bl) {
            this.lockedResourcegroups = (BitSet)bitSet.clone();
        }
    }

    public Long getResourcelockId() {
        return this.resourcelockId;
    }

    public SanUserAccount getUserAccount() {
        return this.userAccount;
    }

    public boolean isSystemlock() {
        return this.IsSystemlock;
    }

    public BitSet getLockedResourcegroups() {
        return (BitSet)this.lockedResourcegroups.clone();
    }

    public SanData copyProperties(SanData sanData) throws SanDataException {
        sanData = this.userAccount.copyProperties(sanData);
        SanObject sanObject = sanData.getObj("AccountInfo");
        sanObject.putLong("ResourcelockId", this.resourcelockId.longValue());
        if (this.lockedResourcegroups != null) {
            sanObject.putBitSet("ResourceGroupBitmap", this.lockedResourcegroups);
        }
        return sanData;
    }
}

