/*
 * Decompiled with CFR 0.152.
 */
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class RJDGDDefaultDataSorter
implements RJDGDDataSorter {
    private static final String CLASSNAME = "RJDGDDefaultDataSorter";
    public static final boolean STRING_COMPARES = false;
    public static final boolean NUMERIC_COMPARES = true;
    private volatile ArrayList m_altTargetData;
    private int m_iSortMode;
    private boolean m_bCompareType;

    public static void main(String[] stringArray) {
        RJDGDDefaultDataSorter rJDGDDefaultDataSorter = new RJDGDDefaultDataSorter();
        RJDGDDefaultDataSorter rJDGDDefaultDataSorter2 = new RJDGDDefaultDataSorter();
        System.out.println("sorter1.size = " + rJDGDDefaultDataSorter.size());
        rJDGDDefaultDataSorter2.add("1", null);
        rJDGDDefaultDataSorter2.add("2", null);
        System.out.println("sorter2.size = " + rJDGDDefaultDataSorter2.size());
        System.out.println("sorter1.isEmpty = " + rJDGDDefaultDataSorter.isEmpty());
        System.out.println("sorter2.isEmpty = " + rJDGDDefaultDataSorter2.isEmpty());
        System.out.println("sorter1.contains = " + rJDGDDefaultDataSorter.contains("1"));
        System.out.println("sorter2.contains = " + rJDGDDefaultDataSorter2.contains("1"));
        System.out.println("sorter1.toArray = " + rJDGDDefaultDataSorter.toArray());
        System.out.println("sorter2.toArray = " + rJDGDDefaultDataSorter2.toArray());
        try {
            RJDGDDefaultDataSorter rJDGDDefaultDataSorter3 = new RJDGDDefaultDataSorter();
            rJDGDDefaultDataSorter3.add(null, null);
            rJDGDDefaultDataSorter3.add(null, new Object());
            rJDGDDefaultDataSorter3.add(new Object(), null);
            rJDGDDefaultDataSorter3.add(new Object(), new Object());
            rJDGDDefaultDataSorter3.remove(2);
            int n = 0;
            while (n < rJDGDDefaultDataSorter3.size()) {
                System.out.println("sorter3.get(" + n + ") = " + rJDGDDefaultDataSorter3.get(n));
                ++n;
            }
            System.out.println("sorter3.size = " + rJDGDDefaultDataSorter3.size());
            rJDGDDefaultDataSorter3.clear();
            System.out.println("sorter3.cleared. size = " + rJDGDDefaultDataSorter3.size());
            RJDGDDefaultDataSorter rJDGDDefaultDataSorter4 = new RJDGDDefaultDataSorter();
            rJDGDDefaultDataSorter4.add(";oqj", "2");
            rJDGDDefaultDataSorter4.add("qw80", "4");
            rJDGDDefaultDataSorter4.add("pu", "3");
            rJDGDDefaultDataSorter4.add(";:q3olj5", "1");
            System.out.println("sorter4.get(0) = " + rJDGDDefaultDataSorter4.get(0));
            System.out.println("sorter4.get(1) = " + rJDGDDefaultDataSorter4.get(1));
            System.out.println("sorter4.get(2) = " + rJDGDDefaultDataSorter4.get(2));
            System.out.println("sorter4.get(3) = " + rJDGDDefaultDataSorter4.get(3));
            rJDGDDefaultDataSorter4.executeSort();
            System.out.println("sorter4.executeSort");
            int n2 = 0;
            while (n2 < rJDGDDefaultDataSorter4.size()) {
                System.out.println("sorter4.get(" + n2 + ") = " + rJDGDDefaultDataSorter4.get(n2));
                ++n2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public RJDGDDefaultDataSorter() {
        this.initInstance();
    }

    public int size() {
        int n = 0;
        if (this.m_altTargetData != null) {
            n = this.m_altTargetData.size();
        }
        return n;
    }

    public boolean isEmpty() {
        boolean bl = false;
        if (this.m_altTargetData != null) {
            bl = this.m_altTargetData.isEmpty();
        }
        return bl;
    }

    public boolean contains(Object object) {
        boolean bl = false;
        if (this.m_altTargetData != null) {
            Iterator iterator = ((AbstractList)this.m_altTargetData).iterator();
            while (iterator.hasNext()) {
                String string;
                SortKey sortKey = (SortKey)iterator.next();
                String string2 = object.toString();
                if (!string2.equals(string = sortKey.toString())) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public Object[] toArray() {
        Object[] objectArray = null;
        ArrayList arrayList = this.m_altTargetData;
        synchronized (arrayList) {
            int n = this.size();
            objectArray = new Object[n];
            int n2 = 0;
            while (n2 < n) {
                SortKey sortKey = (SortKey)this.m_altTargetData.get(n2);
                objectArray[n2] = sortKey.getDataObject();
                ++n2;
            }
        }
        return objectArray;
    }

    public void add(Object object, Object object2) {
        if (this.m_altTargetData != null) {
            ArrayList arrayList = this.m_altTargetData;
            synchronized (arrayList) {
                this.m_altTargetData.add(new SortKey(object, object2));
            }
        }
    }

    public void remove(int n) {
        if (this.m_altTargetData != null) {
            ArrayList arrayList = this.m_altTargetData;
            synchronized (arrayList) {
                if (n > -1) {
                    this.m_altTargetData.remove(n);
                }
            }
        }
    }

    public void clear() {
        if (this.m_altTargetData != null) {
            this.m_altTargetData.clear();
        }
    }

    public Object get(int n) throws IndexOutOfBoundsException {
        Object object = null;
        ArrayList arrayList = this.m_altTargetData;
        synchronized (arrayList) {
            if (this.m_altTargetData != null) {
                SortKey sortKey = (SortKey)this.m_altTargetData.get(n);
                object = sortKey.getDataObject();
            }
        }
        return object;
    }

    public void setSortMode(int n) throws IllegalArgumentException {
        if (n != 1 && n != -1) {
            String string = "Unsupported sort mode : " + n;
            throw new IllegalArgumentException(string);
        }
        this.m_iSortMode = n;
    }

    public void setCompareType(boolean bl) {
        this.m_bCompareType = bl;
    }

    public void executeSort() {
        if (this.m_altTargetData != null) {
            ArrayList arrayList = this.m_altTargetData;
            synchronized (arrayList) {
                Collections.sort(this.m_altTargetData, new DefaultComparator());
            }
        }
    }

    protected void finalize() throws Throwable {
        this.clear();
        this.m_altTargetData = null;
        super.finalize();
    }

    private void initInstance() {
        this.m_altTargetData = new ArrayList(0);
        this.m_iSortMode = 1;
        this.m_bCompareType = false;
    }

    protected class DefaultComparator
    implements Comparator {
        private static final String CLASSNAME = "RJDGDDefaultDataSorter.DefaultComparator";

        public int compare(Object object, Object object2) {
            int n = ((SortKey)object).compareTo(object2);
            return n *= RJDGDDefaultDataSorter.this.m_iSortMode;
        }
    }

    protected class SortKey
    implements Comparable {
        private static final String CLASSNAME = "RJDGDDefaultDataSorter.SortKey";
        private Object m_clsKeyObject;
        private Object m_clsDataObject;

        public SortKey(Object object, Object object2) {
            this.m_clsKeyObject = object;
            this.m_clsDataObject = object2;
        }

        public Object getDataObject() {
            return this.m_clsDataObject;
        }

        public int compareTo(Object object) {
            int n;
            block6: {
                String string = this.toString();
                String string2 = object.toString();
                if (RJDGDDefaultDataSorter.this.m_bCompareType) {
                    try {
                        double d = Double.parseDouble(string);
                        double d2 = Double.parseDouble(string2);
                        if (d == d2) {
                            n = 0;
                            break block6;
                        }
                        if (d < d2) {
                            n = -1;
                            break block6;
                        }
                        n = 1;
                    }
                    catch (Exception exception) {
                        n = string.compareTo(string2);
                    }
                } else {
                    n = string.compareTo(string2);
                }
            }
            return n;
        }

        public String toString() {
            String string = null;
            if (this.m_clsKeyObject != null) {
                string = this.m_clsKeyObject.toString();
            }
            return string;
        }

        protected void finalize() throws Throwable {
            this.m_clsKeyObject = null;
            this.m_clsDataObject = null;
            super.finalize();
        }
    }
}

