/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import sanproject.client.data.RJDataMsg;

public class RJDGDErrorListTable
extends RJDGDBaseTable {
    private static final String CLASSNAME = "RJDGDErrorListTable";
    private static String[] m_sarHeaderKeys = new String[]{"STRING_TAH_ERRORLOCATION", "STRING_TAH_ERRORMESSAGE"};

    public static void main(String[] stringArray) {
        throw new UnsupportedOperationException();
    }

    public RJDGDErrorListTable() {
        this.initInstance();
    }

    public void setModel(TableModel tableModel) {
        this.setAutoCreateColumnsFromModel(true);
        super.setModel(tableModel);
        this.setAutoCreateColumnsFromModel(false);
    }

    protected Object[] getColumnNames() {
        Object[] objectArray = new Object[m_sarHeaderKeys.length];
        int n = 0;
        while (n < m_sarHeaderKeys.length) {
            String string = m_sarHeaderKeys[n];
            objectArray[n] = RJDGDGuidanceManager.getString(string);
            ++n;
        }
        return objectArray;
    }

    protected Color[] getColumnHeaderColors() {
        Color[] colorArray = new Color[m_sarHeaderKeys.length];
        int n = 0;
        while (n < m_sarHeaderKeys.length) {
            String string = m_sarHeaderKeys[n];
            colorArray[n] = RJDGDGuidanceManager.getColor(string);
            ++n;
        }
        return colorArray;
    }

    protected int[] getColumnWidths() {
        return new int[]{130, 484};
    }

    protected int[] getColumnHorizontalAlignments() {
        return new int[]{0, 2};
    }

    protected TableModel getUsedTableModel() {
        Object[] objectArray = this.getColumnNames();
        return new ErrorDetailTableModel(objectArray);
    }

    protected TableCellRenderer getDefaultCellRenderer() {
        return new ErrorDetailTableCellRenderer();
    }

    protected void finalize() throws Throwable {
        RJDGDLogManager.putLog(1, this.getClass().getName() + ":" + CLASSNAME, "++++++++++++++++    finalize( )    ++++++++++++++++");
        super.finalize();
    }

    private void initInstance() {
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        int[] nArray = this.getColumnWidths();
        int n2 = 0;
        while (n2 < n && n2 < nArray.length) {
            TableColumn tableColumn = tableColumnModel.getColumn(n2);
            tableColumn.setPreferredWidth(nArray[n2]);
            tableColumn.setHeaderRenderer(new ErrorDetailTableHeaderRenderer());
            ++n2;
        }
    }

    protected class ErrorDetailTableHeaderRenderer
    implements TableCellRenderer {
        private static final String CLASSNAME = "RJDGDErrorListTable.ErrorDetailTableHeaderRenderer";

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = new JLabel();
            if (object != null) {
                Serializable serializable;
                JTableHeader jTableHeader = jTable.getTableHeader();
                if (jTableHeader instanceof RJDGDBaseTableHeader) {
                    serializable = (RJDGDBaseTableHeader)jTableHeader;
                    TableCellRenderer tableCellRenderer = ((RJDGDBaseTableHeader)serializable).getDefaultHeaderRenderer();
                    jLabel = (JLabel)tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                } else {
                    jLabel = new JLabel(object.toString());
                    jLabel.setOpaque(true);
                    jLabel.setForeground(RJDGDGuidanceManager.DEFAULT_STRING_COLOR);
                    jLabel.setBackground(jTableHeader.getBackground());
                    jLabel.setFont(jTableHeader.getFont());
                    jLabel.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                    jLabel.setHorizontalAlignment(0);
                }
                Color[] colorArray = RJDGDErrorListTable.this.getColumnHeaderColors();
                if (colorArray != null && colorArray.length >= n2) {
                    serializable = RJDGDGuidanceManager.DEFAULT_STRING_COLOR;
                    if (colorArray[n2].getRGB() != ((Color)serializable).getRGB()) {
                        jLabel.setForeground(colorArray[n2]);
                    }
                }
            }
            return jLabel;
        }
    }

    protected class ErrorDetailTableCellRenderer
    extends RJDGDDefaultTableCellRenderer {
        private static final String CLASSNAME = "RJDGDErrorListTable.ErrorDetailTableCellRenderer";

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            int[] nArray;
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object != null && (nArray = RJDGDErrorListTable.this.getColumnHorizontalAlignments()) != null && nArray.length >= n2) {
                jLabel.setHorizontalAlignment(nArray[n2]);
            }
            return jLabel;
        }
    }

    protected class ErrorDetailTableModel
    extends RJDGDBaseTableModel {
        private static final String CLASSNAME = "RJDGDErrorListTable.ErrorDetailTableModel";

        public ErrorDetailTableModel(Object[] objectArray) {
            super(objectArray);
        }

        public boolean isNumericColumn(int n) {
            return false;
        }

        public void refreshData() throws RJDGDRefreshDataException {
            this.removeAllRows();
            RJDGDDataControl rJDGDDataControl = RJDGDDataManager.getDGDControler();
            if (rJDGDDataControl != null) {
                RJDGDErrInfo[] rJDGDErrInfoArray = rJDGDDataControl.getErrInfo();
                if (rJDGDErrInfoArray != null) {
                    int n = 0;
                    while (n < rJDGDErrInfoArray.length) {
                        RJDGDErrInfo rJDGDErrInfo = rJDGDErrInfoArray[n];
                        Object[] objectArray = new Object[]{new RJDGDErrorObject(rJDGDErrInfo, 5), new RJDGDErrorObject(rJDGDErrInfo, 6)};
                        this.addRow(objectArray);
                        ++n;
                    }
                }
            } else {
                String string = "Cann't found DataControl.";
                throw new RJDGDRefreshDataException(string);
            }
        }
    }

    public class RJDGDErrorObject
    implements Serializable {
        private static final String CLASSNAME = "RJDGDErrorListTable.RJDGDErrorObject";
        public static final int VIEW_ERRORPART = 1;
        public static final int VIEW_ERRORCODE = 2;
        public static final int VIEW_CUNUMBER = 3;
        public static final int VIEW_LDEVNUMBER = 4;
        public static final int VIEW_LOCATION = 5;
        public static final int VIEW_MESSAGE = 6;
        private RJDGDErrInfo m_clsErrorInfo;
        private int m_iViewIndex;
        private Color m_clrForeColor;

        public RJDGDErrorObject(RJDGDErrInfo rJDGDErrInfo, int n) {
            this.m_clsErrorInfo = rJDGDErrInfo;
            this.m_iViewIndex = n;
        }

        public RJDGDErrInfo getErrorInformation() {
            return this.m_clsErrorInfo;
        }

        public String toString() {
            String string = null;
            if (this.m_clsErrorInfo != null) {
                switch (this.m_iViewIndex) {
                    case 1: {
                        string = String.valueOf(this.m_clsErrorInfo.getErp());
                        break;
                    }
                    case 2: {
                        string = String.valueOf(this.m_clsErrorInfo.getErc());
                        break;
                    }
                    case 3: {
                        string = String.valueOf(this.m_clsErrorInfo.getCu());
                        break;
                    }
                    case 4: {
                        string = String.valueOf(this.m_clsErrorInfo.getLdev());
                        break;
                    }
                    case 6: {
                        RJDataMsg rJDataMsg = this.m_clsErrorInfo.getMsg();
                        if (rJDataMsg == null) break;
                        string = rJDataMsg.getMessage();
                        break;
                    }
                    default: {
                        string = this.m_clsErrorInfo.getLocation();
                    }
                }
            }
            return string;
        }

        public void setForeground(Color color) {
            this.m_clrForeColor = color;
        }

        public Color getForeground() {
            Color color = null;
            color = this.m_clrForeColor == null ? RJDGDGuidanceManager.DEFAULT_STRING_COLOR : this.m_clrForeColor;
            return color;
        }

        protected void finalize() throws Throwable {
            this.m_clsErrorInfo = null;
            super.finalize();
        }
    }
}

