/*
 * Decompiled with CFR 0.152.
 */
import sanproject.client.data.RJDataLDEV;

public class RJDGDLdev {
    public static final int VOL_MF = 1;
    public static final int VOL_INT = 2;
    private int _cu;
    private int _ldev;
    private RJDGDGuardPatternCom _guardPtn = null;
    private RJDataLDEV _ldevData = null;
    private RJDGDVtocArea _vtoc = null;

    public RJDGDLdev(int n, int n2, RJDGDGuardPatternCom rJDGDGuardPatternCom) throws NullPointerException {
        if (rJDGDGuardPatternCom == null) {
            throw new NullPointerException("guardPtn is null");
        }
        this._cu = n;
        this._ldev = n2;
        this._guardPtn = rJDGDGuardPatternCom;
        this._ldevData = NullLdev.getInstance();
        this._vtoc = RJDGDVtocArea.newNull();
    }

    public RJDGDLdev(int n, int n2, RJDGDGuardPatternCom rJDGDGuardPatternCom, RJDataLDEV rJDataLDEV, RJDGDVtocArea rJDGDVtocArea) throws NullPointerException {
        if (rJDGDGuardPatternCom == null) {
            throw new NullPointerException("guardPtn is null");
        }
        this._cu = n;
        this._ldev = n2;
        this._guardPtn = rJDGDGuardPatternCom;
        this._ldevData = rJDataLDEV != null ? (RJDGDLdev.isMfVol(rJDataLDEV) ? rJDataLDEV : NullLdev.getInstance()) : NullLdev.getInstance();
        this._vtoc = this._ldevData.equals((Object)NullLdev.getInstance()) ? RJDGDVtocArea.newNull() : rJDGDVtocArea;
    }

    public int getCu() {
        return this._cu;
    }

    public int getLdev() {
        return this._ldev;
    }

    public byte getGuard() {
        return this._guardPtn.getGuardStatus(this._cu, this._ldev);
    }

    public void setGuard(byte by) {
        this._guardPtn.setGuardStatus(this._cu, this._ldev, by);
    }

    public String getEmulation() {
        return this._ldevData.getEmulation();
    }

    public int getCapacity() {
        return this._ldevData.getSize();
    }

    public RJDGDVtocArea getVtoc() {
        return this.getGuard() == -126 ? this._vtoc : RJDGDVtocArea.newNull();
    }

    public boolean canChgAttribute() {
        return this._guardPtn.canChgAttribute();
    }

    public boolean canChgVtoc() {
        return this._guardPtn.canChgVtoc() & !this.getVtoc().equals(RJDGDVtocArea.newNull());
    }

    public boolean isModify() {
        return this._vtoc.isModify() | this._guardPtn.isModifyLdev(this._cu, this._ldev);
    }

    public boolean isMfVol() {
        return RJDGDLdev.isMfVol(this._ldevData);
    }

    public static boolean isMfVol(RJDataLDEV rJDataLDEV) {
        boolean bl = false;
        if (rJDataLDEV != null) {
            switch (rJDataLDEV.getVolumeFlg()) {
                case 1: 
                case 2: {
                    bl = true;
                    break;
                }
            }
        }
        return bl;
    }

    private static class NullLdev
    extends RJDataLDEV {
        private static NullLdev singleton = new NullLdev();

        private static NullLdev getInstance() {
            return singleton;
        }

        public String getEmulation() {
            return RJDGDGuidanceManager.getString("STRING_DAT_NODATA");
        }

        public int getSize() {
            return -1;
        }

        public int getVolumeFlg() {
            return 1;
        }
    }
}

