/*
 * Decompiled with CFR 0.152.
 */
package sanproject.server.data;

import java.text.StringCharacterIterator;

public class DGDGuardFileChecker {
    private static final String CLASSNAME = "DGDGuardFileChecker";
    public static final int MAX_FILENAME_LENGTH = 16;
    public static final String GUARD_FILE_EXTENSION = ".gad";
    public static final String SAFE_CHARACTERS = "! #$%&'()+-0123456789=@ABCDEFGHIJKLMNOPQRSTUVWXYZ[]^_`abcdefghijklmnopqrstuvwxyz{}~";
    private String m_strFileName;

    public static void main(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            DGDGuardFileChecker dGDGuardFileChecker = new DGDGuardFileChecker(string);
            System.out.println("  \u30c1\u30a7\u30c3\u30af\u5bfe\u8c61\u540d '" + string + "'");
            System.out.println("-------------------------------------------");
            System.out.println("    '.gad' \u524a\u9664     [" + DGDGuardFileChecker.getFileNameWithoutGuardFileExtension(string) + "]");
            System.out.println("     \u6709\u52b9\u6587\u5b57\u5224\u5225   [" + dGDGuardFileChecker.isSafeCharacters() + "]");
            System.out.println("     \u6587\u5b57\u6570\u5236\u9650     [" + dGDGuardFileChecker.isSafeFileNameLength() + "]");
            System.out.println();
            System.out.println();
            ++n;
        }
    }

    public static String getFileNameWithoutGuardFileExtension(String string) {
        String string2 = string = string.trim();
        if (string != null && string.endsWith(GUARD_FILE_EXTENSION)) {
            string2 = string.substring(0, string.length() - GUARD_FILE_EXTENSION.length());
        }
        return string2;
    }

    public DGDGuardFileChecker(String string) {
        this.m_strFileName = string;
    }

    public boolean isSafeCharacters() {
        boolean bl = true;
        String string = DGDGuardFileChecker.getFileNameWithoutGuardFileExtension(this.m_strFileName);
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (SAFE_CHARACTERS.indexOf(c) == -1) {
                bl = false;
                break;
            }
            c = stringCharacterIterator.next();
        }
        return bl;
    }

    public boolean isSafeFileNameLength() {
        boolean bl = true;
        String string = DGDGuardFileChecker.getFileNameWithoutGuardFileExtension(this.m_strFileName);
        if (string.length() > 16) {
            bl = false;
        }
        return bl;
    }
}

