/*
 * Decompiled with CFR 0.152.
 */
package sanproject.exauthrelay;

import java.io.UnsupportedEncodingException;
import java.util.Properties;
import sanproject.exauthrelay.data.EX_AUTH_STRUCT;
import sanproject.sn2.base.authentication.SJbaseAuthenticationSystem;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.SJcLogUty;

public class SJexauthExAuthRelay {
    private static final String LOG_FUNC = "ExAuthRelay";
    private static final String LOG_TITLE = SJexauthExAuthRelay.class.getSimpleName();
    private static final String ENCODE = "UTF-8";
    private static final String PROPERTY_DIR_NAME = "exauthrelay";
    private static final String PROPERTY_FILA_NAME = "exauthrelay.properties";
    private static final String AUTH_NAME_LIST_KEY = "list";
    private static final String AUTH_NAME_LIST_DEFAULT = "AuthExternalHCS,AuthExternal2";
    private static final String AUTH_NAME_SSO_LIST_KEY = "ssolist";
    private static final String AUTH_NAME_LIST_SEPARATOR = ",";
    private SJcLoggerInterface logger = SJcLogUty.getLogger();
    private Properties props = null;
    private String[] authNameList = null;

    public SJexauthExAuthRelay(int ssoOpt) {
        this.logger.info(LOG_FUNC, LOG_TITLE, "SJexauthExAuthRelay", "Start.");
        try {
            this.props = SJcFileUty.loadProperties(PROPERTY_DIR_NAME, PROPERTY_FILA_NAME);
        }
        catch (SJcException e) {
            this.logger.warn(LOG_FUNC, LOG_TITLE, "SJexauthExAuthRelay", "Failed to read property.", e);
        }
        String authListValue = AUTH_NAME_LIST_DEFAULT;
        if (null != this.props) {
            switch (ssoOpt) {
                case 0: {
                    authListValue = this.props.getProperty(AUTH_NAME_LIST_KEY, AUTH_NAME_LIST_DEFAULT);
                    break;
                }
                case 1: {
                    authListValue = this.props.getProperty(AUTH_NAME_SSO_LIST_KEY, AUTH_NAME_LIST_DEFAULT);
                    break;
                }
                default: {
                    authListValue = this.props.getProperty(AUTH_NAME_LIST_KEY, AUTH_NAME_LIST_DEFAULT);
                }
            }
        }
        this.authNameList = authListValue.split(AUTH_NAME_LIST_SEPARATOR);
        this.logger.info(LOG_FUNC, LOG_TITLE, "SJexauthExAuthRelay", "End.");
    }

    public EX_AUTH_STRUCT authentication(String userName, String pass) {
        this.logger.info(LOG_FUNC, LOG_TITLE, "authentication", "Start. -User ID: " + userName);
        EX_AUTH_STRUCT result = new EX_AUTH_STRUCT();
        SJbaseAuthenticationSystem authSys = new SJbaseAuthenticationSystem();
        boolean authResult = authSys.authentication(userName, pass, this.authNameList);
        this.setUserName(authSys, result, userName);
        this.setResult(result, authResult);
        if (authResult) {
            this.setGroupID(authSys, result);
            this.setRoleID(authSys, result);
            this.setRSGMap(authSys, result);
            result.isAllRSG = authSys.isAllRSG();
        } else {
            this.logger.error(LOG_FUNC, LOG_TITLE, "authentication", "Failed to Authentication.");
        }
        this.logger.info(LOG_FUNC, LOG_TITLE, "authentication", "End. -result: " + authResult);
        return result;
    }

    private void setResult(EX_AUTH_STRUCT result, boolean authResult) {
        result.result = authResult;
    }

    private void setUserName(SJbaseAuthenticationSystem authSys, EX_AUTH_STRUCT result, String userName) {
        String sourceUserName = authSys.getUserName();
        if (null == sourceUserName) {
            sourceUserName = userName;
        }
        if (null != sourceUserName) {
            result.userName = this.getBytes(sourceUserName, 256);
        }
    }

    private void setGroupID(SJbaseAuthenticationSystem authSys, EX_AUTH_STRUCT result) {
        String[] groupIDList = authSys.getGroupID();
        if (null != groupIDList) {
            result.groupID = new byte[1024][65];
            int listSize = groupIDList.length;
            if (listSize > 1024) {
                listSize = 1024;
                this.logger.warn(LOG_FUNC, LOG_TITLE, "setGroupID", "Group list length is too long.");
            }
            for (int i = 0; i < listSize; ++i) {
                result.groupID[i] = this.getBytes(groupIDList[i], 64);
            }
        }
    }

    private void setRoleID(SJbaseAuthenticationSystem authSys, EX_AUTH_STRUCT result) {
        String[] roleIDList = authSys.getRoleID();
        if (null != roleIDList) {
            result.roleID = new byte[1024][65];
            int listSize = roleIDList.length;
            if (listSize > 1024) {
                listSize = 1024;
                this.logger.warn(LOG_FUNC, LOG_TITLE, "setRoleID", "Role list length is too long.");
            }
            for (int i = 0; i < listSize; ++i) {
                result.roleID[i] = this.getBytes(roleIDList[i], 64);
            }
        }
    }

    private void setRSGMap(SJbaseAuthenticationSystem authSys, EX_AUTH_STRUCT result) {
        boolean[] rsgMap = authSys.getResourceGrpMap();
        if (authSys.isAllRSG()) {
            result.resourceGroupMap = new byte[128];
            for (int i = 0; i < 128; ++i) {
                result.resourceGroupMap[i] = -1;
            }
            return;
        }
        if (null != rsgMap) {
            int bitMapLength = rsgMap.length;
            if (bitMapLength > 1024) {
                bitMapLength = 1024;
                this.logger.warn(LOG_FUNC, LOG_TITLE, "setRSGMap", "Bitmap length is too long. -size: " + rsgMap.length);
            }
            result.resourceGroupMap = new byte[128];
            for (int i = 0; i < bitMapLength; ++i) {
                if (!rsgMap[i]) continue;
                int n = i / 8;
                result.resourceGroupMap[n] = (byte)(result.resourceGroupMap[n] | 128 >> i % 8);
            }
        }
    }

    private byte[] getBytes(String source, int maxSize) {
        byte[] ret = new byte[maxSize + 1];
        if (null != source) {
            try {
                byte[] sourceArr = source.getBytes(ENCODE);
                int copyLength = sourceArr.length;
                if (copyLength > maxSize) {
                    copyLength = maxSize;
                    this.logger.warn(LOG_FUNC, LOG_TITLE, "getBytes", "String length is too long. -source: " + source);
                }
                System.arraycopy(sourceArr, 0, ret, 0, copyLength);
            }
            catch (UnsupportedEncodingException e) {
                this.logger.error(LOG_FUNC, LOG_TITLE, "getByte", "Encoding error", e);
            }
        }
        return ret;
    }
}

