/*
 * Decompiled with CFR 0.152.
 */
package sanproject.exauthrelay.sender;

import com.sun.jna.Function;
import com.sun.jna.NativeLibrary;
import com.sun.jna.NativeLong;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SJexauthSender {
    private static final String LOG_FUNC = "ExAuthRelay";
    private static final String LOG_TITLE = SJexauthSender.class.getSimpleName();
    private SJcLoggerInterface logger = null;
    private static final int SEND_NORMAL = 0;
    private static NativeLibrary libExAuthCommon = null;
    private static final String EX_AUTH_COMMON_DLL = "ExAuthCommon";
    private static final String FUNC_NAME_SEND_EX_AUTH_RESPONSE = "SendExAuthResponse";

    public SJexauthSender() throws Throwable {
        String LOG_SUBTITLE = "SJexauthSender";
        try {
            this.logger = SJcLogUty.getLogger();
            this.logger.info(LOG_FUNC, LOG_TITLE, LOG_SUBTITLE, "Start.");
            if (libExAuthCommon == null) {
                libExAuthCommon = NativeLibrary.getInstance((String)EX_AUTH_COMMON_DLL);
                this.logger.info(LOG_FUNC, LOG_TITLE, LOG_SUBTITLE, "libExAuthCommon is loaded now.");
            }
            this.logger.info(LOG_FUNC, LOG_TITLE, LOG_SUBTITLE, "End.");
        }
        catch (Throwable th) {
            this.logger.error(LOG_FUNC, LOG_TITLE, LOG_SUBTITLE, "Exception occured.", th);
            throw th;
        }
    }

    public void sendExAuthResponse(Object param, int param_len) throws Exception {
        String LOG_SUBTITLE = "sendExAuthResponse";
        this.logger.info(LOG_FUNC, LOG_TITLE, LOG_SUBTITLE, "Start.");
        Object[] args = new Object[]{param, param_len};
        NativeLong result = (NativeLong)this.invokeFunction(FUNC_NAME_SEND_EX_AUTH_RESPONSE, NativeLong.class, args);
        if (result == null) {
            throw new Exception("SendExAuthResponse Error. result is null.");
        }
        if (result.intValue() != 0) {
            this.logger.error(LOG_FUNC, LOG_TITLE, LOG_SUBTITLE, "result.intValue() is not SEND_NORMAL. :" + result.intValue());
            throw new Exception("SendExAuthResponse Error. -Return:" + result.intValue());
        }
        this.logger.info(LOG_FUNC, LOG_TITLE, LOG_SUBTITLE, "End.");
    }

    private Object invokeFunction(String methodName, Class<?> returnType, Object[] inArgs) {
        String LOG_SUBTITLE = "invokeFunction";
        this.logger.info(LOG_FUNC, LOG_TITLE, LOG_SUBTITLE, "Start. -methodName:" + methodName);
        Object obj = null;
        if (libExAuthCommon != null) {
            Function func = libExAuthCommon.getFunction(methodName);
            obj = func.invoke(returnType, inArgs);
        } else {
            this.logger.error(LOG_FUNC, LOG_TITLE, LOG_SUBTITLE, "libExAuthCommon is null.");
        }
        this.logger.info(LOG_FUNC, LOG_TITLE, LOG_SUBTITLE, "End.");
        return obj;
    }
}

