/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.log;

import flex.messaging.log.LoggingHttpServletRequestWrapper;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

public class HTTPRequestLog {
    public static final String HTTP_ERROR_INFO = "org.apache.flex.blazeds.internal._exception_info";
    private static String filename;

    public static boolean init(ServletContext context) {
        String logfile = context.getInitParameter("HttpErrorLog");
        if (logfile == null || logfile.length() == 0) {
            return false;
        }
        filename = logfile;
        return true;
    }

    public static void setFileName(String fileName) {
        if (fileName != null) {
            filename = fileName;
        }
    }

    public static String getFileName() {
        return filename;
    }

    public static synchronized void outputRequest(String header, HttpServletRequest httpReq) {
        if (!(httpReq instanceof LoggingHttpServletRequestWrapper) || filename == null) {
            return;
        }
        LoggingHttpServletRequestWrapper req = (LoggingHttpServletRequestWrapper)httpReq;
        FileWriter fw = null;
        try {
            fw = new FileWriter(filename, true);
            fw.write("#===== Request Client Infomation =====#\n");
            if (header != null) {
                fw.write("Error             : " + header + "\n");
            }
            fw.write("Timestamp         : " + new Date(System.currentTimeMillis()).toString() + "\n");
            fw.write("Client IP Address : " + req.getRemoteAddr() + "\n");
            fw.write("Client FQDN       : " + req.getRemoteHost() + "\n");
            fw.write("Body size         : " + req.getContentLength() + "\n");
            fw.write("#===== HTTP Headers =====#\n");
            HTTPRequestLog.outputHeaders(fw, req);
            fw.write("#===== HTTP Body =====#\n");
            HTTPRequestLog.outputBody(fw, req);
            fw.close();
        }
        catch (IOException ex) {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            System.out.println("Unable to write HTTP request data to file " + filename + ": " + ex.toString());
        }
    }

    public static void outputPrint(String message) {
        FileWriter fw = null;
        try {
            fw = new FileWriter(filename, true);
            fw.write(message + "\n");
            fw.close();
        }
        catch (IOException ex) {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            System.out.println("Unable to log message '" + message + "' to file " + filename + " : " + ex.toString());
        }
    }

    private static void outputHeaders(FileWriter fw, LoggingHttpServletRequestWrapper req) throws IOException {
        Enumeration reqHeaderNum = req.getHeaderNames();
        if (reqHeaderNum == null) {
            fw.write("No headers\n");
            return;
        }
        while (reqHeaderNum.hasMoreElements()) {
            String key = (String)reqHeaderNum.nextElement();
            HTTPRequestLog.outputHeaderElements(fw, req, key);
        }
    }

    private static void outputHeaderElements(FileWriter fw, LoggingHttpServletRequestWrapper req, String key) throws IOException {
        Enumeration e = req.getHeaders(key);
        String keyname = key;
        while (e.hasMoreElements()) {
            fw.write(keyname + " : " + e.nextElement() + "\n");
            keyname = "        ";
        }
    }

    private static void outputBody(FileWriter fw, LoggingHttpServletRequestWrapper req) throws IOException {
        int leng = req.getContentLength();
        if (leng <= 0) {
            return;
        }
        byte[] rbuf = new byte[leng];
        ServletInputStream in = req.getInputStream();
        if (in.read(rbuf, 0, leng) > 0) {
            HTTPRequestLog.outputBinary(fw, rbuf);
        }
    }

    private static void outputBinary(FileWriter fw, byte[] buf) throws IOException {
        int adrs = 0;
        for (int j = 0; j < buf.length; j += 16) {
            int i;
            String adrsStr = "00000000" + Integer.toHexString(adrs);
            adrsStr = adrsStr.substring(adrsStr.length() - 8, adrsStr.length());
            fw.write("\n" + adrsStr + " : ");
            adrs += 16;
            for (i = 0; i < 16; ++i) {
                if (i + j >= buf.length) {
                    fw.write("   ");
                    continue;
                }
                int n = buf[i + j];
                if (n < 0) {
                    n += 256;
                }
                String s = "00" + Integer.toHexString(n);
                s = s.substring(s.length() - 2, s.length());
                fw.write(s + " ");
            }
            fw.write("    ");
            for (i = 0; i < 16 && i + j < buf.length; ++i) {
                if (buf[i + j] < 32 || (buf[i + j] & 0xFF) > 222 || buf[i + j] > 126 && (buf[i + j] & 0xFF) < 161) {
                    fw.write(".");
                    continue;
                }
                String s = String.valueOf((char)buf[i + j]);
                fw.write(s);
            }
        }
        fw.write("\n");
    }
}

