/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.util;

import flex.messaging.MessageException;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.SerializationException;
import flex.messaging.validators.DeserializationValidator;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;

public class ClassUtil {
    private static final int TYPE_NOT_FOUND = 10008;
    private static final int UNEXPECTED_TYPE = 10009;
    private static final int CANNOT_CREATE_TYPE = 10010;
    private static final int SECURITY_ERROR = 10011;
    private static final int UNKNOWN_ERROR = 10012;
    private static final String NULL = "null";

    private ClassUtil() {
    }

    public static Class createClass(String type) {
        return ClassUtil.createClass(type, null);
    }

    public static Class createClass(String type, ClassLoader loader) {
        try {
            if (type != null) {
                type = type.trim();
            }
            if (loader == null) {
                return Class.forName(type);
            }
            return Class.forName(type, true, loader);
        }
        catch (ClassNotFoundException cnf) {
            MessageException ex = new MessageException();
            ex.setMessage(10008, new Object[]{type});
            ex.setDetails(10008, "0", new Object[]{type});
            ex.setCode("Server.ResourceUnavailable");
            throw ex;
        }
    }

    public static Object createDefaultInstance(Class cls, Class expectedInstance) {
        return ClassUtil.createDefaultInstance(cls, expectedInstance, false);
    }

    public static Object createDefaultInstance(Class cls, Class expectedInstance, boolean validate) {
        if (validate) {
            ClassUtil.validateCreation(cls);
        }
        String type = cls.getName();
        try {
            Object instance = cls.newInstance();
            if (expectedInstance != null && !expectedInstance.isInstance(instance)) {
                MessageException ex = new MessageException();
                ex.setMessage(10009, new Object[]{instance.getClass().getName(), expectedInstance.getName()});
                ex.setCode("Server.ResourceUnavailable");
                throw ex;
            }
            return instance;
        }
        catch (IllegalAccessException ia) {
            boolean details = false;
            StringBuffer message = new StringBuffer("Unable to create a new instance of type ");
            message.append(type);
            if (!ClassUtil.hasValidDefaultConstructor(cls)) {
                details = true;
            }
            MessageException ex = new MessageException();
            ex.setMessage(10010, new Object[]{type});
            if (details) {
                ex.setDetails(10010, "0");
            }
            ex.setCode("Server.ResourceUnavailable");
            throw ex;
        }
        catch (InstantiationException ine) {
            String variant = null;
            if (cls.isInterface()) {
                variant = "1";
            } else if (ClassUtil.isAbstract(cls)) {
                variant = "2";
            } else if (!ClassUtil.hasValidDefaultConstructor(cls)) {
                variant = "3";
            }
            MessageException ex = new MessageException();
            ex.setMessage(10010, new Object[]{type});
            if (variant != null) {
                ex.setDetails(10010, variant);
            }
            ex.setCode("Server.ResourceUnavailable");
            throw ex;
        }
        catch (SecurityException se) {
            MessageException ex = new MessageException();
            ex.setMessage(10011, new Object[]{type});
            ex.setCode("Server.ResourceUnavailable");
            ex.setRootCause(se);
            throw ex;
        }
        catch (MessageException me) {
            throw me;
        }
        catch (Exception e) {
            MessageException ex = new MessageException();
            ex.setMessage(10012, new Object[]{type});
            ex.setCode("Server.ResourceUnavailable");
            ex.setRootCause(e);
            throw ex;
        }
    }

    public static boolean isAbstract(Class cls) {
        try {
            if (cls != null) {
                int mod = cls.getModifiers();
                return Modifier.isAbstract(mod);
            }
        }
        finally {
            return false;
        }
        {
        }
    }

    public static boolean hasValidDefaultConstructor(Class cls) {
        try {
            if (cls != null) {
                Constructor c = cls.getConstructor(new Class[0]);
                int mod = c.getModifiers();
                return Modifier.isPublic(mod);
            }
        }
        finally {
            return false;
        }
        {
        }
    }

    public static String classLoaderToString(ClassLoader cl) {
        if (cl == null) {
            return NULL;
        }
        if (cl == ClassLoader.getSystemClassLoader()) {
            return "system";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("hashCode: " + System.identityHashCode(cl) + " (parent " + ClassUtil.classLoaderToString(cl.getParent()) + ")");
        return sb.toString();
    }

    public static void validateAssignment(Object obj, int index, Object value) {
        SerializationContext context = SerializationContext.getSerializationContext();
        DeserializationValidator validator = context.getDeserializationValidator();
        if (validator == null) {
            return;
        }
        boolean valid = true;
        try {
            valid = validator.validateAssignment(obj, index, value);
        }
        catch (Exception e) {
            SerializationException se = new SerializationException();
            se.setMessage(10313, new Object[]{obj == null ? NULL : obj.getClass().getName(), index});
            se.setRootCause(e);
            throw se;
        }
        if (!valid) {
            SerializationException se = new SerializationException();
            se.setMessage(10313, new Object[]{obj == null ? NULL : obj.getClass().getName(), index});
            throw se;
        }
    }

    public static void validateAssignment(Object obj, String propName, Object value) {
        SerializationContext context = SerializationContext.getSerializationContext();
        DeserializationValidator validator = context.getDeserializationValidator();
        if (validator == null) {
            return;
        }
        boolean valid = true;
        try {
            valid = validator.validateAssignment(obj, propName, value);
        }
        catch (Exception e) {
            SerializationException se = new SerializationException();
            se.setMessage(10312, new Object[]{obj == null ? NULL : obj.getClass().getName(), propName});
            se.setRootCause(e);
            throw se;
        }
        if (!valid) {
            SerializationException se = new SerializationException();
            se.setMessage(10312, new Object[]{obj == null ? NULL : obj.getClass().getName(), propName});
            throw se;
        }
    }

    public static void validateCreation(Class<?> cls) {
        SerializationContext context = SerializationContext.getSerializationContext();
        DeserializationValidator validator = context.getDeserializationValidator();
        if (validator == null) {
            return;
        }
        boolean valid = true;
        try {
            valid = validator.validateCreation(cls);
        }
        catch (Exception e) {
            SerializationException se = new SerializationException();
            se.setMessage(10311, new Object[]{cls == null ? NULL : cls.getName()});
            se.setRootCause(e);
            throw se;
        }
        if (!valid) {
            SerializationException se = new SerializationException();
            se.setMessage(10311, new Object[]{cls == null ? NULL : cls.getName()});
            throw se;
        }
    }
}

