/*
 * Decompiled with CFR 0.152.
 */
package sanproject.snctrl;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import sanproject.portmanager.SJsncPortManager;
import sanproject.sn2.base.property.SJbaseSystemPropertiesManager;
import sanproject.sn2.com.utility.Logger.inf.SJcCustomLoggerInterface;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.SJcTRLogUty;
import sanproject.sn2.com.utility.tomcat.SJcTomcatOutputStream;
import sanproject.snctrl.com.SJsnctrlSnConst;
import sanproject.snctrl.com.utility.SJcExecCmdUty;
import sanproject.snctrl.com.utility.SJcPropertiesUty;
import sanproject.snctrl.thread.SJsnctrlSnWebAppSurveillanceThread;
import sanproject.snctrl.utility.SJsnctrlSnLockUtility;

public class SJsnctrlSnWebAppController {
    private static final String LOG_FUNCTION = "Jetty";
    private static final String LOG_TITLE = SJsnctrlSnWebAppController.class.getSimpleName();
    private static String mappInstPath = null;
    private static String dkcPath = null;
    private static String lockPath = null;
    private static List<StringBuilder> execCmdList = null;
    private static long period = 5000L;
    private static SJsnctrlSnWebAppSurveillanceThread thread = null;
    private static SJbaseSystemPropertiesManager sysPropMgr = null;
    private static SJcLoggerInterface STD_LOGGER = null;
    private static final String JETTY_LOG = "SN_Jetty-stdout.log";
    private static final String JETTY_ERR_LOG = "SN_Jetty-stderr.log";
    private static final String REGEX = "jna.*\\.dll";

    public static void main(String[] args) throws IOException, InterruptedException {
        String LOG_SUBTITLE = "main";
        if (SJsnctrlSnWebAppController.init()) {
            try {
                Properties localProps = SJcFileUty.loadProperties((String)"webappctrl", (String)"webappctrl.properties");
                String periodTime = localProps.getProperty("SJ_SURVEILLANCE_PERIOD_TIME", String.valueOf(5));
                period = Long.parseLong(periodTime) * 1000L;
            }
            catch (NumberFormatException e) {
                STD_LOGGER.warn(LOG_FUNCTION, LOG_TITLE, "main", "properties file(" + SJsnctrlSnWebAppController.endsWithFileSeparator("webappctrl") + "webappctrl.properties" + ") format is error. keyname (" + "SJ_SURVEILLANCE_PERIOD_TIME" + ")");
            }
            catch (Exception ex) {
                STD_LOGGER.warn(LOG_FUNCTION, LOG_TITLE, "main", "properties file(" + SJsnctrlSnWebAppController.endsWithFileSeparator("webappctrl") + "webappctrl.properties" + ") format is NotFound. ");
            }
            if (period <= 0L) {
                STD_LOGGER.warn(LOG_FUNCTION, LOG_TITLE, "main", "period value error. (" + period + ")");
                period = 5000L;
            }
            STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "main", "period (" + String.valueOf(period) + ")");
            SJcTRLogUty.info((String)"Web Application Server", (String)"TRSTNA000001", (String)"Initializing", (String)"jetty");
            SJsnctrlSnWebAppController.getCommmandLine();
            SJsnctrlSnWebAppController.exportProcessInfo();
            SJsnctrlSnWebAppController.deleteJnaTmpFile();
            if (execCmdList != null) {
                STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "START SERVICE COMMAND", new String(execCmdList.get(0)));
                STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "STOP SERVICE COMMAND(STD)", new String(execCmdList.get(1)));
                STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "STOP SERVICE COMMAND(PRE)", new String(execCmdList.get(2)));
                SJsnctrlSnWebAppController.startSN2();
            }
        }
        if (!"".equals(dkcPath) && !"".equals(mappInstPath)) {
            STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "main", "End.");
        }
    }

    private static boolean init() {
        String LOG_SUBTITLE = "init";
        boolean result = true;
        try {
            String wk_userdir = SJsnctrlSnWebAppController.endsWithFileSeparator(System.getProperty("user.dir"));
            dkcPath = SJsnctrlSnWebAppController.getMoveUpPathNoLogging(wk_userdir, 3);
            if ("".equals(dkcPath)) {
                return false;
            }
            mappInstPath = SJsnctrlSnWebAppController.getMoveUpPathNoLogging(wk_userdir, 5);
            if ("".equals(mappInstPath)) {
                return false;
            }
            SJsnctrlSnWebAppController.initProperty();
            STD_LOGGER = SJcLogUty.getLogger();
            STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "init", "Start.");
            STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "init", "mappInstPath is (" + mappInstPath + ")");
            STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "init", "dkcPath is (" + dkcPath + ")");
            SJsnctrlSnWebAppController.initializeJettyLog();
            lockPath = dkcPath + "LOCKFILE";
            if (!SJsnctrlSnLockUtility.lock(lockPath)) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "init", "SJsnctrlSnLockUtility.lock() error (" + lockPath + ")");
                result = false;
            }
        }
        catch (Exception ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "init", "Exception.", (Throwable)ex);
            result = false;
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "init", "End.");
        return result;
    }

    private static void initProperty() {
        if (System.getProperty("SN_DataPath") == null) {
            System.setProperty("SN_DataPath", dkcPath + SJsnctrlSnConst.SJ_DIR_NAME_SN2_DATA);
        }
        if (System.getProperty("SN_EnvFile") == null) {
            System.setProperty("SN_EnvFile", dkcPath + SJsnctrlSnWebAppController.endsWithFileSeparator(SJsnctrlSnConst.SJ_DIR_NAME_SN2_ENVFILE) + "SN2_Startup.properties");
        }
        if (System.getProperty("SN_EnvFileV") == null) {
            System.setProperty("SN_EnvFileV", dkcPath + SJsnctrlSnWebAppController.endsWithFileSeparator(SJsnctrlSnConst.SJ_DIR_NAME_SN2_ENVFILE) + "SN2_StartupV.properties");
        }
        if (System.getProperty("SN_LogPath") == null) {
            System.setProperty("SN_LogPath", "webappctrl");
        }
        if (System.getProperty("SN_BasePath") == null) {
            System.setProperty("SN_BasePath", dkcPath + "dkc200");
        }
        sysPropMgr = new SJbaseSystemPropertiesManager();
        sysPropMgr.initialize(0);
    }

    public static void startSN2() {
        String LOG_SUBTITLE = "startSN2";
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "startSN2", "Start.");
        if (thread == null || !thread.isAlive()) {
            try {
                thread = new SJsnctrlSnWebAppSurveillanceThread(execCmdList, period, dkcPath);
                thread.start();
            }
            catch (Exception ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "startSN2", "Exception.", (Throwable)ex);
            }
        } else {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "startSN2", "thread is alive.");
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "startSN2", "End.");
    }

    private static boolean isFileExists(String path) {
        String LOG_SUBTITLE = "isFileExists";
        boolean result = false;
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "isFileExists", "Start.");
        if (path == null || "".equals(path)) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "isFileExists", "path is null");
        } else {
            try {
                File file = new File(path);
                if (file.isFile()) {
                    result = true;
                }
            }
            catch (Exception e) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "isFileExists", "Exception.", (Throwable)e);
            }
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "isFileExists", "End.");
        return result;
    }

    private static boolean isDirectoryExists(String path) {
        String LOG_SUBTITLE = "isDirectoryExists";
        boolean result = false;
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "isDirectoryExists", "Start.");
        if (path == null || "".equals(path)) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "isDirectoryExists", "path is null");
        } else {
            try {
                File file = new File(path);
                if (file.isDirectory()) {
                    result = true;
                }
            }
            catch (Exception e) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "isDirectoryExists", "Exception.", (Throwable)e);
            }
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "isDirectoryExists", "End.");
        return result;
    }

    private static boolean execDirectoryMake(String path) {
        String LOG_SUBTITLE = "execDirectoryMake";
        boolean result = true;
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "execDirectoryMake", "Start.");
        try {
            File dirs = new File(path);
            if (!dirs.exists() && !dirs.mkdir()) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "execDirectoryMake", "to many make directorys");
                result = false;
            }
        }
        catch (Exception ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "execDirectoryMake", "Exception.", (Throwable)ex);
            result = false;
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "execDirectoryMake", "End.");
        return result;
    }

    private static boolean clearWorkDirectory(File f) {
        String LOG_SUBTITLE = "clearWorkDirectory";
        if (!f.exists()) {
            return true;
        }
        if (f.isFile() && !f.delete()) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "clearWorkDirectory", "A failed in the deletion of the file. (" + f.getPath() + ")");
            return false;
        }
        if (f.isDirectory()) {
            File[] files;
            for (File file : files = f.listFiles()) {
                if (SJsnctrlSnWebAppController.clearWorkDirectory(file)) continue;
                return false;
            }
            if (!f.delete()) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "clearWorkDirectory", "A failed in the deletion of the file. (" + f.getPath() + ")");
                return false;
            }
        }
        return true;
    }

    public static String endsWithFileSeparator(String path) {
        if (path == null || "".equals(path)) {
            path = File.separator;
        } else if (!path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        return path;
    }

    private static boolean chkFileMakeParameter(String wkpath, String optkey) {
        String LOG_SUBTITLE = "chkFileMakeParameter";
        boolean result = true;
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "chkFileMakeParameter", "start.");
        String wkval = " ";
        wkval = optkey != null && !"".equals(optkey) ? wkval + optkey + "=\"" + wkpath + "\"" : wkval + "\"" + wkpath + "\"";
        if (!SJsnctrlSnWebAppController.isFileExists(wkpath)) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "chkFileMakeParameter", "File not found " + wkpath);
            result = false;
        } else {
            STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "chkFileMakeParameter", wkpath);
            execCmdList.get(0).append(wkval);
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "chkFileMakeParameter", "end.");
        return result;
    }

    private static boolean chkDirMakeParameter(String wkpath, String optkey, int mode) {
        String LOG_SUBTITLE = "chkDirMakeParameter";
        boolean result = true;
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "chkDirMakeParameter", "start.");
        String wkval = " " + optkey + "=\"" + wkpath + "\"";
        if (!SJsnctrlSnWebAppController.isDirectoryExists(wkpath)) {
            if (0 == mode) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "chkDirMakeParameter", "Directory not found " + wkpath);
                result = false;
            } else if (!SJsnctrlSnWebAppController.execDirectoryMake(wkpath)) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "chkDirMakeParameter", "Directory not found " + wkpath);
                result = false;
            }
        } else if (2 == mode) {
            File delFile = new File(wkpath);
            SJsnctrlSnWebAppController.clearWorkDirectory(delFile);
            if (!SJsnctrlSnWebAppController.execDirectoryMake(wkpath)) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "chkDirMakeParameter", "Directory not found " + wkpath);
                result = false;
            }
        }
        if (result) {
            STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "chkDirMakeParameter", wkpath);
            execCmdList.get(0).append(wkval);
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "chkDirMakeParameter", "end.");
        return result;
    }

    private static void getMakeProgramParameters() {
        String LOG_SUBTITLE = "getMakeProgramParameters";
        boolean result = true;
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getMakeProgramParameters", "start.");
        String wkval = mappInstPath + SJsnctrlSnWebAppController.endsWithFileSeparator(SJsnctrlSnConst.SJ_DIR_NAME_OSS_JAVA) + "java.exe";
        if (!SJsnctrlSnWebAppController.isFileExists(wkval)) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getMakeProgramParameters", "File not found " + wkval);
            result = false;
        } else {
            STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getMakeProgramParameters", wkval);
            execCmdList.get(0).append(wkval);
            execCmdList.get(1).append(wkval);
            execCmdList.get(2).append(wkval);
        }
        String wkpath = mappInstPath + SJsnctrlSnWebAppController.endsWithFileSeparator(SJsnctrlSnConst.SJ_DIR_NAME_OSS_JETTY) + "start.jar";
        wkval = " -jar \"" + wkpath + "\"";
        if (!SJsnctrlSnWebAppController.isFileExists(wkpath)) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getMakeProgramParameters", "File not found " + wkpath);
            result = false;
        } else {
            STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getMakeProgramParameters", wkpath);
            execCmdList.get(0).append(wkval);
            execCmdList.get(1).append(wkval);
            execCmdList.get(2).append(wkval);
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getMakeProgramParameters", "end.");
        if (!result) {
            SJcTRLogUty.error((String)"Web Application Server", (String)"TRSTNA000003", (String)"Failed : Failed to start a Storage Navigator.", (String)"jetty");
            execCmdList = null;
        }
    }

    private static void getMakeConfFileParameters() {
        String LOG_SUBTITLE = "getMakeConfFileParameters";
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getMakeConfFileParameters", "start.");
        String wkpath = dkcPath + SJsnctrlSnWebAppController.endsWithFileSeparator(SJsnctrlSnConst.SJ_DIR_NAME_SN2_ENVFILE) + "SN2_Startup.properties";
        SJsnctrlSnWebAppController.chkFileMakeParameter(wkpath, "-DSN_EnvFile");
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getMakeConfFileParameters", "end.");
    }

    private static void getMakeWorkDirectoryParameters() {
        String LOG_SUBTITLE = "getMakeWorkDirectoryParameters";
        boolean result = true;
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getMakeWorkDirectoryParameters", "start.");
        String wkpath = mappInstPath + SJsnctrlSnConst.SJ_DIR_NAME_CMN_ROOT;
        SJsnctrlSnWebAppController.chkDirMakeParameter(wkpath, "-DCmn_BasePath", 0);
        wkpath = mappInstPath + SJsnctrlSnConst.SJ_DIR_NAME_CMN_DATA;
        SJsnctrlSnWebAppController.chkDirMakeParameter(wkpath, "-DCmn_DataPath", 0);
        wkpath = dkcPath + "dkc200";
        if (!SJsnctrlSnWebAppController.chkDirMakeParameter(wkpath, "-DSN_BasePath", 0)) {
            result = false;
        }
        if (!SJsnctrlSnWebAppController.chkDirMakeParameter(wkpath = dkcPath + SJsnctrlSnConst.SJ_DIR_NAME_SN2_DATA, "-DSN_DataPath", 0)) {
            result = false;
        }
        if (!SJsnctrlSnWebAppController.chkDirMakeParameter(wkpath = mappInstPath + SJsnctrlSnConst.SJ_DIR_NAME_OSS_JETTY, "-Djetty.home", 0)) {
            result = false;
        }
        if (!SJsnctrlSnWebAppController.chkDirMakeParameter(wkpath = dkcPath + SJsnctrlSnConst.SJ_DIR_NAME_SN2_JETTY, "jetty.base", 0)) {
            result = false;
        }
        if (!SJsnctrlSnWebAppController.chkDirMakeParameter(wkpath = dkcPath + SJsnctrlSnConst.SJ_DIR_NAME_SN2_LOGS, "-Djetty.logs", 1)) {
            result = false;
        }
        if (!SJsnctrlSnWebAppController.chkDirMakeParameter(wkpath = dkcPath + SJsnctrlSnConst.SJ_DIR_NAME_SN2_WORK, "-Djava.io.tmpdir", 1)) {
            result = false;
        }
        if (!SJsnctrlSnWebAppController.chkDirMakeParameter(wkpath = dkcPath + SJsnctrlSnConst.SJ_DIR_NAME_SN2_CATALINA_BASE, "-Dcatalina.base", 0)) {
            result = false;
        }
        if (!result) {
            SJcTRLogUty.error((String)"Web Application Server", (String)"TRSTNA000003", (String)"Failed : Failed to start a Storage Navigator.", (String)"jetty");
            execCmdList = null;
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getMakeWorkDirectoryParameters", "end.");
    }

    private static void getMakePortNumberParameters() {
        String LOG_SUBTITLE = "getMakePortNumberParameters";
        String dkcKind = "";
        String wkval = "";
        boolean result = true;
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getMakePortNumberParameters", "start.");
        try {
            File file = new File(dkcPath);
            dkcKind = file.getName();
            int wpno = SJsnctrlSnWebAppController.getJettyStartPort(dkcKind);
            if (wpno < 0) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getMakePortNumberParameters", "getJettyStartPort error code[" + String.valueOf(wpno) + "]");
                result = false;
            } else {
                wkval = " -Djetty.port=" + String.valueOf(wpno);
                execCmdList.get(0).append(wkval);
            }
            int[] portNoArray = SJsnctrlSnWebAppController.getJettyStopPort(dkcKind);
            wpno = portNoArray[0];
            if (wpno < 0) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getMakePortNumberParameters", "getJettyStopPort error code[" + String.valueOf(wpno) + "]");
                result = false;
            } else {
                wkval = " -DSTOP.PORT=" + String.valueOf(wpno);
                execCmdList.get(0).append(wkval);
                execCmdList.get(1).append(wkval);
                wkval = " -DSTOP.PORT=" + String.valueOf(portNoArray[1]);
                execCmdList.get(2).append(wkval);
            }
        }
        catch (Exception ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getMakePortNumberParameters", "Exception.", (Throwable)ex);
            result = false;
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getMakePortNumberParameters", "end.");
        if (!result) {
            execCmdList = null;
        }
    }

    private static void getMakeOtherParameters() {
        String LOG_SUBTITLE = "getMakeOtherParameters";
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getMakeOtherParameters", "start.");
        String wkval = " -DSTOP.KEY=\"sn2jetty\"";
        execCmdList.get(0).append(wkval);
        execCmdList.get(1).append(wkval);
        execCmdList.get(2).append(wkval);
        wkval = " --stop";
        execCmdList.get(1).append(wkval);
        execCmdList.get(2).append(wkval);
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getMakeOtherParameters", "end.");
    }

    private static void getCommmandLine() {
        String LOG_SUBTITLE = "getCommmandLine";
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getCommmandLine", "start.");
        execCmdList = new ArrayList<StringBuilder>();
        execCmdList.add(new StringBuilder());
        execCmdList.add(new StringBuilder());
        execCmdList.add(new StringBuilder());
        SJsnctrlSnWebAppController.getMakeProgramParameters();
        if (execCmdList != null) {
            SJsnctrlSnWebAppController.getMakeConfFileParameters();
        }
        if (execCmdList != null) {
            SJsnctrlSnWebAppController.getMakeWorkDirectoryParameters();
        }
        if (execCmdList != null) {
            SJsnctrlSnWebAppController.getMakePortNumberParameters();
        }
        if (execCmdList != null) {
            SJsnctrlSnWebAppController.getMakeOtherParameters();
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getCommmandLine", "end.");
    }

    public static String getMoveUpPathNoLogging(String path, int mlevel) {
        String curdir = path;
        try {
            for (int i = 0; i < mlevel; ++i) {
                File currentDirectory = new File(curdir);
                if ((curdir = currentDirectory.getParent()) != null) continue;
                curdir = "";
                break;
            }
        }
        catch (Exception ex) {
            curdir = "";
        }
        if (curdir == null) {
            curdir = "";
        } else if (!"".equals(curdir)) {
            curdir = SJsnctrlSnWebAppController.endsWithFileSeparator(curdir);
        }
        return curdir;
    }

    private static void initializeJettyLog() {
        SJcCustomLoggerInterface loggerJetty = SJcLogUty.getLogger((String)JETTY_LOG);
        SJcCustomLoggerInterface logger_err_Jetty = SJcLogUty.getLogger((String)JETTY_ERR_LOG);
        SJcTomcatOutputStream os = new SJcTomcatOutputStream((SJcLoggerInterface)loggerJetty);
        PrintStream ps = new PrintStream((OutputStream)os);
        SJcTomcatOutputStream osr = new SJcTomcatOutputStream((SJcLoggerInterface)logger_err_Jetty);
        PrintStream psr = new PrintStream((OutputStream)osr);
        System.setOut(ps);
        System.setErr(psr);
    }

    private static void deleteJnaTmpFile() {
        File file;
        File[] jFiles;
        String LOG_SUBTITLE = "deleteJnaTmpFile";
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "deleteJnaTmpFile", "Start.");
        String tmpDir = dkcPath + SJsnctrlSnConst.SJ_DIR_NAME_SN2_WORK;
        if (tmpDir != null && (jFiles = (file = new File(tmpDir)).listFiles(SJsnctrlSnWebAppController.getFileRegexFilter(REGEX))) != null) {
            for (File jFile : jFiles) {
                boolean result = jFile.delete();
                STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "deleteJnaTmpFile", "File = " + jFile.getName() + " [" + result + "]");
            }
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "deleteJnaTmpFile", "End.");
    }

    private static FilenameFilter getFileRegexFilter(String regex) {
        final String regex_ = regex;
        return new FilenameFilter(){

            public boolean accept(File dir, String name) {
                boolean ret = name.matches(regex_);
                return ret;
            }
        };
    }

    private static int getJettyStartPort(String dkcid) {
        int port = SJsncPortManager.getPortNo((String)"DeviceJettyStart", (String)dkcid, (boolean)false);
        port = port < 0 ? SJsnctrlSnWebAppController.regetPort("DeviceJettyStart", dkcid) : SJsnctrlSnWebAppController.checkPort("DeviceJettyStart", dkcid, port);
        return port;
    }

    private static int[] getJettyStopPort(String dkcid) {
        int[] port = new int[2];
        int port_pre = -1;
        int port_assign = SJsncPortManager.getPortNo((String)"DeviceJettyStop", (String)dkcid, (boolean)false);
        if (port_assign < 0) {
            port_assign = SJsnctrlSnWebAppController.regetPort("DeviceJettyStop", dkcid);
        } else {
            port_pre = port_assign;
            port_assign = SJsnctrlSnWebAppController.checkPort("DeviceJettyStop", dkcid, port_assign);
        }
        port[0] = port_assign;
        port[1] = port_pre == -1 ? port_assign : port_pre;
        return port;
    }

    private static int regetPort(String funcName, String dkcid) {
        int port = SJsncPortManager.regetPortNo((String)funcName, (String)dkcid, (boolean)false);
        if (port < 0) {
            if ("DeviceJettyStart".equals(funcName)) {
                SJcTRLogUty.error((String)"Web Application Server", (String)"TRSTNA000008", (String)"Failed : Failed to start a Storage Navigator. Because the starting port is alerady in use.", (String)"jetty");
            } else {
                SJcTRLogUty.error((String)"Web Application Server", (String)"TRSTNA000009", (String)"Failed : Failed to start a Storage Navigator. Because the stopping port is alerady in use.", (String)"jetty");
            }
        }
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int checkPort(String funcName, String dkcid, int port) {
        String LOG_SUBTITLE = "checkPort";
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(port);
        }
        catch (Exception e) {
            STD_LOGGER.warn(LOG_FUNCTION, LOG_TITLE, "checkPort", "Port connection failed. port = " + port, (Throwable)e);
            port = SJsnctrlSnWebAppController.regetPort(funcName, dkcid);
        }
        finally {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException ex) {
                STD_LOGGER.warn(LOG_FUNCTION, LOG_TITLE, "checkPort", "Exception occured. ", (Throwable)ex);
            }
        }
        return port;
    }

    private static void exportProcessInfo() {
        String LOG_SUBTITLE = "exportProcessInfo";
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "exportProcessInfo", "Start.");
        ArrayList<String> execBatcmd = new ArrayList();
        String cmnDataPath = mappInstPath + SJsnctrlSnConst.SJ_DIR_NAME_CMN_DATA;
        String batFile = SJcPropertiesUty.getPropertiesString("COMMAND_EXPORT_DIR");
        if (batFile == null) {
            STD_LOGGER.warn(LOG_FUNCTION, LOG_TITLE, "exportProcessInfo", "batFile Undefined.");
            return;
        }
        String batFilePath = SJsnctrlSnWebAppController.endsWithFileSeparator(cmnDataPath) + batFile;
        execBatcmd = SJcExecCmdUty.createStrcmd("cmd", "/c", batFilePath, "2>&1");
        SJcExecCmdUty.execCmd(execBatcmd);
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "exportProcessInfo", "End.");
    }
}

