/*
 * Decompiled with CFR 0.152.
 */
package sanproject.snctrl.utility;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;

public class SJsnctrlProcessLockUtility {
    private static final String LOG_FUNCTION = "JettyStop";
    private static final String LOG_TITLE = SJsnctrlProcessLockUtility.class.getSimpleName();
    private File lockFile = null;
    private FileOutputStream fos = null;
    private FileChannel fchan = null;
    private FileLock flock = null;
    private static SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();

    public SJsnctrlProcessLockUtility(String path) throws Exception {
        String LOG_SUBTITLE = "SJsnctrlProcessLockUtility";
        try {
            this.lockFile = new File(path);
            this.fos = new FileOutputStream(this.lockFile);
            this.fchan = this.fos.getChannel();
        }
        catch (Exception ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "SJsnctrlProcessLockUtility", "Path is undefined. Path:[" + path + "]", (Throwable)ex);
            throw ex;
        }
    }

    public synchronized void getLock() throws Exception {
        String LOG_SUBTITLE = "getLock";
        try {
            if (this.fchan == null) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getLock", "fchan is null.");
                this.releaseEnd();
                throw new Exception();
            }
            this.flock = this.fchan.lock();
        }
        catch (IOException ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getLock", "Lock IOException.", (Throwable)ex);
            this.releaseEnd();
            throw ex;
        }
    }

    public synchronized boolean tryLock() throws IOException {
        String LOG_SUBTITLE = "tryLock";
        boolean result = true;
        try {
            if (this.fchan != null) {
                this.flock = this.fchan.tryLock();
            }
        }
        catch (IOException ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "tryLock", "tryLock IOException.", (Throwable)ex);
            this.releaseEnd();
            throw ex;
        }
        if (null == this.flock) {
            result = false;
        }
        return result;
    }

    public synchronized void release() throws IOException {
        String LOG_SUBTITLE = "release";
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "release", "Start.");
        try {
            if (this.flock != null) {
                this.flock.release();
            }
        }
        catch (IOException ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "release", "Lock release IOException.", (Throwable)ex);
            throw ex;
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "release", "End.");
    }

    public synchronized void releaseEnd() {
        String LOG_SUBTITLE = "releaseEnd";
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "releaseEnd", "Start.");
        if (this.flock != null) {
            try {
                this.flock.release();
            }
            catch (IOException ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "releaseEnd", "Lock release IOException.", (Throwable)ex);
            }
        }
        if (this.fchan != null) {
            try {
                this.fchan.close();
            }
            catch (IOException ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "releaseEnd", "Channel close IOException.", (Throwable)ex);
            }
        }
        if (this.fos != null) {
            try {
                this.fos.close();
            }
            catch (IOException ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "releaseEnd", "Stream close IOException.", (Throwable)ex);
            }
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "releaseEnd", "End.");
    }
}

