/*
 * Decompiled with CFR 0.152.
 */
package sanproject.syslog.sender;

import java.io.File;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.syslog.sender.HandshakeException;
import sanproject.syslog.sender.KeyStoreException;
import sanproject.syslog.sender.SubjectAltNameIPException;
import sanproject.syslog.sender.TCPConnectException;
import sanproject.syslog.sender.TLSSenderException;
import sanproject.syslog.sender.TrustStoreException;
import sanproject.syslog.sender.WriteException;

public class TLSSender {
    private SSLSocket m_SSLsocket = null;
    private byte m_UpdateCertificate = 0;
    private String m_KeyStoreName = null;
    private String m_TrustStoreName = null;
    private SJcLoggerInterface m_Logger = null;
    private boolean m_bUpdateCheck = false;
    private long m_KeyStoreLastModified = 0L;
    private long m_TrustStoreLastModified = 0L;
    static final String TLS_VERSION = "TLSv1.2";
    static final int ALTNAME_IP = 7;
    static final String STORE_FILE_DIR_PATH = "san\\syslog\\";
    static final String KEY_STORE_PASSWORD = "hitachi2syslog1t0l0s2A3u1d0i0t2p";
    static final String TRUST_STORE_PASSWOR = "I2n1b0a0n2d3syslog1t0l0shitachip";
    static final int CLOCKS_PER_SEC = 1000;
    static final int SEND_BUFFER_SIZE = 1;
    static final byte[] CHECK_DATA = new byte[]{48};
    static final String DISABLED_CIPHERSUITES_3DES = "3DES";

    public TLSSender(String string, String string2, String string3) {
        this.m_KeyStoreName = string;
        this.m_TrustStoreName = string2;
        this.m_Logger = SJcLogUty.getLogger(string3);
    }

    public int Send(byte[] byArray, byte[] byArray2, int n, byte by, byte by2) {
        int n2 = 0;
        boolean bl = by != this.m_UpdateCertificate;
        try {
            InetAddress inetAddress = InetAddress.getByAddress(byArray2);
            if (bl && 0L != this.m_KeyStoreLastModified && 0L != this.m_TrustStoreLastModified) {
                this.m_bUpdateCheck = true;
            }
            if (null != this.m_SSLsocket) {
                if (this.m_bUpdateCheck) {
                    File file = new File(SJcEnvUty.getSnBasePath() + STORE_FILE_DIR_PATH + this.m_KeyStoreName);
                    File file2 = new File(SJcEnvUty.getSnBasePath() + STORE_FILE_DIR_PATH + this.m_TrustStoreName);
                    if (this.m_KeyStoreLastModified != file.lastModified() || this.m_TrustStoreLastModified != file2.lastModified()) {
                        bl = true;
                        this.m_KeyStoreLastModified = 0L;
                        this.m_TrustStoreLastModified = 0L;
                        this.m_bUpdateCheck = false;
                    } else {
                        bl = false;
                    }
                }
                if (!this.m_SSLsocket.getInetAddress().equals(inetAddress) || bl || n != this.m_SSLsocket.getPort()) {
                    this.Shutdown();
                }
            }
            if (null == this.m_SSLsocket) {
                int n3 = by2 * 1000;
                this.m_UpdateCertificate = by;
                this.Connect(inetAddress, n, n3);
            }
            this.Write(byArray);
        }
        catch (TLSSenderException tLSSenderException) {
            n2 = tLSSenderException.GetErrID();
            this.m_Logger.error("TLSSender.Send", "TLSSenderException", "ErrId=" + String.valueOf(n2), tLSSenderException.getMessage());
            this.Shutdown();
        }
        catch (Exception exception) {
            n2 = 7;
            this.m_Logger.error("TLSSender.Send", "Exception", "ErrId=" + String.valueOf(n2), "", exception);
            this.Shutdown();
        }
        return n2;
    }

    public void Connect(InetAddress inetAddress, int n, int n2) throws KeyStoreException, TrustStoreException, TCPConnectException, HandshakeException, SubjectAltNameIPException {
        String[] stringArray;
        String[] stringArray2;
        KeyManager[] keyManagerArray = this.GetKeyManager();
        TrustManager[] trustManagerArray = this.GetTrustManager();
        try {
            stringArray2 = SSLContext.getInstance(TLS_VERSION);
            stringArray2.init(keyManagerArray, trustManagerArray, null);
            this.m_SSLsocket = (SSLSocket)stringArray2.getSocketFactory().createSocket();
            stringArray = new InetSocketAddress(inetAddress, n);
            this.m_SSLsocket.connect((SocketAddress)stringArray, n2);
        }
        catch (Exception exception) {
            this.m_Logger.error("TLSSender.Connect", "Exception", "TCPConnectException", "", exception);
            throw new TCPConnectException("TCP Conncet Err.");
        }
        try {
            stringArray2 = this.getEnableSuites(this.m_SSLsocket.getSupportedCipherSuites());
            stringArray = new String[1 + stringArray2.length];
            stringArray[0] = "TLS_RSA_WITH_AES_128_CBC_SHA";
            System.arraycopy(stringArray2, 0, stringArray, 1, stringArray2.length);
            this.m_SSLsocket.setEnabledCipherSuites(stringArray);
            this.m_SSLsocket.setUseClientMode(true);
            this.m_SSLsocket.startHandshake();
            this.m_SSLsocket.setSendBufferSize(1);
        }
        catch (Exception exception) {
            this.m_Logger.error("TLSSender.Connect", "Exception", "HandshakeException", "", exception);
            throw new HandshakeException("Handshake Err.");
        }
        this.CheckSubjectAltNameIP();
    }

    private String[] getEnableSuites(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].indexOf(DISABLED_CIPHERSUITES_3DES) != -1) continue;
            arrayList.add(stringArray[i]);
        }
        String[] stringArray2 = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray2[i] = (String)arrayList.get(i);
        }
        return stringArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Shutdown() {
        try {
            if (null != this.m_SSLsocket && this.m_SSLsocket.isConnected() && !this.m_SSLsocket.isClosed()) {
                this.m_SSLsocket.close();
            }
        }
        catch (Exception exception) {
            this.m_Logger.error("TLSSender.Shutdown", "Exception", "", "", exception);
        }
        finally {
            this.m_SSLsocket = null;
        }
    }

    private void Write(byte[] byArray) throws WriteException {
        try {
            this.m_SSLsocket.getOutputStream().write(CHECK_DATA);
            this.m_SSLsocket.getOutputStream().flush();
            this.m_SSLsocket.getOutputStream().write(byArray);
            this.m_SSLsocket.getOutputStream().flush();
        }
        catch (Exception exception) {
            this.m_Logger.error("TLSSender.Write", "Exception", "", "", exception);
            throw new WriteException("Write Err.");
        }
    }

    private KeyManager[] GetKeyManager() throws KeyStoreException {
        try {
            File file = new File(SJcEnvUty.getSnBasePath() + STORE_FILE_DIR_PATH + this.m_KeyStoreName);
            if (file.lastModified() != this.m_KeyStoreLastModified) {
                this.m_KeyStoreLastModified = file.lastModified();
                this.m_bUpdateCheck = false;
            }
            FileInputStream fileInputStream = null;
            KeyStore keyStore = null;
            char[] cArray = KEY_STORE_PASSWORD.toCharArray();
            try {
                fileInputStream = new FileInputStream(file);
                keyStore = KeyStore.getInstance("JKS");
                keyStore.load(fileInputStream, cArray);
            }
            catch (Exception exception) {
                throw exception;
            }
            finally {
                if (null != fileInputStream) {
                    try {
                        fileInputStream.close();
                    }
                    catch (Exception exception) {
                        this.m_Logger.error("TLSSender.GetKeyManager", "Exception", "keyStoreStream.close", "", exception);
                    }
                }
            }
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            keyManagerFactory.init(keyStore, cArray);
            return keyManagerFactory.getKeyManagers();
        }
        catch (Exception exception) {
            this.m_Logger.error("TLSSender.GetKeyManager", "Exception", "KeyStoreException", "", exception);
            throw new KeyStoreException("GetKeyManager Err.");
        }
    }

    private TrustManager[] GetTrustManager() throws TrustStoreException {
        try {
            File file = new File(STORE_FILE_DIR_PATH + this.m_TrustStoreName);
            if (file.lastModified() != this.m_TrustStoreLastModified) {
                this.m_TrustStoreLastModified = file.lastModified();
                this.m_bUpdateCheck = false;
            }
            FileInputStream fileInputStream = null;
            KeyStore keyStore = null;
            char[] cArray = TRUST_STORE_PASSWOR.toCharArray();
            try {
                fileInputStream = new FileInputStream(file);
                keyStore = KeyStore.getInstance("JKS");
                keyStore.load(fileInputStream, cArray);
            }
            catch (Exception exception) {
                throw exception;
            }
            finally {
                if (null != fileInputStream) {
                    try {
                        fileInputStream.close();
                    }
                    catch (Exception exception) {
                        this.m_Logger.error("TLSSender.GetTrustManager", "Exception", "trustStoreStream.close", "", exception);
                    }
                }
            }
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
            trustManagerFactory.init(keyStore);
            return trustManagerFactory.getTrustManagers();
        }
        catch (Exception exception) {
            this.m_Logger.error("TLSSender.GetTrustManager", "Exception", "TrustStoreException", "", exception);
            throw new TrustStoreException("GetTrustManager Err.");
        }
    }

    private void CheckSubjectAltNameIP() throws SubjectAltNameIPException {
        try {
            X509Certificate x509Certificate = (X509Certificate)this.m_SSLsocket.getSession().getPeerCertificates()[0];
            Collection<List<?>> collection = x509Certificate.getSubjectAlternativeNames();
            for (List<?> list : collection) {
                if (7 != (Integer)list.get(0)) continue;
                String string = (String)list.get(1);
                String string2 = this.m_SSLsocket.getInetAddress().getHostAddress();
                if (!string2.equalsIgnoreCase(string)) continue;
                return;
            }
            throw new SubjectAltNameIPException("Check SubjectAltNameIP Err.");
        }
        catch (Exception exception) {
            if (exception instanceof SubjectAltNameIPException) {
                throw (SubjectAltNameIPException)exception;
            }
            this.m_Logger.error("TLSSender.CheckSubjectAltNameIP", "Exception", "SubjectAltNameIPException", "", exception);
            throw new SubjectAltNameIPException("Check SubjectAltNameIP Err.");
        }
    }
}

