/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.codegen;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class GetFilesInDirectory {
    public static final boolean debug = Boolean.getBoolean("Debug");
    private static final String DEBUG = "Debug";

    public static List<String> getFileNames(Path dir, FileCallback cb) throws IOException {
        ArrayList<String> fileNames = new ArrayList<String>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            for (Path path : stream) {
                if (path.toFile().isDirectory()) {
                    if (null == cb || cb.shouldRecurseIntoDirectory(path)) {
                        fileNames.addAll(GetFilesInDirectory.getFileNames(path, cb));
                        continue;
                    }
                    if (!debug) continue;
                    System.out.println("Skipping directory: " + path);
                    continue;
                }
                File file = path.toFile();
                if (null == cb || cb.shouldAddFile(file)) {
                    fileNames.add(file.getCanonicalPath());
                    continue;
                }
                if (!debug) continue;
                System.out.println("Skipping file: " + file);
            }
        }
        return fileNames;
    }

    public static List<String> getFileNames(String dir, FileCallback cb) throws IOException {
        File srcDir = new File(dir);
        return GetFilesInDirectory.getFileNames(srcDir.toPath(), cb);
    }

    public static void main(String[] args) {
        String path = 0 != args.length ? args[0] : System.getProperty("user.dir");
        try {
            File file = new File(path);
            if (!file.isDirectory()) {
                System.err.println(path + " is not a directory!");
                System.exit(1);
            }
            Path dir = file.toPath();
            List<String> fileNames = GetFilesInDirectory.getFileNames(dir, new FileCallback(){

                @Override
                public boolean shouldAddFile(File theFile) {
                    return theFile.getAbsolutePath().endsWith(".class");
                }

                @Override
                public boolean shouldRecurseIntoDirectory(Path theDir) {
                    return true;
                }
            });
            System.out.println(System.lineSeparator() + "Files in " + path);
            for (String fileName : fileNames) {
                System.out.println("\t" + fileName);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static interface FileCallback {
        public boolean shouldAddFile(File var1);

        public boolean shouldRecurseIntoDirectory(Path var1);
    }
}

