/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.codegen;

import com.ws.cim.codegen.FileFinder;
import com.ws.cim.codegen.GetFilesInDirectory;
import com.ws.cim.codegen.WSDiagnosticListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.tools.JavaCompiler;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class JCompiler {
    private static final String JAVA_FILE_EXTENSION = ".java";
    private static final String SOURCEPATH = "-sourcepath";
    private static final String DESTINATIONPATH = "-d";
    private final List<String> cmdLine;
    private final JavaCompiler javaCompiler;
    private String dirs2Exclude;

    public static void main(String[] args) {
        try {
            JCompiler compiler = new JCompiler(args, "bin|\\.settings");
            compiler.compile();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public JCompiler(String excludeDirs) throws RuntimeException {
        this.setExcludeDirs(excludeDirs);
        this.cmdLine = new ArrayList<String>();
        this.javaCompiler = ToolProvider.getSystemJavaCompiler();
        if (null == this.javaCompiler) {
            throw new RuntimeException("Unable to find a Java compiler, is program being run by the JDK?");
        }
    }

    public JCompiler(String[] args) throws RuntimeException {
        this((String)null);
        if (null != args) {
            this.cmdLine.addAll(Arrays.asList(args));
        }
    }

    public JCompiler(String[] args, String excludeDirs) throws RuntimeException {
        this(excludeDirs);
        if (null != args) {
            this.cmdLine.addAll(Arrays.asList(args));
        }
    }

    public boolean compile() throws FileNotFoundException, IOException {
        String destPath;
        String srcPath;
        int idx = this.cmdLine.indexOf(SOURCEPATH);
        if (-1 != idx) {
            srcPath = this.cmdLine.get(idx + 1);
        } else {
            srcPath = System.getProperty("user.dir");
            this.cmdLine.add(SOURCEPATH);
            this.cmdLine.add(srcPath);
        }
        idx = this.cmdLine.indexOf(DESTINATIONPATH);
        if (-1 != idx) {
            destPath = this.cmdLine.get(idx + 1);
            File dir = new File(destPath);
            if (!(dir.exists() && dir.isDirectory() || dir.mkdirs())) {
                throw new FileNotFoundException("Failed to create output directory: " + destPath);
            }
        } else {
            destPath = System.getProperty("user.dir");
            this.cmdLine.add(DESTINATIONPATH);
            this.cmdLine.add(destPath);
        }
        FileFinder excluder = new FileFinder(JAVA_FILE_EXTENSION, this.dirs2Exclude);
        List<String> javaFiles = GetFilesInDirectory.getFileNames(srcPath, (GetFilesInDirectory.FileCallback)excluder);
        WSDiagnosticListener diagnosticListener = new WSDiagnosticListener();
        StandardJavaFileManager fileMgr = this.javaCompiler.getStandardFileManager(diagnosticListener, null, null);
        System.out.println("Compiling " + javaFiles.size() + " files with these options " + this.cmdLine);
        JavaCompiler.CompilationTask compilation = this.javaCompiler.getTask(null, fileMgr, diagnosticListener, this.cmdLine, null, fileMgr.getJavaFileObjectsFromStrings(javaFiles));
        boolean ret = compilation.call();
        if (ret) {
            System.out.println("Successfully compiled " + javaFiles.size() + " files");
            System.out.println("Output files should be in " + destPath);
        } else {
            System.err.println("Compilation failed!" + System.lineSeparator());
            diagnosticListener.displayDiagnostics();
        }
        return ret;
    }

    public void setExcludeDirs(String excludeDirs) {
        this.dirs2Exclude = excludeDirs;
    }
}

