/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.codegen;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;

public class WSDiagnosticListener
implements DiagnosticListener<JavaFileObject> {
    private final List<Diagnostic<? extends JavaFileObject>> diagnostics = Collections.synchronizedList(new ArrayList());
    private long numErrors = 0L;
    private long numWarnings = 0L;

    private void createDiagnosticMessage(StringBuilder builder, Diagnostic<? extends JavaFileObject> diag) {
        builder.append("\t");
        builder.append(diag.getSource().getName());
        builder.append(":");
        builder.append(diag.getLineNumber());
        builder.append(System.lineSeparator());
        builder.append("\t\t");
        builder.append(diag.getMessage(null));
        builder.append(System.lineSeparator());
    }

    public void displayDiagnostics() {
        this.displayDiagnostics(System.err);
    }

    public void displayDiagnostics(PrintStream ps) {
        StringBuilder warnings = new StringBuilder();
        StringBuilder errors = new StringBuilder();
        for (Diagnostic<? extends JavaFileObject> diag : this.diagnostics) {
            if (diag.getKind() == Diagnostic.Kind.ERROR) {
                ++this.numErrors;
                this.createDiagnosticMessage(errors, diag);
                continue;
            }
            if (diag.getKind() != Diagnostic.Kind.WARNING) continue;
            ++this.numWarnings;
            this.createDiagnosticMessage(warnings, diag);
        }
        ps.println(this.numErrors + " errors:");
        ps.println(errors.toString());
        ps.println(this.numWarnings + " warnings:");
        ps.println(warnings.toString());
    }

    @Override
    public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
        if (null != diagnostic) {
            this.diagnostics.add(diagnostic);
        }
    }
}

