/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.codegen.cmpi;

import com.ws.cim.codegen.java.JavaCodeWriterConstants;
import com.ws.cim.codegen.jsr48.CodeGeneratorConstants;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Iterator;
import javax.cim.CIMClass;
import javax.cim.CIMClassProperty;
import javax.cim.CIMDataType;
import javax.cim.CIMMethod;
import javax.cim.CIMParameter;

public class CHeaderCodeGenerator {
    private static final String DESCRIPTION = "Description";
    private final String NEWLINE = System.getProperty("line.separator");
    private final CIMClass mClass;
    private final String mOutdir;

    public CHeaderCodeGenerator(CIMClass pCc, String pOutdir) {
        this.mOutdir = pOutdir;
        this.mClass = pCc;
    }

    public void generateCode() throws Exception {
        File dir = new File(this.mOutdir);
        if (!(dir.exists() && dir.isDirectory() || dir.mkdir())) {
            throw new IllegalArgumentException("could not create directory: " + this.mOutdir);
        }
        String fileName = this.mOutdir + File.separator + this.mClass.getName() + ".h";
        File cFile = new File(fileName);
        if (cFile.exists()) {
            cFile.delete();
        }
        BufferedWriter out = new BufferedWriter(new FileWriter(fileName, false));
        StringBuffer strBuffer = new StringBuffer();
        String classComment = this.mClass.hasQualifier(DESCRIPTION) ? this.mClass.getQualifier(DESCRIPTION).getValue().toString() : " ";
        Iterator<String> commentIterator = JavaCodeWriterConstants.getLineIterator(classComment, 78, 0, true);
        while (commentIterator.hasNext()) {
            out.write(commentIterator.next());
        }
        out.newLine();
        String className = this.mClass.getName();
        strBuffer.append("#ifndef _" + className.toUpperCase() + "_H_" + this.NEWLINE);
        strBuffer.append("#define _" + className.toUpperCase() + "_H_" + this.NEWLINE + this.NEWLINE);
        this.addExportSymbol(strBuffer);
        strBuffer.append("#ifdef __cplusplus" + this.NEWLINE);
        strBuffer.append("#define EXTERN_C extern \"C\" {" + this.NEWLINE);
        strBuffer.append("EXTERN_C" + this.NEWLINE);
        strBuffer.append("#endif" + this.NEWLINE + this.NEWLINE);
        strBuffer.append("#define CCN_" + className.toUpperCase() + " \"" + className + "\"");
        strBuffer.append(this.NEWLINE);
        this.addProperties(strBuffer);
        this.addMethods(strBuffer);
        strBuffer.append("/* Structure which represents an instance of " + className + " */");
        strBuffer.append(this.NEWLINE);
        strBuffer.append("typedef struct {" + this.NEWLINE);
        for (CIMClassProperty cp : this.mClass.getProperties()) {
            CIMDataType cdt = cp.getDataType();
            String dt = CodeGeneratorConstants.CDATATYPE[cdt.getType()];
            strBuffer.append("\t" + dt + (cdt.isArray() ? "*" : "") + " " + "m" + cp.getName() + ";" + this.NEWLINE);
            if (!cdt.isArray()) continue;
            strBuffer.append("\tsize_t mNumberOf" + cp.getName() + ";" + this.NEWLINE);
        }
        strBuffer.append("}" + className + ";" + this.NEWLINE);
        strBuffer.append(this.NEWLINE);
        this.addProviderPrototypes(strBuffer);
        strBuffer.append("#ifdef __cplusplus" + this.NEWLINE);
        strBuffer.append("#define END_EXTERN_C }" + this.NEWLINE);
        strBuffer.append("END_EXTERN_C" + this.NEWLINE);
        strBuffer.append("#undef EXTERN_C" + this.NEWLINE);
        strBuffer.append("#undef END_EXTERN_C" + this.NEWLINE);
        strBuffer.append("#endif" + this.NEWLINE);
        strBuffer.append(this.NEWLINE);
        strBuffer.append("#endif /* _" + className + "_ */");
        out.write(strBuffer.toString());
        out.newLine();
        out.close();
    }

    private void addProviderPrototypes(StringBuffer pStr) {
        String[] providerArr = new String[]{"Instance", "Indication", "Association", "Method"};
        String strClassName = this.mClass.getName().substring(4).toUpperCase();
        String strMacro = "CMPI_" + strClassName + "_EXPORT CMPI";
        String startText = "*" + this.mClass.getName() + "_Create_";
        String midText = "MI(CMPIBroker *pBrk, ";
        String endText = "\tCMPIContext *pCtx, CMPIStatus *pStatus);";
        for (int index = 0; index < 4; ++index) {
            if (!(index == 2 && this.mClass.isAssociation() || index == 3 && this.mClass.getMethodCount() > 0) && index >= 2) continue;
            pStr.append(strMacro + providerArr[index] + "MI" + this.NEWLINE);
            pStr.append("\t" + this.controlLine(startText + providerArr[index] + midText));
            pStr.append(endText);
            pStr.append(this.NEWLINE);
            pStr.append(this.NEWLINE);
        }
    }

    private String controlLine(String pStr) {
        int maxLen = 78;
        int nTab = 0;
        StringBuffer strRet = new StringBuffer();
        Iterator<String> methodIterator = JavaCodeWriterConstants.getLineIterator(pStr, maxLen, nTab, false);
        while (methodIterator.hasNext()) {
            strRet.append(methodIterator.next());
        }
        return strRet.toString();
    }

    private void addExportSymbol(StringBuffer pStr) {
        pStr.append("#ifdef CMPI_PLATFORM_WIN32_IX86_MSVC" + this.NEWLINE);
        String strClassName = this.mClass.getName().substring(4).toUpperCase();
        pStr.append("#define CMPI_" + strClassName + "_EXPORT __declspec(dllexport)" + this.NEWLINE);
        if (this.hasDateTimeType()) {
            pStr.append("\ttypedef __int64 LONGLONG;" + this.NEWLINE);
            pStr.append("\ttypedef unsigned __int64 ULONGLONG;" + this.NEWLINE);
        }
        pStr.append("\t/* map strcasecmp to _stricmp on Windows */" + this.NEWLINE);
        pStr.append("\t#ifndef strcasecmp" + this.NEWLINE);
        pStr.append("\t\t#define strcasecmp _stricmp" + this.NEWLINE);
        pStr.append("\t#endif /* strcasecmp */" + this.NEWLINE);
        pStr.append("#else" + this.NEWLINE);
        pStr.append("#define CMPI_" + strClassName + "_EXPORT" + this.NEWLINE);
        if (this.hasDateTimeType()) {
            pStr.append("typedef long long LONGLONG;" + this.NEWLINE);
            pStr.append("typedef unsigned long long ULONGLONG;" + this.NEWLINE);
        }
        pStr.append("#endif /* CMPI_PLATFORM_WIN32_IX86_MSVC */" + this.NEWLINE + this.NEWLINE);
    }

    private void addProperties(StringBuffer pStr) {
        if (this.mClass.getProperties() != null) {
            for (CIMClassProperty cp : this.mClass.getProperties()) {
                String propQualifier = cp.hasQualifier(DESCRIPTION) ? cp.getQualifier(DESCRIPTION).getValue().toString() : "";
                String propValue = this.getValue(cp);
                StringBuilder propComment = new StringBuilder();
                propComment.append(cp.getName());
                propComment.append(" ");
                propComment.append(CodeGeneratorConstants.CMPITYPE[cp.getDataType().getType()] + " " + propValue);
                if (propValue.equals("")) {
                    propComment.append("\n\n");
                } else {
                    propComment.append(" \n\n");
                }
                propComment.append(propQualifier);
                Iterator<String> commentIterator = JavaCodeWriterConstants.getLineIterator(propComment.toString(), 78, 0, true);
                while (commentIterator.hasNext()) {
                    pStr.append(commentIterator.next());
                }
                pStr.append("#define CPN_" + cp.getName().toUpperCase() + " " + "\"" + cp.getName() + "\"" + this.NEWLINE);
            }
        }
    }

    private String getValue(CIMClassProperty<?> cp) {
        StringBuffer strRet = new StringBuffer();
        try {
            if (cp.getValue() != null) {
                if (cp.getDataType().isArray()) {
                    Object[] strArr = (Object[])cp.getValue();
                    strRet.append("{");
                    for (int index = 0; index < strArr.length; ++index) {
                        strRet.append(strArr[index]);
                        if (index >= strArr.length - 1) continue;
                        strRet.append(", ");
                    }
                    strRet.append("}");
                } else if (cp.getDataType().getType() == 14 || cp.getDataType().getType() == 17) {
                    strRet.append(cp.getDataType().getRefClassName());
                } else {
                    strRet.append(cp.getValue().toString());
                }
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        return strRet.toString();
    }

    private void addMethods(StringBuffer pStr) {
        if (this.mClass.getMethodCount() > 0) {
            StringBuilder strArguments = new StringBuilder();
            ArrayList methodParam = new ArrayList();
            for (CIMMethod cm : this.mClass.getMethods()) {
                for (CIMParameter mparam : cm.getParameters()) {
                    methodParam.add(mparam);
                }
                this.addParameters(methodParam, strArguments, cm.getName());
                methodParam.clear();
                String methodQualifier = cm.hasQualifier(DESCRIPTION) ? cm.getQualifierValue(DESCRIPTION).toString() : "";
                String methodComment = CodeGeneratorConstants.CMPITYPE[cm.getDataType().getType()] + " " + cm.getName() + "()" + " \n\n" + methodQualifier;
                Iterator<String> commentIterator = JavaCodeWriterConstants.getLineIterator(methodComment, 78, 0, true);
                while (commentIterator.hasNext()) {
                    pStr.append(commentIterator.next());
                }
                pStr.append("#define CMN_" + cm.getName().toUpperCase() + " " + "\"" + cm.getName() + "\"" + this.NEWLINE);
            }
            pStr.append(strArguments.toString());
        }
    }

    private void addParameters(ArrayList<CIMParameter<?>> pMethodParam, StringBuilder pStr, String pMethodName) {
        for (CIMParameter<?> cParam : pMethodParam) {
            String paramQualifier = cParam.hasQualifier(DESCRIPTION) ? cParam.getQualifierValue(DESCRIPTION).toString() : "";
            String paramComment = cParam.getName() + " " + CodeGeneratorConstants.CMPITYPE[cParam.getDataType().getType()] + " \n\n" + paramQualifier;
            Iterator<String> commentIterator = JavaCodeWriterConstants.getLineIterator(paramComment, 78, 0, true);
            while (commentIterator.hasNext()) {
                pStr.append(commentIterator.next());
            }
            pStr.append("#define CAN_" + pMethodName.toUpperCase() + "_" + cParam.getName().toUpperCase() + " " + "\"" + cParam.getName() + "\"" + this.NEWLINE);
        }
    }

    private boolean hasDateTimeType() {
        CIMClassProperty[] ccp;
        boolean oRet = false;
        for (CIMClassProperty ccpe : ccp = this.mClass.getProperties()) {
            String dataType = ccpe.getDataType().toString();
            if (!dataType.equals("datetime")) continue;
            oRet = true;
            break;
        }
        return oRet;
    }
}

