/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.codegen.cmpi;

import com.ws.cim.codegen.cmpi.AssociationMIGenerator;
import com.ws.cim.codegen.cmpi.CArgument;
import com.ws.cim.codegen.cmpi.CDataMember;
import com.ws.cim.codegen.cmpi.CFunction;
import com.ws.cim.codegen.cmpi.CFunctionBody;
import com.ws.cim.codegen.cmpi.IndicationMIGenerator;
import com.ws.cim.codegen.cmpi.InstanceMIGenerator;
import com.ws.cim.codegen.cmpi.MethodMIGenerator;
import com.ws.cim.codegen.java.JavaCodeWriterConstants;
import com.ws.cim.codegen.jsr48.CodeGeneratorConstants;
import java.util.ArrayList;
import javax.cim.CIMClass;
import javax.cim.CIMClassProperty;
import javax.cim.CIMDataType;
import javax.cim.CIMMethod;
import javax.cim.CIMParameter;

public class C_SourceFileGenerator {
    private final ArrayList<CFunction> mFunctionList;
    private final ArrayList<CDataMember> mDataMember;
    private final CIMClass mCIMClass;

    public C_SourceFileGenerator(CIMClass pCIMClass) {
        this.mCIMClass = pCIMClass;
        this.mFunctionList = new ArrayList();
        this.mDataMember = new ArrayList();
        this.setFunctions();
        this.setDataMember();
    }

    private void setFunctions() {
        InstanceMIGenerator instanceMI = new InstanceMIGenerator(this.mCIMClass);
        IndicationMIGenerator indicationMI = new IndicationMIGenerator(this.mCIMClass);
        AssociationMIGenerator associationMI = new AssociationMIGenerator(this.mCIMClass);
        MethodMIGenerator metohdMI = new MethodMIGenerator(this.mCIMClass);
        this.addCreateEmptyClassStructure();
        this.addFreeStructure();
        this.addGetTypeAsCMPIArray();
        this.addGetCMPIArrayAsType();
        this.addIsPropertyPresent();
        this.addGetSinglePath();
        this.addGetSingleInstance();
        this.mFunctionList.addAll(instanceMI.getFunctions());
        this.mFunctionList.addAll(indicationMI.getFunctions());
        if (this.mCIMClass.isAssociation()) {
            this.mFunctionList.addAll(associationMI.getFunctions());
        }
        if (this.mCIMClass.getMethodCount() > 0) {
            this.mFunctionList.addAll(metohdMI.getCIMClassFunctions());
            this.mFunctionList.addAll(metohdMI.getFunctions());
        }
        this.mFunctionList.add(instanceMI.createInstanceMI());
        this.mFunctionList.add(indicationMI.createIndicationMI());
        if (this.mCIMClass.isAssociation()) {
            this.mFunctionList.add(associationMI.createAssociationMI());
        }
        if (this.mCIMClass.getMethodCount() > 0) {
            this.mFunctionList.add(metohdMI.createMethodMI());
        }
    }

    private void setDataMember() {
        String comment = "Handle to the CMPI Broker";
        this.mDataMember.add(new CDataMember(comment, JavaCodeWriterConstants.TYPE.DEFAULT, true, true, "CMPIBroker", "*gBroker", "NULL"));
    }

    public ArrayList<CFunction> getFunctions() {
        return this.mFunctionList;
    }

    public ArrayList<CDataMember> getDataMembers() {
        return this.mDataMember;
    }

    private void addCreateEmptyClassStructure() {
        ArrayList<CArgument> arguments = new ArrayList<CArgument>();
        ArrayList<String> bText = new ArrayList<String>();
        arguments.add(new CArgument(false, " * pStatus", "CMPIStatus"));
        bText.add(this.mCIMClass.getName() + " *ret = NULL" + ";");
        bText.add("ret = calloc(1, sizeof(" + this.mCIMClass.getName() + ")" + ")" + ";");
        bText.add("if (ret != NULL) {");
        bText.add("CMSetStatus(pStatus, CMPI_RC_OK);");
        bText.add("}else {");
        bText.add("CMSetStatusWithChars(gBroker, pStatus, CMPI_RC_ERR_FAILED,");
        bText.add("\"Insf. Memory to allocate " + this.mCIMClass.getName() + "\")" + ";");
        bText.add("}");
        bText.add("return ret;");
        CFunctionBody body = new CFunctionBody(null, bText);
        String comment = "Creates a single " + this.mCIMClass.getName() + " structure in memory." + "It *MUST* be freed by the caller, e.g. call free" + this.mCIMClass.getName() + "";
        CFunction method = new CFunction(comment, true, this.mCIMClass.getName() + " *", "create" + this.mCIMClass.getName(), arguments, body.toString());
        this.mFunctionList.add(method);
    }

    private void addFreeStructure() {
        ArrayList<CArgument> arguments = new ArrayList<CArgument>();
        ArrayList<String> bText = new ArrayList<String>();
        arguments.add(new CArgument(false, "*poMA", this.mCIMClass.getName()));
        bText.add("if(poMA != NULL) {");
        for (CIMClassProperty prop : this.mCIMClass.getProperties()) {
            String type = CodeGeneratorConstants.CDATATYPE[prop.getDataType().getType()];
            boolean isArray = prop.getDataType().isArray();
            if ((type.equalsIgnoreCase("char*") || type.equalsIgnoreCase("CMPIObjectPath*") || type.equalsIgnoreCase("CMPIDateTime*")) && isArray) {
                bText.add("if(poMA->m" + prop.getName() + " != NULL" + "&& poMA->mNumberOf" + prop.getName() + " > 0) " + "{");
                bText.add("int index = 0;");
                bText.add("for(index = 0; index < poMA->mNumberOf" + prop.getName() + ";" + " index++) " + "{");
                bText.add("free(poMA->m" + prop.getName() + "[index])" + ";");
                bText.add("}");
                bText.add("free(poMA->m" + prop.getName() + ")" + ";");
                bText.add("}");
            }
            if (!type.equalsIgnoreCase("char*") && !type.equalsIgnoreCase("CMPIObjectPath*") && !type.equalsIgnoreCase("CMPIDateTime*") && isArray) {
                bText.add("if(poMA->m" + prop.getName() + " != NULL) " + "{");
                bText.add("free(poMA->m" + prop.getName() + ")" + ";");
                bText.add("}");
            }
            if (!type.equalsIgnoreCase("char*") && !type.equalsIgnoreCase("CMPIObjectPath*") && !type.equalsIgnoreCase("CMPIDateTime*") || isArray) continue;
            bText.add("if(poMA->m" + prop.getName() + " != NULL) " + "{");
            bText.add("free(poMA->m" + prop.getName() + ")" + ";");
            bText.add("}");
        }
        bText.add("}");
        CFunctionBody body = new CFunctionBody(null, bText);
        String comment = "Frees memory associated with the " + this.mCIMClass.getName();
        CFunction method = new CFunction(comment, true, "void", "free" + this.mCIMClass.getName(), arguments, body.toString());
        this.mFunctionList.add(method);
    }

    public static String getArrayType(CIMDataType pDataType) {
        int typeIndex = pDataType.getType();
        String type = CodeGeneratorConstants.CDATATYPE[typeIndex];
        String arrayType = pDataType.toString().toUpperCase() + "Array";
        if (type.equalsIgnoreCase("char*")) {
            arrayType = "CharArray";
        }
        if (type.equalsIgnoreCase("CMPIObjectPath*")) {
            arrayType = "CMPIObjectPathArray";
        }
        return arrayType;
    }

    protected static String getCMPIType(CIMDataType pDataType) {
        String cmpiType = pDataType.toString();
        if (CodeGeneratorConstants.DATATYPE[pDataType.getType()].equalsIgnoreCase("CIMObjectPath")) {
            cmpiType = cmpiType.trim();
            cmpiType = cmpiType.substring(cmpiType.length() - 3, cmpiType.length()).toLowerCase();
        }
        if (CodeGeneratorConstants.DATATYPE[pDataType.getType()].equalsIgnoreCase("String")) {
            cmpiType = "chars";
        }
        if (CodeGeneratorConstants.DATATYPE[pDataType.getType()].equalsIgnoreCase("CIMDateTime")) {
            cmpiType = "dateTime";
        }
        return cmpiType;
    }

    protected static String getCMPIValue(CIMDataType pDataType) {
        String cmpiValue = pDataType.toString();
        if (CodeGeneratorConstants.DATATYPE[pDataType.getType()].equalsIgnoreCase("CIMObjectPath")) {
            cmpiValue = cmpiValue.trim();
            cmpiValue = cmpiValue.substring(cmpiValue.length() - 3, cmpiValue.length()).toLowerCase();
        }
        if (CodeGeneratorConstants.DATATYPE[pDataType.getType()].equalsIgnoreCase("String")) {
            cmpiValue = "chars";
        }
        if (CodeGeneratorConstants.DATATYPE[pDataType.getType()].equalsIgnoreCase("CIMDateTime")) {
            cmpiValue = "dateTime";
        }
        if (pDataType.isArray()) {
            cmpiValue = "array";
        }
        return cmpiValue;
    }

    public void addGetCMPIArrayAsType() {
        for (CIMMethod methods : this.mCIMClass.getMethods()) {
            for (CIMParameter param : methods.getParameters()) {
                if (!param.getDataType().isArray()) continue;
                ArrayList<CArgument> arguments = new ArrayList<CArgument>();
                arguments.add(new CArgument(false, "*pArray", "CMPIArray"));
                arguments.add(new CArgument(false, " pNumberOfElements", "CMPICount"));
                arguments.add(new CArgument(false, "*pStatus", "CMPIStatus"));
                ArrayList<String> bText = new ArrayList<String>();
                int type = param.getDataType().getType();
                bText.add(CodeGeneratorConstants.CMPITYPE[type] + "* ret;");
                bText.add("if (pArray != NULL && pNumberOfElements != 0) {");
                bText.add("ret = calloc(pNumberOfElements,sizeof(" + CodeGeneratorConstants.CMPITYPE[type] + "));");
                bText.add("int index = 0;");
                bText.add("for (index = 0;");
                bText.add("(pStatus->rc == CMPI_RC_OK) && (index < pNumberOfElements);");
                bText.add("index++) {");
                bText.add("CMPIData data = CMGetArrayElementAt(pArray,index,pStatus);");
                String cmpiType = C_SourceFileGenerator.getCMPIType(param.getDataType());
                if (cmpiType.equalsIgnoreCase("chars")) {
                    cmpiType = "string";
                }
                bText.add("ret[index] = data.value." + cmpiType + ";");
                bText.add("/* Error will be caught by for loop and returned to the caller */");
                bText.add("}");
                bText.add("} else {");
                bText.add("CMSetStatusWithChars(gBroker, pStatus, CMPI_RC_ERR_FAILED,");
                bText.add("\"Passed in array was NULL\");");
                bText.add("}");
                bText.add("return ret;");
                CFunctionBody body = new CFunctionBody(null, bText);
                String comment = "Converts the passed in CMPI array into a native C array.";
                String name = CodeGeneratorConstants.CMPITYPE[type].equals("CMPIString*") ? CodeGeneratorConstants.CMPITYPE[type].substring(0, CodeGeneratorConstants.CMPITYPE[type].length() - 1) : CodeGeneratorConstants.CMPITYPE[type];
                CFunction method = new CFunction(comment, true, CodeGeneratorConstants.CMPITYPE[type] + "*", "getCMPIArrayAs" + name + "Array", arguments, body.toString());
                this.mFunctionList.add(method);
            }
        }
    }

    private void addGetTypeAsCMPIArray() {
        ArrayList<String> dataTypeList = new ArrayList<String>();
        String dataType = "";
        for (CIMClassProperty cIMClassProperty : this.mCIMClass.getProperties()) {
            dataType = CodeGeneratorConstants.DATATYPE[cIMClassProperty.getDataType().getType()];
            if (!cIMClassProperty.getDataType().isArray() || dataTypeList.contains(dataType)) continue;
            dataTypeList.add(dataType);
            this.addGetTypeAsCMPIArray(cIMClassProperty.getDataType());
        }
        for (CIMClassProperty cIMClassProperty : this.mCIMClass.getMethods()) {
            for (CIMParameter param : cIMClassProperty.getParameters()) {
                dataType = CodeGeneratorConstants.DATATYPE[param.getDataType().getType()];
                if (!param.hasQualifierValue("OUT", (Object)true) || !param.getDataType().isArray() || dataTypeList.contains(dataType)) continue;
                dataTypeList.add(dataType);
                this.addGetTypeAsCMPIArray(param.getDataType());
            }
        }
    }

    private void addGetTypeAsCMPIArray(CIMDataType pDataType) {
        ArrayList<CArgument> arguments = new ArrayList<CArgument>();
        ArrayList<String> bText = new ArrayList<String>();
        int typeIndex = pDataType.getType();
        arguments.add(new CArgument(false, "pArray", CodeGeneratorConstants.CDATATYPE[typeIndex] + "*"));
        arguments.add(new CArgument(false, " pNumberOfElements", "size_t"));
        arguments.add(new CArgument(false, "*pStatus", "CMPIStatus"));
        String cmpiArrayType = C_SourceFileGenerator.getCMPIType(pDataType);
        bText.add("CMPIArray *ret = NULL;");
        bText.add("if (pArray != NULL && pNumberOfElements != 0) {");
        bText.add("int index = 0;");
        bText.add("ret = CMNewArray(gBroker, pNumberOfElements, CMPI_" + cmpiArrayType + "A, pStatus)" + ";");
        bText.add("for (index = 0;");
        bText.add("(pStatus->rc == CMPI_RC_OK) && (index < pNumberOfElements);");
        bText.add("index++) {");
        bText.add("CMPIValue val;");
        bText.add("val." + C_SourceFileGenerator.getCMPIType(pDataType) + "= pArray[index];");
        bText.add("*pStatus = CMSetArrayElementAt(ret, index, &val, CMPI_" + C_SourceFileGenerator.getCMPIType(pDataType) + ")" + ";");
        bText.add(" /* Error will be caught by for loop and returned to caller */");
        bText.add("}");
        bText.add("} else {");
        bText.add("CMSetStatusWithChars(gBroker, pStatus, CMPI_RC_ERR_FAILED,");
        bText.add("\"Passed in array was NULL\");");
        bText.add("}");
        bText.add("return ret;");
        CFunctionBody body = new CFunctionBody(null, bText);
        String comment = "Converts the passed in native C array into a CMPI array";
        CFunction method = new CFunction(comment, true, "CMPIArray", "*get" + C_SourceFileGenerator.getArrayType(pDataType) + "AsCMPIArray", arguments, body.toString());
        this.mFunctionList.add(method);
    }

    private void addGetSinglePath() {
        ArrayList<CArgument> arguments = new ArrayList<CArgument>();
        ArrayList<String> bText = new ArrayList<String>();
        arguments.add(new CArgument(true, "*pBrk", "CMPIBroker"));
        arguments.add(new CArgument(false, "*pStatus", "CMPIStatus"));
        arguments.add(new CArgument(true, "*pNamespace", "CMPIObjectPath"));
        arguments.add(new CArgument(true, "*poMA", this.mCIMClass.getName()));
        bText.add("CMPIObjectPath * path = NULL;");
        bText.add("CMPIString *nsString = CMGetNameSpace(pNamespace, pStatus);");
        bText.add("const char *ns = CMGetCharsPtr(nsString, pStatus);");
        bText.add("/* Create a new object path */");
        bText.add("path = CMNewObjectPath(pBrk, ns, CCN_" + this.mCIMClass.getName().toUpperCase() + ", pStatus)" + ";");
        for (CIMClassProperty key : this.mCIMClass.getKeys()) {
            bText.add("if (pStatus->rc == CMPI_RC_OK) {");
            String cmpiType = C_SourceFileGenerator.getCMPIType(key.getDataType());
            if (key.getDataType().isArray()) {
                cmpiType = cmpiType + "A";
            }
            bText.add("*pStatus = CMAddKey(path, CPN_" + key.getName().toUpperCase() + ",(" + C_SourceFileGenerator.getCMPIValue(key.getDataType()) + " *) poMA->m" + key.getName() + ", CMPI_" + cmpiType + ")" + ";");
            bText.add("}");
        }
        bText.add("return path;");
        CFunctionBody body = new CFunctionBody(null, bText);
        String comment = "Create an object path for the " + this.mCIMClass.getName();
        CFunction method = new CFunction(comment, true, "CMPIObjectPath", "*getSinglePath", arguments, body.toString());
        this.mFunctionList.add(method);
    }

    private void addGetSingleInstance() {
        String cmpiType;
        ArrayList<CArgument> arguments = new ArrayList<CArgument>();
        ArrayList<String> bText = new ArrayList<String>();
        arguments.add(new CArgument(true, "*pBrk", "CMPIBroker"));
        arguments.add(new CArgument(false, "*pStatus", "CMPIStatus"));
        arguments.add(new CArgument(true, "*pNamespace", "CMPIObjectPath"));
        arguments.add(new CArgument(true, "*poMA", this.mCIMClass.getName()));
        arguments.add(new CArgument(true, "**pProps", "char"));
        bText.add("CMPIObjectPath * path = NULL;");
        bText.add("CMPIInstance * inst = NULL;");
        bText.add("/* Make a new instance representing the object */");
        bText.add("inst = CMNewInstance(pBrk, pNamespace, pStatus);");
        bText.add("if(pStatus->rc == CMPI_RC_OK) {");
        bText.add("/* each instance needs an object path embedded in it */");
        bText.add("path = getSinglePath(pBrk, pStatus, pNamespace, poMA);");
        bText.add("if(pStatus->rc == CMPI_RC_OK) {");
        bText.add("/* Set the instance object path */");
        bText.add("*pStatus = CMSetObjectPath(inst, path);");
        bText.add("/* Set the session instance ID */");
        for (CIMClassProperty key : this.mCIMClass.getKeys()) {
            bText.add("if(pStatus->rc == CMPI_RC_OK && isPropertyPresent(CPN_" + key.getName().toUpperCase() + ",pProps)) " + "{");
            bText.add("CMPIData data;");
            bText.add("/*");
            bText.add("Since we already have added this property to the embedded");
            bText.add("object path just get it from the ObjectPath and add it to the instance.");
            bText.add("*/");
            cmpiType = C_SourceFileGenerator.getCMPIType(key.getDataType());
            if (cmpiType.equalsIgnoreCase("chars")) {
                cmpiType = "string";
            }
            if (key.getDataType().isArray()) {
                cmpiType = cmpiType + "A";
            }
            bText.add("data = CMGetKey(path, CPN_" + key.getName().toUpperCase() + ", pStatus )" + ";");
            bText.add("if(pStatus->rc == CMPI_RC_OK) {");
            bText.add("*pStatus = CMSetProperty(inst,CPN_" + key.getName().toUpperCase() + ", &data.value" + ", CMPI_" + cmpiType + ")" + ";");
            bText.add("}");
            bText.add("}");
        }
        bText.add("");
        bText.add("/* process non-key property */");
        for (CIMClassProperty prop : this.mCIMClass.getProperties()) {
            if (prop.isKey()) continue;
            bText.add("if(pStatus->rc == CMPI_RC_OK && isPropertyPresent(CPN_" + prop.getName().toUpperCase() + ",pProps)) " + "{");
            String value = cmpiType = C_SourceFileGenerator.getCMPIType(prop.getDataType());
            if (prop.getDataType().isArray()) {
                cmpiType = cmpiType + "A";
                value = "array";
            }
            if (!CodeGeneratorConstants.DATATYPE[prop.getDataType().getType()].equalsIgnoreCase("String") || prop.getDataType().isArray()) {
                String getValue = "poMA->m" + prop.getName();
                if (prop.getDataType().isArray()) {
                    getValue = "get" + C_SourceFileGenerator.getArrayType(prop.getDataType()) + "AsCMPIArray(" + getValue + ", poMA->mNumberOf" + prop.getName() + ", pStatus)";
                }
                if (cmpiType.contains("dateTime")) {
                    getValue = "CMNewDateTimeFromBinary(pBrk,poMA->m" + prop.getName() + ", 0, pStatus)";
                }
                bText.add("/* Create a CMPIValue object to store the value */");
                bText.add("CMPIValue val;");
                bText.add("/* copy value into the CMPIValue object */");
                bText.add("val." + value + " = " + getValue + ";");
                bText.add("/* set the value in the instance */");
                bText.add("*pStatus = CMSetProperty(inst,CPN_" + prop.getName().toUpperCase() + ", &val, CMPI_" + cmpiType + ")" + ";");
            } else {
                bText.add("/* set the value in the instance */");
                bText.add("*pStatus = CMSetProperty(inst,CPN_" + prop.getName().toUpperCase() + ",(CMPIValue*)poMA->m" + prop.getName() + ", CMPI_" + cmpiType + ")" + ";");
            }
            bText.add("}");
        }
        bText.add("}");
        bText.add("}");
        bText.add("return inst;");
        CFunctionBody body = new CFunctionBody(null, bText);
        String comment = "Returns a single instance of " + this.mCIMClass.getName();
        CFunction method = new CFunction(comment, true, "CMPIInstance", "*getSingleInstance", arguments, body.toString());
        this.mFunctionList.add(method);
    }

    private void addIsPropertyPresent() {
        ArrayList<CArgument> arguments = new ArrayList<CArgument>();
        ArrayList<String> bText = new ArrayList<String>();
        arguments.add(new CArgument(true, "*pName", "char"));
        arguments.add(new CArgument(true, "**pList", "char"));
        bText.add("CMPIBoolean found = 0;");
        bText.add("/* If the property list filter is empty, return true */ ");
        bText.add("if (NULL == pList) {");
        bText.add("found = 1;");
        bText.add("} else {");
        bText.add("while(NULL != *pList) {");
        bText.add("/* Property names are case sensitve */");
        bText.add("if(0 == strcasecmp(pName,*pList)) {");
        bText.add("found = 1;");
        bText.add("break;");
        bText.add("}");
        bText.add("pList++;");
        bText.add("}");
        bText.add("}");
        bText.add("return found;");
        CFunctionBody body = new CFunctionBody(null, bText);
        String comment = "Search if the property is present in the property list";
        CFunction method = new CFunction(comment, true, "CMPIBoolean", "isPropertyPresent", arguments, body.toString());
        this.mFunctionList.add(method);
    }
}

