/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.codegen.cmpi;

import com.ws.cim.codegen.cmpi.CArgument;
import com.ws.cim.codegen.cmpi.CFunction;
import com.ws.cim.codegen.cmpi.CFunctionBody;
import java.util.ArrayList;
import javax.cim.CIMClass;

public class IndicationMIGenerator {
    private ArrayList<CFunction> mFunctionList;
    private CIMClass mCIMClass;

    public IndicationMIGenerator(CIMClass pCIMClass) {
        this.mCIMClass = pCIMClass;
        this.mFunctionList = new ArrayList();
        this.setFunctions();
    }

    public ArrayList<CFunction> getFunctions() {
        return this.mFunctionList;
    }

    private void setFunctions() {
        this.addActivateFilter();
        this.addAuthorizeFilter();
        this.adddDeActivateFilter();
        this.addMustPoll();
        this.addEnableIndications();
        this.addDisableIndications();
        this.addCleanup();
    }

    private void addActivateFilter() {
        ArrayList<CArgument> arguments = new ArrayList<CArgument>();
        ArrayList<String> bText = new ArrayList<String>();
        arguments.add(new CArgument(false, "*pMI", "CMPIIndicationMI"));
        arguments.add(new CArgument(true, "*pCtx", "CMPIContext"));
        arguments.add(new CArgument(true, "*pFilter", "CMPISelectExp"));
        arguments.add(new CArgument(true, "*pClassName", "char"));
        arguments.add(new CArgument(true, "*pClassPath", "CMPIObjectPath"));
        arguments.add(new CArgument(false, "pFirstActivation", "CMPIBoolean"));
        this.commonBodyText(bText);
        CFunctionBody body = new CFunctionBody(null, bText);
        String comment = "This function shall begin monitoring the resource according to the filter expression only.";
        CFunction method = new CFunction(comment, true, "CMPIStatus", "activateFilter", arguments, body.toString());
        this.mFunctionList.add(method);
    }

    private void addAuthorizeFilter() {
        ArrayList<CArgument> arguments = new ArrayList<CArgument>();
        ArrayList<String> bText = new ArrayList<String>();
        arguments.add(new CArgument(false, "*pMI", "CMPIIndicationMI"));
        arguments.add(new CArgument(true, "*pCtx", "CMPIContext"));
        arguments.add(new CArgument(true, "*pFilter", "CMPISelectExp"));
        arguments.add(new CArgument(true, "*pClassName", "char"));
        arguments.add(new CArgument(true, "*pClassPath", "CMPIObjectPath"));
        arguments.add(new CArgument(true, "*pOwner", "char"));
        this.commonBodyText(bText);
        CFunctionBody body = new CFunctionBody(null, bText);
        String comment = "This function shall verify whether this filter is allowed.";
        CFunction method = new CFunction(comment, true, "CMPIStatus", "authorizeFilter", arguments, body.toString());
        this.mFunctionList.add(method);
    }

    private void adddDeActivateFilter() {
        ArrayList<CArgument> arguments = new ArrayList<CArgument>();
        ArrayList<String> bText = new ArrayList<String>();
        arguments.add(new CArgument(false, "*pMI", "CMPIIndicationMI"));
        arguments.add(new CArgument(true, "*pCtx", "CMPIContext"));
        arguments.add(new CArgument(true, "*pFilter", "CMPISelectExp"));
        arguments.add(new CArgument(true, "*pClassName", "char"));
        arguments.add(new CArgument(true, "*pClassPath", "CMPIObjectPath"));
        arguments.add(new CArgument(false, "pLastActivation", "CMPIBoolean"));
        this.commonBodyText(bText);
        CFunctionBody body = new CFunctionBody(null, bText);
        String comment = "This function invocation mandates the MI to stop monitoring the resource using this filter.";
        CFunction method = new CFunction(comment, true, "CMPIStatus", "deActivateFilter", arguments, body.toString());
        this.mFunctionList.add(method);
    }

    private void addMustPoll() {
        ArrayList<CArgument> arguments = new ArrayList<CArgument>();
        ArrayList<String> bText = new ArrayList<String>();
        arguments.add(new CArgument(false, "*mi", "CMPIIndicationMI"));
        arguments.add(new CArgument(true, "*ctx", "CMPIContext"));
        arguments.add(new CArgument(true, "*filter", "CMPISelectExp"));
        arguments.add(new CArgument(true, "*className", "char"));
        arguments.add(new CArgument(true, "*classPath", "CMPIObjectPath"));
        this.commonBodyText(bText);
        CFunctionBody body = new CFunctionBody(null, bText);
        String comment = "This function enables very simple MIs to support indications without providing a complete indication support implementation. When true is returned, the MB will enumerate the instances of this MI at regular intervals and apply indication filters.";
        CFunction method = new CFunction(comment, true, "CMPIStatus", "mustPoll", arguments, body.toString());
        this.mFunctionList.add(method);
    }

    private void addEnableIndications() {
        ArrayList<CArgument> arguments = new ArrayList<CArgument>();
        ArrayList<String> bText = new ArrayList<String>();
        arguments.add(new CArgument(false, "*pMI", "CMPIIndicationMI"));
        arguments.add(new CArgument(true, "*pCtx", "CMPIContext"));
        this.commonBodyText(bText);
        CFunctionBody body = new CFunctionBody(null, bText);
        String comment = "This function is normally called by the MB after having done its initialization and processing of persistent subscription requests.";
        CFunction method = new CFunction(comment, true, "CMPIStatus", "enableIndications", arguments, body.toString());
        this.mFunctionList.add(method);
    }

    private void addDisableIndications() {
        ArrayList<CArgument> arguments = new ArrayList<CArgument>();
        ArrayList<String> bText = new ArrayList<String>();
        arguments.add(new CArgument(false, "*pMI", "CMPIIndicationMI"));
        arguments.add(new CArgument(true, "*pCtx", "CMPIContext"));
        this.commonBodyText(bText);
        CFunctionBody body = new CFunctionBody(null, bText);
        String comment = "function is normally called when the MB is shutting down indication services either temporarily or permanently.";
        CFunction method = new CFunction(comment, true, "CMPIStatus", "disableIndications", arguments, body.toString());
        this.mFunctionList.add(method);
    }

    private void addCleanup() {
        ArrayList<CArgument> arguments = new ArrayList<CArgument>();
        arguments.add(new CArgument(false, "*pMI", "CMPIIndicationMI"));
        arguments.add(new CArgument(true, "*pCtx", "CMPIContext"));
        arguments.add(new CArgument(false, "pBool", "CMPIBoolean"));
        ArrayList<String> bText = new ArrayList<String>();
        bText.add("CMPIStatus ret = {CMPI_RC_OK,NULL};");
        bText.add("return ret;");
        CFunctionBody body = new CFunctionBody(null, bText);
        String comment = "Perform cleanup prior to unloading the Indication provider.";
        CFunction method = new CFunction(comment, true, "CMPIStatus", "indicationCleanup", arguments, body.toString());
        this.mFunctionList.add(method);
    }

    private void commonBodyText(ArrayList<String> pBText) {
        pBText.add("CMPIStatus ret = {CMPI_RC_ERR_FAILED,NULL};");
        pBText.add("/*");
        pBText.add("TODO - IMPLEMENT FUNCTION");
        pBText.add("*/");
        pBText.add("return ret;");
    }

    protected CFunction createIndicationMI() {
        ArrayList<CArgument> arguments = new ArrayList<CArgument>();
        ArrayList<String> bText = new ArrayList<String>();
        arguments.add(new CArgument(false, "*pBrk", "CMPIBroker"));
        arguments.add(new CArgument(false, "*pCtx", "CMPIContext"));
        arguments.add(new CArgument(false, "*pStatus", "CMPIStatus"));
        bText.add("/* The provider factory - Indication provider must have this. */");
        bText.add("static CMPIIndicationMIFT indicationMIFT = {");
        bText.add("CMPIVersion100,");
        bText.add("CMPIVersion100,");
        bText.add("\"" + this.mCIMClass.getName() + "\",");
        bText.add("indicationCleanup,");
        bText.add("authorizeFilter,");
        bText.add("mustPoll,");
        bText.add("activateFilter,");
        bText.add("deActivateFilter,");
        bText.add("enableIndications,");
        bText.add("disableIndications");
        bText.add("};");
        bText.add("");
        bText.add("static CMPIIndicationMI indicationMI = {NULL, &indicationMIFT};");
        bText.add("CMPIStatus status = {CMPI_RC_OK, NULL}; ");
        bText.add("CMPIIndicationMI* ret = NULL; ");
        bText.add("");
        bText.add("/* perform any one time initialization code here */ ");
        bText.add("");
        bText.add("/* if initialization succeeds  set ret */ ");
        bText.add("ret = &indicationMI; ");
        bText.add("");
        bText.add("/* if pStatus isn't NULL we need to update it with a success/failure value */ ");
        bText.add("if (pStatus != NULL) { ");
        bText.add("pStatus->rc = status.rc;");
        bText.add("pStatus->msg = status.msg; ");
        bText.add("} ");
        bText.add("return ret;");
        CFunctionBody body = new CFunctionBody(null, bText);
        String comment = "The " + this.mCIMClass.getName() + "_Create_IndicationMI() functions shall perform any necessary" + " initialization operations of this MI group.";
        CFunction method = new CFunction(comment, false, "CMPIIndicationMI *", this.mCIMClass.getName() + "_Create_IndicationMI", arguments, body.toString());
        return method;
    }
}

