/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.codegen.cmpi;

import com.ws.cim.codegen.cmpi.CArgument;
import com.ws.cim.codegen.cmpi.CFunction;
import com.ws.cim.codegen.cmpi.CFunctionBody;
import com.ws.cim.codegen.cmpi.C_SourceFileGenerator;
import com.ws.cim.codegen.java.JavaCodeWriterConstants;
import com.ws.cim.codegen.jsr48.CodeGeneratorConstants;
import com.ws.cim.codegen.jsr48.MethodCodeGenerator;
import java.util.ArrayList;
import javax.cim.CIMClass;
import javax.cim.CIMMethod;
import javax.cim.CIMParameter;

class MethodMIGenerator {
    private final CIMClass mCIMClass;
    private final ArrayList<CFunction> mFunctionList;
    private final ArrayList<CFunction> mCIMClassFunctionList;

    public MethodMIGenerator(CIMClass pCIMClass) {
        this.mCIMClass = pCIMClass;
        this.mFunctionList = new ArrayList();
        this.mCIMClassFunctionList = new ArrayList();
        this.setFunctions();
    }

    private void setFunctions() {
        this.addCIMClassFunctions();
        this.addInvokeFunction();
        this.addCleanup();
    }

    public ArrayList<CFunction> getFunctions() {
        return this.mFunctionList;
    }

    public ArrayList<CFunction> getCIMClassFunctions() {
        return this.mCIMClassFunctionList;
    }

    protected CFunction createMethodMI() {
        ArrayList<CArgument> arguments = new ArrayList<CArgument>();
        ArrayList<String> bText = new ArrayList<String>();
        arguments.add(new CArgument(false, "*pBrk", "CMPIBroker"));
        arguments.add(new CArgument(false, "*pCtx", "CMPIContext"));
        arguments.add(new CArgument(false, "*pStatus", "CMPIStatus"));
        bText.add("/* The provider factory - Method provider must have this. */");
        bText.add("static CMPIMethodMIFT methodMIFT = {");
        bText.add("CMPIVersion100,");
        bText.add("CMPIVersion100,");
        bText.add("\"" + this.mCIMClass.getName() + "\",");
        bText.add("methodCleanup,");
        bText.add("invokeMethod");
        bText.add("};");
        bText.add("");
        bText.add("static CMPIMethodMI methodMI = {NULL, &methodMIFT};");
        bText.add("CMPIStatus status = {CMPI_RC_OK, NULL};");
        bText.add("CMPIMethodMI* ret = NULL;");
        bText.add("");
        bText.add("/* perform any one time initialization code here */ ");
        bText.add("");
        bText.add("/* if initialization succeeds  set ret */ ");
        bText.add("ret = &methodMI; ");
        bText.add("");
        bText.add("/* if pStatus isn't NULL we need to update it with a success/failure value */ ");
        bText.add("if (pStatus != NULL) { ");
        bText.add("pStatus->rc = status.rc;");
        bText.add("pStatus->msg = status.msg;");
        bText.add("} ");
        bText.add("return ret;");
        CFunctionBody body = new CFunctionBody(null, bText);
        String comment = "The " + this.mCIMClass.getName() + "_Create_MethodMI() functions shall perform any necessary" + " initialization operations of this MI group.";
        CFunction method = new CFunction(comment, false, "CMPIMethodMI *", this.mCIMClass.getName() + "_Create_MethodMI", arguments, body.toString());
        return method;
    }

    public CFunction addCreateMethodMI() {
        ArrayList<CArgument> arguments = new ArrayList<CArgument>();
        ArrayList<String> bText = new ArrayList<String>();
        arguments.add(new CArgument(false, "*pBrk", "CMPIBroker"));
        arguments.add(new CArgument(false, "*pCtx", "CMPIContext"));
        arguments.add(new CArgument(false, "*pStatus", "CMPIStatus"));
        bText.add("/* The provider factory - Method provider must have this. */");
        bText.add("static CMPIMethodMIFT methodMIFT = {");
        bText.add("CMPIVersion100,");
        bText.add("CMPIVersion100,");
        bText.add("\"" + this.mCIMClass.getName() + "\",");
        bText.add("methodCleanup,");
        bText.add("invokeMethod");
        bText.add("};");
        bText.add("");
        bText.add("static CMPIMethodMI methodMI = {NULL, &methodMIFT};");
        bText.add("CMPIStatus status = {CMPI_RC_OK, NULL};");
        bText.add("CMPIMethodMI* ret = NULL;");
        bText.add("");
        bText.add("/* perform any one time initialization code here */ ");
        bText.add("");
        bText.add("/* if initialization succeeds  set ret */ ");
        bText.add("ret = &methodMI; ");
        bText.add("");
        bText.add("/* if pStatus isn't NULL we need to update it with a success/failure value */ ");
        bText.add("if (pStatus != NULL) { ");
        bText.add("pStatus->rc = status.rc;");
        bText.add("pStatus->msg = status.msg;");
        bText.add("} ");
        bText.add("return ret;");
        CFunctionBody body = new CFunctionBody(null, bText);
        String comment = "The " + this.mCIMClass.getName() + "_Create_MethodMI() functions shall perform any necessary" + " initialization operations of this MI group.";
        CFunction method = new CFunction(comment, false, "CMPIMethodMI *", this.mCIMClass.getName() + "_Create_MethodMI", arguments, body.toString());
        return method;
    }

    private void addInvokeFunction() {
        ArrayList<CArgument> arguments = new ArrayList<CArgument>();
        ArrayList<String> bText = new ArrayList<String>();
        arguments.add(new CArgument(false, "*pMI", "CMPIMethodMI"));
        arguments.add(new CArgument(true, "*pCtx", "CMPIContext"));
        arguments.add(new CArgument(true, "*pRslt", "CMPIResult"));
        arguments.add(new CArgument(true, "*pPath", "CMPIObjectPath"));
        arguments.add(new CArgument(true, "*pMethod", "char"));
        arguments.add(new CArgument(true, "*pIn", "CMPIArgs"));
        arguments.add(new CArgument(false, "*pOut", "CMPIArgs"));
        bText.add("/* not supported */");
        bText.add("CMPIStatus ret = {CMPI_RC_ERR_NOT_SUPPORTED,NULL};");
        bText.add("");
        bText.add("CMPIData data;");
        bText.add("");
        CIMMethod[] methods = this.mCIMClass.getMethods();
        String ifCondition = "";
        for (CIMMethod method : methods) {
            int i;
            bText.add(ifCondition + "if(strcasecmp(pMethod, CMN_" + method.getName().toUpperCase() + ") == 0){");
            ArrayList<String> args = new ArrayList<String>();
            for (CIMParameter param : method.getParameters()) {
                String name;
                String dataType = CodeGeneratorConstants.CMPITYPE[param.getDataType().getType()];
                String argName = name = MethodCodeGenerator.properCase(param.getName());
                String value = "";
                if (dataType.equals("CMPIDateTime") || dataType.equals("CMPIObjectPath")) {
                    dataType = dataType + "*";
                    value = " = NULL";
                }
                if (param.getDataType().isArray()) {
                    dataType = dataType + "*";
                    value = " = NULL";
                }
                args.add(argName);
                bText.add(dataType + " " + name + value + ";");
            }
            int inArgsCtr = 0;
            int outArgsCtr = 0;
            ArrayList<CIMParameter> outParams = new ArrayList<CIMParameter>();
            if (method.getParameters().length > 0) {
                bText.add("CMPIData tempData;");
            }
            for (CIMParameter param : method.getParameters()) {
                if (param.hasQualifierValue("IN", (Object)true)) {
                    if (param.hasQualifierValue("OUT", (Object)true)) {
                        ++outArgsCtr;
                        outParams.add(param);
                    }
                    String name = MethodCodeGenerator.properCase(param.getName());
                    String type = C_SourceFileGenerator.getCMPIValue(param.getDataType());
                    ++inArgsCtr;
                    bText.add("/* get the " + param.getName() + " parameter*/ ");
                    bText.add("tempData = CMGetArg(pIn, CAN_" + method.getName().toUpperCase() + "_" + param.getName().toUpperCase() + ", &ret);");
                    bText.add("/* set the " + param.getName() + " param value*/ ");
                    if (param.getDataType().isArray()) {
                        bText.add("CMPICount arraySize = CMGetArrayCount(tempData.value.array,&ret);");
                        int typeIndex = param.getDataType().getType();
                        String arrayType = CodeGeneratorConstants.CMPITYPE[typeIndex].equals("CMPIString*") ? CodeGeneratorConstants.CMPITYPE[typeIndex].substring(0, CodeGeneratorConstants.CMPITYPE[typeIndex].length() - 1) : CodeGeneratorConstants.CMPITYPE[typeIndex];
                        bText.add(name + " = getCMPIArrayAs" + arrayType + "Array(tempData.value.array,arraySize,&ret);");
                    } else {
                        bText.add(name + " = tempData.value." + type + ";");
                    }
                    bText.add("if( ret.rc == CMPI_RC_OK ) {");
                    continue;
                }
                ++outArgsCtr;
                outParams.add(param);
            }
            String parameter = args.size() > 0 ? "gBroker, ret, " + JavaCodeWriterConstants.getCommaSeparatedLine(args) : "";
            bText.add("data = " + MethodCodeGenerator.properCase(method.getName()) + "(" + parameter + ");");
            for (CIMParameter outParam : outParams) {
                String cmpiValue = C_SourceFileGenerator.getCMPIValue(outParam.getDataType());
                String cmpiType = C_SourceFileGenerator.getCMPIType(outParam.getDataType());
                String assignmentStr = MethodCodeGenerator.properCase(outParam.getName());
                if (outParam.getDataType().isArray()) {
                    cmpiType = cmpiType + "A";
                    String getValue = "poMA->m" + outParam.getName();
                    assignmentStr = "get" + C_SourceFileGenerator.getArrayType(outParam.getDataType()) + "AsCMPIArray(" + getValue + ", poMA->mNumberOf" + outParam.getName() + ", pStatus)";
                }
                bText.add("tempData.value." + cmpiValue + " = " + assignmentStr + ";");
                bText.add("ret = CMAddArg(pOut, CAN_" + method.getName().toUpperCase() + "_" + outParam.getName().toUpperCase() + ", &tempData.value, CMPI_" + cmpiType + ");");
                bText.add("if(ret.rc == CMPI_RC_OK) {");
            }
            bText.add("pRslt->ft->returnData(pRslt,&data.value,data.type);");
            for (i = 0; i < outArgsCtr; ++i) {
                bText.add("}");
            }
            ifCondition = "} else ";
            for (i = 0; i < inArgsCtr; ++i) {
                bText.add("}");
            }
        }
        bText.add("}");
        bText.add("pRslt->ft->returnDone(pRslt);");
        bText.add("return ret;");
        CFunctionBody body = new CFunctionBody(null, bText);
        String comment = "Invoke a named, extrinsic method of an Instance defined by an ObjectPath.";
        CFunction method = new CFunction(comment, true, "CMPIStatus", "invokeMethod", arguments, body.toString());
        this.mFunctionList.add(method);
    }

    private void addCIMClassFunctions() {
        CIMMethod[] cimMethods;
        for (CIMMethod function : cimMethods = this.mCIMClass.getMethods()) {
            CIMParameter[] functionParam = function.getParameters();
            ArrayList<CArgument> arguments = new ArrayList();
            ArrayList<String> bText = new ArrayList<String>();
            bText.add("CMPIData ret = { CMPI_" + C_SourceFileGenerator.getCMPIType(function.getDataType()) + (function.getDataType().isArray() ? "A" : "") + ", CMPI_badValue, {0} };");
            if (functionParam.length > 0) {
                arguments = this.processCimFunctionParam(functionParam, bText);
            } else {
                bText.add("");
                bText.add("/* TODO IMPLEMENT THE CODE THAT PERFORMS THE FUNCTION HERE. */");
            }
            bText.add("");
            bText.add("/* REPLACE THE VALUE RETURNED WITH AN APPROPRIATE VALUE */");
            bText.add("return ret;");
            CFunctionBody body = new CFunctionBody(null, bText);
            String comment = function.hasQualifier("Description") ? function.getQualifierValue("Description").toString() : "comment";
            CFunction method = new CFunction(comment, true, "CMPIData", MethodCodeGenerator.properCase(function.getName()), arguments, body.toString());
            this.mCIMClassFunctionList.add(method);
        }
    }

    /*
     * WARNING - void declaration
     */
    private ArrayList<CArgument> processCimFunctionParam(CIMParameter<?>[] functionParam, ArrayList<String> pBText) {
        void var8_10;
        ArrayList<CArgument> argRet = new ArrayList<CArgument>();
        ArrayList inParam = new ArrayList();
        ArrayList outParam = new ArrayList();
        argRet.add(new CArgument(true, "*pBrk", "CMPIBroker"));
        argRet.add(new CArgument(false, "pStatus", "CMPIStatus"));
        CIMParameter<?>[] arr$ = functionParam;
        int len$ = arr$.length;
        boolean bl = false;
        while (var8_10 < len$) {
            CIMParameter<?> cIMParameter = arr$[var8_10];
            boolean isInParam = false;
            if (cIMParameter.hasQualifierValue("IN", (Object)true)) {
                inParam.add(cIMParameter);
                if (!cIMParameter.hasQualifierValue("OUT", (Object)true)) {
                    isInParam = true;
                }
            } else {
                outParam.add(cIMParameter);
            }
            String dType = CodeGeneratorConstants.CMPITYPE[cIMParameter.getDataType().getType()];
            String pName = "p" + cIMParameter.getName();
            if (dType.equals("CMPIObjectPath") || dType.equals("CMPIDateTime")) {
                dType = dType + "*";
            }
            if (cIMParameter.getDataType().isArray()) {
                if (isInParam) {
                    dType = dType + " const*";
                    isInParam = false;
                } else {
                    dType = dType + "*";
                }
            }
            argRet.add(new CArgument(isInParam, pName, dType));
            ++var8_10;
        }
        ArrayList<String> testIfNullCode = new ArrayList<String>();
        for (CIMParameter cIMParameter : inParam) {
            StringBuffer stringBuffer = new StringBuffer(cIMParameter.getName());
            stringBuffer.setCharAt(0, Character.toLowerCase(stringBuffer.charAt(0)));
            testIfNullCode.add("/*");
            testIfNullCode.add("// TODO  THIS ARGUMENT IS NOT LISTED AS REQUIRED");
            testIfNullCode.add("IF YOUR IMPLEMENTATION REQUIRES IT, UNCOMMENT THE FOLLOWING LINES");
            testIfNullCode.add("if (p" + cIMParameter.getName() + " == NULL ) " + "{");
            testIfNullCode.add("");
            testIfNullCode.add("CMPIStatus tempStatus;");
            testIfNullCode.add("pStatus.rc = CMPI_RC_ERR_FAILED");
            testIfNullCode.add("pStatus.msg = pBrk->newCMPIString(pBrk, \"p" + cIMParameter.getName() + " should not be NULL\", &tempStatus)");
            testIfNullCode.add("}");
            testIfNullCode.add("*/");
        }
        ArrayList<String> outPutParam = new ArrayList<String>();
        for (CIMParameter cIMParameter : outParam) {
            outPutParam.add("/*");
            outPutParam.add("* p" + cIMParameter.getName() + " is an output parameter.");
            outPutParam.add("* Set the Job value before returning");
            outPutParam.add("*/");
        }
        pBText.addAll(testIfNullCode);
        pBText.add("");
        pBText.add("/* TODO IMPLEMENT THE CODE THAT PERFORMS THE FUNCTION HERE. */");
        pBText.add("");
        pBText.addAll(outPutParam);
        return argRet;
    }

    private void addCleanup() {
        ArrayList<CArgument> arguments = new ArrayList<CArgument>();
        arguments.add(new CArgument(false, "*pMI", "CMPIMethodMI"));
        arguments.add(new CArgument(true, "*pCtx", "CMPIContext"));
        arguments.add(new CArgument(false, "pBool", "CMPIBoolean"));
        ArrayList<String> bText = new ArrayList<String>();
        bText.add("CMPIStatus ret = {CMPI_RC_OK,NULL};");
        bText.add("return ret;");
        CFunctionBody body = new CFunctionBody(null, bText);
        String comment = "Perform cleanup prior to unloading the Method provider.";
        CFunction method = new CFunction(comment, true, "CMPIStatus", "methodCleanup", arguments, body.toString());
        this.mFunctionList.add(method);
    }
}

