/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.codegen.java;

import com.ws.cim.codegen.java.JavaCodeWriterConstants;
import com.ws.cim.codegen.java.JavaDataConstant;
import com.ws.cim.codegen.java.JavaDataMember;
import com.ws.cim.codegen.java.JavaEnums;
import com.ws.cim.codegen.java.JavaMethod;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.ResourceBundle;

public class JavaCodeWriter {
    private String mFileComment;
    private String mPackageName;
    private ArrayList<String> mImportList;
    private String mClassComment;
    private boolean mIsClass;
    private String mClassName;
    private String mExtendedsClassName;
    private ArrayList<String> mImplementedClassList;
    private ArrayList<JavaDataConstant> mDataConstants;
    private ArrayList<JavaDataMember> mDataMembers;
    private ArrayList<JavaMethod> mMethods;
    private ArrayList<JavaEnums> mEnums;
    private String mOutdir;

    public JavaCodeWriter(String pOutdir) {
        this.mOutdir = pOutdir;
        this.mImportList = new ArrayList();
        this.mImplementedClassList = new ArrayList();
        this.mDataMembers = new ArrayList();
        this.mDataConstants = new ArrayList();
        this.mMethods = new ArrayList();
    }

    public void setExtendedClassName(String pExtendsClassName) {
        this.mExtendedsClassName = pExtendsClassName;
    }

    public void addImport(String pImportName) {
        this.mImportList.add(pImportName);
    }

    public void addMethod(JavaMethod m) {
        this.mMethods.add(m);
    }

    public void setEnums(ArrayList<JavaEnums> pEnums) {
        this.mEnums = pEnums;
    }

    public void setImports(ArrayList<String> pImportList) {
        this.mImportList = pImportList;
    }

    public void addDataMember(JavaDataMember pDataMember) {
        this.mDataMembers.add(pDataMember);
    }

    public void addDataConstant(JavaDataConstant pDataConstant) {
        this.mDataConstants.add(pDataConstant);
    }

    public void setClassInfo(boolean clazz, String pClassComment, String pClassName, String pExtendedsClassName, ArrayList<String> pImplementedList) {
        if (pImplementedList != null) {
            this.mImplementedClassList = pImplementedList;
        }
        this.mExtendedsClassName = pExtendedsClassName;
        this.mIsClass = clazz;
        this.mClassName = pClassName;
        this.mClassComment = pClassComment;
    }

    public void setFileComment(String pComment) {
        this.mFileComment = pComment;
    }

    public void setPackageName(String pPackageName) {
        this.mPackageName = pPackageName;
    }

    private void sortInnerImportList(ArrayList<String> pStrList) {
        Object[] strArr = new String[pStrList.size()];
        for (int i = 0; i < pStrList.size(); ++i) {
            strArr[i] = pStrList.get(i);
        }
        Arrays.sort(strArr);
        pStrList.clear();
        pStrList.addAll(Arrays.asList(strArr));
    }

    private void sortImportList() {
        ArrayList<String> java = new ArrayList<String>();
        ArrayList<String> javax = new ArrayList<String>();
        ArrayList<String> org = new ArrayList<String>();
        ArrayList<String> com = new ArrayList<String>();
        ArrayList<String> others = new ArrayList<String>();
        String str = "";
        for (int i = 0; i < this.mImportList.size(); ++i) {
            str = this.mImportList.get(i);
            String[] strToken = str.split("\\.");
            if (strToken[0].equals("java")) {
                java.add(str);
                continue;
            }
            if (strToken[0].equals("javax")) {
                javax.add(str);
                continue;
            }
            if (strToken[0].equals("org")) {
                org.add(str);
                continue;
            }
            if (strToken[0].equals("com")) {
                com.add(str);
                continue;
            }
            others.add(str);
        }
        if (java != null || javax != null || org != null || com != null || others != null) {
            this.mImportList.clear();
            if (java != null) {
                this.sortInnerImportList(java);
                this.mImportList.addAll(java);
            }
            if (javax != null) {
                this.sortInnerImportList(javax);
                this.mImportList.addAll(javax);
            }
            if (org != null) {
                this.sortInnerImportList(org);
                this.mImportList.addAll(org);
            }
            if (com != null) {
                this.sortInnerImportList(com);
                this.mImportList.addAll(com);
            }
            if (others != null) {
                this.sortInnerImportList(others);
                this.mImportList.addAll(others);
            }
        }
    }

    public void write(String pFileName) throws Exception {
        if (pFileName == null) {
            throw new IllegalArgumentException("Invalid Argument: File name cannot be null!");
        }
        File dir = new File(this.mOutdir);
        if (!(dir.exists() && dir.isDirectory() || dir.mkdirs())) {
            throw new IllegalArgumentException("could not create directory: " + this.mOutdir);
        }
        String fileName = this.mOutdir + File.separator + pFileName;
        File cFile = new File(fileName);
        if (cFile.exists()) {
            cFile.delete();
        }
        BufferedWriter out = new BufferedWriter(new FileWriter(fileName, false));
        ResourceBundle rb = ResourceBundle.getBundle("com.ws.cim.codegen.java.JavaCodeWriter");
        Iterator<String> commentIterator = JavaCodeWriterConstants.getLineIterator(this.mFileComment, 78, 0, true);
        while (commentIterator.hasNext()) {
            out.write(commentIterator.next());
        }
        out.newLine();
        if (this.mPackageName != null) {
            out.write(MessageFormat.format(rb.getString("packageLine"), this.mPackageName));
            out.newLine();
            out.newLine();
        }
        this.sortImportList();
        for (int i = 0; i < this.mImportList.size(); ++i) {
            out.write(MessageFormat.format(rb.getString("importLine"), this.mImportList.get(i)));
            out.newLine();
        }
        out.newLine();
        commentIterator = JavaCodeWriterConstants.getLineIterator(this.mClassComment, 78, 0, true);
        while (commentIterator.hasNext()) {
            out.write(commentIterator.next());
        }
        out.newLine();
        String extendsLine = null;
        String implementedLine = null;
        StringBuilder inheritance = new StringBuilder();
        if (this.mExtendedsClassName != null && this.mExtendedsClassName.length() != 0) {
            extendsLine = MessageFormat.format(rb.getString("extendsLine"), this.mExtendedsClassName);
        }
        if (this.mImplementedClassList != null && !this.mImplementedClassList.isEmpty()) {
            String csl = JavaCodeWriterConstants.getCommaSeparatedLine(this.mImplementedClassList);
            implementedLine = MessageFormat.format(rb.getString("implementsLine"), csl);
        }
        Object[] objArr = new Object[]{this.mIsClass ? "class" : "interface", this.mClassName, inheritance.toString()};
        StringBuilder ch = new StringBuilder();
        ch.append(MessageFormat.format(rb.getString("classLine"), objArr));
        if (extendsLine != null) {
            ch.append(" " + extendsLine);
        }
        if (implementedLine != null) {
            ch.append(" " + implementedLine);
        }
        ch.append(" {");
        Iterator<String> classIterator = JavaCodeWriterConstants.getLineIterator(ch.toString(), 78, 0, false);
        StringBuilder classHeader = new StringBuilder();
        while (classIterator.hasNext()) {
            classHeader.append(classIterator.next());
        }
        out.write(classHeader.toString());
        out.newLine();
        if (this.mIsClass) {
            for (JavaDataConstant javaDataConstant : this.mDataConstants) {
                out.write(javaDataConstant.toString());
                out.newLine();
                out.newLine();
            }
            for (JavaDataMember javaDataMember : this.mDataMembers) {
                out.write(javaDataMember.toString());
                out.newLine();
                out.newLine();
            }
            for (JavaMethod javaMethod : this.mMethods) {
                out.write(javaMethod.toString());
                out.newLine();
                out.newLine();
            }
        } else {
            if (this.mEnums != null) {
                for (JavaEnums javaEnums : this.mEnums) {
                    out.write(javaEnums.toString());
                    out.newLine();
                }
            }
            if (this.mMethods != null) {
                for (JavaMethod javaMethod : this.mMethods) {
                    out.write(javaMethod.getPrototype());
                    out.newLine();
                }
            }
        }
        out.write("}");
        out.newLine();
        out.close();
    }
}

