/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.codegen.jsr48;

import com.ws.cim.codegen.java.JavaCodeWriterConstants;
import com.ws.cim.codegen.java.JavaDataConstant;
import com.ws.cim.codegen.java.JavaMethod;
import com.ws.cim.codegen.java.JavaMethodBody;
import com.ws.cim.codegen.java.JavaMethodVariable;
import com.ws.cim.codegen.jsr48.AbstractCodeGenerator;
import com.ws.cim.codegen.jsr48.CodeGeneratorConstants;
import com.ws.cim.codegen.jsr48.JavaArgument;
import com.ws.utilities.Resources;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.cim.CIMClass;
import javax.cim.CIMClassProperty;
import javax.cim.CIMDataType;
import javax.cim.CIMMethod;
import javax.cim.CIMParameter;

public class MethodCodeGenerator
extends AbstractCodeGenerator {
    private final String RESOURCE_BUNDLE = "com.ws.cim.codegen.jsr48.CodeGenerator";
    private final Resources mResourceBundleHandle;
    private CIMClass mClass;
    private final ArrayList<JavaMethod> mClassMethods;
    private final ArrayList<JavaDataConstant> mClassConstants;
    private ArrayList<JavaMethod> interface_methods;
    private ArrayList<String> interface_imports;

    public MethodCodeGenerator(CIMClass pClass) {
        if (pClass != null) {
            this.mClass = pClass;
        }
        this.mClassMethods = new ArrayList();
        this.mClassConstants = new ArrayList();
        this.mResourceBundleHandle = new Resources("com.ws.cim.codegen.jsr48.CodeGenerator");
        if (null != pClass && pClass.getMethodCount() > 0) {
            this.setImports();
            this.setMethods();
            this.setConstants();
        } else {
            this.setImports("javax.cim.CIMObjectPath");
            this.setImports("javax.cim.CIMProperty");
            this.addTypeConversionMethod();
        }
    }

    @Override
    public void setImports() {
        this.setImports("javax.cim.CIMObjectPath");
        this.setImports("javax.cim.CIMProperty");
        this.setImports("javax.wbem.WBEMException");
        if (mClassType.equals("Provider")) {
            this.setImports("javax.wbem.provider.MethodProvider");
            this.setImports("javax.wbem.provider.ProviderHandle");
        }
    }

    @Override
    public void setMethods() {
        if (this.mClass != null) {
            this.generateCIMClassMethods();
            if (mClassType.equals("Provider") && this.mClass.getMethodCount() > 0) {
                this.addInvokeMethod();
            } else {
                this.addTypeConversionMethod();
            }
            this.addCIMClassMethods();
        }
    }

    @Override
    public void setDataMembers() {
    }

    @Override
    public void setConstants() {
        if (this.mDataConstants != null && !this.mDataConstants.containsAll(this.mClassConstants)) {
            this.mDataConstants.addAll(this.mClassConstants);
        }
    }

    public ArrayList<JavaMethod> getCIMMethods() {
        return this.interface_methods;
    }

    public ArrayList<String> getCIMImports() {
        return this.interface_imports;
    }

    private void addInvokeMethod() {
        ArrayList<String> throwList = new ArrayList<String>();
        throwList.add("WBEMException");
        ArrayList<JavaArgument> argList = new ArrayList<JavaArgument>();
        argList.add(new JavaArgument(true, "pOp", "CIMObjectPath"));
        argList.add(new JavaArgument(true, "pMethodName", "String"));
        argList.add(new JavaArgument(true, "pInArgs", "CIMArgument<?>[]"));
        argList.add(new JavaArgument(false, "pOutArgs", "CIMArgument<?>[]"));
        ArrayList<String> bText = new ArrayList<String>();
        bText.add("try{");
        bText.add("\n\t\t\tObject oRet = null;");
        ArrayList<JavaMethodVariable> bVariable = new ArrayList<JavaMethodVariable>();
        if (mClassType.equals("Provider")) {
            bText.add("\n\t\t\tcheckAccess(mProviderHandle);");
        }
        bText.add("\n\t\t\tif(pInArgs != null && pInArgs.length > 0 ){");
        if (this.mClassMethods != null && this.mClassConstants != null) {
            CIMMethod[] methods;
            String ifCondition = "";
            String innerIfCondition = "";
            for (CIMMethod m : methods = this.mClass.getMethods()) {
                if (m.isPropagated()) continue;
                int outParamCtr = 0;
                JavaDataConstant dc = null;
                String comment = "A String constant that represents the " + m.getName() + " method";
                dc = new JavaDataConstant(comment, JavaCodeWriterConstants.TYPE.PRIVATE, true, true, "String", "CMN_" + m.getName().toUpperCase(), "\"" + MethodCodeGenerator.properCase(m.getName()) + "\"");
                this.mClassConstants.add(dc);
                bText.add("\n\t\t\t\t" + ifCondition + "if (" + dc.getName() + ".equalsIgnoreCase(pMethodName)) {");
                ifCondition = "} else ";
                ArrayList<String> args = new ArrayList<String>();
                if (m.getParameters().length > 0) {
                    CIMParameter[] ja;
                    for (CIMParameter je : ja = m.getParameters()) {
                        args.add(MethodCodeGenerator.properCase(je.getName()));
                        bText.add("\n\t\t\t\t\t" + this.getDataType(je.getDataType()) + " " + MethodCodeGenerator.properCase(je.getName()) + " = null;");
                    }
                    bText.add("\n\t\t\t\t\tfor(CIMArgument<?> arg:pInArgs){");
                    for (CIMParameter je : ja) {
                        comment = "A String constant that represents the " + je.getName() + "argument of the " + m.getName() + " method.";
                        JavaDataConstant constant = new JavaDataConstant(comment, JavaCodeWriterConstants.TYPE.PRIVATE, true, true, "String", "CAN_" + m.getName().toUpperCase() + "_" + je.getName().toUpperCase(), "\"" + je.getName() + "\"");
                        this.mClassConstants.add(constant);
                        if (je.hasQualifier("IN")) {
                            if (je.hasQualifier("OUT")) {
                                ++outParamCtr;
                            }
                            bText.add("\n\t\t\t\t\t\t" + innerIfCondition + "if (" + constant.getName() + ".equalsIgnoreCase(arg.getName())){");
                            String assignStr = MethodCodeGenerator.properCase(je.getName());
                            bText.add("\n\t\t\t\t\t\t" + assignStr + " = " + "(" + this.getDataType(je.getDataType()) + ")" + "arg.getValue();");
                            innerIfCondition = " } else ";
                            continue;
                        }
                        ++outParamCtr;
                    }
                    bText.add("\n\t\t\t\t\t\t}");
                    bText.add("\n\t\t\t\t\t}");
                }
                innerIfCondition = "";
                bText.add("\n\t\t\t\t\toRet = " + MethodCodeGenerator.properCase(m.getName()) + "(" + JavaCodeWriterConstants.getCommaSeparatedLine(args) + ");");
                if (outParamCtr <= 0) continue;
                bText.addAll(this.addOutputArgs(m, outParamCtr));
            }
        }
        bText.add("\n\t\t\t\t} else{");
        bText.add("\n\t\t\t\t\tthrow new WBEMException(WBEMException.CIM_ERR_METHOD_NOT_FOUND);");
        bText.add("\n\t\t\t\t}");
        bText.add("\n\t\t\t}");
        bText.add("\n\t\t\treturn oRet;");
        bText.add("\n\t\t} catch(Throwable t){");
        bText.add("\n\t\t\tthrow new WBEMException(WBEMException.CIM_ERR_FAILED);");
        bText.add("\n\t\t}");
        JavaMethodBody body = new JavaMethodBody(bVariable, bText);
        JavaMethod m = new JavaMethod("This method is invoked in order to perform the Extrinsic Method Invocation operation as defined by the CIM operations over HTTP spec at  <a href =\"http://www.dmtf.org\">www.dmtf.org</a>. The WBEM Server calls this method when the extrinsic method specified is to be invoked. \n \n@param pOp \n\t\t\tContains the path to the instance or class(if static) whose method \n\t\t\tmust be invoked \n@param pMethodName \n\t\t\tThe name of the extrinsic method even if only one extrinsic method \n\t\t\tis supported. \n@param pInArgs \n\t\t\tAn array of CIMArgument which are the input parameters for methodName. \n\t\t\tIf methodName has no input parameters then pInArgs will be a zero- \n\t\t\tlength array. \n@param pOutArgs \n\t\t\tAn array of CIMArgument which are the output values for methodName \n\t\t\treturned bythe Provider. If methodName has no output parameters then \n\t\t\tit is assumed that the client has allocated a zero-length array that \n\t\t\tthe Provider need not modify. \n \n@return The return value of the method. \n \n@throws WBEMException \n\t\t\tIf unsuccessful, one of the following status codes may be returned. \n\t\t\tThe ORDERED list is: \n\t\t\t<ul> \n\t\t\t\t<li>CIM_ERR_ACCESS_DENIED \n\t\t\t\t<li>CIM_ERR_INVALID_PARAMETER(for this method) \n\t\t\t\t<li>CIM_ERR_NOT_FOUND(if instance does not exist) \n\t\t\t\t<li>CIM_ERR_METHOD_NOT_FOUND \n\t\t\t\t<li>CIM_ERR_METHOD_NOT_AVAILABLE(The Provider does not support \n\t\t\t\tthe method) \n\t\t\t\t<li>CIM_ERR_FAILED(some other unspecified error occurred) \n\t\t\t</ul>", JavaCodeWriterConstants.TYPE.PUBLIC, false, "Object", "invokeMethod", argList, throwList, body.toString());
        this.mMethods.add(m);
    }

    private ArrayList<String> addOutputArgs(CIMMethod<?> pMethod, int pOutParamCtr) {
        ArrayList<String> bText = new ArrayList<String>();
        if (pOutParamCtr > 0) {
            CIMParameter[] param;
            bText.add("\n\t\t\t\t\tpOutArgs = new CIMArgument[" + pOutParamCtr + "];");
            int pOutIndex = 0;
            for (CIMParameter arg : param = pMethod.getParameters()) {
                if (!arg.hasQualifierValue("OUT", (Object)true)) continue;
                CIMDataType dType = arg.getDataType();
                String typeDisc = CodeGeneratorConstants.DATATYPE[dType.getType()];
                String dataType = "";
                if (dType.getType() == 14) {
                    if (dType.isArray()) {
                        typeDisc = typeDisc + "[]";
                        dataType = ", new CIMDataType(\"" + arg.getDataType().getRefClassName() + "\", 0), ";
                    } else {
                        dataType = ", new CIMDataType(\"" + arg.getDataType().getRefClassName() + "\"), ";
                    }
                } else {
                    if (dType.isArray()) {
                        typeDisc = typeDisc + "[]";
                    }
                    dataType = ", " + this.mResourceBundleHandle.loadString(typeDisc) + ", ";
                }
                bText.add("\n\t\t\t\t\tpOutArgs[" + pOutIndex++ + "] = new CIMArgument<" + typeDisc + ">(CAN_" + pMethod.getName().toUpperCase() + "_" + arg.getName().toUpperCase() + dataType + MethodCodeGenerator.properCase(arg.getName()) + ");");
            }
        }
        return bText;
    }

    public static String properCase(String s) {
        return s.substring(0, 1).toLowerCase() + s.substring(1);
    }

    public String getMethodDescription(CIMMethod<?> pMethod) {
        StringBuffer description = new StringBuffer();
        if (pMethod.hasQualifier("Description")) {
            description.append(pMethod.getQualifierValue("Description"));
            if (pMethod.hasQualifier("Deprecated")) {
                description.append(" \n \n@deprecated\t");
                String[] deprecatedValues = (String[])pMethod.getQualifier("Deprecated").getValue();
                for (int i = 0; i < deprecatedValues.length; ++i) {
                    description.append(deprecatedValues[i]);
                    if (i >= deprecatedValues.length - 1) continue;
                    description.append(",");
                }
            }
        }
        return description.toString();
    }

    public String getDataType(CIMDataType pDataType) {
        int index = pDataType.getType();
        String dataType = CodeGeneratorConstants.DATATYPE[index];
        if (pDataType.isArray()) {
            dataType = dataType + "[]";
        }
        return dataType.toString();
    }

    private void generateCIMClassMethods() {
        CIMMethod[] method;
        if (this.mClass != null && (method = this.mClass.getMethods()) != null) {
            this.interface_methods = new ArrayList();
            this.interface_imports = new ArrayList();
            boolean errorInvalidArgIsDone = false;
            for (CIMMethod me : method) {
                if (me.isPropagated()) continue;
                String comment = this.getMethodDescription(me);
                ArrayList<JavaArgument> argList = new ArrayList<JavaArgument>();
                CIMParameter[] param = me.getParameters();
                if (param != null) {
                    for (CIMParameter p : param) {
                        boolean isFinal = false;
                        int index = p.getDataType().getType();
                        if (p.hasQualifierValue("IN", (Object)true) && !p.hasQualifierValue("OUT", (Object)true)) {
                            isFinal = true;
                        }
                        String name = "p" + p.getName();
                        argList.add(new JavaArgument(isFinal, name, this.getDataType(p.getDataType())));
                        this.addImport(index);
                        if (this.getImport(index) != "") {
                            this.interface_imports.add(this.getImport(index));
                        }
                        comment = comment + " \n \n@param p" + p.getName() + " \t" + p.getQualifierValue("Description");
                    }
                }
                ArrayList<String> bText = new ArrayList<String>();
                if (me.getDataType().getType() != 16) {
                    String methodName = me.getName();
                    String dataType = CodeGeneratorConstants.DATATYPE[me.getDataType().getType()];
                    bText.add("try{");
                    if (mClassType.equals("Client")) {
                        this.setImports("javax.cim.CIMArgument");
                        bText.add("\n\t\t\tCIMArgument<?> inParams[] = null;");
                        bText.add("\n\t\t\tCIMArgument<?> outParams[] = null;");
                        bText.add("\n\t\t\tObject obj = null;");
                        bText.add("\n\t\t\tobj = mWBEMClient.invokeMethod(mCimInstance.getObjectPath(), \"" + methodName + "\", inParams, outParams);");
                        bText.add("\n\t\t\treturn (" + dataType + ")obj;");
                        bText.add("");
                    } else {
                        if (null != param) {
                            for (CIMParameter arg : param) {
                                if (!arg.hasQualifierValue("IN", (Object)true)) continue;
                                bText.add("\n\t\t\t" + this.getDataType(arg.getDataType()) + " " + MethodCodeGenerator.properCase(arg.getName()) + " = null;");
                            }
                        }
                        if (null != param) {
                            for (CIMParameter arg : param) {
                                if (!arg.hasQualifierValue("IN", (Object)true)) continue;
                                String argName = "CAN_" + me.getName().toUpperCase() + "_" + arg.getName().toUpperCase();
                                if (arg.hasQualifierValue("Required", (Object)true)) {
                                    bText.add("\n\t\t\tif ( p" + arg.getName() + " == null ){");
                                    bText.add("\n\t\t\t\tthrow new WBEMException(WBEMException.CIM_ERR_INVALID_PARAMETER,ERROR_INVALID_ARG + " + argName + ");");
                                    bText.add("\n\t\t\t}");
                                } else {
                                    bText.add("\n\t\t\t// TODO: THIS ARGUMENT IS NOT LISTED AS REQUIRED");
                                    bText.add("\n\t\t\t/*");
                                    bText.add("\n\t\t\tIF YOUR IMPLEMENTATION REQUIRES IT, UNCOMMENT THE FOLLOWING LINES");
                                    bText.add("\n\t\t\tif ( p" + arg.getName() + " == null ){");
                                    bText.add("\n\t\t\t\tthrow new WBEMException(WBEMException.CIM_ERR_INVALID_PARAMETER,ERROR_INVALID_ARG + " + argName + ");");
                                    bText.add("\n\t\t\t}");
                                    bText.add("\n\t\t\t*/");
                                }
                                if (errorInvalidArgIsDone) continue;
                                errorInvalidArgIsDone = true;
                                this.mClassConstants.add(new JavaDataConstant("A string constant that contains the ERROR_INVALID_ARG value.", JavaCodeWriterConstants.TYPE.PRIVATE, true, true, "String", "ERROR_INVALID_ARG", "\"The input parameter can not be null: \""));
                            }
                            for (CIMParameter arg : param) {
                                if (!arg.hasQualifierValue("IN", (Object)true)) continue;
                                bText.add("\n\t\t\t" + MethodCodeGenerator.properCase(arg.getName()) + " = p" + arg.getName() + ";");
                            }
                            bText.add("\n\t\t\t//TODO IMPLEMENT THE CODE THAT PERFORMS THE METHOD HERE.");
                            for (CIMParameter arg : param) {
                                if (!arg.hasQualifierValue("OUT", (Object)true)) continue;
                                bText.add("\n\t\t\t/*");
                                bText.add("\n\t\t\t p" + arg.getName() + "is an output parameter.");
                                bText.add("\n\t\t\t Set the " + arg.getName() + "value before returning");
                                bText.add("\n\t\t\t */");
                            }
                            bText.add("\n\t\t\t// REPLACE THE NULL VALUE RETURNED WITH AN APPROPRIATE VALUE OF THE DATATYPE");
                            bText.add("\n\t\t\t// INDICATED.");
                            bText.add("\n\t\t\treturn (" + dataType + ")null;");
                        }
                    }
                    bText.add("\n\t\t} catch(Throwable t){");
                    bText.add("\n\t\t\tthrow new WBEMException(WBEMException.CIM_ERR_FAILED);");
                    bText.add("\n\t\t}");
                    int index = me.getDataType().getType();
                    this.addImport(index);
                    if (!this.getImport(index).isEmpty()) {
                        this.interface_imports.add(this.getImport(index));
                    }
                    comment = comment + " \n \n@return The return value of " + me.getName() + " method.";
                }
                ArrayList<String> throwlist = new ArrayList<String>();
                throwlist.add("WBEMException");
                comment = comment + " \n \n@throws WBEMException - is what all WBEM Operations return when there is an error.";
                this.interface_imports.add("javax.wbem.WBEMException");
                JavaMethodBody body = new JavaMethodBody(null, bText);
                JavaMethod m = new JavaMethod(comment, JavaCodeWriterConstants.TYPE.PUBLIC, false, this.getDataType(me.getDataType()), MethodCodeGenerator.properCase(me.getName()), argList, throwlist, body.toString());
                if (m == null) continue;
                this.mClassMethods.add(m);
                this.interface_methods.add(m);
            }
        }
    }

    private void addCIMClassMethods() {
        if (this.mClassMethods != null) {
            this.mMethods.addAll(this.mClassMethods);
        }
    }

    private void addTypeConversionMethod() {
        String comment = "This method will handle the data type conversion for WS-Management protocol";
        ArrayList<JavaArgument> argList = new ArrayList<JavaArgument>();
        argList.add(new JavaArgument(true, "pInstance", "CIMInstance"));
        ArrayList<String> bText = new ArrayList<String>();
        ArrayList<String> typeList = new ArrayList<String>();
        CIMClassProperty[] properties = this.mClass.getProperties();
        ArrayList<String> keyPropArray = new ArrayList<String>();
        keyPropArray.add("\n\t\tCIMProperty<?>[] keyProps = {");
        bText.add("\n\t\tCIMProperty<?>[] propList = {");
        for (CIMClassProperty classProp : properties) {
            String propDataType;
            String propName = classProp.getName();
            CIMDataType dataType = classProp.getDataType();
            String dataTypeStr = this.getImport(dataType.getType());
            if (null != dataTypeStr && !dataTypeStr.isEmpty()) {
                this.setImports(dataTypeStr);
            }
            String dType = "";
            String value = "";
            dType = dataType.getType() == 14 ? "CIMObjectPath" : this.mResourceBundleHandle.loadString(dataType + "");
            if (dataType.isArray()) {
                dType = dType + "[]";
            }
            value = "get" + dType.replaceAll("\\[\\]", "Arr") + "Value(pInstance, \"" + propName + "\")";
            if (dataType.getType() != 8) {
                if (!typeList.contains(dType)) {
                    typeList.add(dType);
                }
                propDataType = "";
                propDataType = dataType.getType() == 14 ? MessageFormat.format(this.mResourceBundleHandle.loadString(dType), dataType.getRefClassName()) : this.mResourceBundleHandle.loadString(dType);
                this.setImports("javax.cim.CIMDataType");
                bText.add("\n\t\t\tnew CIMProperty<" + dType + ">(\"" + propName + "\", " + propDataType + ", " + value + "),");
            }
            if (!classProp.isKey()) continue;
            if (!typeList.contains(dType)) {
                typeList.add(dType);
            }
            propDataType = "";
            propDataType = dataType.getType() == 14 ? MessageFormat.format(this.mResourceBundleHandle.loadString(dType), dataType.getRefClassName()) : this.mResourceBundleHandle.loadString(dType);
            this.setImports("javax.cim.CIMDataType");
            keyPropArray.add("\n\t\t\tnew CIMProperty<" + dType + ">(\"" + propName + "\", " + propDataType + ", " + value + "),");
        }
        bText.add("\n\t\t};");
        keyPropArray.add("\n\t\t};");
        bText.add("\n\t\tCIMInstance tempInst = pInstance.deriveInstance(propList);");
        for (String keyProp : keyPropArray) {
            bText.add(keyProp);
        }
        bText.add("\n\t\tCIMObjectPath op = pInstance.getObjectPath();");
        bText.add("\n\t\tCIMObjectPath derivedOP = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), op.getObjectName(), keyProps, op.getXmlSchemaName());");
        bText.add("\n\t\tsetCIMInstance(tempInst.deriveInstance(derivedOP));");
        JavaMethodBody body = new JavaMethodBody(null, bText);
        JavaMethod m = new JavaMethod(comment, JavaCodeWriterConstants.TYPE.PRIVATE, false, "void", "typeConversion", argList, null, body.toString());
        this.mMethods.add(m);
        for (String dtypes : typeList) {
            JavaMethod helperMethod = this.addHelperMethod(dtypes);
            this.mMethods.add(helperMethod);
        }
    }

    private JavaMethod addHelperMethod(String pDataType) {
        ArrayList<JavaArgument> argList = new ArrayList<JavaArgument>();
        argList.add(new JavaArgument(true, "pInstance", "CIMInstance"));
        argList.add(new JavaArgument(true, "pPropName", "String"));
        ArrayList<String> bText = new ArrayList<String>();
        String methodName = "get" + pDataType.replaceAll("\\[\\]", "Arr") + "Value";
        String comment = "Helper method that retrieves " + pDataType + " property value";
        bText.add(pDataType + " propertyValue = null;");
        bText.add("\n\t\tCIMProperty<?> property = pInstance.getProperty(pPropName);");
        bText.add("\n\t\tif(null != property){");
        if (pDataType.equals("String") || pDataType.equals("String[]")) {
            bText.add("\n\t\t\ttry {");
            bText.add("\n\t\t\t\tpropertyValue = (" + pDataType + ") property.getValue();");
            bText.add("\n\t\t\t} catch (Throwable th) {");
            bText.add("\n\t\t\t\tth.printStackTrace();");
            bText.add("\n\t\t\t}");
        } else {
            bText.add("\n\t\t\tif (property.getValue() instanceof " + pDataType + ") {");
            bText.add("\n\t\t\t\tpropertyValue = (" + pDataType + ") property.getValue();");
            bText.add("\n\t\t\t} else {");
            bText.add("\n\t\t\t\ttry {");
            if (pDataType.contains("[]")) {
                bText.add("\n\t\t\t\t\tif(property.getValue() instanceof String[]){");
                bText.add("\n\t\t\t\t\t\tString[] strValueArr = (String[]) property.getValue();");
                bText.add("\n\t\t\t\t\t\tif (strValueArr != null) {");
                bText.add("\n\t\t\t\t\t\t\tpropertyValue = new " + pDataType.substring(0, pDataType.length() - 2) + "[strValueArr.length];");
                bText.add("\n\t\t\t\t\t\t\tfor (int ndx = 0; ndx < propertyValue.length; ndx++) {");
                bText.add("\n\t\t\t\t\t\t\t\tpropertyValue[ndx] = new " + pDataType.substring(0, pDataType.length() - 2) + "(strValueArr[ndx]);");
                bText.add("\n\t\t\t\t\t\t\t}");
                bText.add("\n\t\t\t\t\t\t}");
                bText.add("\n\t\t\t\t\t} else {");
                bText.add("\n\t\t\t\t\t\tString strValue = (String) property.getValue();");
                bText.add("\n\t\t\t\t\t\tpropertyValue = new " + pDataType.substring(0, pDataType.length() - 2) + "[1];");
                bText.add("\n\t\t\t\t\t\tpropertyValue[0] = new " + pDataType.substring(0, pDataType.length() - 2) + "(strValue);");
                bText.add("\n\t\t\t\t\t}");
            } else {
                bText.add("\n\t\t\t\t\tString strValue = (String) property.getValue();");
                String dtype = pDataType;
                if (pDataType.equals("CIMDateTime")) {
                    this.setImports("javax.cim.CIMDateTimeAbsolute");
                    dtype = "CIMDateTimeAbsolute";
                }
                bText.add("\n\t\t\t\t\tpropertyValue = new " + dtype + "(strValue);");
            }
            bText.add("\n\t\t\t\t} catch (Throwable th) {");
            bText.add("\n\t\t\t\t\tth.printStackTrace();");
            bText.add("\n\t\t\t\t}");
            bText.add("\n\t\t\t}");
        }
        bText.add("\n\t\t}");
        bText.add("\n\t\treturn propertyValue;");
        JavaMethodBody body = new JavaMethodBody(null, bText);
        JavaMethod m = new JavaMethod(comment, JavaCodeWriterConstants.TYPE.PRIVATE, false, pDataType, methodName, argList, null, body.toString());
        return m;
    }
}

