/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.codegen.jsr48.client;

import com.ws.cim.codegen.java.JavaCodeWriter;
import com.ws.cim.codegen.java.JavaCodeWriterConstants;
import com.ws.cim.codegen.java.JavaEnums;
import com.ws.cim.codegen.java.JavaMethod;
import com.ws.cim.codegen.jsr48.CodeGeneratorUtils;
import com.ws.cim.codegen.jsr48.ImportManager;
import java.util.ArrayList;

public class InterfaceCodeGenerator {
    private final JavaCodeWriter cw;
    private final ArrayList<String> mImportList;
    private final ArrayList<JavaMethod> mMethodList;
    private final ImportManager mImports;
    private final String mDescription;
    private final String mClassName;
    private final String mSuperClassName;
    private final ArrayList<JavaEnums> mEnums;
    private String mPackageName;

    public InterfaceCodeGenerator(ArrayList<String> pImportList, ArrayList<JavaMethod> pMethodList, ArrayList<JavaEnums> pEnums, String pDescription, String pClassName, String pSuperClassName, String pOutdir, String pPackageName) {
        this.mImportList = new ArrayList<String>(pImportList);
        this.mMethodList = new ArrayList<JavaMethod>(pMethodList);
        this.mDescription = pDescription;
        this.mClassName = pClassName;
        this.mSuperClassName = pSuperClassName;
        this.mImports = new ImportManager();
        this.cw = new JavaCodeWriter(pOutdir);
        this.mPackageName = pPackageName;
        this.mEnums = pEnums;
    }

    public void setPackageName(String pPackageName) {
        this.mPackageName = pPackageName;
    }

    public void generateCode() throws Exception {
        String superclass = this.mSuperClassName;
        String className = this.mClassName;
        this.cw.setFileComment("This code was generated by WS SDK Pro");
        if (this.mClassName.equals("CIMBaseInterface")) {
            this.cw.setPackageName(this.mPackageName);
        } else {
            String schemaName = this.mClassName.substring(0, this.mClassName.indexOf("_")).toLowerCase();
            this.cw.setPackageName(this.mPackageName + "." + schemaName);
            className = this.mClassName + "Interface";
        }
        if (null != this.mSuperClassName && !this.mSuperClassName.isEmpty()) {
            if (!this.mSuperClassName.equals("CIMBaseInterface")) {
                String superClassSchema = CodeGeneratorUtils.getSchemaName(this.mSuperClassName);
                this.mImportList.add(this.mPackageName + "." + superClassSchema.toLowerCase() + "." + this.mSuperClassName + "Interface");
                superclass = superclass + "Interface";
            } else {
                this.mImportList.add(this.mPackageName + "." + this.mSuperClassName);
            }
        }
        for (String str : this.mImportList) {
            this.mImports.addImport(str);
        }
        for (JavaMethod me : this.mMethodList) {
            if (me.getType() == JavaCodeWriterConstants.TYPE.PROTECTED) continue;
            this.cw.addMethod(me);
        }
        String description = this.mDescription;
        this.cw.setClassInfo(false, description, className, superclass, null);
        this.cw.setImports(this.mImports.getImportList());
        this.cw.setEnums(this.mEnums);
        this.cw.write(className + ".java");
    }
}

