/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.codegen.jsr48.constants;

import com.ws.cim.codegen.java.JavaCodeWriter;
import com.ws.cim.codegen.java.JavaCodeWriterConstants;
import com.ws.cim.codegen.java.JavaDataConstant;
import com.ws.cim.codegen.jsr48.CodeGeneratorUtils;
import com.ws.cim.codegen.jsr48.ImportManager;
import java.io.File;
import java.util.ArrayList;
import javax.cim.CIMClass;
import javax.cim.CIMClassProperty;
import javax.cim.CIMMethod;
import javax.cim.CIMParameter;

public class ConstantsCodeGenerator {
    private final CIMClass mCIMClass;
    private JavaCodeWriter mCodeWriter;
    private static final String CONSTANTS = "Constants";
    private static final String DATATYPE = "String";
    private static final String NAME = "CCN_NAME";
    private static final String CCN = "CCN_";
    private static final String CPN = "CPN_";
    private static final String CMN = "CMN_";
    private static final String CAN = "CAN_";
    private static final String QUOTE = "\"";
    private String mOutdir;
    private final String mPackageName;
    private String mInitiative;
    private final ImportManager mImports;

    public ConstantsCodeGenerator(CIMClass pClass, String pOutdir, String pCompanyName, String pInitiative, String pPackage) throws Exception {
        this.mCIMClass = pClass;
        this.mOutdir = pOutdir;
        this.mPackageName = pPackage;
        this.mInitiative = pInitiative;
        this.mImports = new ImportManager();
    }

    public void generateCode() throws Exception {
        try {
            String className = this.mCIMClass.getName();
            String schemaName = className.substring(0, className.indexOf("_")).toLowerCase();
            if (this.mInitiative == null || this.mInitiative.equals("")) {
                this.mInitiative = "wbem";
            }
            String classPackageName = (this.mPackageName + ".schema." + schemaName).toLowerCase();
            this.mOutdir = (this.mOutdir + "schema" + File.separator + schemaName).toLowerCase();
            this.mCodeWriter = new JavaCodeWriter(this.mOutdir);
            this.mCodeWriter.setFileComment("This code was generated by WS SDK Pro");
            this.mCodeWriter.setPackageName(classPackageName);
            this.mCodeWriter.setImports(this.mImports.getImportList());
            ArrayList<JavaDataConstant> constants = this.generateJavaDataConstants();
            this.generateSpecificCode(constants);
            String description = this.getClassDescription();
            String parentClass = this.mCIMClass.getSuperClassName();
            if (null != parentClass) {
                parentClass = parentClass + CONSTANTS;
                String parentPackageName = this.mPackageName.toLowerCase() + ".schema." + CodeGeneratorUtils.getSchemaName(this.mCIMClass.getSuperClassName()).toLowerCase();
                if (!classPackageName.equalsIgnoreCase(parentPackageName)) {
                    this.mCodeWriter.addImport(parentPackageName + "." + parentClass);
                }
            }
            this.mCodeWriter.setClassInfo(true, description, className + CONSTANTS, parentClass, null);
            this.mCodeWriter.write(className + CONSTANTS + ".java");
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    public String getClassDescription() {
        StringBuffer description = new StringBuffer();
        if (this.mCIMClass.hasQualifier("Description")) {
            description.append(this.mCIMClass.getQualifierValue("Description"));
            if (this.mCIMClass.hasQualifier("Deprecated")) {
                description.append(" \n \n@deprecated\t");
                String[] deprecatedValues = (String[])this.mCIMClass.getQualifier("Deprecated").getValue();
                for (int i = 0; i < deprecatedValues.length; ++i) {
                    description.append(deprecatedValues[i]);
                    if (i >= deprecatedValues.length - 1) continue;
                    description.append(",");
                }
            }
        }
        return description.toString();
    }

    private void generateSpecificCode(ArrayList<JavaDataConstant> pDataConstants) {
        for (JavaDataConstant c : pDataConstants) {
            this.mCodeWriter.addDataConstant(c);
        }
    }

    private ArrayList<JavaDataConstant> generateJavaDataConstants() {
        CIMMethod[] methodArray;
        CIMClassProperty[] classPropertyArray;
        ArrayList<JavaDataConstant> constantList = new ArrayList<JavaDataConstant>();
        constantList.add(new JavaDataConstant("The Class Name", JavaCodeWriterConstants.TYPE.PUBLIC, true, true, DATATYPE, NAME, QUOTE + this.mCIMClass.getName() + QUOTE));
        for (CIMClassProperty prop : classPropertyArray = this.mCIMClass.getProperties()) {
            if (prop.isPropagated()) continue;
            if (prop.getDataType().getType() == 14) {
                String refClassName = prop.getDataType().getRefClassName();
                JavaDataConstant jdc = new JavaDataConstant("The \"" + prop.getName() + QUOTE + " Class Name", JavaCodeWriterConstants.TYPE.PUBLIC, true, true, DATATYPE, CCN + prop.getName().toUpperCase(), QUOTE + refClassName + QUOTE);
                if (!this.isConstantExist(constantList, jdc)) {
                    constantList.add(1, jdc);
                }
            }
            constantList.add(new JavaDataConstant(prop.toString(), JavaCodeWriterConstants.TYPE.PUBLIC, true, true, DATATYPE, CPN + prop.getName().toUpperCase(), QUOTE + prop.getName() + QUOTE));
        }
        for (CIMMethod method : methodArray = this.mCIMClass.getMethods()) {
            CIMParameter[] parameterArray;
            constantList.add(new JavaDataConstant(method.toString(), JavaCodeWriterConstants.TYPE.PUBLIC, true, true, DATATYPE, CMN + method.getName().toUpperCase(), QUOTE + method.getName() + QUOTE));
            for (CIMParameter param : parameterArray = method.getParameters()) {
                constantList.add(new JavaDataConstant(param.toString(), JavaCodeWriterConstants.TYPE.PUBLIC, true, true, DATATYPE, CAN + method.getName().toUpperCase() + "_" + param.getName().toUpperCase(), QUOTE + param.getName() + QUOTE));
            }
        }
        return constantList;
    }

    private boolean isConstantExist(ArrayList<JavaDataConstant> pConstantList, JavaDataConstant pContant) {
        if (null != pConstantList) {
            for (JavaDataConstant jdc : pConstantList) {
                if (!jdc.getName().equals(pContant.getName())) continue;
                return true;
            }
        }
        return false;
    }
}

