/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.codegen.jsr48.provider;

import com.ws.cim.codegen.jsr48.CodeGeneratorUtils;
import com.ws.cim.codegen.jsr48.ImportManager;
import com.ws.wbem.apps.common.WSProductInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.cim.CIMClass;
import javax.cim.CIMClassProperty;
import javax.cim.CIMMethod;

public class BaseProviderGenerator {
    public static final String BIN_DIR_NAME = "bin";
    public static final String SRC_DIR_NAME = "src";
    private static final String COMMON_DIR_NAME = "common";
    protected static final String DEFAULT_TEMPLATES_DIR = "com/ws/cim/codegen/jsr48/templates";
    private static final String BUILD_XML_TEMPLATE = "buildxml.txt";
    private static final String ASSOC_PROV_IMPL_IF = "AssocProvImplIF.txt";
    private static final String BASE_ASSOCIATOR_IMPL = "BaseAssociatorImpl.txt";
    private static final String BASE_ASSOCIATOR_PROVIDER = "BaseAssociatorProvider.txt";
    private static final String BASE_CLASS_DATA = "BaseClassData.txt";
    private static final String BASE_PROVIDER = "BaseProvider.txt";
    private static final String BASE_PROVIDER_IMPL = "BaseProviderImpl.txt";
    private static final String IMPLEMENTATION_REGISTRY = "ImplementationRegistry.txt";
    private static final String PROVIDER_IMPL_IF = "ProviderImplIF.txt";
    private static final String UNIX_FILE_SEP = "/";
    private static final String UTILITY_TITLE = "MOFMORPH";
    private static final String COMPANY = "company";
    private static final String TEMPLATES = "templates";
    private static final String PACKAGE = "package";
    private static final String COPYWRITE = "copywrite";
    private static boolean hasBuildFile = false;
    private static boolean mBaseClassesCreated = false;
    public static final String LIB_DIR_STRING = "lib";
    protected CIMClass mCIMClass;
    protected String mOutdir;
    protected String mCopywrite;
    protected String mCompanyName;
    protected String mPackageName;
    protected ImportManager mImports;
    protected boolean hasUserDefinedTemplate;
    protected ArrayList<String> mSelectedSchema;
    protected ArrayList<String> mSelectedClasses;
    private String mTemplatesDir;

    protected static StringBuilder getBasePart(String outputDirectory) {
        StringBuilder ret;
        if (null != outputDirectory) {
            ret = new StringBuilder(outputDirectory);
            if (!outputDirectory.endsWith(UNIX_FILE_SEP)) {
                ret.append(UNIX_FILE_SEP);
            }
        } else {
            ret = new StringBuilder();
        }
        return ret;
    }

    public static String getCommonDirName(String outputDirectory) {
        StringBuilder ret = BaseProviderGenerator.getBasePart(outputDirectory);
        ret.append(COMMON_DIR_NAME);
        return ret.toString();
    }

    public static String getCommonSRCName(String outputDirectory) {
        StringBuilder ret = BaseProviderGenerator.getBasePart(outputDirectory);
        ret.append(SRC_DIR_NAME);
        return ret.toString();
    }

    public static String getGeneratedJarFileName() {
        return "WSCodeGen.jar";
    }

    public BaseProviderGenerator(CIMClass pClass, String pDirPath, HashMap<String, String> pCustomPropMap, ArrayList<String> pSelectedSchema, ArrayList<String> pSelectedClasses) throws Exception {
        this.mCIMClass = pClass;
        this.mOutdir = pDirPath;
        this.mCompanyName = pCustomPropMap.get(COMPANY);
        this.mPackageName = pCustomPropMap.get(PACKAGE).toLowerCase();
        this.mTemplatesDir = pCustomPropMap.get(TEMPLATES);
        if (null == this.mTemplatesDir) {
            this.mTemplatesDir = DEFAULT_TEMPLATES_DIR;
            this.hasUserDefinedTemplate = false;
        } else {
            this.hasUserDefinedTemplate = true;
        }
        this.mCopywrite = pCustomPropMap.get(COPYWRITE);
        this.mImports = new ImportManager();
        this.mSelectedSchema = pSelectedSchema;
        this.mSelectedClasses = pSelectedClasses;
        if (!mBaseClassesCreated) {
            this.generateBaseClasses();
            mBaseClassesCreated = true;
        }
    }

    private void createBuildFile() {
        String buildxmlDir = this.mOutdir.substring(0, this.mOutdir.indexOf(SRC_DIR_NAME) - 1);
        try {
            String buildTemplate = this.getTemplate(DEFAULT_TEMPLATES_DIR, BUILD_XML_TEMPLATE);
            buildTemplate = this.replaceCompanyTag(buildTemplate);
            String sdkLocation = System.getProperty("user.dir");
            sdkLocation = sdkLocation.replaceAll("\\\\", UNIX_FILE_SEP);
            try {
                String libDir = sdkLocation.substring(0, sdkLocation.indexOf(BIN_DIR_NAME) - 1);
                buildTemplate = buildTemplate.replaceAll("\\{sdk_location\\}", libDir);
            }
            catch (Exception e) {
                buildTemplate = buildTemplate.replaceAll("\\{sdk_location\\}", sdkLocation);
            }
            String jarFile = (buildxmlDir + File.separatorChar + LIB_DIR_STRING + File.separatorChar + BaseProviderGenerator.getGeneratedJarFileName()).replaceAll("\\\\", UNIX_FILE_SEP);
            buildTemplate = buildTemplate.replaceAll("\\{generated_jar_file\\}", jarFile);
            if (null != buildTemplate) {
                this.writeFile(buildxmlDir, "build", buildTemplate, ".xml", true);
            }
        }
        catch (IOException e) {
            System.err.println("Failed to create build.xml!");
            e.printStackTrace();
        }
        catch (Throwable t) {
            System.err.println("Failed get build.xml template!");
            t.printStackTrace();
        }
    }

    private void generateBaseClasses() throws Exception {
        String baseDir = BaseProviderGenerator.getCommonDirName(this.mOutdir);
        String assocProvImplIF = this.getTemplate("com/ws/cim/codegen/jsr48/templates/common", ASSOC_PROV_IMPL_IF);
        if (null != (assocProvImplIF = this.readReplaceContent(assocProvImplIF, "AssocProvImplIF"))) {
            this.writeFile(baseDir, "AssocProvImplIF", assocProvImplIF, true);
        }
        String baseAssocImpl = this.getTemplate("com/ws/cim/codegen/jsr48/templates/common", BASE_ASSOCIATOR_IMPL);
        if (null != (baseAssocImpl = this.readReplaceContent(baseAssocImpl, "BaseAssociatorImpl"))) {
            this.writeFile(baseDir, "BaseAssociatorImpl", baseAssocImpl, true);
        }
        String baseAssocProvider = this.getTemplate("com/ws/cim/codegen/jsr48/templates/common", BASE_ASSOCIATOR_PROVIDER);
        if (null != (baseAssocProvider = this.readReplaceContent(baseAssocProvider, "BaseAssociatorProvider"))) {
            this.writeFile(baseDir, "BaseAssociatorProvider", baseAssocProvider, true);
        }
        String baseClassDataTemplate = null;
        baseClassDataTemplate = this.getTemplate("com/ws/cim/codegen/jsr48/templates/common", BASE_CLASS_DATA);
        String baseClassData = this.readReplaceContent(baseClassDataTemplate, "BaseClassData");
        if (null != baseClassData) {
            this.writeFile(baseDir, "BaseClassData", baseClassData, true);
        }
        String baseProviderTemplate = null;
        baseProviderTemplate = this.getTemplate("com/ws/cim/codegen/jsr48/templates/common", BASE_PROVIDER);
        String baseProvider = this.readReplaceContent(baseProviderTemplate, "BaseProvider");
        if (null != baseProvider) {
            this.writeFile(baseDir, "BaseProvider", baseProvider, true);
        }
        String baseProviderImpl = this.getTemplate("com/ws/cim/codegen/jsr48/templates/common", BASE_PROVIDER_IMPL);
        if (null != (baseProviderImpl = this.readReplaceContent(baseProviderImpl, "BaseProviderImpl"))) {
            this.writeFile(baseDir, "BaseProviderImpl", baseProviderImpl, true);
        }
        String implementationRegistry = this.getTemplate("com/ws/cim/codegen/jsr48/templates/common", IMPLEMENTATION_REGISTRY);
        if (null != (implementationRegistry = this.readReplaceContent(implementationRegistry, "ImplementationRegistry"))) {
            this.writeFile(baseDir, "ImplementationRegistry", implementationRegistry, true);
        }
        String providerImplIF = this.getTemplate("com/ws/cim/codegen/jsr48/templates/common", PROVIDER_IMPL_IF);
        if (null != (providerImplIF = this.readReplaceContent(providerImplIF, "ProviderImplIF"))) {
            this.writeFile(baseDir, "ProviderImplIF", providerImplIF, true);
        }
        if (!hasBuildFile) {
            this.createBuildFile();
            hasBuildFile = true;
        }
    }

    private String generateMethodSwitch() throws Exception {
        CIMMethod[] methodArray;
        StringBuilder invokeMethodSwitch = new StringBuilder();
        if (this.mCIMClass != null && null != (methodArray = this.mCIMClass.getMethods()) && methodArray.length > 0) {
            for (CIMMethod method : methodArray) {
                String methodName = method.getName();
                String caseStatement = MessageFormat.format(CodeGeneratorUtils.loadString("INVOKE_METHOD_SWITCH_STATEMENT"), methodName.toUpperCase(), methodName);
                invokeMethodSwitch.append(caseStatement);
            }
        }
        if (invokeMethodSwitch.length() > 0) {
            this.mImports.addImport("javax.cim.CIMArgument");
            this.mImports.addImport("javax.cim.UnsignedInteger32");
            return invokeMethodSwitch.toString();
        }
        return "";
    }

    private String getArrayString(String dt, Object[] value) {
        StringBuilder b = new StringBuilder("new ");
        b.append(dt);
        b.append("[] { ");
        boolean first = true;
        for (Object v : value) {
            b.append("new ");
            b.append(dt);
            b.append("(\"");
            if (null != v && !v.equals("")) {
                b.append(v);
            } else if ("String".equals(dt)) {
                b.append("Generated Value");
            }
            b.append("\")");
            if (!first) {
                b.append(", ");
            }
            first = false;
        }
        b.append(" }");
        return b.toString();
    }

    private String getCopywrite() {
        try {
            if (this.mCopywrite == null || this.mCopywrite.isEmpty()) {
                return "";
            }
            StringBuilder copywrite = new StringBuilder();
            try (FileReader fr = new FileReader(this.mCopywrite);
                 BufferedReader br = new BufferedReader(fr);){
                String textLine;
                while ((textLine = br.readLine()) != null) {
                    copywrite.append(textLine).append("\n * ");
                }
            }
            return copywrite.toString();
        }
        catch (Exception e) {
            System.err.println("Unable to get copywrite");
            e.printStackTrace();
            return "";
        }
    }

    protected String getTemplate(String pTemplateDir, String pTemplateName) throws Exception {
        String template = null;
        InputStream templateFile = null;
        if (this.hasUserDefinedTemplate) {
            try {
                templateFile = new FileInputStream(new File(this.mTemplatesDir + UNIX_FILE_SEP + pTemplateName));
            }
            catch (FileNotFoundException e) {
                templateFile = this.getClass().getClassLoader().getResourceAsStream(pTemplateDir + UNIX_FILE_SEP + pTemplateName);
            }
        } else {
            templateFile = this.getClass().getClassLoader().getResourceAsStream(pTemplateDir + UNIX_FILE_SEP + pTemplateName);
        }
        if (null != templateFile) {
            BufferedReader input = null;
            InputStreamReader templateStream = new InputStreamReader(templateFile);
            StringBuilder contents = new StringBuilder();
            input = new BufferedReader(templateStream);
            String newLine = System.getProperty("line.separator");
            String line = null;
            while ((line = input.readLine()) != null) {
                contents.append(line);
                contents.append(newLine);
            }
            template = contents.toString();
            templateStream.close();
            input.close();
        }
        if (null != templateFile) {
            templateFile.close();
        }
        return template;
    }

    private String hashsetToString(HashSet<String> pHashsetStr) {
        Iterator<String> iter = pHashsetStr.iterator();
        StringBuilder strBuilder = new StringBuilder();
        while (iter.hasNext()) {
            strBuilder.append(iter.next());
        }
        return strBuilder.toString();
    }

    protected String readReplaceContent(String pTemplate, String pClassName) throws Exception {
        String additionalImports;
        String propName;
        if (null == pTemplate) {
            throw new Exception("Error: Could not read the Template. Please verify location and filename");
        }
        String modifiedContent = null;
        String className = CodeGeneratorUtils.stripSchemaName(pClassName);
        String schemaName = CodeGeneratorUtils.getSchemaName(pClassName);
        String copywrite = this.getCopywrite();
        String tempStr = pTemplate;
        WSProductInfo sdkProduct = new WSProductInfo("com.ws.wbem.apps.mofmorph");
        tempStr = tempStr.replaceAll("\\{productTitle\\}", sdkProduct.getProductName() == null ? "" : sdkProduct.getProductName());
        tempStr = tempStr.replaceAll("\\{versionName\\}", sdkProduct.getVersion() == null ? "" : sdkProduct.getVersion());
        tempStr = tempStr.replaceAll("\\{copywrite\\}", copywrite);
        tempStr = tempStr.replaceAll("\\{utilityTitle\\}", UTILITY_TITLE);
        tempStr = tempStr.replaceAll("\\{packageName\\}", this.mPackageName.toLowerCase());
        tempStr = tempStr.replaceAll("\\{company\\}", this.mCompanyName.toLowerCase());
        tempStr = this.replaceCompanyTag(tempStr);
        Calendar calendar = Calendar.getInstance();
        tempStr = tempStr.replaceAll("\\{YEAR\\}", Integer.toString(calendar.get(1)));
        tempStr = tempStr.replaceAll("\\{ClassName\\}", className);
        tempStr = tempStr.replaceAll("\\{schemaName\\}", schemaName.toLowerCase());
        tempStr = tempStr.replaceAll("\\{SchemaName\\}", schemaName);
        if (this.mCIMClass.isAssociation()) {
            CIMClassProperty[] propArray = this.mCIMClass.getProperties();
            if (null != propArray) {
                ArrayList<CIMClassProperty> refProps = new ArrayList<CIMClassProperty>();
                for (CIMClassProperty prop : propArray) {
                    if (prop.getDataType().getType() != 14) continue;
                    refProps.add(prop);
                }
                if (null != refProps && refProps.size() >= 2) {
                    String refClassName1 = CodeGeneratorUtils.stripSchemaName(((CIMClassProperty)refProps.get(0)).getDataType().getRefClassName());
                    tempStr = tempStr.replaceAll("CCN_\\{Ref1ClassName\\}", "CCN_" + refClassName1.toUpperCase());
                    tempStr = tempStr.replaceAll("\\{Ref1ClassName\\}", refClassName1);
                    String refClassName2 = CodeGeneratorUtils.stripSchemaName(((CIMClassProperty)refProps.get(1)).getDataType().getRefClassName());
                    tempStr = tempStr.replaceAll("CCN_\\{Ref2ClassName\\}", "CCN_" + refClassName2.toUpperCase());
                    if (refClassName1.equals(refClassName2)) {
                        tempStr = tempStr.replaceAll("inst\\{Ref2ClassName\\}", "inst" + refClassName2 + "2");
                        tempStr = tempStr.replaceAll("op\\{Ref2ClassName\\}", "op" + refClassName2 + "2");
                    }
                    tempStr = tempStr.replaceAll("\\{Ref2ClassName\\}", refClassName2);
                    tempStr = tempStr.replaceAll("\\{REF1\\}", ((CIMClassProperty)refProps.get(0)).getName().toUpperCase());
                    tempStr = tempStr.replaceAll("\\{ref1\\}", ((CIMClassProperty)refProps.get(0)).getName());
                    tempStr = tempStr.replaceAll("\\{REF2\\}", ((CIMClassProperty)refProps.get(1)).getName().toUpperCase());
                    tempStr = tempStr.replaceAll("\\{ref2\\}", ((CIMClassProperty)refProps.get(1)).getName());
                }
            }
        } else {
            String keyPropString = "";
            String PropString = "";
            StringBuilder keyPropList = new StringBuilder();
            CIMClassProperty[] props = this.mCIMClass.getProperties();
            if (null != props && props.length > 1) {
                StringBuilder keyProps = new StringBuilder();
                StringBuilder nonKeyProps = new StringBuilder();
                int keyCount = 0;
                for (CIMClassProperty prop : props) {
                    String dataType = CodeGeneratorUtils.loadString(prop.getDataType().toString());
                    this.mImports.addImport(prop.getDataType().getType());
                    if (prop.getDataType().isArray()) {
                        dataType = dataType + "[]";
                    }
                    if (prop.isKey()) {
                        propName = "CPN_" + prop.getName().toUpperCase();
                        keyProps.append(MessageFormat.format(CodeGeneratorUtils.loadString("NEW_PROPERTY"), dataType, propName, CodeGeneratorUtils.loadString(dataType), "true"));
                        keyPropList.append(propName).append(",");
                        ++keyCount;
                        continue;
                    }
                    nonKeyProps.append(MessageFormat.format(CodeGeneratorUtils.loadString("NEW_PROPERTY"), dataType, "CPN_" + prop.getName().toUpperCase(), CodeGeneratorUtils.loadString(dataType), "false"));
                }
                keyPropString = keyProps.length() > 1 ? MessageFormat.format(CodeGeneratorUtils.loadString("KEY_PROPERTIES"), keyProps.substring(0, keyProps.length() - 1)) : CodeGeneratorUtils.loadString("NO_KEY_PROPERTIES");
                StringBuilder keyCountStr = new StringBuilder();
                for (int count = 0; count < keyCount; ++count) {
                    keyCountStr.append("keys[").append(count).append("], ");
                    if (count % 4 != 0 || count <= 1) continue;
                    keyCountStr.append("\n\t\t\t\t\t");
                }
                if (nonKeyProps.length() > 1) {
                    PropString = keyCount != 0 ? MessageFormat.format(CodeGeneratorUtils.loadString("PROPERTIES_WITH_KEYS"), keyCountStr.toString(), nonKeyProps.substring(0, nonKeyProps.length() - 1)) : MessageFormat.format(CodeGeneratorUtils.loadString("PROPERTIES_WITHOUT_KEYS"), nonKeyProps.substring(0, nonKeyProps.length() - 1));
                }
            }
            tempStr = tempStr.replaceAll("\\{KeyProperties\\}", keyPropString);
            tempStr = tempStr.replaceAll("\\{Properties\\}", PropString);
            String keyPropListStr = "";
            if (keyPropList.length() > 1) {
                String str = keyPropList.toString();
                keyPropListStr = str.substring(0, str.length() - 1);
            }
            tempStr = tempStr.replaceAll("\\{KeyPropertyList\\}", keyPropListStr);
        }
        HashSet<String> propSetters = new HashSet<String>();
        StringBuilder propWithValues = new StringBuilder();
        StringBuilder propKeyWithValues = new StringBuilder();
        StringBuilder keyList = new StringBuilder();
        CIMClassProperty[] props = this.mCIMClass.getProperties();
        if (null != props && props.length > 1) {
            for (CIMClassProperty prop : props) {
                String propSetterStr;
                String dataType;
                boolean isRefProp = false;
                Object propValue = prop.getValue();
                String dType = prop.getDataType().toString();
                if (dType.equals("datetime")) {
                    dType = dType + "_interval";
                    this.mImports.addImport("javax.cim.CIMDateTimeInterval");
                } else if (null != dType && dType.contains("REF")) {
                    dType = "ref";
                    isRefProp = true;
                }
                if (prop.isKey()) {
                    propName = prop.getName();
                    keyList.append("CPN_").append(propName.toUpperCase()).append(", ");
                    String value = "null";
                    if (propName.equals("Name") || propName.equals("CreationClassName") || propName.equals("SystemCreationClassName")) {
                        value = "getClassName()";
                    } else if (propName.equals("SystemName")) {
                        value = "op.getHost()";
                    } else if (propName.equals("InstanceID")) {
                        value = "\"" + this.mCIMClass.getName() + ":" + "0001" + "\"";
                    }
                    propKeyWithValues.append(MessageFormat.format(CodeGeneratorUtils.loadString("PROPERTY_KEY_VALUE_SETTERS"), propName, value));
                } else {
                    dataType = CodeGeneratorUtils.loadString(dType);
                    if (null != propValue && !propValue.toString().isEmpty()) {
                        if (propValue instanceof Object[]) {
                            propWithValues.append(MessageFormat.format(CodeGeneratorUtils.loadString("PROPERTY_VALUE_SETTERS_ARRAY"), prop.getName(), this.getArrayString(dataType, (Object[])propValue)));
                        } else {
                            propWithValues.append(MessageFormat.format(CodeGeneratorUtils.loadString("PROPERTY_VALUE_SETTERS"), prop.getName(), dataType, propValue.toString()));
                        }
                    }
                }
                dataType = CodeGeneratorUtils.loadString(dType);
                this.mImports.addImport(prop.getDataType().getType());
                if (prop.getDataType().isArray()) {
                    dataType = dataType + "[]";
                }
                if (isRefProp) {
                    this.mImports.addImport("javax.wbem.WBEMException");
                    propSetterStr = MessageFormat.format(CodeGeneratorUtils.loadString("PROPERTY_REF_SETTERS"), prop.getName(), prop.getName().toUpperCase());
                    propSetters.add(propSetterStr);
                    continue;
                }
                propSetterStr = MessageFormat.format(CodeGeneratorUtils.loadString("PROPERTY_SETTERS"), prop.getName(), dataType, prop.getName().toUpperCase(), CodeGeneratorUtils.loadString(dataType));
                propSetters.add(propSetterStr);
            }
            tempStr = !propSetters.isEmpty() ? tempStr.replaceAll("\\{propertySetters\\}", this.hashsetToString(propSetters)) : tempStr.replaceAll("\\{propertySetters\\}", " ");
            tempStr = !propKeyWithValues.toString().isEmpty() ? tempStr.replaceAll("\\{prop_key_value_setters\\}", propKeyWithValues.toString()) : tempStr.replaceAll("\\{prop_key_value_setters\\}", " ");
            if (!propWithValues.toString().isEmpty()) {
                tempStr = tempStr.replaceAll("\\{prop_value_setters\\}", propWithValues.toString());
                tempStr = tempStr.replaceAll("\\{catch_WBEMException\\}", CodeGeneratorUtils.loadString("CATCH_WBEMEXCEPTION"));
            } else {
                tempStr = tempStr.replaceAll("\\{prop_value_setters\\}", " ");
                tempStr = tempStr.replaceAll("\\{catch_WBEMException\\}", " ");
            }
            tempStr = tempStr.replaceAll("\"\"", "\"");
        } else {
            tempStr = tempStr.replaceAll("\\{propertySetters\\}", " ");
            tempStr = tempStr.replaceAll("\\{prop_key_value_setters\\}", " ");
            tempStr = tempStr.replaceAll("\\{prop_value_setters\\}", " ");
        }
        CIMMethod[] methods = this.mCIMClass.getMethods();
        if (null != methods && methods.length > 0) {
            this.mImports.addImport("javax.cim.CIMArgument");
            this.mImports.addImport("javax.cim.CIMObjectPath");
            this.mImports.addImport("javax.cim.UnsignedInteger32");
            this.mImports.addImport("javax.wbem.WBEMException");
            String methodName = methods[0].getName();
            StringBuilder exMethod1 = new StringBuilder(MessageFormat.format(CodeGeneratorUtils.loadString("EXTRINSIC_METHOD1"), methodName.toUpperCase(), methodName));
            String extrisicMethod_2Str = CodeGeneratorUtils.loadString("EXTRINSIC_METHOD2");
            String abstractMethodStr = CodeGeneratorUtils.loadString("ABSTRACT_EXTRINSIC_METHOD");
            StringBuilder exMethod2 = new StringBuilder(MessageFormat.format(extrisicMethod_2Str, methodName, methodName.toUpperCase()));
            String extrisicMethod_1Str = CodeGeneratorUtils.loadString("EXTRINSIC_METHOD1_1");
            StringBuilder abstractExMethod = new StringBuilder(MessageFormat.format(abstractMethodStr, methodName, methodName.toUpperCase()));
            for (int ndx = 1; ndx < this.mCIMClass.getMethodCount(); ++ndx) {
                methodName = methods[ndx].getName();
                exMethod1.append(MessageFormat.format(extrisicMethod_1Str, methodName.toUpperCase(), methodName));
                exMethod2.append(MessageFormat.format(extrisicMethod_2Str, methodName, methodName.toUpperCase()));
                abstractExMethod.append(MessageFormat.format(abstractMethodStr, methodName, methodName.toUpperCase()));
            }
            tempStr = tempStr.replaceAll("\\{extrinsicMethod1\\}", exMethod1.toString());
            tempStr = tempStr.replaceAll("\\{extrinsicMethod2\\}", exMethod2.toString());
            tempStr = tempStr.replaceAll("//\\{AbstractMethods\\}", abstractExMethod.toString());
        }
        String invokeMethodSwitch = this.generateMethodSwitch();
        tempStr = tempStr.replaceAll("\\{invokeMethodName_switch\\}", invokeMethodSwitch);
        String keyListStr = keyList.toString().trim();
        if (null != keyListStr && keyListStr.length() > 0) {
            keyListStr = keyListStr.substring(0, keyListStr.length() - 1);
        }
        if (null != (tempStr = null != (additionalImports = this.mImports.toString(tempStr = tempStr.replaceAll("\\{key_props_list\\}", keyListStr))) && !additionalImports.isEmpty() ? tempStr.replaceAll("\\{Imports\\}", additionalImports.substring(0, additionalImports.length() - 1)) : tempStr.replaceAll("\\{Imports\\}", " "))) {
            modifiedContent = tempStr;
        }
        return modifiedContent;
    }

    private String replaceCompanyTag(String str4Replace) {
        return str4Replace.replaceAll("\\{Company\\}", this.mCompanyName);
    }

    protected void writeFile(String pOutDir, String pClassName, String pModifiedContent, boolean pOverwrite) throws IOException {
        this.writeFile(pOutDir, pClassName, pModifiedContent, ".java", pOverwrite);
    }

    private void writeFile(String pOutDir, String pClassName, String pModifiedContent, String pFileExtention, boolean pOverwrite) throws IOException {
        if (null != pModifiedContent) {
            File dir = new File(pOutDir);
            String className = CodeGeneratorUtils.stripSchemaName(pClassName);
            if (!(dir.exists() && dir.isDirectory() || dir.mkdirs())) {
                throw new IllegalArgumentException("could not create directory: " + this.mOutdir);
            }
            String fileName = pOutDir + File.separator + className + pFileExtention;
            File cFile = new File(fileName);
            if (cFile.exists()) {
                if (pOverwrite) {
                    cFile.delete();
                } else {
                    return;
                }
            }
            try (BufferedWriter out = new BufferedWriter(new FileWriter(fileName, false));){
                out.write(pModifiedContent);
            }
        }
    }
}

