/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.json;

import com.ws.cim.CIMMapping;
import com.ws.cim.json.CIMRSElementsWriter;
import java.io.File;
import java.io.FileOutputStream;
import javax.cim.CIMClass;
import javax.cim.CIMElement;
import javax.cim.CIMInstance;
import javax.cim.CIMQualifierType;

public class JSONMapping
implements CIMMapping {
    private static final String FORMAT_JSON = "json";
    private boolean mIsTyped;
    private CIMRSElementsWriter mWriter;
    private boolean mQuiet;
    private String mOutdir;
    private FileOutputStream mQualifierTypeFile;
    private FileOutputStream mInstancesFile;

    @Override
    public void initialize(String outdir) throws Exception {
        this.mOutdir = outdir;
        this.mIsTyped = true;
        this.mWriter = new CIMRSElementsWriter(true);
    }

    private void initInstanceFile() throws Exception {
        if (null == this.mInstancesFile) {
            this.mInstancesFile = new FileOutputStream(this.mOutdir + File.separator + "instances.json");
        }
    }

    private void initQTFile() throws Exception {
        if (null == this.mQualifierTypeFile) {
            this.mQualifierTypeFile = new FileOutputStream(this.mOutdir + File.separator + "qualifiertypes.json");
        }
    }

    @Override
    public void close() throws Exception {
        if (!this.mQuiet) {
            // empty if block
        }
        if (null != this.mQualifierTypeFile) {
            this.mQualifierTypeFile.flush();
            this.mQualifierTypeFile.close();
        }
        if (null != this.mInstancesFile) {
            this.mInstancesFile.flush();
            this.mInstancesFile.close();
        }
    }

    @Override
    public void produceMappedElement(CIMElement element) throws Exception {
        if (element instanceof CIMClass) {
            CIMClass clazz = (CIMClass)element;
            FileOutputStream classFile = new FileOutputStream(this.mOutdir + File.separator + clazz.getName() + ".json");
            this.mWriter.writeCIMClass(classFile, (CIMClass)element, true);
            classFile.flush();
            classFile.close();
        } else if (element instanceof CIMQualifierType) {
            this.initQTFile();
            this.mWriter.writeCIMQualifierType(this.mQualifierTypeFile, (CIMQualifierType)element);
        }
    }

    @Override
    public void produceMappedInstance(CIMInstance instance) throws Exception {
        this.initInstanceFile();
        this.mWriter.writeCIMInstance(this.mInstancesFile, instance, this.mIsTyped);
    }

    @Override
    public void setFormat(String format) {
        if (!format.equalsIgnoreCase(FORMAT_JSON)) {
            throw new IllegalArgumentException("Format not supported.");
        }
    }

    @Override
    public void setProperty(String name, String value) {
        if ("q".equalsIgnoreCase(name)) {
            this.mQuiet = true;
        } else if ("nt".equalsIgnoreCase(name)) {
            this.mIsTyped = false;
        }
    }

    @Override
    public String[] getCustomPropertyNames(String format) {
        if (FORMAT_JSON.equalsIgnoreCase(format)) {
            return new String[]{"nt", "q"};
        }
        return null;
    }

    @Override
    public String getCustomPropertyDescription(String cpName) {
        if ("q".equals(cpName)) {
            return "This option will supress all output (not including exceptions).";
        }
        if ("nt".equals(cpName)) {
            return "This option will remove the type information from instances";
        }
        return null;
    }
}

