/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.v3;

import com.ws.cim.CIMMapping;
import com.ws.cim.v3.V3MOFMapping;
import java.util.Properties;
import javax.cim.CIMClass;
import javax.cim.CIMElement;
import javax.cim.CIMInstance;

public class CIMV3Mapping
implements CIMMapping {
    private static final String FORMAT_MOF = "MOF";
    private String mFormat;
    private Properties mProps;
    private V3MOFMapping mV3;

    @Override
    public void close() {
        this.mV3.close();
    }

    public CIMElement getCIMElement(Object mapping) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getCustomPropertyDescription(String cpName) {
        if ("q".equals(cpName)) {
            return "This option will supress all output (not including errors)";
        }
        if ("v".equals(cpName)) {
            return "This option will set the version number (e.g. 1.0.0)";
        }
        if ("d".equals(cpName)) {
            return "This option will turn off the removal of deprecated classes, properties and methods.";
        }
        if ("p".equals(cpName)) {
            return "This option will put the files into directories based on the PackaPath qualifier value";
        }
        if ("f".equals(cpName)) {
            return "This option will only convert elements with the schema names (case sensitive) provided";
        }
        return null;
    }

    @Override
    public String[] getCustomPropertyNames(String format) {
        if (FORMAT_MOF.equalsIgnoreCase(format)) {
            return new String[]{"d", "p", "q", "v"};
        }
        return null;
    }

    @Override
    public void initialize(String outdir) {
        this.mProps = new Properties();
        this.mV3 = new V3MOFMapping(outdir);
    }

    @Override
    public void produceMappedElement(CIMElement element) throws Exception {
        if (element instanceof CIMClass) {
            if (FORMAT_MOF.equals(this.mFormat)) {
                this.mV3.mapIt((CIMElement)((CIMClass)element).filterProperties(true, true), this.mProps);
            }
        }
    }

    @Override
    public void produceMappedInstance(CIMInstance instance) throws Exception {
    }

    @Override
    public void setFormat(String format) {
        if (format.equalsIgnoreCase(FORMAT_MOF)) {
            this.mFormat = FORMAT_MOF;
            return;
        }
        throw new IllegalArgumentException("The format \"" + format + "\" is not valid.");
    }

    @Override
    public void setProperty(String name, String value) {
        this.mProps.put(name, value);
    }
}

