/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.xmi.metaclass;

import com.ws.cim.xmi.metaclass.BaseMetaClass;
import com.ws.cim.xmi.metaclass.OperationMetaClass;
import com.ws.cim.xmi.metaclass.PropertyMetaClass;
import com.ws.utilities.Resources;
import java.text.MessageFormat;
import javax.cim.CIMClass;
import javax.cim.CIMClassProperty;
import javax.cim.CIMMethod;

public class ClassMetaClass
extends BaseMetaClass {
    private static final String BUNDLE = "com.ws.cim.xmi.XMIGenerator";
    protected CIMClass mClass;
    private Resources mLocalResourceHandle;

    public ClassMetaClass(CIMClass pClass) {
        this.mClass = pClass;
        this.mName = pClass.getName();
        this.mLocalResourceHandle = new Resources(BUNDLE);
    }

    public String toString(String pTabs) {
        String tabs = pTabs + "\t";
        String generalization = this.generateGeneralization(tabs);
        String ownedAttribute = this.generateOwnedAttributes(tabs);
        String ownedOperation = this.generateOwnedOperation(tabs);
        String ownedComment = this.generateOwnedComment(this.mClass, tabs);
        String classInfo = MessageFormat.format(this.mLocalResourceHandle.loadString("CLASS_METACLASS"), pTabs, this.mName, this.isAbstract(), this.isLeaf(), this.mVisibility, generalization, ownedAttribute, ownedOperation, ownedComment);
        return classInfo;
    }

    protected String isAbstract() {
        if (this.mClass.hasQualifier("Abstract")) {
            return " isAbstract=\"true\"";
        }
        return "";
    }

    protected String isLeaf() {
        if (this.mClass.hasQualifier("Terminal")) {
            return " isLeaf=\"true\"";
        }
        return "";
    }

    protected String isDerived() {
        return "false";
    }

    protected String generateOwnedAttributes(String pTabs) {
        StringBuffer propertyInfos = new StringBuffer();
        CIMClassProperty[] classProperties = this.mClass.getProperties();
        if (null != classProperties && classProperties.length > 0) {
            for (CIMClassProperty classProperty : classProperties) {
                PropertyMetaClass propertyMetaClass = new PropertyMetaClass(classProperty, this.mClass.getName(), this.mClass.isAssociation());
                propertyInfos.append(propertyMetaClass.toString(pTabs + "\t"));
            }
        }
        return propertyInfos.toString();
    }

    protected String generateOwnedOperation(String pTabs) {
        StringBuffer methodInfos = new StringBuffer();
        CIMMethod[] classMethods = this.mClass.getMethods();
        if (null != classMethods && classMethods.length > 0) {
            for (CIMMethod classMethod : classMethods) {
                OperationMetaClass operationMetaClass = new OperationMetaClass(classMethod);
                methodInfos.append(operationMetaClass.toString(pTabs + "\t"));
            }
        }
        return methodInfos.toString();
    }

    protected String generateGeneralization(String pTabs) {
        String retVal = "";
        String parentClass = this.mClass.getSuperClassName();
        if (null != parentClass) {
            return MessageFormat.format(this.mLocalResourceHandle.loadString("GENERALIZATION"), pTabs, parentClass);
        }
        return retVal;
    }
}

