/*
 * Decompiled with CFR 0.152.
 */
package sanproject.session.server;

import java.rmi.Naming;
import java.rmi.registry.LocateRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import sanproject.session.common.SJsessionDef;
import sanproject.session.common.receive.inf.SJsessionReceiveInterface;
import sanproject.session.common.remote.inf.SJsessionRemoteInterface;
import sanproject.session.server.common.SJsessionServerUty;
import sanproject.session.server.process.plugin.SJsessionProcessPluginManager;
import sanproject.session.server.receive.manager.SJsessionReceiveModuleManager;
import sanproject.session.server.receive.plugin.SJsessionReceivePluginItem;
import sanproject.session.server.receive.plugin.SJsessionReceivePluginManager;
import sanproject.session.server.remote.SJsessionRemote;
import sanproject.session.server.store.SJsessionStoreHouse;
import sanproject.session.server.unique.SJsessionUniqueIDUtility;
import sanproject.sn2.base.property.SJbaseSystemPropertiesManager;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.SJcSecureUty;

public class SJsessionWakeUpper {
    private static final String LOG_FUNCTION = "SessionServer";
    private static final String LOG_TITLE = SJsessionWakeUpper.class.getSimpleName();
    private static SJcLoggerInterface logger = null;
    private static SJsessionRemoteInterface remote = null;
    private static SJbaseSystemPropertiesManager sysPropMgr = null;
    private static Timer rmiCheckTimer = null;

    public static void main(String[] args) {
        String LOG_SUBTITLE = "main";
        try {
            SJsessionWakeUpper.initProperty();
            System.setProperty("SN_LogPath", "session");
            SJsessionWakeUpper.initSystemProperties();
        }
        catch (Exception ex) {
            System.exit(0);
        }
        logger = SJsessionServerUty.getLogger();
        logger.info(LOG_FUNCTION, LOG_TITLE, "main", "Start.");
        try {
            SJsessionWakeUpper.initialize();
            remote = new SJsessionRemote();
            SJsessionWakeUpper.rebirth();
            int port = SJsessionWakeUpper.initRegistry();
            String url = SJsessionWakeUpper.bindRegistry(port);
            SJsessionWakeUpper.startTimer(url);
        }
        catch (Exception e) {
            logger.error(LOG_FUNCTION, LOG_TITLE, "main", "Exception", e);
            SJsessionWakeUpper.finish();
            System.exit(0);
        }
        catch (Error e) {
            System.exit(0);
        }
        logger.info(LOG_FUNCTION, LOG_TITLE, "main", "End.");
    }

    private static void rebirth() {
        String LOG_SUBTITLE = "rebirth";
        logger.info(LOG_FUNCTION, LOG_TITLE, "rebirth", "Start.");
        String path = SJcFileUty.setEndPathSeparator("tmp") + "SVPLogin.dat";
        if (!SJcFileUty.exists(path)) {
            logger.info(LOG_FUNCTION, LOG_TITLE, "rebirth", "SVPLogin.dat Not Found.");
            logger.info(LOG_FUNCTION, LOG_TITLE, "rebirth", "End.");
            return;
        }
        try {
            HashMap<String, Object> info = new HashMap<String, Object>();
            info.put("APPLICATIONID", "SVPWIN");
            info.put("VERSION", SJsessionDef.VERSION_VAL);
            SJsessionReceiveInterface receive = remote.getSessionReceiver(info);
            byte[] loginBin = new byte[]{};
            loginBin = SJcFileUty.loadBinary("tmp", "SVPLogin.dat", 0, -1);
            HashMap reloginInfo = (HashMap)SJcSecureUty.decryptDeserialize(loginBin);
            ArrayList<HashMap> loginList = new ArrayList<HashMap>();
            loginList.add(reloginInfo);
            reloginInfo.put("RELOGIN_LIST", loginList);
            receive.reLogin(reloginInfo);
        }
        catch (Exception ex) {
            logger.error(LOG_FUNCTION, LOG_TITLE, "rebirth", "Exception", ex);
        }
        logger.info(LOG_FUNCTION, LOG_TITLE, "rebirth", "End.");
    }

    private static void initProperty() {
        String defPath;
        String snDataPath = System.getProperty("SN_DataPath");
        if (snDataPath == null) {
            System.setProperty("SN_DataPath", "C:\\dkc200\\san\\SN2\\SN2Files");
            snDataPath = "C:\\dkc200\\san\\SN2\\SN2Files";
        }
        if (System.getProperty("SN_EnvFile") == null) {
            defPath = SJcFileUty.setEndPathSeparator(snDataPath) + "data\\base\\setting\\system\\properties\\SN2_Startup.properties";
            System.setProperty("SN_EnvFile", defPath);
        }
        if (System.getProperty("SN_EnvFileV") == null) {
            defPath = SJcFileUty.setEndPathSeparator(snDataPath) + "data\\base\\setting\\system\\properties\\SN2_StartupV.properties";
            System.setProperty("SN_EnvFileV", defPath);
        }
    }

    private static void initSystemProperties() {
        sysPropMgr = new SJbaseSystemPropertiesManager();
        sysPropMgr.initialize(0);
    }

    private static void finishSystemProperties() {
        if (sysPropMgr != null) {
            sysPropMgr.finish();
        }
    }

    private static int initRegistry() throws Exception {
        String LOG_SUBTITLE = "initRegistry";
        logger.info(LOG_FUNCTION, LOG_TITLE, "initRegistry", "Start.");
        int port = SJcEnvUty.getProperty2int("SN_SESSION_PORT_NO", 52099);
        logger.info(LOG_FUNCTION, LOG_TITLE, "initRegistry", "port:" + port);
        LocateRegistry.createRegistry(port);
        logger.info(LOG_FUNCTION, LOG_TITLE, "initRegistry", "End.");
        return port;
    }

    private static String bindRegistry(int port) throws Exception {
        String LOG_SUBTITLE = "bindRegistry";
        logger.info(LOG_FUNCTION, LOG_TITLE, "bindRegistry", "Start.");
        String registry_name = SJcEnvUty.getProperty("SN_SESSION_REGISTRY", "SessionControl");
        String url = "rmi://localhost:" + port + "/" + registry_name;
        logger.info(LOG_FUNCTION, LOG_TITLE, "bindRegistry", "url: " + url);
        Naming.rebind(url, remote);
        logger.info(LOG_FUNCTION, LOG_TITLE, "bindRegistry", "End.");
        return url;
    }

    public static void initialize() throws Exception {
        String LOG_SUBTITLE = "initialize";
        logger.info(LOG_FUNCTION, LOG_TITLE, "initialize", "Start.");
        SJsessionWakeUpper.initializePlugin();
        SJsessionStoreHouse storeHouse = SJsessionStoreHouse.createInstance();
        storeHouse.initialize();
        SJsessionReceiveModuleManager.createInstance();
        SJsessionUniqueIDUtility.initializeTable();
        logger.info(LOG_FUNCTION, LOG_TITLE, "initialize", "End.");
    }

    private static void initializePlugin() {
        SJsessionReceivePluginManager.registReceiveModulePlugins();
        HashMap<String, SJsessionReceivePluginItem> map = SJsessionReceivePluginManager.getPluginMap();
        for (String appID : map.keySet()) {
            SJsessionProcessPluginManager.registProcessModulePlugins(appID);
        }
    }

    public static void finish() {
        SJsessionReceiveModuleManager rcvMng;
        String LOG_SUBTITLE = "finish";
        logger.info(LOG_FUNCTION, LOG_TITLE, "finish", "Start.");
        SJsessionStoreHouse storeHouse = SJsessionStoreHouse.getInstance();
        if (storeHouse != null) {
            storeHouse.finish();
        }
        if ((rcvMng = SJsessionReceiveModuleManager.getInstance()) != null) {
            rcvMng.finish();
        }
        SJsessionWakeUpper.finishSystemProperties();
        logger.info(LOG_FUNCTION, LOG_TITLE, "finish", "End.");
    }

    public static void startTimer(String url) {
        String LOG_SUBTITLE = "startTimer";
        logger.info(LOG_FUNCTION, LOG_TITLE, "startTimer", "Start.");
        int checkPolling = SJcEnvUty.getProperty2int("SN_SESSION_RMI_CHECK_POLLING", 30);
        logger.info(LOG_FUNCTION, LOG_TITLE, "startTimer", "checkPolling:" + checkPolling);
        long period = checkPolling * 1000;
        rmiCheckTimer = new Timer();
        RMICheck task = new RMICheck(url);
        rmiCheckTimer.schedule((TimerTask)task, 0L, period);
        logger.info(LOG_FUNCTION, LOG_TITLE, "startTimer", "End.");
    }

    static class RMICheck
    extends TimerTask {
        String url = null;
        String LOG_SUBTITLE = RMICheck.class.getSimpleName();

        public RMICheck(String url) {
            this.url = url;
        }

        public void run() {
            try {
                SJsessionRemoteInterface rm = (SJsessionRemoteInterface)Naming.lookup(this.url);
                rm.checkConnect();
            }
            catch (Exception ex) {
                logger.error(SJsessionWakeUpper.LOG_FUNCTION, LOG_TITLE, this.LOG_SUBTITLE, "RMI Check Error.", ex);
                try {
                    SJsessionWakeUpper.finish();
                }
                catch (Exception exf) {
                    logger.warn(SJsessionWakeUpper.LOG_FUNCTION, LOG_TITLE, this.LOG_SUBTITLE, "Finish Error.", exf);
                }
                System.exit(0);
            }
        }
    }
}

