/*
 * Decompiled with CFR 0.152.
 */
package sanproject.session.server.process;

import java.util.HashMap;
import sanproject.session.common.exception.SJsessionException;
import sanproject.session.server.common.SJsessionServerUty;
import sanproject.session.server.process.SJsessionProcessBase;
import sanproject.session.server.store.SJsessionInfo;
import sanproject.session.server.store.SJsessionInfoApp;
import sanproject.sn2.com.utility.SJcUserGroupInfoUty;
import sanproject.sn2.com.utility.account.SJcRoleResourceContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SJsessionProcess4SN2_SVP
extends SJsessionProcessBase {
    public SJsessionProcess4SN2_SVP(String appID, String loginType) {
        super(appID, loginType);
    }

    @Override
    protected void chgSessionInfo(String gsid, HashMap<String, Object> authResult, String password) throws SJsessionException {
        SJsessionInfoApp infoApp = SJsessionServerUty.convertToLoginInfo(authResult, this.authBase.getAuthSystem(), password);
        SJsessionInfo session = this.store.getSession(gsid);
        if (session != null) {
            SJsessionInfoApp infoSVP = session.getLoginInfo("SVPWIN");
            if (infoSVP != null) {
                infoApp.setAddress(infoSVP.getAddress());
            }
            String[] roleid = session.getRoleIDs();
            boolean[] rsgid = session.getRsgIDs();
            if (null != roleid && null != rsgid) {
                authResult.put("USERGROUPS", new String[]{""});
                SJcRoleResourceContainer roleRsgContainer = session.getResourceRole();
                authResult.put("RESOURCE_ROLE", roleRsgContainer);
                authResult.put("USER_ROLES", roleid);
                authResult.put("RESOURCE_GROUP_IDS", rsgid);
                boolean allrsg = session.isAllRsg();
                authResult.put("ALL_RSG_FLG", allrsg);
            } else {
                authResult.put("USERGROUPS", session.getUserGroups());
                authResult.put("RESOURCE_ROLE", SJcUserGroupInfoUty.getUserGroupObject(session.getUserGroups()));
            }
        }
        if (this.isSessionInsert()) {
            this.store.chgSession(gsid, infoApp);
        }
    }
}

