/*
 * Decompiled with CFR 0.152.
 */
package sanproject.server.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import sanproject.server.data.CREffectiveInfo;
import sanproject.server.data.CREnvInfo;
import sanproject.server.data.CRNoticeInfo;
import sanproject.server.data.CRURLInfo;
import sanproject.server.data.CRgetURLInfo;
import sanproject.server.data.GetRmiException;
import sanproject.server.data.JNIException;
import sanproject.server.data.RmiConObjInFile;
import sanproject.server.data.RmiConObjOutFile;
import sanproject.server.data.RmiObjImpl;
import sanproject.server.data.SANRmiException;
import sanproject.server.data.StringControl;
import sanproject.server.data.common_Obj;

public class CRObj
extends common_Obj {
    protected static final int ON_DELETE = 1;
    protected static final int OFF_DELETE = 0;
    protected static final int LV_NO = 3;
    protected static final int LV_RELEASE = 2;
    protected static final int LV_DEBUG = 1;
    protected static final int LV_DETAIL = 0;
    private static final int LOG_MODE = 3;
    private static final int COUNT_URL = 33;
    private static final int COUNT_ENV = 1;
    private static final int COLUMN_LEN_URL = 10;
    private static final int COLUMN_LEN_ENV = 6;
    private static final String FUN_CR_URLI = "CR getChangeReportURLInfo";
    private static final String FUN_CR_ENV = "CR getChangeReportEnv";
    protected static final int RETRY_TO_FILE = 3;
    protected static final int SLEEP_TO_FILE = 2000;
    private static final String PATH_FILE = "c:\\dkc200\\config\\";
    private static final String PATH_DIFF = "c:\\dkc200\\diff\\";
    private static final String FILENAME_URL = "ChangeReportURLlist.csv";
    private static final String FILENAME_ENV = "ChangeReportEnv.csv";
    private static final int MIN_ID = 0;
    private static final int MAX_ID = 32;
    private static final int MIN_LEN_URL = 1;
    private static final int MAX_LEN_URL = 1024;
    private static final int MIN_LEN_USERID = 0;
    private static final int MAX_LEN_USERID = 25;
    private static final int MIN_LEN_PASS = 0;
    private static final int MAX_LEN_PASS = 25;
    private static final int POSITION_ID = 0;
    private static final int POSITION_URL = 1;
    private static final int POSITION_EFFECTIVE = 2;
    private static final int POSITION_UNLOCK = 3;
    private static final int POSITION_HRC_MRCF = 4;
    private static final int POSITION_HIHSM = 5;
    private static final int POSITION_RSIM = 6;
    private static final int POSITION_REBOOT = 7;
    private static final int POSITION_USER_ID = 8;
    private static final int POSITION_PASSWORD = 9;
    private static final String ON = "1";
    private static final String OFF = "0";
    private static final String[] TYPES = new String[]{"Unlock", "Migration", "RSIM", "HRCorMRCF", "SvpReboot"};
    private static final int[] TYPES_POS = new int[]{3, 5, 6, 4, 7};
    private static final String SVP_DUAL_EXE = "c:\\dkc200\\mp\\pc\\WbCnfSt.exe";
    private static Vector m_VectorURL = new Vector(0);
    private static Vector m_VectorEnv = new Vector(0);
    private static CRgetURLInfo[] m_URL = null;
    private static CREnvInfo m_Env = null;

    public CRObj(RmiObjImpl rmiObjImpl) {
        super(rmiObjImpl);
        try {
            m_VectorURL.setSize(33);
            this.initFileRetryer(m_VectorURL, FILENAME_URL);
            this.resetURLInfo();
            m_VectorEnv.setSize(1);
            this.initFileRetryer(m_VectorEnv, FILENAME_ENV);
            this.resetEnvInfo();
        }
        catch (JNIException jNIException) {
            String string = StringControl.getErrStack(jNIException);
            this.sysOut(3, string);
            throw new IllegalStateException(jNIException.getMessage());
        }
        catch (RuntimeException runtimeException) {
            String string = StringControl.getErrStack(runtimeException);
            this.sysOut(3, string);
            throw new IllegalStateException(runtimeException.getMessage());
        }
    }

    protected void initFileRetryer(Vector vector, String string) throws JNIException {
        boolean bl = false;
        int n = 4;
        int n2 = 0;
        while (n2 < n) {
            try {
                if (this.initFile(vector, string)) {
                    bl = true;
                    break;
                }
                throw this.newException("initFileRetryer() FileAccessError Dummy", 4001);
            }
            catch (JNIException jNIException) {
                if (n2 < 3) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (Exception exception) {}
                } else {
                    throw this.newException("initFileRetryer() FileAccessError", 4001);
                }
                ++n2;
            }
        }
        if (!bl) {
            throw this.newException("initFileRetryer() FileAccessError", 4001);
        }
    }

    protected boolean initFile(Vector vector, String string) throws JNIException {
        boolean bl = false;
        this.sysOut(1, "initFile() vector: " + vector + ",filename " + string);
        try {
            RmiConObjInFile rmiConObjInFile = new RmiConObjInFile(PATH_FILE + string);
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                ArrayList arrayList = rmiConObjInFile.getArrayList();
                this.sysOut(0, "initFile() in.getArrayList(): " + arrayList);
                if (vector.equals(m_VectorURL) && n == m_VectorURL.size()) {
                    if (arrayList != null) {
                        int n3 = Integer.parseInt((String)arrayList.get(0));
                        vector.set(n3, arrayList);
                    }
                } else {
                    vector.set(n2, arrayList);
                }
                ++n2;
            }
            rmiConObjInFile.clear();
            bl = true;
        }
        catch (GetRmiException getRmiException) {
            this.sysOut(1, "initFile() GetRmiException " + getRmiException.nErrData);
            if (getRmiException.nErrData == 4000) {
                this.createFile(0, PATH_FILE + string);
                bl = true;
            }
            bl = false;
        }
        this.sysOut(0, "initFile() vector.size(): " + vector.size());
        return bl;
    }

    protected boolean checkRange(int n, int n2, int n3) {
        return n2 <= n && n <= n3;
    }

    protected void checkNull(Object object) throws JNIException {
        if (object == null) {
            throw this.newException("checkNull() No Data", 5300);
        }
    }

    protected void checkID(int n) throws JNIException {
        if (!this.checkRange(n, 0, 32)) {
            throw this.newException("checkID() ID : " + n, 5301);
        }
    }

    protected void checkString(int n, String string) throws JNIException {
        boolean bl = false;
        this.checkNull(string);
        int n2 = string.length();
        switch (n) {
            case 1: {
                bl = this.checkRange(n2, 1, 1024);
                break;
            }
            case 8: {
                bl = this.checkRange(n2, 0, 25);
                break;
            }
            case 9: {
                bl = this.checkRange(n2, 0, 25);
                break;
            }
            default: {
                throw this.newException("checkString() kind :" + n, 2005);
            }
        }
        if (!bl) {
            throw this.newException("checkString() kind :" + n, 3002);
        }
    }

    protected CRgetURLInfo[] getChangeReportURLInfo() throws SANRmiException {
        String string = FUN_CR_URLI;
        CRgetURLInfo[] cRgetURLInfoArray = null;
        this.preProc(string);
        try {
            try {
                this.run(string);
                cRgetURLInfoArray = this.getURLInfo();
                this.runEnd(string);
            }
            catch (Exception exception) {
                this.exp(exception);
                Object var5_4 = null;
                this.postProc(string);
            }
            Object var5_3 = null;
            this.postProc(string);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.postProc(string);
            throw throwable;
        }
        return cRgetURLInfoArray;
    }

    protected CREnvInfo getChangeReportEnv() throws SANRmiException {
        String string = FUN_CR_ENV;
        CREnvInfo cREnvInfo = null;
        this.preProc(string);
        try {
            try {
                this.run(string);
                cREnvInfo = this.getEnvInfo();
                this.runEnd(string);
            }
            catch (Exception exception) {
                this.exp(exception);
                Object var5_4 = null;
                this.postProc(string);
            }
            Object var5_3 = null;
            this.postProc(string);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.postProc(string);
            throw throwable;
        }
        return cREnvInfo;
    }

    protected CRgetURLInfo[] getURLInfo() {
        Vector vector = m_VectorURL;
        synchronized (vector) {
            CRgetURLInfo[] cRgetURLInfoArray = m_URL;
            return cRgetURLInfoArray;
        }
    }

    protected CREnvInfo getEnvInfo() {
        Vector vector = m_VectorEnv;
        synchronized (vector) {
            CREnvInfo cREnvInfo = m_Env;
            return cREnvInfo;
        }
    }

    private void resetURLInfo() {
        Vector vector = m_VectorURL;
        synchronized (vector) {
            int n = m_VectorURL.size();
            int n2 = 0;
            this.sysOut(0, "resetURLInfo() m_VectorURL.size(): " + n);
            int n3 = 0;
            while (n3 < n) {
                Object e = m_VectorURL.get(n3);
                if (e != null) {
                    ++n2;
                }
                ++n3;
            }
            m_URL = new CRgetURLInfo[n2];
            int n4 = 0;
            int n5 = 0;
            while (n5 < n) {
                Object e = m_VectorURL.get(n5);
                if (e != null) {
                    ArrayList arrayList = (ArrayList)e;
                    this.sysOut(0, "resetURLInfo() ArrayList: " + arrayList);
                    CRObj.m_URL[n4] = this.changeURL(arrayList);
                    ++n4;
                }
                ++n5;
            }
        }
    }

    private void resetEnvInfo() {
        Vector vector = m_VectorEnv;
        synchronized (vector) {
        }
    }

    protected CRgetURLInfo changeURL(ArrayList arrayList) {
        this.sysOut(0, "changeURL() list: " + arrayList);
        CRgetURLInfo cRgetURLInfo = new CRgetURLInfo();
        cRgetURLInfo.entryID = Integer.parseInt((String)arrayList.get(0));
        cRgetURLInfo.noticeURL = (String)arrayList.get(1);
        cRgetURLInfo.userID = (String)arrayList.get(8);
        cRgetURLInfo.password = (String)arrayList.get(9);
        String string = (String)arrayList.get(2);
        cRgetURLInfo.effective = string.equals(ON);
        int n = TYPES.length;
        CRNoticeInfo[] cRNoticeInfoArray = new CRNoticeInfo[n];
        int n2 = 0;
        while (n2 < n) {
            cRNoticeInfoArray[n2] = new CRNoticeInfo();
            cRNoticeInfoArray[n2].type = TYPES[n2];
            String string2 = (String)arrayList.get(TYPES_POS[n2]);
            cRNoticeInfoArray[n2].validity = string2.equals(ON);
            ++n2;
        }
        cRgetURLInfo.noticeInfo = cRNoticeInfoArray;
        return cRgetURLInfo;
    }

    protected void reflectEffective(CREffectiveInfo cREffectiveInfo) throws JNIException {
        Vector vector = m_VectorURL;
        synchronized (vector) {
            m_VectorURL = this.setEffetive(m_VectorURL, cREffectiveInfo);
            this.resetURLInfo();
        }
    }

    protected void refrectURLInfoEntry(CRURLInfo[] cRURLInfoArray) throws JNIException {
        Vector vector = m_VectorURL;
        synchronized (vector) {
            m_VectorURL = this.setURLEntry(m_VectorURL, cRURLInfoArray);
            this.resetURLInfo();
        }
    }

    protected void refrectURLInfoDelete(int[] nArray) throws JNIException {
        Vector vector = m_VectorURL;
        synchronized (vector) {
            m_VectorURL = this.setURLDelete(m_VectorURL, nArray);
            this.resetURLInfo();
        }
    }

    protected void refrectEnvInfo(CREnvInfo cREnvInfo) throws JNIException {
        Vector vector = m_VectorEnv;
        synchronized (vector) {
            m_VectorEnv = this.setEnv(m_VectorEnv, cREnvInfo);
            this.resetEnvInfo();
        }
    }

    protected void makeURLInfo() throws JNIException {
        Vector vector = m_VectorURL;
        synchronized (vector) {
            this.makeFile(m_URL.length, m_VectorURL, FILENAME_URL);
        }
    }

    protected void makeEnvInfo() throws JNIException {
        Vector vector = m_VectorEnv;
        synchronized (vector) {
            this.makeFile(1, m_VectorEnv, FILENAME_ENV);
        }
    }

    private void makeFileRetryer(int n, Vector vector, String string) throws JNIException {
        boolean bl = false;
        int n2 = 4;
        int n3 = 0;
        while (n3 < n2) {
            try {
                if (this.makeFile(n, vector, string)) {
                    bl = true;
                    break;
                }
                throw this.newException("makeFileRetryer() FileAccessError Dummy", 4001);
            }
            catch (JNIException jNIException) {
                if (n3 < 3) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (Exception exception) {}
                } else {
                    throw this.newException("makeFileRetryer() FileAccessError", 4001);
                }
                ++n3;
            }
        }
        if (!bl) {
            throw this.newException("makeFileRetryer() FileAccessError", 4001);
        }
    }

    private boolean makeFile(int n, Vector vector, String string) throws JNIException {
        this.sysOut(1, "makeFile() : " + n + " : " + string);
        this.sysOut(0, "makeFile() vector: " + vector);
        boolean bl = false;
        try {
            this.createFile(1, PATH_FILE + string);
            String string2 = StringControl.LN_SEP;
            RmiConObjOutFile rmiConObjOutFile = new RmiConObjOutFile(PATH_FILE + string);
            int n2 = vector.size();
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 1;
            int n4 = 0;
            while (n4 < n2) {
                Object e = vector.get(n4);
                if (e != null) {
                    ArrayList arrayList = (ArrayList)e;
                    String string3 = arrayList.toString();
                    string3 = string3.substring(1, string3.length() - 1);
                    string3 = StringControl.replace(string3, " ", "");
                    stringBuffer.append(string3);
                    if (n3 < n) {
                        stringBuffer.append(string2);
                        ++n3;
                    }
                }
                ++n4;
            }
            if (n > 0) {
                rmiConObjOutFile.putOneLine(stringBuffer.toString());
            }
            this.backupFile(string);
            bl = true;
        }
        catch (GetRmiException getRmiException) {
            this.sysOut(1, "makeFile() GetRmiException " + getRmiException.nErrData);
        }
        return bl;
    }

    protected Vector setEffetive(Vector vector, CREffectiveInfo cREffectiveInfo) throws JNIException {
        this.checkNull(cREffectiveInfo);
        this.checkID(cREffectiveInfo.entryID);
        int n = cREffectiveInfo.entryID;
        boolean bl = false;
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            ArrayList arrayList = (ArrayList)vector.get(n3);
            if (arrayList != null && n == (n4 = Integer.parseInt((String)arrayList.get(0)))) {
                bl = true;
                String string = cREffectiveInfo.effective ? ON : OFF;
                arrayList.set(2, string);
                vector.set(cREffectiveInfo.entryID, arrayList);
                break;
            }
            ++n3;
        }
        if (!bl) {
            throw this.newException("setEffetive() entryID : " + n, 5301);
        }
        return vector;
    }

    protected Vector setURLEntry(Vector vector, CRURLInfo[] cRURLInfoArray) throws JNIException {
        this.sysOut(1, "setURLEntry() vector: " + vector);
        this.checkNull(cRURLInfoArray);
        boolean bl = false;
        int n = cRURLInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            CRURLInfo cRURLInfo = cRURLInfoArray[n2];
            this.checkNull(cRURLInfo);
            this.checkID(cRURLInfo.entryID);
            Object e = vector.get(cRURLInfo.entryID);
            ArrayList<String> arrayList = (ArrayList<String>)e;
            if (arrayList == null || arrayList.size() == 0) {
                bl = true;
                arrayList = new ArrayList<String>();
                this.setSizeArrayList(arrayList, 10);
            }
            this.sysOut(0, "setURLEntry() list: " + arrayList);
            this.checkString(1, cRURLInfo.noticeURL);
            this.checkString(8, cRURLInfo.userID);
            this.checkString(9, cRURLInfo.password);
            arrayList.set(0, String.valueOf(cRURLInfo.entryID));
            arrayList.set(2, OFF);
            arrayList.set(1, cRURLInfo.noticeURL);
            arrayList.set(8, cRURLInfo.userID);
            arrayList.set(9, cRURLInfo.password);
            CRNoticeInfo[] cRNoticeInfoArray = cRURLInfo.noticeInfo;
            this.checkNull(cRNoticeInfoArray);
            int n3 = cRNoticeInfoArray.length;
            int n4 = TYPES.length;
            int n5 = 0;
            while (n5 < n4) {
                if (bl) {
                    arrayList.set(TYPES_POS[n5], ON);
                }
                int n6 = 0;
                while (n6 < n3) {
                    CRNoticeInfo cRNoticeInfo = cRNoticeInfoArray[n6];
                    this.checkNull(cRNoticeInfo);
                    if (TYPES[n5].equals(cRNoticeInfo.type)) {
                        String string = cRNoticeInfo.validity ? ON : OFF;
                        arrayList.set(TYPES_POS[n5], string);
                        break;
                    }
                    ++n6;
                }
                ++n5;
            }
            vector.set(cRURLInfo.entryID, arrayList);
            ++n2;
        }
        return vector;
    }

    protected Vector setURLDelete(Vector vector, int[] nArray) throws JNIException {
        this.checkNull(nArray);
        boolean bl = false;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            this.checkID(n3);
            int n4 = vector.size();
            int n5 = 0;
            while (n5 < n4) {
                int n6;
                ArrayList arrayList = (ArrayList)vector.get(n5);
                if (arrayList != null && n3 == (n6 = Integer.parseInt((String)arrayList.get(0)))) {
                    bl = true;
                    vector.set(n3, null);
                    break;
                }
                ++n5;
            }
            if (!bl) {
                throw this.newException("setURLDelete() entryID : " + n3, 5301);
            }
            ++n2;
        }
        return vector;
    }

    protected Vector setEnv(Vector vector, CREnvInfo cREnvInfo) throws JNIException {
        return vector;
    }

    /*
     * Loose catch block
     */
    private void backupFile(String string) throws JNIException {
        block14: {
            File file = new File(PATH_FILE + string);
            if (file.exists()) {
                FileInputStream fileInputStream = null;
                FileOutputStream fileOutputStream = null;
                fileInputStream = new FileInputStream(file);
                int n = fileInputStream.available();
                byte[] byArray = new byte[n];
                fileInputStream.read(byArray);
                File file2 = new File(PATH_DIFF);
                if (!file2.exists()) {
                    file2.mkdirs();
                }
                fileOutputStream = new FileOutputStream(PATH_DIFF + string);
                fileOutputStream.write(byArray);
                Object var9_10 = null;
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                    break block14;
                }
                catch (IOException iOException) {
                    this.sysOut(3, "backupFile() :" + iOException.getMessage());
                }
                break block14;
                {
                    catch (FileNotFoundException fileNotFoundException) {
                        throw this.newException("backupFile() :" + string, 2005);
                    }
                    catch (IOException iOException) {
                        throw this.newException("backupFile() :" + string, 4001);
                    }
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        this.sysOut(3, "backupFile() :" + iOException.getMessage());
                    }
                    throw throwable;
                }
            }
        }
    }

    protected void execSvpDual() throws JNIException {
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(SVP_DUAL_EXE);
        }
        catch (IOException iOException) {
            throw this.newException("execSvpDual() :process execute failed", 2005);
        }
    }

    private void setSizeArrayList(ArrayList arrayList, int n) {
        int n2;
        int n3 = n2 = arrayList.size();
        while (n3 < n) {
            arrayList.add(null);
            ++n3;
        }
    }

    protected void createFile(int n, String string) throws JNIException {
        boolean bl = false;
        int n2 = 4;
        int n3 = 0;
        while (n3 < n2) {
            try {
                File file = new File(string);
                if (n == 1) {
                    file.delete();
                }
                if (file.createNewFile()) {
                    bl = true;
                    break;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.out);
                if (n3 < 3) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (Exception exception) {}
                }
                throw this.newException("createFile() FileAccessError", 4001);
            }
            ++n3;
        }
        if (!bl) {
            throw this.newException("createFile() FileAccessError", 4001);
        }
    }

    protected void sysOut(int n, Object object) {
        if (n >= 3) {
            System.out.println(object);
        }
    }

    protected JNIException newException(String string, int n) {
        return new JNIException(string, 1, n);
    }
}

