/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.com.utility.Logger;

import com.sun.jna.Function;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Pointer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import sanproject.sn2.base.property.SJbaseSystemPropertiesConst;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.com.utility.Logger.ADT_LOG;
import sanproject.sn2.com.utility.Logger.SJcAuditLogPrinter;
import sanproject.sn2.com.utility.Logger.inf.SJcAuditLogElementContainerInterface;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.SJcLogUty;

public class SJcAuditLogPrinterSN2
extends SJcAuditLogPrinter {
    private static HashMap<String, Integer> funcTable;
    protected Pointer handleDetail;
    protected ADT_LOG adtlog;
    private SJcAuditLogElementContainerInterface eleCon;
    private Integer funcIdSn2;
    private String opeResultSn2;
    private Pointer detailPointer;
    public static final String FUNC_NAME_LOGIN = "LOGIN";
    public static final String FUNC_NAME_LOGOUT = "LOGOUT";
    private final String FUNC_NAME_SYSTEM = "SYSTEM";
    private final int FUNC_NAME_DEFALT_VALUE = 21248;
    private final String RESULT_SN2_SUCCESS = "Normal end";
    private final String RESULT_SN2_WARNING = "Warning";
    private final String RESULT_SN2_ERROR = "Error";
    private final String RESULT_SN2_OTHER = "-";
    private final String P_SESSION_ID_SYSTEM = "<System>";
    private final int US_CATEGORY_ID_CONFIG = 7;
    private final int US_CATEGORY_ID_AUTH = 4;
    private final int FILE_FLG_SYSTEM = 0;
    private final int SUBJECT_ID_UID = 0;
    private final int SUBJECT_ID_SYSTEM = 2;
    private final int B_SESSION_ID_SYSTEM = 0;
    public static final String ADD_INFO_LOGTYPE = "SN2_AUDITLOG_ADD_LOGTYPE";
    public static final String ADD_INFO_NAME_USER = "SN2_AUDITLOG_ADD_USER";
    public static final String ADD_INFO_NAME_HOST = "SN2_AUDITLOG_ADD_HOST";
    public static final String ADD_INFO_LOGID = "SN2_AUDITLOG_ADD_LOGID";
    public static final String ADD_INFO_EXTIF = "SN2_AUDITLOG_ADD_EXTIF";
    public static final String ADD_INFO_LOGTYPE_SYSTEM = "SYSTEM";
    public static final String ADD_INFO_LOGTYPE_USER = "USER";
    private static SJcLoggerInterface logger;
    private static final String LOG_FUNCTION = "SJcAuditLogPrinterSN2";
    private static final String LOG_TITLE = "SJcAuditLogPrinterSN2";
    private String logType = null;
    private String sessionID = null;
    private String hostName = null;
    private Integer connectID = 0;
    private Integer exdIfID = 0;
    private static NativeLibrary libAdtCmn;

    public SJcAuditLogPrinterSN2() {
        SJcAuditLogPrinterSN2.initTable();
        if (libAdtCmn == null) {
            String dllPath = SJcEnvUty.getSnBasePath() + "mp\\pc\\AdtCmn.dll";
            libAdtCmn = NativeLibrary.getInstance((String)dllPath);
        }
    }

    static void initTable() {
        String LOG_SUBTITLE = "initTable";
        logger.info("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "Start. ");
        try {
            if (funcTable == null) {
                funcTable = new HashMap();
                String szDirectory = SJbaseSystemPropertiesConst.SN_DIRECTORY_BASE_AUDIT;
                String szFile = "SN2AuditLogFuncName.properties";
                Properties properties = SJcFileUty.loadProperties(szDirectory, szFile);
                Enumeration<?> enu = properties.propertyNames();
                while (enu.hasMoreElements()) {
                    String key = (String)enu.nextElement();
                    if (key == null || key.trim().equals("") || properties.get(key) == null || ((String)properties.get(key)).trim().equals("")) continue;
                    try {
                        funcTable.put(key, Integer.decode(properties.getProperty(key)));
                    }
                    catch (Exception e) {
                        logger.error("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "Exception. ", e);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "Exception. ", e);
        }
        logger.info("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "End. ");
    }

    protected void setupADT_LOG() {
        this.adtlog = new ADT_LOG();
        this.adtlog.usFuncID = (short)this.funcIdSn2.intValue();
        this.adtlog.setSzOperation(this.eleCon.getOperationName());
        this.adtlog.setSzParam(this.eleCon.getOperationParameter());
        this.adtlog.setSzResult(this.opeResultSn2);
        this.adtlog.pDetailInf = this.detailPointer.getString(0L);
        this.adtlog.usCategoryID = (short)7;
        this.adtlog.bFileFlg = 0;
        this.adtlog.bSessionID = 0;
        if (null != this.eleCon.getTaskName()) {
            this.adtlog.setSzTaskName(this.eleCon.getTaskName());
        } else {
            this.adtlog.setSzTaskName("");
        }
        if (null == this.logType || !this.logType.equals(ADD_INFO_LOGTYPE_SYSTEM)) {
            String funcName = this.eleCon.getFunctionName();
            if (null != funcName && (funcName.equals(FUNC_NAME_LOGIN) || funcName.equals(FUNC_NAME_LOGOUT))) {
                this.adtlog.usCategoryID = (short)4;
            }
            this.adtlog.usSubjectID = 0;
            this.adtlog.pSessionID = this.sessionID;
            this.adtlog.setSzHostname(this.hostName);
            this.adtlog.ulConnectID.setValue((long)this.connectID.intValue());
            this.adtlog.ulExdIfID.setValue((long)this.exdIfID.intValue());
        } else {
            this.adtlog.pSessionID = "<System>";
            this.adtlog.usSubjectID = (short)2;
        }
    }

    @Override
    public void putLog(SJcAuditLogElementContainerInterface ec) {
        String opeResult;
        String LOG_SUBTITLE = "putLog";
        logger.info("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "Start. -ec:" + ec);
        this.eleCon = ec;
        String funcName = ec.getFunctionName();
        this.funcIdSn2 = funcTable.get(funcName);
        if (this.funcIdSn2 == null) {
            this.funcIdSn2 = 21248;
        }
        if ((opeResult = ec.getOperationResult()) != null) {
            if (opeResult.equals("Success")) {
                this.opeResultSn2 = "Normal end";
            } else {
                SJcMessage msg = ec.getOperationErrorCode();
                String errCode = "";
                String functionID = "";
                String moduleID = "";
                String msgID = "";
                if (msg != null) {
                    errCode = "";
                    functionID = msg.getFunctionID();
                    moduleID = msg.getModuleID();
                    msgID = msg.getMsgID();
                }
                if (functionID != null && moduleID != null && msgID != null) {
                    errCode = functionID + moduleID + "-" + msgID;
                }
                this.opeResultSn2 = opeResult.equals("Warning") ? "Warning(" + errCode + ")" : (opeResult.equals("Error") ? "Error(" + errCode + ")" : "-");
            }
        } else {
            this.opeResultSn2 = "-";
        }
        this.handleDetail = this.adtFmtCreate();
        this.adtFmtClear();
        this.logType = null;
        this.sessionID = null;
        this.hostName = null;
        this.connectID = 0;
        this.exdIfID = 0;
        HashMap<String, String> map = ec.getAdditionalInfo();
        String[] info = new String[3];
        if (map != null && !map.isEmpty()) {
            this.logType = map.get(ADD_INFO_LOGTYPE);
            this.sessionID = map.get(ADD_INFO_NAME_USER);
            this.hostName = map.get(ADD_INFO_NAME_HOST);
            try {
                this.connectID = Integer.valueOf(map.get(ADD_INFO_LOGID));
            }
            catch (NumberFormatException e) {
                logger.info("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "ADD_INFO_LOGID is not a numerical value. ");
                this.connectID = 1;
            }
            try {
                this.exdIfID = Integer.valueOf(map.get(ADD_INFO_EXTIF));
            }
            catch (NumberFormatException e) {
                logger.info("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "ADD_INFO_EXTIF is not a numerical value. ");
                this.exdIfID = 4;
            }
            map.remove(ADD_INFO_LOGTYPE);
            map.remove(ADD_INFO_NAME_USER);
            map.remove(ADD_INFO_NAME_HOST);
            map.remove(ADD_INFO_LOGID);
            map.remove(ADD_INFO_EXTIF);
            logger.info("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "logType  =[" + this.logType + "]");
            logger.info("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "sessionID=[" + this.sessionID + "]");
            logger.info("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "hostName =[" + this.hostName + "]");
            logger.info("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "connectID=[" + this.connectID + "]");
            logger.info("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "exdIfID=[" + this.exdIfID + "]");
            Iterator<String> it = map.keySet().iterator();
            if (it.hasNext()) {
                String[] start = new String[]{""};
                this.adtFmtPrintf(start);
                int i = 1;
                while (it.hasNext()) {
                    String key = it.next();
                    String value = map.get(key);
                    if (key != null && value != null) {
                        info[0] = "%s=%s";
                        info[1] = key;
                        info[2] = value;
                        this.adtFmtPrintfItem(info);
                    }
                    ++i;
                }
                String[] end = new String[]{"\n"};
                this.adtFmtPrintfItemEnd(end);
            }
        }
        this.formatDetail(ec);
        this.detailPointer = this.adtFmtGetString();
        this.setupADT_LOG();
        if (this.logType == null) {
            if (funcName != null) {
                if (funcName.equals(FUNC_NAME_LOGIN) || funcName.equals(FUNC_NAME_LOGOUT)) {
                    this.adtWriteLoginLogEx3();
                } else {
                    this.adtWriteOpeLogEx3();
                }
            } else {
                this.adtWriteOpeLogEx3();
            }
        } else if (this.logType.equals(ADD_INFO_LOGTYPE_SYSTEM)) {
            this.adtWriteOpeLogEx2();
        } else if (this.logType.equals(ADD_INFO_LOGTYPE_USER)) {
            this.adtWriteOpeLogEx3();
        } else {
            logger.info("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "ADD_INFO_LOGID is not a numerical value. ");
        }
        this.adtFmtReleaseString();
        this.adtFmtDelete();
        logger.info("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "End.");
    }

    protected Pointer adtFmtCreate() {
        String LOG_SUBTITLE = "adtFmtCreate";
        logger.trace("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "Start. ");
        Pointer po = (Pointer)this.invokeFormatDetail("AdtFmt_Create", Pointer.class, null);
        logger.trace("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "End.  -return:" + po);
        return po;
    }

    protected void adtFmtClear() {
        String LOG_SUBTITLE = "adtFmtClear";
        logger.trace("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "Start. ");
        Object[] dllArg = new Object[]{this.handleDetail};
        this.invokeFormatDetail("AdtFmt_Clear", dllArg);
        logger.trace("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "End. ");
    }

    protected int adtFmtPrintf(String[] str) {
        String LOG_SUBTITLE = "adtFmtPrintf";
        logger.trace("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "Start. -key" + str);
        Object[] args = new Object[str.length + 2];
        args[0] = this.handleDetail;
        args[1] = null;
        System.arraycopy(str, 0, args, 2, str.length);
        int ret = (Integer)this.invokeFormatDetail("AdtFmt_Printf", Integer.class, args);
        logger.trace("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "End.  -return:" + ret);
        return ret;
    }

    protected int adtFmtPrintfItem(String[] str) {
        String LOG_SUBTITLE = "adtFmtPrintfItem";
        logger.trace("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "Start. -key" + str);
        Object[] args = new Object[str.length + 1];
        args[0] = this.handleDetail;
        System.arraycopy(str, 0, args, 1, str.length);
        int ret = (Integer)this.invokeFormatDetail("AdtFmt_PrintfItem", Integer.class, args);
        logger.trace("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "End.  -return:" + ret);
        return ret;
    }

    protected int adtFmtPrintfItemEnd(String[] str) {
        String LOG_SUBTITLE = "adtFmtPrintfItemEnd";
        logger.trace("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "Start. -key" + str);
        Object[] args = new Object[str.length + 1];
        args[0] = this.handleDetail;
        System.arraycopy(str, 0, args, 1, str.length);
        int ret = (Integer)this.invokeFormatDetail("AdtFmt_PrintfItemEnd", Integer.class, args);
        logger.trace("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "End.  -return:" + ret);
        return ret;
    }

    protected Pointer adtFmtGetString() {
        String LOG_SUBTITLE = "adtFmtGetString";
        logger.trace("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "Start. ");
        Object[] args = new Object[]{this.handleDetail};
        Pointer po = (Pointer)this.invokeFormatDetail("AdtFmt_GetString", Pointer.class, args);
        logger.trace("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "End.  -return:" + po);
        return po;
    }

    protected int adtWriteLoginLogGlobal() {
        String LOG_SUBTITLE = "adtWriteLoginLogGlobal";
        logger.trace("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "Start. ");
        Object[] args = new Object[]{this.adtlog};
        int ret = (Integer)this.invokeFormatDetail("AdtCmn_WriteLoginLog_Global", Integer.class, args);
        if (ret == 0) {
            logger.error("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "Can't write adtlog.  ");
        }
        logger.trace("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "End.  -return:" + ret);
        return ret;
    }

    protected int adtWriteLoginLogEx3() {
        String LOG_SUBTITLE = "adtWriteLoginLogEx3";
        logger.trace("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "Start. ");
        Object[] args = new Object[]{this.adtlog};
        int ret = (Integer)this.invokeFormatDetail("AdtCmn_WriteLoginLog_Ex3", Integer.class, args);
        if (ret == 0) {
            logger.error("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "Can't write adtlog.  ");
        }
        logger.trace("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "End.  -return:" + ret);
        return ret;
    }

    protected int adtWriteOpeLogEx2() {
        String LOG_SUBTITLE = "adtWriteOpeLogEx2";
        logger.trace("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "Start. ");
        Object[] args = new Object[]{this.adtlog};
        int ret = (Integer)this.invokeFormatDetail("AdtCmn_WriteOpeLog_Ex2", Integer.class, args);
        if (ret == 0) {
            logger.error("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "Can't write adtlog.  ");
        }
        logger.trace("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "End.  -return:" + ret);
        return ret;
    }

    protected int adtWriteOpeLogEx3() {
        String LOG_SUBTITLE = "adtWriteOpeLogEx3";
        logger.trace("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "Start. ");
        Object[] args = new Object[]{this.adtlog};
        int ret = (Integer)this.invokeFormatDetail("AdtCmn_WriteOpeLog_Ex3", Integer.class, args);
        if (ret == 0) {
            logger.error("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "Can't write adtlog.  ");
        }
        logger.trace("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "End.  -return:" + ret);
        return ret;
    }

    protected int adtWriteOpeLogGlobal() {
        String LOG_SUBTITLE = "adtWriteOpeLogGlobal";
        logger.trace("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "Start. ");
        Object[] args = new Object[]{this.adtlog};
        int ret = (Integer)this.invokeFormatDetail("AdtCmn_WriteOpeLog_Global", Integer.class, args);
        if (ret == 0) {
            logger.error("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "Can't write adtlog.  ");
        }
        logger.trace("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "End.  -return:" + ret);
        return ret;
    }

    protected void adtFmtReleaseString() {
        String LOG_SUBTITLE = "adtFmtReleaseString";
        logger.trace("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "Start. ");
        Object[] args = new Object[]{this.handleDetail};
        this.invokeFormatDetail("AdtFmt_ReleaseString", args);
        logger.trace("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "End.  ");
    }

    protected void adtFmtDelete() {
        String LOG_SUBTITLE = "adtFmtDelete";
        logger.trace("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "Start. ");
        Object[] args = new Object[]{this.handleDetail};
        this.invokeFormatDetail("AdtFmt_Delete", args);
        logger.trace("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "End.  ");
    }

    public Object invokeFormatDetail(String methodName, Class<?> returnCla, Object[] args) {
        String LOG_SUBTITLE = "invokeFormatDetail";
        logger.info("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "Start. -key1:" + methodName + " -key2:" + returnCla + " -key3:" + args);
        Object obj = null;
        if (null != libAdtCmn) {
            try {
                Function func = libAdtCmn.getFunction(methodName);
                obj = func.invoke(returnCla, args);
            }
            catch (Exception e) {
                logger.error("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "Exception. ", e);
            }
        } else {
            logger.info("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "libAdtCmn is null");
        }
        logger.info("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "End.  -return:" + obj);
        return obj;
    }

    public void invokeFormatDetail(String methodName, Object[] args) {
        String LOG_SUBTITLE = "invokeFormatDetail";
        logger.info("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "Start. -key1:" + methodName + " -key2:" + args);
        if (null != libAdtCmn) {
            try {
                Function func = libAdtCmn.getFunction(methodName);
                func.invoke(args);
            }
            catch (Exception e) {
                logger.error("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "Exception. ", e);
            }
        } else {
            logger.info("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "libAdtCmn is null");
        }
        logger.info("SJcAuditLogPrinterSN2", "SJcAuditLogPrinterSN2", LOG_SUBTITLE, "End.  ");
    }

    @Override
    public void formatDetail(SJcAuditLogElementContainerInterface ec) {
    }

    static {
        logger = SJcLogUty.getLogger();
        libAdtCmn = null;
    }
}

